/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Predicate;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.feature.Features;
import mod.pbj.script.Script;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AccuracyFeature
extends ConditionalFeature {
    private static final float MIN_ACCURACY_MODIFIER = 0.1f;
    private static final float MAX_ACCURACY_MODIFIER = 10.0f;
    private float accuracyModifier;
    @Nullable
    private Script script;

    private AccuracyFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, float accuracyModifier, Script script) {
        super(owner, predicate);
        this.accuracyModifier = accuracyModifier;
        this.script = script;
    }

    public MutableComponent getDescription() {
        return this.accuracyModifier < 1.0f ? Component.m_237115_((String)"description.pointblank.reducesAccuracy").m_7220_((Component)Component.m_237113_((String)String.format(" %.0f%%", Float.valueOf(100.0f * (1.0f - this.accuracyModifier))))) : Component.m_237115_((String)"description.pointblank.increasesAccuracy").m_7220_((Component)Component.m_237113_((String)String.format(" %.0f%%", Float.valueOf(100.0f * (this.accuracyModifier - 1.0f)))));
    }

    public float getAccuracyModifier() {
        return this.accuracyModifier;
    }

    public static float getAccuracyModifier(ItemStack itemStack) {
        List<Features.EnabledFeature> enabledAccuracyFeatures = Features.getEnabledFeatures(itemStack, AccuracyFeature.class);
        float accuracyModifier = 1.0f;
        for (Features.EnabledFeature enabledFeature : enabledAccuracyFeatures) {
            AccuracyFeature accuracyFeature = (AccuracyFeature)enabledFeature.feature();
            if (accuracyFeature.hasScript() && accuracyFeature.hasFunction("addAccuracyModifier")) {
                accuracyModifier *= ((Float)accuracyFeature.invokeFunction("addAccuracyModifier", itemStack, accuracyFeature)).floatValue();
            }
            if (accuracyFeature.hasScript() && accuracyFeature.hasFunction("getAccuracyModifier")) {
                accuracyModifier *= ((Float)accuracyFeature.invokeFunction("getAccuracyModifier", itemStack, accuracyFeature)).floatValue();
                continue;
            }
            accuracyModifier *= accuracyFeature.getAccuracyModifier();
        }
        return Mth.m_14036_((float)accuracyModifier, (float)0.1f, (float)10.0f);
    }

    @Override
    @Nullable
    public Script getScript() {
        return this.script;
    }

    public static class Builder
    implements FeatureBuilder<Builder, AccuracyFeature> {
        private Predicate<ConditionContext> condition = ctx -> true;
        private float accuracyModifier;
        private Script script;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withAccuracyModifier(double accuracyModifier) {
            this.accuracyModifier = (float)accuracyModifier;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            this.withAccuracyModifier(JsonUtil.getJsonFloat(obj, "accuracyModifier"));
            return this;
        }

        public Builder withScript(Script script) {
            this.script = script;
            return this;
        }

        @Override
        public AccuracyFeature build(FeatureProvider featureProvider) {
            return new AccuracyFeature(featureProvider, this.condition, this.accuracyModifier, this.script);
        }
    }
}

