/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Predicate;
import mod.pbj.client.GunClientState;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.feature.Features;
import mod.pbj.item.GunItem;
import mod.pbj.script.Script;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class AdsSpeedFeature
extends ConditionalFeature {
    private float adsMultiplier;
    @Nullable
    private Script script;

    public AdsSpeedFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, float adsMultiplier, Script script) {
        super(owner, predicate);
        this.adsMultiplier = adsMultiplier;
        this.script = script;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static long getTotalAdsSpeed(ItemStack itemStack, Player player, GunClientState state) {
        if (!(itemStack.m_41720_() instanceof GunItem)) {
            return 0L;
        }
        List<Features.EnabledFeature> enabledAccuracyFeatures = Features.getEnabledFeatures(itemStack, AdsSpeedFeature.class);
        float adsModifier = 1.0f;
        for (Features.EnabledFeature enabledFeature : enabledAccuracyFeatures) {
            AdsSpeedFeature adsFeature = (AdsSpeedFeature)enabledFeature.feature();
            if (!adsFeature.predicate.test(new ConditionContext((LivingEntity)player, itemStack, state))) continue;
            if (adsFeature.hasScript() && adsFeature.hasFunction("addAdsSpeedModifier")) {
                adsModifier *= ((Float)adsFeature.invokeFunction("addAdsSpeedModifier", itemStack, adsFeature)).floatValue();
            }
            if (adsFeature.hasScript() && adsFeature.hasFunction("getAdsSpeedModifier")) {
                adsModifier *= ((Float)adsFeature.invokeFunction("getAdsSpeedModifier", itemStack, adsFeature)).floatValue();
                continue;
            }
            adsModifier *= adsFeature.getAdsMultiplier();
        }
        return Math.round((float)((GunItem)itemStack.m_41720_()).adsSpeed * adsModifier);
    }

    public float getAdsMultiplier() {
        return this.adsMultiplier;
    }

    @Override
    @Nullable
    public Script getScript() {
        return this.script;
    }

    public static class Builder
    implements FeatureBuilder<Builder, AdsSpeedFeature> {
        private Predicate<ConditionContext> condition = ctx -> true;
        private float adsSpeedMultiplier;
        private Script script;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withAdsSpeedMultiplier(double adsSpeed) {
            this.adsSpeedMultiplier = (float)adsSpeed;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            this.withAdsSpeedMultiplier(JsonUtil.getJsonFloat(obj, "adsModifier"));
            return this;
        }

        public Builder withScript(Script script) {
            this.script = script;
            return this;
        }

        @Override
        public AdsSpeedFeature build(FeatureProvider featureProvider) {
            return new AdsSpeedFeature(featureProvider, this.condition, this.adsSpeedMultiplier, this.script);
        }
    }
}

