/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import mod.pbj.attachment.AttachmentCategory;
import mod.pbj.attachment.AttachmentModelInfo;
import mod.pbj.attachment.Attachments;
import mod.pbj.client.GunStateListener;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.feature.Features;
import mod.pbj.item.GunItem;
import mod.pbj.registry.ExtensionRegistry;
import mod.pbj.script.Script;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public final class AimingFeature
extends ConditionalFeature
implements GunStateListener {
    private static final Matrix4f IDENTITY_MATRIX = new Matrix4f();
    private Matrix4f aimMatrix;
    private final float zoom;
    private final float viewBobbing;
    private final Script script;

    /*
     * Unable to fully structure code
     */
    @OnlyIn(value=Dist.CLIENT)
    public static void applyAimingPosition(ItemStack itemStack, PoseStack poseStack, float rescale, float aimingProgress) {
        block6: {
            block7: {
                block8: {
                    if (!(itemStack.m_41720_() instanceof GunItem) || !(aimingProgress > 0.0f)) break block6;
                    poseMatrices = AttachmentModelInfo.findInverseBoneMatrices(itemStack, "scope", rescale);
                    if (poseMatrices.isEmpty()) break block7;
                    aimingFeature = Features.getFirstEnabledFeature(itemStack, AimingFeature.class);
                    attachmentPos = null;
                    if (aimingFeature == null) break block8;
                    var8_7 = aimingFeature.feature();
                    if (!(var8_7 instanceof AimingFeature)) ** GOTO lbl-1000
                    feature = (AimingFeature)var8_7;
                    if (feature.aimMatrix != null) {
                        attachmentPos = Pair.of((Object)itemStack, (Object)feature.aimMatrix);
                    } else lbl-1000:
                    // 2 sources

                    {
                        attachmentPos = (Pair)poseMatrices.get(aimingFeature.ownerPath());
                    }
                }
                if (attachmentPos == null) {
                    attachmentPos = poseMatrices.firstEntry().getValue();
                }
                if (attachmentPos == null) {
                    return;
                }
                if (aimingProgress < 1.0f) {
                    poseStack.m_252931_(AimSwitchAnimation.INSTANCE.update(AimingFeature.IDENTITY_MATRIX, (Matrix4f)attachmentPos.getSecond(), aimingProgress));
                } else {
                    poseStack.m_252931_(AimSwitchAnimation.INSTANCE.update((Matrix4f)attachmentPos.getSecond()));
                }
            }
            poseStack.m_252880_(0.0f, aimingProgress * -0.6095f * rescale, aimingProgress * -0.7f * rescale);
        }
    }

    private AimingFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, float zoom, float viewBobbing, Matrix4f aimMatrix, Script script) {
        super(owner, predicate);
        this.zoom = zoom;
        this.viewBobbing = viewBobbing;
        this.script = script;
        this.aimMatrix = aimMatrix;
    }

    public MutableComponent getDescription() {
        return Component.m_237115_((String)"description.pointblank.enablesAimingWithZoom").m_7220_((Component)Component.m_237113_((String)String.format(" %.0f%%", Float.valueOf(this.zoom * 100.0f))));
    }

    public float getZoom() {
        return this.zoom;
    }

    public float getViewBobbing() {
        return this.viewBobbing;
    }

    public static float getZoom(ItemStack itemStack) {
        Pair<String, ItemStack> selected = Attachments.getSelectedAttachment(itemStack, AttachmentCategory.SCOPE);
        ItemStack selectedStack = null;
        selectedStack = selected != null ? (ItemStack)selected.getSecond() : itemStack;
        Item item = selectedStack.m_41720_();
        if (item instanceof FeatureProvider) {
            FeatureProvider fp = (FeatureProvider)item;
            AimingFeature feature = fp.getFeature(AimingFeature.class);
            if (feature != null) {
                if (feature.hasScript() && feature.hasFunction("getZoom")) {
                    return ((Float)feature.invokeFunction("getZoom", itemStack, feature)).floatValue();
                }
                return feature.getZoom();
            }
        } else {
            item = selectedStack.m_41720_();
            if (item instanceof GunItem) {
                GunItem gunItem = (GunItem)item;
                return (float)gunItem.getAimingZoom();
            }
        }
        return 0.0f;
    }

    public static float getViewBobbing(ItemStack itemStack) {
        FeatureProvider fp;
        AimingFeature feature;
        Pair<String, ItemStack> selected = Attachments.getSelectedAttachment(itemStack, AttachmentCategory.SCOPE);
        ItemStack selectedStack = null;
        selectedStack = selected != null ? (ItemStack)selected.getSecond() : itemStack;
        Item item = selectedStack.m_41720_();
        if (item instanceof FeatureProvider && (feature = (fp = (FeatureProvider)item).getFeature(AimingFeature.class)) != null) {
            return feature.getViewBobbing();
        }
        return 1.0f;
    }

    @Override
    @Nullable
    public Script getScript() {
        return this.script;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class AimSwitchAnimation {
        private static final AimSwitchAnimation INSTANCE = new AimSwitchAnimation(200L);
        protected long startTime;
        protected long nanoDuration;
        protected boolean isDone;
        protected Matrix4f fromMatrix;
        protected Matrix4f toMatrix;

        protected AimSwitchAnimation(long durationMillis) {
            this.nanoDuration = durationMillis * 1000000L;
            this.fromMatrix = IDENTITY_MATRIX;
            this.toMatrix = IDENTITY_MATRIX;
        }

        protected float getProgress() {
            double progress = (double)(System.nanoTime() - this.startTime) / (double)this.nanoDuration;
            if (progress > 1.0) {
                progress = 1.0;
            }
            return Mth.m_14036_((float)((float)progress), (float)0.0f, (float)1.0f);
        }

        public void reset() {
            this.isDone = false;
            this.startTime = System.nanoTime();
        }

        public Matrix4f update(Matrix4f matrix) {
            float progress;
            if (this.toMatrix != matrix) {
                this.fromMatrix = this.toMatrix;
                this.toMatrix = matrix;
                this.reset();
            }
            if ((progress = this.getProgress()) >= 1.0f) {
                this.isDone = true;
            }
            return this.isDone ? this.toMatrix : new Matrix4f((Matrix4fc)this.fromMatrix).lerp((Matrix4fc)this.toMatrix, progress);
        }

        public Matrix4f update(Matrix4f fromMatrix, Matrix4f toMatrix, float progress) {
            Matrix4f resultMatrix = new Matrix4f((Matrix4fc)fromMatrix).lerp((Matrix4fc)toMatrix, progress);
            AimSwitchAnimation.INSTANCE.fromMatrix = fromMatrix;
            AimSwitchAnimation.INSTANCE.toMatrix = toMatrix;
            return resultMatrix;
        }
    }

    public static class Builder
    implements FeatureBuilder<Builder, AimingFeature> {
        private static final float DEFAULT_ZOOM = 0.1f;
        private Predicate<ConditionContext> condition = ctx -> true;
        private float zoom;
        private float viewBobbing = 1.0f;
        public ExtensionRegistry.Extension extension;
        private Script script;
        private Matrix4f aimMatrix;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withZoom(double zoom) {
            this.zoom = (float)zoom;
            return this;
        }

        public Builder withAimMatrix(Matrix4f aimMatrix) {
            this.aimMatrix = aimMatrix;
            return this;
        }

        public Builder withViewBobbing(double viewBobbing) {
            this.viewBobbing = Mth.m_14036_((float)((float)viewBobbing), (float)0.0f, (float)1.0f);
            return this;
        }

        public Builder withScript(Script script) {
            this.script = script;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            this.withZoom(JsonUtil.getJsonFloat(obj, "zoom", 0.1f));
            this.withViewBobbing(JsonUtil.getJsonFloat(obj, "viewBobbing", 1.0f));
            this.withScript(JsonUtil.getJsonScript(obj));
            return this;
        }

        @Override
        public AimingFeature build(FeatureProvider featureProvider) {
            return new AimingFeature(featureProvider, this.condition, this.zoom, this.viewBobbing, this.aimMatrix, this.script);
        }
    }
}

