/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.Feature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.feature.Features;
import mod.pbj.script.Script;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AmmoCapacityFeature
extends ConditionalFeature {
    private static final int MIN_AMMO = 1;
    private static final int MAX_AMMO = Integer.MAX_VALUE;
    private IntUnaryOperator ammoCapacityTransformer;
    private Component description;
    @Nullable
    private Script script;

    private AmmoCapacityFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, IntUnaryOperator ammoCapacityTransformer, Component description, Script script) {
        super(owner, predicate);
        this.description = description;
        this.ammoCapacityTransformer = ammoCapacityTransformer;
        this.script = script;
    }

    @Override
    public Component getDescription() {
        return this.description;
    }

    public static int modifyAmmoCapacity(ItemStack itemStack, int ammoCapacity) {
        AmmoCapacityFeature feature;
        Feature feature2;
        Features.EnabledFeature enabledExtendedAmmoFeature = Features.getFirstEnabledFeature(itemStack, AmmoCapacityFeature.class);
        if (enabledExtendedAmmoFeature != null && (feature2 = enabledExtendedAmmoFeature.feature()) instanceof AmmoCapacityFeature && (feature = (AmmoCapacityFeature)feature2).hasFunction("modifyAmmoCapacity")) {
            return (Integer)feature.invokeFunction("modifyAmmoCapacity", ammoCapacity, itemStack, feature);
        }
        return enabledExtendedAmmoFeature != null ? ((AmmoCapacityFeature)enabledExtendedAmmoFeature.feature()).ammoCapacityTransformer.applyAsInt(ammoCapacity) : ammoCapacity;
    }

    @Override
    @Nullable
    public Script getScript() {
        return this.script;
    }

    public static class Builder
    implements FeatureBuilder<Builder, AmmoCapacityFeature> {
        private Predicate<ConditionContext> condition = ctx -> true;
        private IntUnaryOperator ammoCapacityTransformer;
        private Component description;
        private Script script;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withAmmoCapacityModifier(float ammoCapacityModifier) {
            this.ammoCapacityTransformer = ammo -> Mth.m_14045_((int)Math.round((float)ammo * ammoCapacityModifier), (int)1, (int)Integer.MAX_VALUE);
            this.description = Component.m_237115_((String)"description.pointblank.extendsAmmoCapacity").m_7220_((Component)Component.m_237113_((String)String.format(" %d%%", Float.valueOf((ammoCapacityModifier - 1.0f) * 100.0f))));
            return this;
        }

        public Builder withAmmoCapacity(int ammoCapacity) {
            this.ammoCapacityTransformer = ammo -> Mth.m_14045_((int)ammoCapacity, (int)1, (int)Integer.MAX_VALUE);
            this.description = Component.m_237115_((String)"description.pointblank.changesAmmoCapacity").m_7220_((Component)Component.m_237113_((String)(" " + ammoCapacity)));
            return this;
        }

        public Builder withScript(Script script) {
            this.script = script;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            if (obj.has("ammoCapacityModifier")) {
                this.withAmmoCapacityModifier(JsonUtil.getJsonFloat(obj, "ammoCapacityModifier"));
            } else if (obj.has("ammoCapacity")) {
                this.withAmmoCapacity(JsonUtil.getJsonInt(obj, "ammoCapacity"));
            }
            this.withScript(JsonUtil.getJsonScript(obj));
            return this;
        }

        @Override
        public AmmoCapacityFeature build(FeatureProvider featureProvider) {
            if (this.ammoCapacityTransformer == null) {
                throw new IllegalStateException("Either ammoCapacity ammoCapacityModifier must be set");
            }
            return new AmmoCapacityFeature(featureProvider, this.condition, this.ammoCapacityTransformer, this.description, this.script);
        }
    }
}

