/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.script.Script;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class AttributeFeature
extends ConditionalFeature {
    private final Script script;
    public final Attribute baseAttribute;
    public final AttributeModifier modifier;

    public AttributeFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, @Nullable Script script, Attribute baseAttribute, AttributeModifier modifier) {
        super(owner, predicate);
        this.script = script;
        this.baseAttribute = baseAttribute;
        this.modifier = modifier;
    }

    @Override
    public List<Component> getDescriptions() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add((Component)MutableComponent.m_237204_((ComponentContents)Component.m_237115_((String)this.baseAttribute.m_22087_()).m_214077_()).m_130946_(": %s".formatted(this.getFormattedModifier(this.modifier))));
        return components;
    }

    private String getFormattedModifier(AttributeModifier modifier) {
        Object string = switch (modifier.m_22217_()) {
            default -> throw new IncompatibleClassChangeError();
            case AttributeModifier.Operation.ADDITION -> "+ ";
            case AttributeModifier.Operation.MULTIPLY_BASE -> "base x ";
            case AttributeModifier.Operation.MULTIPLY_TOTAL -> "x ";
        };
        string = (String)string + modifier.m_22218_();
        return string;
    }

    @Override
    @Nullable
    public Script getScript() {
        return this.script;
    }

    public static class Builder
    implements FeatureBuilder<Builder, AttributeFeature> {
        private Predicate<ConditionContext> condition = ctx -> true;
        private Attribute baseAttribute;
        private AttributeModifier modifier;
        private Script script;
        public static final HashMap<AttributeModifier.Operation, String[]> modifierValues = new HashMap();

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withAttribute(Attribute attribute) {
            this.baseAttribute = attribute;
            return this;
        }

        public Builder withAttributeModifier(AttributeModifier attributeModifier) {
            this.modifier = attributeModifier;
            return this;
        }

        public Builder withScript(Script script) {
            this.script = script;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            Attribute attribute;
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            if ((attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.parse((String)JsonUtil.getJsonString(obj, "attribute")))) == null) {
                throw new IllegalArgumentException("Attribute %s does not exist!".formatted(JsonUtil.getJsonString(obj, "attribute")));
            }
            this.withAttribute(attribute);
            JsonObject modObj = obj.getAsJsonObject("modifier");
            AttributeModifier modifier = new AttributeModifier(UUID.randomUUID(), attribute.m_22087_(), modObj.get("amount").getAsDouble(), Builder.operationFromString(modObj.has("operator") ? modObj.get("operator").getAsString() : modObj.get("operation").getAsString()));
            this.withAttributeModifier(modifier);
            this.withScript(JsonUtil.getJsonScript(obj));
            return this;
        }

        public static AttributeModifier.Operation operationFromString(String str) {
            AttributeModifier.Operation[] fop = new AttributeModifier.Operation[]{null};
            modifierValues.forEach((op, strArr) -> {
                for (String key : strArr) {
                    if (!str.trim().equalsIgnoreCase(key)) continue;
                    fop[0] = op;
                    return;
                }
            });
            return fop[0];
        }

        @Override
        public AttributeFeature build(FeatureProvider featureProvider) {
            return new AttributeFeature(featureProvider, this.condition, this.script, this.baseAttribute, this.modifier);
        }

        static {
            modifierValues.put(AttributeModifier.Operation.ADDITION, new String[]{"add_value", "addition", "+"});
            modifierValues.put(AttributeModifier.Operation.MULTIPLY_BASE, new String[]{"add_multiplied_base", "multiply_base", "*b", "xb"});
            modifierValues.put(AttributeModifier.Operation.MULTIPLY_TOTAL, new String[]{"add_multiplied_total", "multiply_total", "*", "x"});
        }
    }
}

