/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Predicate;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.feature.Features;
import mod.pbj.script.Script;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class DamageFeature
extends ConditionalFeature {
    private static final float MIN_DAMAGE_MODIFIER = 0.01f;
    private static final float MAX_DAMAGE_MODIFIER = 10.0f;
    private final float hitScanDamageModifier;
    private final Component description;
    @Nullable
    private final Script script;

    private DamageFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, float hitScanDamageModifier, Script script) {
        super(owner, predicate);
        this.hitScanDamageModifier = hitScanDamageModifier;
        this.script = script;
        this.description = hitScanDamageModifier < 1.0f ? Component.m_237115_((String)"description.pointblank.reducesDamage").m_7220_((Component)Component.m_237113_((String)String.format(" %.0f%%", Float.valueOf(100.0f * (1.0f - hitScanDamageModifier))))) : Component.m_237115_((String)"description.pointblank.increasesDamage").m_7220_((Component)Component.m_237113_((String)String.format(" %.0f%%", Float.valueOf(100.0f * (hitScanDamageModifier - 1.0f)))));
    }

    @Override
    public Component getDescription() {
        return this.description;
    }

    public float getHitScanDamageModifier() {
        return this.hitScanDamageModifier;
    }

    public static float getHitScanDamageModifier(ItemStack itemStack) {
        List<Features.EnabledFeature> enabledDamageFeatures = Features.getEnabledFeatures(itemStack, DamageFeature.class);
        float hitScanDamageModifier = 1.0f;
        for (Features.EnabledFeature enabledFeature : enabledDamageFeatures) {
            DamageFeature damageFeature = (DamageFeature)enabledFeature.feature();
            if (damageFeature.hasScript() && damageFeature.hasFunction("addDamageModifier")) {
                hitScanDamageModifier *= ((Float)damageFeature.invokeFunction("addDamageModifier", itemStack, damageFeature)).floatValue();
            }
            if (damageFeature.hasScript() && damageFeature.hasFunction("getDamageModifier")) {
                hitScanDamageModifier *= ((Float)damageFeature.invokeFunction("getDamageModifier", itemStack, damageFeature)).floatValue();
                continue;
            }
            hitScanDamageModifier *= damageFeature.getHitScanDamageModifier();
        }
        return Mth.m_14036_((float)hitScanDamageModifier, (float)0.01f, (float)10.0f);
    }

    @Override
    @Nullable
    public Script getScript() {
        return this.script;
    }

    public static class Builder
    implements FeatureBuilder<Builder, DamageFeature> {
        private Predicate<ConditionContext> condition = ctx -> true;
        private float hitScanDamageModifier;
        private Script script;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withHitScanDamageModifier(double damageModifier) {
            this.hitScanDamageModifier = (float)damageModifier;
            return this;
        }

        public Builder withScript(Script script) {
            this.script = script;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            this.withHitScanDamageModifier(JsonUtil.getJsonFloat(obj, "hitScanDamageModifier"));
            this.withScript(JsonUtil.getJsonScript(obj));
            return this;
        }

        @Override
        public DamageFeature build(FeatureProvider featureProvider) {
            return new DamageFeature(featureProvider, this.condition, this.hitScanDamageModifier, this.script);
        }
    }
}

