/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.feature.Features;
import mod.pbj.script.Script;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class DefenseFeature
extends ConditionalFeature {
    private final float defenseModifier;
    private final Script script;
    private final int defense;
    private final float toughnessModifier;
    private final float toughness;

    public DefenseFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, float defenseModifier, int defense, float toughness, float toughnessModifier, @Nullable Script script) {
        super(owner, predicate);
        this.defenseModifier = defenseModifier;
        this.script = script;
        this.defense = defense;
        this.toughnessModifier = toughnessModifier;
        this.toughness = toughness;
    }

    public static float getToughnessModifier(ItemStack itemStack) {
        List<Features.EnabledFeature> enabledDefenseFeatures = Features.getEnabledFeatures(itemStack, DefenseFeature.class);
        float toughnessModifier = 1.0f;
        for (Features.EnabledFeature enabledFeature : enabledDefenseFeatures) {
            DefenseFeature defenseFeature = (DefenseFeature)enabledFeature.feature();
            if (defenseFeature.hasFunction("addToughnessModifier")) {
                toughnessModifier *= ((Float)defenseFeature.invokeFunction("addToughnessModifier", itemStack, defenseFeature)).floatValue();
            }
            if (defenseFeature.hasFunction("getToughnessModifier")) {
                toughnessModifier *= ((Float)defenseFeature.invokeFunction("getToughnessModifier", itemStack, defenseFeature)).floatValue();
                continue;
            }
            toughnessModifier *= defenseFeature.getToughnessModifier();
        }
        return Mth.m_14036_((float)toughnessModifier, (float)0.01f, (float)10.0f);
    }

    public static float getToughnessAdditive(ItemStack itemStack) {
        List<Features.EnabledFeature> enabledDefenseFeatures = Features.getEnabledFeatures(itemStack, DefenseFeature.class);
        float toughness = 0.0f;
        for (Features.EnabledFeature enabledFeature : enabledDefenseFeatures) {
            DefenseFeature defenseFeature = (DefenseFeature)enabledFeature.feature();
            if (defenseFeature.hasFunction("addToughness")) {
                toughness += defenseFeature.invokeFunction("addToughness", Float.TYPE, itemStack, defenseFeature).floatValue();
            }
            if (defenseFeature.hasFunction("getToughness")) {
                toughness += defenseFeature.invokeFunction("getToughness", Float.TYPE, itemStack, defenseFeature).floatValue();
                continue;
            }
            toughness += defenseFeature.getToughnessAdditive();
        }
        return toughness;
    }

    public static float getDefenseModifier(ItemStack itemStack) {
        List<Features.EnabledFeature> enabledDefenseFeatures = Features.getEnabledFeatures(itemStack, DefenseFeature.class);
        float defenseModifier = 1.0f;
        for (Features.EnabledFeature enabledFeature : enabledDefenseFeatures) {
            DefenseFeature defenseFeature = (DefenseFeature)enabledFeature.feature();
            if (defenseFeature.hasFunction("addDefenseModifier")) {
                defenseModifier *= ((Float)defenseFeature.invokeFunction("addDefenseModifier", itemStack, defenseFeature)).floatValue();
            }
            if (defenseFeature.hasFunction("getDefenseModifier")) {
                defenseModifier *= ((Float)defenseFeature.invokeFunction("getDefenseModifier", itemStack, defenseFeature)).floatValue();
                continue;
            }
            defenseModifier *= defenseFeature.getDefenseModifier();
        }
        return Mth.m_14036_((float)defenseModifier, (float)0.01f, (float)10.0f);
    }

    public static int getDefenseAdditive(ItemStack itemStack) {
        List<Features.EnabledFeature> enabledDefenseFeatures = Features.getEnabledFeatures(itemStack, DefenseFeature.class);
        int defenseModifier = 0;
        for (Features.EnabledFeature enabledFeature : enabledDefenseFeatures) {
            DefenseFeature defenseFeature = (DefenseFeature)enabledFeature.feature();
            if (defenseFeature.hasFunction("addDefense")) {
                defenseModifier += ((Integer)defenseFeature.invokeFunction("addDefense", itemStack, defenseFeature)).intValue();
            }
            if (defenseFeature.hasFunction("getDefense")) {
                defenseModifier += ((Integer)defenseFeature.invokeFunction("getDefense", itemStack, defenseFeature)).intValue();
                continue;
            }
            defenseModifier += defenseFeature.getDefenseAdditive();
        }
        return defenseModifier;
    }

    @Override
    public List<Component> getDescriptions() {
        ArrayList<Component> components = new ArrayList<Component>();
        if (this.defense != 0) {
            components.add((Component)MutableComponent.m_237204_((ComponentContents)Component.m_237115_((String)"description.pointblank.armor").m_214077_()).m_130946_(String.format(" %s", this.defense)));
        }
        if (this.toughness != 0.0f) {
            components.add((Component)MutableComponent.m_237204_((ComponentContents)Component.m_237115_((String)"description.pointblank.toughness").m_214077_()).m_130946_(String.format(" %s", Float.valueOf(this.toughness))));
        }
        if (this.defenseModifier > 1.0f) {
            components.add((Component)MutableComponent.m_237204_((ComponentContents)Component.m_237115_((String)"description.pointblank.increasesDefense").m_214077_()).m_130946_(String.format(" %sx", Float.valueOf(this.defenseModifier))));
        }
        if (this.defenseModifier < 1.0f) {
            components.add((Component)MutableComponent.m_237204_((ComponentContents)Component.m_237115_((String)"description.pointblank.decreasesDefense").m_214077_()).m_130946_(String.format(" %sx", Float.valueOf(this.defenseModifier))));
        }
        if (this.toughnessModifier > 1.0f) {
            components.add((Component)MutableComponent.m_237204_((ComponentContents)Component.m_237115_((String)"description.pointblank.increasesToughness").m_214077_()).m_130946_(String.format(" %sx", Float.valueOf(this.toughnessModifier))));
        }
        if (this.toughnessModifier < 1.0f) {
            components.add((Component)MutableComponent.m_237204_((ComponentContents)Component.m_237115_((String)"description.pointblank.decreasesToughness").m_214077_()).m_130946_(String.format(" %sx", Float.valueOf(this.toughnessModifier))));
        }
        return components;
    }

    @Deprecated
    private MutableComponent getToughnessComponent() {
        MutableComponent start = this.toughnessModifier < 1.0f ? Component.m_237115_((String)"description.pointblank.reducesToughness") : Component.m_237115_((String)"description.pointblank.increasesToughness");
        start.m_130946_(String.format(" %.0f%%", 100.0 * (1.0 - (double)this.toughnessModifier))).m_7220_((Component)Component.m_237113_((String)"description.pointblank.increasesToughness").m_130946_(" +%s".formatted(Float.valueOf(this.toughness))));
        return start;
    }

    @Deprecated
    public MutableComponent getDefenseComponent() {
        return Component.m_237113_((String)String.format(" %.0f%%", 100.0 * (1.0 - (double)this.defenseModifier))).m_7220_((Component)Component.m_237113_((String)"description.pointblank.increasesDefense").m_130946_(" +%s".formatted(this.defense)));
    }

    public float getDefenseModifier() {
        return this.defenseModifier;
    }

    public int getDefenseAdditive() {
        return this.defense;
    }

    public float getToughnessModifier() {
        return this.toughnessModifier;
    }

    public float getToughnessAdditive() {
        return this.toughness;
    }

    @Override
    @Nullable
    public Script getScript() {
        return this.script;
    }

    public static class Builder
    implements FeatureBuilder<Builder, DefenseFeature> {
        private Predicate<ConditionContext> condition = ctx -> true;
        private float defenseModifier;
        private Script script;
        private int defense;
        private float toughness;
        private float toughnessModifier;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withDefenseModifier(double defenseModifier) {
            this.defenseModifier = (float)defenseModifier;
            return this;
        }

        public Builder withScript(Script script) {
            this.script = script;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            this.withDefenseModifier(JsonUtil.getJsonFloat(obj, "defenseModifier", 1.0f));
            this.withDefense(JsonUtil.getJsonInt(obj, "defenseAdditive", 0));
            this.withToughnessModifier(JsonUtil.getJsonFloat(obj, "toughnessModifier", 1.0f));
            this.withToughness(JsonUtil.getJsonFloat(obj, "toughnessAdditive", 0.0f));
            this.withScript(JsonUtil.getJsonScript(obj));
            return this;
        }

        public Builder withDefense(int defenseAdditive) {
            this.defense = defenseAdditive;
            return this;
        }

        public Builder withToughness(float toughness) {
            this.toughness = toughness;
            return this;
        }

        public Builder withToughnessModifier(float toughnessModifier) {
            this.toughnessModifier = toughnessModifier;
            return this;
        }

        @Override
        public DefenseFeature build(FeatureProvider featureProvider) {
            return new DefenseFeature(featureProvider, this.condition, this.defenseModifier, this.defense, this.toughness, this.toughnessModifier, this.script);
        }
    }
}

