/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mod.pbj.feature.Feature;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;

public interface FeatureProvider {
    default public <T extends Feature> T getFeature(Class<T> featureType) {
        return null;
    }

    default public boolean hasFeature(Class<? extends Feature> feature) {
        return this.getFeature(feature) != null;
    }

    public Collection<Feature> getFeatures();

    default public List<Component> getDescriptionTooltipLines() {
        return Collections.emptyList();
    }

    default public List<Component> getFeatureTooltipLines() {
        ArrayList<Component> tooltipLines = new ArrayList<Component>();
        for (Feature feature : this.getFeatures()) {
            MutableComponent featureDescription = feature.getDescription().m_6881_().m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC);
            if (featureDescription.m_214077_() != ComponentContents.f_237124_) {
                tooltipLines.add((Component)featureDescription);
            }
            for (Component component : feature.getDescriptions()) {
                MutableComponent desc = component.m_6881_().m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC);
                if (desc.m_214077_() == ComponentContents.f_237124_) continue;
                tooltipLines.add((Component)desc);
            }
        }
        return tooltipLines;
    }
}

