/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mod.pbj.attachment.Attachment;
import mod.pbj.attachment.Attachments;
import mod.pbj.client.effect.EffectBuilder;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.Feature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.item.GunItem;
import mod.pbj.registry.FeatureTypeRegistry;
import mod.pbj.util.JsonUtil;
import mod.pbj.util.LRUCache;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Features {
    private static final LRUCache<Pair<Tag, Class<? extends Feature>>, List<EnabledFeature>> selectedItemFeatureCache = new LRUCache(200);
    private static final LRUCache<Pair<Tag, GunItem.FirePhase>, List<Pair<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>, Predicate<ConditionContext>>>> enabledPhaseEffects = new LRUCache(100);

    public static <T extends Feature> EnabledFeature getFirstEnabledFeature(ItemStack itemStack, Class<? extends Feature> featureClass) {
        List<EnabledFeature> enabledFeatures = Features.getEnabledFeatures(itemStack, featureClass);
        return !enabledFeatures.isEmpty() ? enabledFeatures.get(0) : null;
    }

    public static <T extends Feature> List<EnabledFeature> getEnabledFeatures(ItemStack itemStack, Class<? extends Feature> featureClass) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag == null) {
            return Collections.emptyList();
        }
        Pair key = Pair.of((Object)tag, featureClass);
        List<EnabledFeature> enabledFeatures = selectedItemFeatureCache.get((Pair<Tag, Class<? extends Feature>>)key);
        if (enabledFeatures == null) {
            enabledFeatures = Features.computeEnabledFeatures(itemStack, featureClass);
            selectedItemFeatureCache.put((Pair<Tag, Class<? extends Feature>>)key, enabledFeatures);
        }
        return enabledFeatures;
    }

    private static List<EnabledFeature> computeEnabledFeatures(ItemStack rootStack, Class<? extends Feature> featureType) {
        FeatureProvider fp;
        Feature feature;
        NavigableMap<String, ItemStack> attachmentStacks = Attachments.getAttachments(rootStack, true);
        ArrayList<EnabledFeature> result = new ArrayList<EnabledFeature>();
        for (Map.Entry attachmentEntry : attachmentStacks.entrySet()) {
            FeatureProvider fp2;
            Feature feature2;
            Item item = ((ItemStack)attachmentEntry.getValue()).m_41720_();
            if (!(item instanceof FeatureProvider) || (feature2 = (fp2 = (FeatureProvider)item).getFeature(featureType)) == null || !(((ItemStack)attachmentEntry.getValue()).m_41720_() instanceof Attachment) || !feature2.isEnabledForAttachment(rootStack, (ItemStack)attachmentEntry.getValue())) continue;
            result.add(new EnabledFeature(feature2, (ItemStack)attachmentEntry.getValue(), (String)attachmentEntry.getKey()));
        }
        Item var9 = rootStack.m_41720_();
        if (var9 instanceof FeatureProvider && (feature = (fp = (FeatureProvider)var9).getFeature(featureType)) != null && feature.isEnabled(rootStack)) {
            result.add(new EnabledFeature(feature, rootStack, "/"));
        }
        return result;
    }

    public static boolean hasFeature(ItemStack itemStack, Feature feature) {
        Item var3 = itemStack.m_41720_();
        if (var3 instanceof FeatureProvider) {
            FeatureProvider fp = (FeatureProvider)var3;
            return fp.hasFeature(feature.getClass());
        }
        return false;
    }

    public static List<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>> getEnabledPhaseEffects(ItemStack itemStack, GunItem.FirePhase phase) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag == null) {
            return Collections.emptyList();
        }
        List conditionalEffects = enabledPhaseEffects.computeIfAbsent((Pair<Tag, GunItem.FirePhase>)Pair.of((Object)tag, (Object)phase), p -> Features.computeEnabledPhaseEffects(itemStack, phase));
        ConditionContext context = new ConditionContext(itemStack);
        return conditionalEffects.stream().filter(p -> ((Predicate)p.getSecond()).test(context)).map(Pair::getFirst).toList();
    }

    private static List<Pair<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>, Predicate<ConditionContext>>> computeEnabledPhaseEffects(ItemStack rootStack, GunItem.FirePhase firePhase) {
        NavigableMap<String, ItemStack> attachmentStacks = Attachments.getAttachments(rootStack, true);
        ArrayList result = new ArrayList();
        for (Class<? extends Feature> featureType : FeatureTypeRegistry.getFeatureTypes().values()) {
            List<Pair<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>, Predicate<ConditionContext>>> effectBuilders;
            FeatureProvider fp;
            Feature feature;
            for (Map.Entry attachmentEntry : attachmentStacks.entrySet()) {
                List<Pair<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>, Predicate<ConditionContext>>> effectBuilders2;
                FeatureProvider fp2;
                Feature feature2;
                Item item = ((ItemStack)attachmentEntry.getValue()).m_41720_();
                if (!(item instanceof FeatureProvider) || (feature2 = (fp2 = (FeatureProvider)item).getFeature(featureType)) == null || !(((ItemStack)attachmentEntry.getValue()).m_41720_() instanceof Attachment) || !feature2.isEnabledForAttachment(rootStack, (ItemStack)attachmentEntry.getValue()) || (effectBuilders2 = feature2.getEffectBuilders().get(firePhase)) == null) continue;
                result.addAll(effectBuilders2);
            }
            Item var12 = rootStack.m_41720_();
            if (!(var12 instanceof FeatureProvider) || (feature = (fp = (FeatureProvider)var12).getFeature(featureType)) == null || !feature.isEnabled(rootStack) || (effectBuilders = feature.getEffectBuilders().get(firePhase)) == null) continue;
            result.addAll(effectBuilders);
        }
        return result;
    }

    public static List<Pair<String, Supplier<FeatureBuilder<?, ?>>>> getFeatureBuilders() {
        return Arrays.stream(FeatureTypeRegistry.class.getDeclaredFields()).filter(field -> {
            try {
                return field.get(null) instanceof Supplier;
            }
            catch (IllegalAccessException ignored) {
                return false;
            }
        }).map(field -> {
            try {
                return Pair.of((Object)field.getName(), (Object)((Supplier)field.get(null)));
            }
            catch (IllegalAccessException ignored) {
                return Pair.of((Object)null, (Object)null);
            }
        }).toList();
    }

    public static FeatureBuilder<?, ?> fromJson(JsonObject obj) {
        String featureType = JsonUtil.getJsonString(obj, "type");
        for (Pair<String, Supplier<FeatureBuilder<?, ?>>> pair : Features.getFeatureBuilders()) {
            if (!featureType.equalsIgnoreCase((String)pair.getFirst())) continue;
            return ((FeatureBuilder)((Supplier)pair.getSecond()).get()).withJsonObject(obj);
        }
        throw new IllegalArgumentException("Invalid feature type: " + featureType);
    }

    public record EnabledFeature(Feature feature, ItemStack ownerStack, String ownerPath) {
    }
}

