/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mod.pbj.client.effect.EffectBuilder;
import mod.pbj.client.effect.MuzzleFlashEffect;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.item.GunItem;
import mod.pbj.registry.EffectRegistry;
import mod.pbj.script.Script;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class MuzzleFlashFeature
extends ConditionalFeature {
    private final List<Pair<MuzzleFlashEffect.Builder, Predicate<ConditionContext>>> muzzleEffectBuilders = new ArrayList<Pair<MuzzleFlashEffect.Builder, Predicate<ConditionContext>>>();

    public MuzzleFlashFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, Map<GunItem.FirePhase, List<Pair<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>, Predicate<ConditionContext>>>> effectBuilders) {
        super(owner, predicate, effectBuilders);
        for (Map.Entry<GunItem.FirePhase, List<Pair<Supplier<EffectBuilder<EffectBuilder<?, ?>, ?>>, Predicate<ConditionContext>>>> firePhaseListEntry : effectBuilders.entrySet()) {
            for (Pair<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>, Predicate<ConditionContext>> pair : firePhaseListEntry.getValue()) {
                EffectBuilder eb = (EffectBuilder)((Supplier)pair.getFirst()).get();
                if (!(eb instanceof MuzzleFlashEffect.Builder)) continue;
                MuzzleFlashEffect.Builder mfeb = (MuzzleFlashEffect.Builder)eb;
                this.muzzleEffectBuilders.add((Pair<MuzzleFlashEffect.Builder, Predicate<ConditionContext>>)Pair.of((Object)mfeb, (Object)((Predicate)pair.getSecond())));
            }
        }
    }

    public List<Pair<MuzzleFlashEffect.Builder, Predicate<ConditionContext>>> getMuzzleFlashEffectBuilders() {
        return this.muzzleEffectBuilders;
    }

    @Override
    public boolean isEnabled(ItemStack itemStack) {
        return super.isEnabled(itemStack);
    }

    @Override
    @Nullable
    public Script getScript() {
        return null;
    }

    public static class Builder
    implements FeatureBuilder<Builder, MuzzleFlashFeature> {
        private final Map<GunItem.FirePhase, List<Pair<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>, Predicate<ConditionContext>>>> effectBuilders = new HashMap();
        private Predicate<ConditionContext> condition = ctx -> true;

        public Builder withEffect(GunItem.FirePhase firePhase, Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>> effectBuilder) {
            List builders = this.effectBuilders.computeIfAbsent(firePhase, k -> new ArrayList());
            builders.add(Pair.of(effectBuilder, ctx -> true));
            return this;
        }

        public Builder withEffect(GunItem.FirePhase firePhase, Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>> effectBuilder, Predicate<ConditionContext> condition) {
            List builders = this.effectBuilders.computeIfAbsent(firePhase, k -> new ArrayList());
            builders.add(Pair.of(effectBuilder, condition));
            return this;
        }

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            for (JsonObject effect : JsonUtil.getJsonObjects(obj, "effects")) {
                Predicate<ConditionContext> condition;
                GunItem.FirePhase firePhase = (GunItem.FirePhase)JsonUtil.getEnum(effect, "phase", GunItem.FirePhase.class, null, true);
                String effectName = JsonUtil.getJsonString(effect, "name");
                Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>> supplier = () -> EffectRegistry.getEffectBuilderSupplier(effectName).get();
                if (effect.has("condition")) {
                    JsonObject conditionObj = effect.getAsJsonObject("condition");
                    condition = Conditions.fromJson((JsonElement)conditionObj);
                } else {
                    condition = ctx -> true;
                }
                this.withEffect(firePhase, supplier, condition);
            }
            return this;
        }

        @Override
        public MuzzleFlashFeature build(FeatureProvider featureProvider) {
            return new MuzzleFlashFeature(featureProvider, this.condition, this.effectBuilders);
        }
    }
}

