/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.function.Predicate;
import mod.pbj.attachment.AttachmentCategory;
import mod.pbj.attachment.Attachments;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.script.Script;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class PipFeature
extends ConditionalFeature {
    private final float zoom;
    private final ResourceLocation overlayTexture;
    private final ResourceLocation maskTexture;
    private final boolean isParallaxEnabled;
    @Nullable
    private Script script;

    private PipFeature(FeatureProvider owner, Predicate<ConditionContext> condition, float zoom, boolean isParallaxEnabled, ResourceLocation overlayTexture, ResourceLocation maskTexture, Script script) {
        super(owner, condition);
        this.zoom = zoom;
        this.script = script;
        this.isParallaxEnabled = isParallaxEnabled;
        this.overlayTexture = overlayTexture;
        this.maskTexture = maskTexture;
    }

    public MutableComponent getDescription() {
        return Component.m_237115_((String)"description.pointblank.enablesPipWithZoom").m_7220_((Component)Component.m_237113_((String)String.format(" %.0f%%", Float.valueOf(this.zoom * 100.0f))));
    }

    public float getZoom() {
        return this.zoom;
    }

    public ResourceLocation getMaskTexture() {
        return this.maskTexture;
    }

    public boolean isParallaxEnabled() {
        return this.isParallaxEnabled;
    }

    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    public static Optional<Float> getZoom(ItemStack itemStack) {
        FeatureProvider fp;
        PipFeature feature;
        Pair<String, ItemStack> selected = Attachments.getSelectedAttachment(itemStack, AttachmentCategory.SCOPE);
        ItemStack selectedStack = selected != null ? (ItemStack)selected.getSecond() : itemStack;
        Item item = selectedStack.m_41720_();
        if (item instanceof FeatureProvider && (feature = (fp = (FeatureProvider)item).getFeature(PipFeature.class)) != null) {
            if (feature.hasFunction("getPipZoom")) {
                return Optional.of(Float.valueOf(((Float)feature.invokeFunction("getPipZoom", itemStack, feature)).floatValue()));
            }
            return Optional.of(Float.valueOf(feature.getZoom()));
        }
        return Optional.empty();
    }

    public static ResourceLocation getMaskTexture(ItemStack itemStack) {
        FeatureProvider fp;
        PipFeature feature;
        Pair<String, ItemStack> selected = Attachments.getSelectedAttachment(itemStack, AttachmentCategory.SCOPE);
        ItemStack selectedStack = selected != null ? (ItemStack)selected.getSecond() : itemStack;
        Item item = selectedStack.m_41720_();
        if (item instanceof FeatureProvider && (feature = (fp = (FeatureProvider)item).getFeature(PipFeature.class)) != null) {
            if (feature.hasFunction("getMaskTexture")) {
                return (ResourceLocation)feature.invokeFunction("getMaskTexture", itemStack, feature);
            }
            return feature.getMaskTexture();
        }
        return null;
    }

    public static PipFeature getSelected(ItemStack itemStack) {
        Pair<String, ItemStack> selected = Attachments.getSelectedAttachment(itemStack, AttachmentCategory.SCOPE);
        if (selected != null) {
            ItemStack selectedStack = (ItemStack)selected.getSecond();
            Item var4 = selectedStack.m_41720_();
            if (var4 instanceof FeatureProvider) {
                FeatureProvider fp = (FeatureProvider)var4;
                return fp.getFeature(PipFeature.class);
            }
            return null;
        }
        return null;
    }

    @Override
    @Nullable
    public Script getScript() {
        return this.script;
    }

    public static class Builder
    implements FeatureBuilder<Builder, PipFeature> {
        private static final float DEFAULT_ZOOM = 0.9f;
        private static final String DEFAULT_MASK_TEXTURE = "textures/gui/pip_mask_solid_rect.png";
        private Predicate<ConditionContext> condition = ctx -> true;
        private ResourceLocation overlayTexture;
        private ResourceLocation maskTexture;
        private float zoom;
        private boolean isParallaxEnabled;
        private Script script;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withZoom(double zoom) {
            this.zoom = (float)zoom;
            return this;
        }

        public Builder withOverlayTexture(String texture) {
            this.overlayTexture = new ResourceLocation("pointblank", texture);
            return this;
        }

        public Builder withMaskTexture(String texture) {
            this.maskTexture = new ResourceLocation("pointblank", texture);
            return this;
        }

        public Builder withParallaxEnabled(boolean isParallaxEnabled) {
            this.isParallaxEnabled = isParallaxEnabled;
            return this;
        }

        public Builder withScript(Script script) {
            this.script = script;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            String maskTextureName;
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson(obj.get("condition")));
            }
            this.withScript(JsonUtil.getJsonScript(obj));
            this.isParallaxEnabled = JsonUtil.getJsonBoolean(obj, "parallax", false);
            this.isParallaxEnabled = JsonUtil.getJsonBoolean(obj, "parallax", false);
            String overlayTextureName = JsonUtil.getJsonString(obj, "overlayTexture", null);
            if (overlayTextureName != null) {
                this.withOverlayTexture(overlayTextureName);
            }
            if ((maskTextureName = JsonUtil.getJsonString(obj, "maskTexture", null)) == null && this.isParallaxEnabled) {
                maskTextureName = DEFAULT_MASK_TEXTURE;
            }
            if (maskTextureName != null) {
                this.withMaskTexture(maskTextureName);
            }
            this.withZoom(JsonUtil.getJsonFloat(obj, "zoom", 0.9f));
            return this;
        }

        @Override
        public PipFeature build(FeatureProvider featureProvider) {
            ResourceLocation maskTexture = this.maskTexture;
            if (maskTexture == null && this.isParallaxEnabled) {
                maskTexture = new ResourceLocation("pointblank", DEFAULT_MASK_TEXTURE);
            }
            return new PipFeature(featureProvider, this.condition, this.zoom, this.isParallaxEnabled, this.overlayTexture, maskTexture, this.script);
        }
    }
}

