/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.script.Script;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public final class ReticleFeature
extends ConditionalFeature {
    public static final float DEFAULT_MAX_ANGULAR_OFFSET_DEGREES = 5.0f;
    public static final float DEFAULT_MAX_ANGULAR_OFFSET_COS = Mth.m_14089_((float)0.08726646f);
    private final ResourceLocation texture;
    private final boolean isParallaxEnabled;
    private final float maxAngularOffsetCos;
    @Nullable
    private Script script;

    private ReticleFeature(FeatureProvider owner, Predicate<ConditionContext> condition, ResourceLocation texture, boolean isParallaxEnabled, float maxAngularOffsetCos, Script script) {
        super(owner, condition);
        this.texture = texture;
        this.isParallaxEnabled = isParallaxEnabled;
        this.maxAngularOffsetCos = maxAngularOffsetCos;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public boolean isParallaxEnabled() {
        return this.isParallaxEnabled;
    }

    public float getMaxAngularOffsetCos() {
        return this.maxAngularOffsetCos;
    }

    @Override
    @Nullable
    public Script getScript() {
        return this.script;
    }

    public static class Builder
    implements FeatureBuilder<Builder, ReticleFeature> {
        private Predicate<ConditionContext> condition = ctx -> true;
        private boolean isParallaxEnabled;
        private float maxAngularOffsetCos = DEFAULT_MAX_ANGULAR_OFFSET_COS;
        private ResourceLocation texture;
        private Script script;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withTexture(String texture) {
            this.texture = new ResourceLocation("pointblank", texture);
            return this;
        }

        public Builder withParallaxEnabled(boolean isParallaxEnabled) {
            this.isParallaxEnabled = isParallaxEnabled;
            return this;
        }

        public Builder withMaxAngularOffset(float maxAngularOffsetDegrees) {
            this.maxAngularOffsetCos = Mth.m_14089_((float)((float)Math.PI / 180 * Mth.m_14036_((float)maxAngularOffsetDegrees, (float)0.0f, (float)45.0f)));
            return this;
        }

        public Builder withScript(Script script) {
            this.script = script;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            this.withScript(JsonUtil.getJsonScript(obj));
            this.isParallaxEnabled = JsonUtil.getJsonBoolean(obj, "parallax", false);
            if (obj.has("texture")) {
                this.withTexture(JsonUtil.getJsonString(obj, "texture"));
            } else if (this.isParallaxEnabled) {
                this.withTexture("textures/item/reticle4.png");
            }
            this.withMaxAngularOffset(JsonUtil.getJsonFloat(obj, "maxAngularOffset", 5.0f));
            return this;
        }

        @Override
        public ReticleFeature build(FeatureProvider featureProvider) {
            ResourceLocation texture = this.texture;
            if (texture == null) {
                texture = this.isParallaxEnabled ? new ResourceLocation("pointblank", "textures/item/reticle4.png") : new ResourceLocation("pointblank", "textures/item/reticle.png");
            }
            return new ReticleFeature(featureProvider, this.condition, texture, this.isParallaxEnabled, this.maxAngularOffsetCos, this.script);
        }
    }
}

