/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import mod.pbj.client.GunClientState;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.feature.Features;
import mod.pbj.script.Script;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.util.ClientUtils;

public class SkinFeature
extends ConditionalFeature {
    private ResourceLocation texture;
    @Nullable
    private final Script script;
    private Map<String, Pair<ResourceLocation, Predicate<ConditionContext>>> conditions;

    private SkinFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, ResourceLocation texture, Script script, Map<String, Pair<ResourceLocation, Predicate<ConditionContext>>> conditions) {
        super(owner, predicate);
        this.texture = texture;
        this.script = script;
        this.conditions = conditions;
    }

    public MutableComponent getDescription() {
        return Component.m_237113_((String)"Changes skin");
    }

    public static ResourceLocation getTexture(ItemStack itemStack) {
        Object object;
        Features.EnabledFeature enabledSkinTexture = Features.getFirstEnabledFeature(itemStack, SkinFeature.class);
        if (enabledSkinTexture != null && (object = enabledSkinTexture.feature()) instanceof SkinFeature) {
            SkinFeature feature = (SkinFeature)object;
            if (feature.conditions != null && !feature.conditions.isEmpty()) {
                for (Map.Entry entry : feature.conditions.entrySet()) {
                    String gunId;
                    GunClientState gunState = GunClientState.getMainHeldState(ClientUtils.getClientPlayer());
                    ConditionContext testCondition = new ConditionContext(itemStack, gunState);
                    if (gunState != null && itemStack.m_41720_().toString().equals(entry.getKey()) && !((Predicate)((Pair)entry.getValue()).getSecond()).test(testCondition)) {
                        return null;
                    }
                    if (gunState == null || !itemStack.m_41720_().toString().equals(entry.getKey())) continue;
                    if (feature.hasFunction("getSkinTexture")) {
                        return (ResourceLocation)feature.invokeFunction("getSkinTexture", itemStack, feature);
                    }
                    if (feature.conditions == null || !feature.conditions.containsKey(gunId = itemStack.m_41720_().toString())) continue;
                    return (ResourceLocation)feature.conditions.get(gunId).getFirst();
                }
            }
            return feature.texture;
        }
        return null;
    }

    @Override
    @Nullable
    public Script getScript() {
        return this.script;
    }

    public static class Builder
    implements FeatureBuilder<Builder, SkinFeature> {
        private Predicate<ConditionContext> condition = ctx -> true;
        private ResourceLocation skinResource;
        private Script script;
        private Map<String, Pair<ResourceLocation, Predicate<ConditionContext>>> conditions;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withTexture(String texture) {
            this.skinResource = new ResourceLocation("pointblank", texture);
            return this;
        }

        public Builder withScript(Script script) {
            this.script = script;
            return this;
        }

        public Builder withTextures(JsonArray tArr) {
            this.conditions = new HashMap<String, Pair<ResourceLocation, Predicate<ConditionContext>>>();
            for (int i = 0; i < tArr.size(); ++i) {
                JsonObject obj = tArr.get(i).getAsJsonObject();
                String gunId = obj.get("gunId").getAsString();
                String texture = obj.get("texture").getAsString();
                Predicate<ConditionContext> skinCondition = ctx -> true;
                if (obj.has("condition") && obj.get("condition") != null) {
                    skinCondition = Conditions.fromJson(obj.get("condition"));
                }
                this.conditions.put(gunId, (Pair<ResourceLocation, Predicate<ConditionContext>>)Pair.of((Object)new ResourceLocation("pointblank", texture), skinCondition));
            }
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("texture")) {
                this.withTexture(JsonUtil.getJsonString(obj, "texture"));
            }
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            if (obj.has("skins")) {
                this.withTextures(obj.getAsJsonArray("skins"));
            }
            this.withScript(JsonUtil.getJsonScript(obj));
            return this;
        }

        @Override
        public SkinFeature build(FeatureProvider featureProvider) {
            return new SkinFeature(featureProvider, this.condition, this.skinResource, this.script, this.conditions);
        }
    }
}

