/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mod.pbj.attachment.AttachmentHost;
import mod.pbj.attachment.Attachments;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.item.AttachmentItem;
import mod.pbj.script.Script;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class SlotFeature
extends ConditionalFeature {
    public int weight = 64;
    @Nullable
    public List<Either<Either<Supplier<Item>, TagKey<Item>>, Class<? extends Item>>> whitelist = null;
    public final Script script;

    public SlotFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, int weight, List<Either<Either<Supplier<Item>, TagKey<Item>>, Class<? extends Item>>> whitelist, Script script) {
        super(owner, predicate);
        this.script = script;
        this.weight = weight;
        this.whitelist = whitelist;
    }

    public static int getWeight(ItemStack itemStack, List<Either<Either<Supplier<Item>, TagKey<Item>>, Class<? extends Item>>> whitelist) {
        if (itemStack.m_41619_() || itemStack.m_41613_() == 0) {
            return 99999;
        }
        if (whitelist == null) {
            return 64 / itemStack.m_41613_();
        }
        if (SlotFeature.matches(itemStack, whitelist)) {
            return 64 / itemStack.m_41613_();
        }
        return -1;
    }

    public static boolean matches(ItemStack itemStack, List<Either<Either<Supplier<Item>, TagKey<Item>>, Class<? extends Item>>> whitelist) {
        if (whitelist == null || whitelist.isEmpty()) {
            return true;
        }
        for (Either<Either<Supplier<Item>, TagKey<Item>>, Class<? extends Item>> entry : whitelist) {
            Class itemClass;
            TagKey tag;
            Item item;
            Either itemOrTag;
            if (!(entry.left().isPresent() ? ((itemOrTag = (Either)entry.left().get()).left().isPresent() ? itemStack.m_150930_(item = (Item)((Supplier)itemOrTag.left().get()).get()) : itemStack.m_204117_(tag = (TagKey)itemOrTag.right().get())) : (itemClass = (Class)entry.right().get()).isInstance(itemStack.m_41720_()))) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Script getScript() {
        return this.script;
    }

    public static interface SlotHolder {
        public static final String TAG = "Items";

        default public boolean stack(ItemStack pStack, ItemStack pOther, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
            if (pAction == ClickAction.PRIMARY && pOther.m_41619_()) {
                return false;
            }
            if (pAction == ClickAction.SECONDARY && pOther.m_41619_()) {
                this.removeItem(pStack, pPlayer, pAccess);
                return true;
            }
            if (pOther.m_41619_()) {
                return false;
            }
            return this.addItem(pStack, pOther);
        }

        default public boolean addItem(ItemStack pStack, ItemStack toAdd) {
            Item item;
            int weight = 0;
            ArrayList<Either<Either<Supplier<Item>, TagKey<Item>>, Class<? extends Item>>> whitelist = new ArrayList<Either<Either<Supplier<Item>, TagKey<Item>>, Class<? extends Item>>>();
            if (!pStack.m_41784_().m_128441_(TAG)) {
                pStack.m_41784_().m_128365_(TAG, (Tag)new ListTag());
            }
            if ((item = pStack.m_41720_()) instanceof AttachmentHost) {
                AttachmentHost host = (AttachmentHost)item;
                if (host.hasFeature(SlotFeature.class)) {
                    SlotFeature selfFeature = (SlotFeature)host.getFeature(SlotFeature.class);
                    weight += selfFeature.weight;
                    if (selfFeature.whitelist != null) {
                        whitelist.addAll(selfFeature.whitelist);
                    }
                }
                for (ItemStack attachment : Attachments.getAttachments(pStack)) {
                    if (!((AttachmentItem)attachment.m_41720_()).hasFeature(SlotFeature.class)) continue;
                    SlotFeature feature = ((AttachmentItem)attachment.m_41720_()).getFeature(SlotFeature.class);
                    weight += feature.weight;
                    if (feature.whitelist == null) continue;
                    whitelist.addAll(feature.whitelist);
                }
                if (this.getTotalWeight(pStack) >= weight) {
                    return false;
                }
                if (!toAdd.m_41619_() && SlotFeature.matches(toAdd, whitelist)) {
                    int countToAdd;
                    int stackWeight = 0;
                    for (countToAdd = 0; countToAdd < toAdd.m_41613_(); ++countToAdd) {
                        if (this.getTotalWeight(pStack) + (stackWeight += 64 / toAdd.m_41741_()) <= weight) continue;
                        stackWeight -= 64 / toAdd.m_41741_();
                        break;
                    }
                    this.add(pStack, toAdd, countToAdd);
                    toAdd.m_41774_(countToAdd);
                    return true;
                }
                return false;
            }
            return false;
        }

        default public boolean removeItem(ItemStack pStack, Player entity, SlotAccess pSlot) {
            boolean allow = false;
            this.getContents(pStack).findFirst().ifPresent(item -> {
                Tag list = pStack.m_41784_().m_128423_(TAG);
                if (!(list instanceof ListTag)) {
                    return;
                }
                ListTag listTag = (ListTag)list;
                listTag.remove((Object)item.m_41739_(new CompoundTag()));
                int itemWeight = SlotFeature.getWeight(item, this.getWhitelist(pStack));
                pSlot.m_142104_(item);
            });
            return allow;
        }

        default public int getTotalWeight(ItemStack pStack) {
            return this.getContents(pStack).mapToInt(stack -> 64 / stack.m_41741_() * stack.m_41613_()).sum();
        }

        default public void add(ItemStack pStack, ItemStack toAdd, int countToAdd) {
            Tag tag = pStack.m_41784_().m_128423_(TAG);
            if (tag instanceof ListTag) {
                ListTag listTag = (ListTag)tag;
                listTag.add((Object)toAdd.m_255036_(countToAdd).m_41739_(new CompoundTag()));
            }
        }

        default public int getMaxWeight(ItemStack pStack) {
            int weight = 0;
            SlotHolder slotHolder = this;
            if (slotHolder instanceof AttachmentHost) {
                AttachmentHost host = (AttachmentHost)((Object)slotHolder);
                if (host.hasFeature(SlotFeature.class)) {
                    SlotFeature selfFeature = (SlotFeature)host.getFeature(SlotFeature.class);
                    weight += selfFeature.weight;
                }
                for (ItemStack attachment : Attachments.getAttachments(pStack)) {
                    if (!((AttachmentItem)attachment.m_41720_()).hasFeature(SlotFeature.class)) continue;
                    SlotFeature feature = ((AttachmentItem)attachment.m_41720_()).getFeature(SlotFeature.class);
                    weight += feature.weight;
                }
            }
            return weight;
        }

        default public Stream<ItemStack> getContents(ItemStack pStack) {
            CompoundTag compoundtag = pStack.m_41783_();
            if (compoundtag == null) {
                return Stream.empty();
            }
            ListTag listtag = compoundtag.m_128437_(TAG, 10);
            return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
        }

        @Nullable
        default public List<Either<Either<Supplier<Item>, TagKey<Item>>, Class<? extends Item>>> getWhitelist(ItemStack pStack) {
            ArrayList<Either<Either<Supplier<Item>, TagKey<Item>>, Class<? extends Item>>> whitelist = new ArrayList<Either<Either<Supplier<Item>, TagKey<Item>>, Class<? extends Item>>>();
            SlotHolder slotHolder = this;
            if (slotHolder instanceof AttachmentHost) {
                AttachmentHost host = (AttachmentHost)((Object)slotHolder);
                if (host.hasFeature(SlotFeature.class)) {
                    SlotFeature selfFeature = (SlotFeature)host.getFeature(SlotFeature.class);
                    if (selfFeature.whitelist != null) {
                        whitelist.addAll(selfFeature.whitelist);
                    }
                }
                for (ItemStack attachment : Attachments.getAttachments(pStack)) {
                    if (!((AttachmentItem)attachment.m_41720_()).hasFeature(SlotFeature.class)) continue;
                    SlotFeature feature = ((AttachmentItem)attachment.m_41720_()).getFeature(SlotFeature.class);
                    if (feature.whitelist == null) continue;
                    whitelist.addAll(feature.whitelist);
                }
            }
            return whitelist;
        }
    }

    public static class Builder
    implements FeatureBuilder<Builder, SlotFeature> {
        public int maxStackSize = 64;
        public Predicate<ConditionContext> predicate = ctx -> true;
        public Script script = null;
        public List<Either<Either<Supplier<Item>, TagKey<Item>>, Class<? extends Item>>> whitelist;

        public Builder withMaxStackSize(int maxStackSize) {
            this.maxStackSize = maxStackSize;
            return this;
        }

        public Builder withPredicate(Predicate<ConditionContext> predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder withScript(Script script) {
            this.script = script;
            return this;
        }

        public Builder withWhitelist(JsonArray list) {
            ArrayList<Either<Either<Supplier<Item>, TagKey<Item>>, Class<? extends Item>>> whitelist = new ArrayList<Either<Either<Supplier<Item>, TagKey<Item>>, Class<? extends Item>>>();
            for (JsonElement jsonElement : list) {
                String element = jsonElement.getAsString();
                if (element.startsWith("class")) {
                    String className = element.substring(6);
                    try {
                        Class<?> itemClass = Class.forName(className);
                        whitelist.add((Either<Either<Supplier<Item>, TagKey<Item>>, Class<? extends Item>>)Either.right(itemClass));
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Class not found: " + className + " | a Pointblank Slot feature has malformed whitelist!", e);
                    }
                }
                String itemName = element;
                if (itemName.startsWith("#")) {
                    String tagName = itemName.substring(1);
                    TagKey tagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation(tagName));
                    whitelist.add((Either<Either<Supplier<Item>, TagKey<Item>>, Class<? extends Item>>)Either.left((Object)Either.right((Object)tagKey)));
                    continue;
                }
                whitelist.add((Either<Either<Supplier<Item>, TagKey<Item>>, Class<? extends Item>>)Either.left((Object)Either.left(() -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName)))));
            }
            this.whitelist = whitelist;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject var1) {
            this.withScript(JsonUtil.getJsonScript(var1));
            this.withMaxStackSize(JsonUtil.getJsonInt(var1, "weight", 64));
            if (var1.has("condition")) {
                this.withPredicate(Conditions.fromJson((JsonElement)var1.getAsJsonObject("condition")));
            }
            if (var1.has("whitelist")) {
                this.withWhitelist(var1.getAsJsonArray("whitelist"));
            }
            return this;
        }

        @Override
        public SlotFeature build(FeatureProvider var1) {
            return new SlotFeature(var1, this.predicate, this.maxStackSize, this.whitelist, this.script);
        }
    }
}

