/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.inventory;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mod.pbj.Nameable;
import mod.pbj.attachment.Attachment;
import mod.pbj.attachment.AttachmentCategory;
import mod.pbj.attachment.AttachmentHost;
import mod.pbj.attachment.Attachments;
import mod.pbj.event.AttachmentAddedEvent;
import mod.pbj.event.AttachmentRemovedEvent;
import mod.pbj.inventory.AttachmentContainerMenu;
import mod.pbj.inventory.AttachmentSlot;
import mod.pbj.inventory.SimpleAttachmentContainer;
import mod.pbj.inventory.SlotMapping;
import mod.pbj.util.MiscUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VirtualInventory
implements ContainerListener {
    private static final Logger logger = LogManager.getLogger((String)"pointblank");
    protected AttachmentCategory category;
    protected ItemStack itemStack;
    protected VirtualInventory parent;
    protected Map<AttachmentCategory, VirtualInventory> elements;
    protected Player owner;

    private VirtualInventory(Player owner, AttachmentCategory category, VirtualInventory parent, ItemStack itemStack) {
        this.owner = owner;
        this.category = category;
        this.parent = parent;
        this.itemStack = itemStack != null ? itemStack : ItemStack.f_41583_;
        this.elements = new LinkedHashMap<AttachmentCategory, VirtualInventory>();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    private void addElement(VirtualInventory e) {
        AttachmentCategory category = e.category;
        if (category == null) {
            logger.error("Adding an element without a category");
        }
        this.elements.put(e.category, e);
    }

    public Map<AttachmentCategory, VirtualInventory> getElements() {
        return Collections.unmodifiableMap(this.elements);
    }

    public VirtualInventory getElement(AttachmentCategory category) {
        return this.elements.get(category);
    }

    private Collection<AttachmentCategory> getCategories() {
        return this.elements.keySet();
    }

    public boolean mayPlace(ItemStack attachmentStack, AttachmentSlot attachmentSlot) {
        if (attachmentSlot.getSlotIndex() > this.elements.size()) {
            return false;
        }
        if (!this.isCompatibleAttachment(attachmentStack)) {
            return false;
        }
        AttachmentCategory attachmentCategory = ((Attachment)attachmentStack.m_41720_()).getCategory();
        return !this.hasAttachmentInCategory(attachmentCategory);
    }

    public boolean hasAttachments() {
        return this.elements.values().stream().anyMatch(e -> e.itemStack != null && !e.itemStack.m_41619_());
    }

    private boolean hasAttachmentInCategory(AttachmentCategory category) {
        VirtualInventory e = this.elements.get(category);
        return e != null && e.itemStack != null && !e.itemStack.m_41619_();
    }

    private boolean isCompatibleAttachment(ItemStack attachmentStack) {
        Item var3 = attachmentStack.m_41720_();
        if (var3 instanceof Attachment) {
            Attachment attachment = (Attachment)var3;
            if (((AttachmentHost)this.itemStack.m_41720_()).getCompatibleAttachments().contains(attachment)) {
                boolean var10000 = true;
                return var10000;
            }
        }
        boolean var10000 = false;
        return var10000;
    }

    public boolean mayPickup(Player player) {
        return false;
    }

    String getPath() {
        if (this.parent != null) {
            Item var2 = this.itemStack.m_41720_();
            if (var2 instanceof Nameable) {
                Nameable nameable = (Nameable)var2;
                String var3 = this.parent.getPath();
                return var3 + "/" + nameable.getName();
            }
            String var10000 = this.parent.getPath();
            return var10000 + "/" + String.valueOf(this.itemStack.m_41720_());
        }
        return MiscUtil.getItemStackId(this.itemStack).toString();
    }

    private ItemStack getRootStack() {
        return this.parent != null ? this.parent.getRootStack() : this.itemStack;
    }

    public void m_5757_(Container c) {
        if (c instanceof SimpleAttachmentContainer) {
            SimpleAttachmentContainer container = (SimpleAttachmentContainer)c;
            AttachmentContainerMenu menu = container.getMenu();
            logger.debug("Virtual inventory {} handling changes in container {}, stack tags {}", (Object)this, (Object)container, (Object)this.itemStack.m_41783_());
            SlotMapping slotMapping = menu.getSlotMapping();
            Map<Integer, AttachmentCategory> stackSlotMapping = slotMapping.getStackSlotMapping(this);
            if (stackSlotMapping == null) {
                logger.warn("Slot mapping not found for container {}, stack tags {}", (Object)System.identityHashCode(container), (Object)this.itemStack.m_41783_());
            } else {
                List<Attachment> removedItems = Attachments.removeAllAttachments(this.itemStack);
                for (int i = 1; i < container.m_6643_(); ++i) {
                    Event event;
                    Object category;
                    ItemStack slotStack = container.m_8020_(i);
                    if (!slotStack.m_41619_() && (category = slotStack.m_41720_()) instanceof Attachment) {
                        Attachment a1 = (Attachment)category;
                        logger.debug("Adding attachment '{}' from slot {} with tag {} to stack '{}'", (Object)slotStack, (Object)i, (Object)slotStack.m_41783_(), (Object)this.itemStack);
                        Attachments.addAttachment(this.itemStack, slotStack, true);
                        if (!removedItems.contains(a1)) {
                            event = new AttachmentAddedEvent(this.itemStack, slotStack);
                            MinecraftForge.EVENT_BUS.post(event);
                            logger.debug("Added new attachment '{}' from slot {} with tag {} to stack '{}' with tag {} and path {}", (Object)slotStack, (Object)i, (Object)slotStack.m_41783_(), (Object)this.itemStack, (Object)this.itemStack.m_41783_());
                        } else {
                            logger.debug("Re-added existing attachment '{}' from slot {} with tag {} to stack '{}' with tag {}", (Object)slotStack, (Object)i, (Object)slotStack.m_41783_(), (Object)this.itemStack, (Object)this.itemStack.m_41783_());
                        }
                        stackSlotMapping.put(i, a1.getCategory());
                        VirtualInventory childInventory = VirtualInventory.createInventory(this.owner, this, slotStack);
                        if (childInventory == null) continue;
                        this.elements.put(a1.getCategory(), childInventory);
                        continue;
                    }
                    category = stackSlotMapping.remove(i);
                    if (category == null) continue;
                    logger.debug("Removing attachment '{}' from slot {}, with tag {} from stack '{}'", (Object)slotStack, (Object)i, (Object)slotStack.m_41783_(), (Object)this.itemStack);
                    VirtualInventory e = this.elements.get(category);
                    if (e == null) continue;
                    event = new AttachmentRemovedEvent(this.owner, this.getRootStack(), this.itemStack, slotStack);
                    MinecraftForge.EVENT_BUS.post(event);
                    e.itemStack = ItemStack.f_41583_;
                    e.elements.clear();
                }
                slotMapping.saveSlotMapping();
                if (this.parent != null) {
                    this.parent.onContentChange();
                }
                menu.updateAttachmentSlots();
                menu.m_38946_();
                logger.debug("Virtual inventory {} handled changes for container {}, stack tags {}", (Object)this, (Object)container, (Object)this.itemStack.m_41783_());
            }
        }
    }

    private void onContentChange() {
        logger.debug("Updating tag content for {}, tag: {}", (Object)this, (Object)this.itemStack.m_41783_());
        this.updateTag();
        logger.debug("Updating tag content for {}, tag: {}", (Object)this, (Object)this.itemStack.m_41783_());
        if (this.parent != null) {
            this.parent.updateTag();
        }
    }

    private CompoundTag updateTag() {
        if (this.itemStack == null) {
            return null;
        }
        if (this.itemStack.m_41619_()) {
            logger.error("Virtual inventory {} attempted to update empty stack {}", (Object)this, (Object)this.itemStack);
            return null;
        }
        CompoundTag tag = this.itemStack.m_41784_();
        Item item = this.itemStack.m_41720_();
        if (item instanceof Attachment) {
            Attachment attachment = (Attachment)item;
            String attachmentId = ForgeRegistries.ITEMS.getKey((Object)attachment.m_5456_()).toString();
            tag.m_128359_("id", attachmentId);
            boolean isRemovable = !tag.m_128425_("rmv", 99) || tag.m_128471_("rmv");
            tag.m_128379_("rmv", isRemovable);
        }
        ListTag nestedAttachments = tag.m_128437_("as", 10);
        nestedAttachments.clear();
        for (Map.Entry<AttachmentCategory, VirtualInventory> e : this.elements.entrySet()) {
            CompoundTag nestedAttachmentTag = e.getValue().updateTag();
            if (nestedAttachmentTag == null) continue;
            nestedAttachments.add((Object)nestedAttachmentTag);
        }
        tag.m_128365_("as", (Tag)nestedAttachments);
        return tag;
    }

    Map<Integer, AttachmentCategory> createSlotMapping(String stackId) {
        HashMap<Integer, AttachmentCategory> mapping = new HashMap<Integer, AttachmentCategory>();
        int i = 1;
        for (AttachmentCategory category : this.getCategories()) {
            VirtualInventory e = this.getElement(category);
            ItemStack itemStack = e.getItemStack();
            if (itemStack != null && !itemStack.m_41619_()) {
                mapping.put(i, category);
            }
            ++i;
        }
        return mapping;
    }

    boolean isValidSlotMapping(Map<Integer, AttachmentCategory> mapping) {
        return mapping.isEmpty() ? this.elements.isEmpty() : this.elements.keySet().containsAll(mapping.values());
    }

    public String toString() {
        return String.format("{vi: %d, path: %s, elements: %s}", System.identityHashCode(this), this.getPath(), this.elements);
    }

    private static VirtualInventory createInventory(Player owner, VirtualInventory parentInventory, ItemStack currentStack) {
        Item currentTag;
        AttachmentCategory currentCategory = null;
        if (currentStack != null && (currentTag = currentStack.m_41720_()) instanceof Attachment) {
            Attachment attachment = (Attachment)currentTag;
            currentCategory = attachment.getCategory();
        }
        VirtualInventory currentInventory = new VirtualInventory(owner, currentCategory, parentInventory, currentStack);
        if (currentStack != null) {
            CompoundTag currentTag2 = currentStack.m_41784_();
            Item attachmentStacks = currentStack.m_41720_();
            if (attachmentStacks instanceof AttachmentHost) {
                AttachmentHost attachmentHost = (AttachmentHost)attachmentStacks;
                HashMap<AttachmentCategory, ItemStack> var17 = new HashMap<AttachmentCategory, ItemStack>();
                if (currentTag2.m_128425_("as", 9)) {
                    ListTag attachmentsList = currentTag2.m_128437_("as", 10);
                    for (int i = 0; i < attachmentsList.size(); ++i) {
                        CompoundTag attachmentTag = attachmentsList.m_128728_(i);
                        String itemId = attachmentTag.m_128461_("id");
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
                        if (!(item instanceof Attachment)) continue;
                        Attachment attachment = (Attachment)item;
                        ItemStack attachmentItemStack = new ItemStack((ItemLike)item);
                        attachmentItemStack.m_41751_(attachmentTag);
                        var17.put(attachment.getCategory(), attachmentItemStack);
                    }
                }
                for (AttachmentCategory category : attachmentHost.getCompatibleAttachmentCategories()) {
                    ItemStack attachmentStack = (ItemStack)var17.get(category);
                    VirtualInventory nestedInventory = attachmentStack == null ? new VirtualInventory(owner, category, currentInventory, null) : VirtualInventory.createInventory(owner, currentInventory, attachmentStack);
                    if (nestedInventory == null) continue;
                    currentInventory.addElement(nestedInventory);
                }
                logger.debug("Created {} with stack: {}, tag {}, elements: {}", (Object)currentInventory, (Object)currentStack, (Object)currentStack.m_41783_(), currentInventory.elements);
            }
        }
        return currentInventory;
    }

    public static VirtualInventory createInventory(Player owner, ItemStack mainStack) {
        return VirtualInventory.createInventory(owner, null, mainStack);
    }
}

