/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mod.pbj.Nameable;
import mod.pbj.attachment.Attachment;
import mod.pbj.attachment.AttachmentCategory;
import mod.pbj.attachment.AttachmentHost;
import mod.pbj.attachment.Attachments;
import mod.pbj.client.controller.GlowAnimationController;
import mod.pbj.client.effect.AbstractEffect;
import mod.pbj.client.render.ArmorInHandRenderer;
import mod.pbj.client.render.ArmorItemRenderer;
import mod.pbj.crafting.Craftable;
import mod.pbj.feature.AttributeFeature;
import mod.pbj.feature.DefenseFeature;
import mod.pbj.feature.DescriptionFeature;
import mod.pbj.feature.Feature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.Features;
import mod.pbj.feature.SlotFeature;
import mod.pbj.item.AttachmentItem;
import mod.pbj.item.GunItem;
import mod.pbj.item.ItemBuilder;
import mod.pbj.item.ScriptHolder;
import mod.pbj.registry.ItemRegistry;
import mod.pbj.script.Script;
import mod.pbj.util.JsonUtil;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ArmorItem
extends net.minecraft.world.item.ArmorItem
implements Equipable,
Nameable,
ScriptHolder,
Craftable,
AttachmentHost,
GeoItem,
SlotFeature.SlotHolder {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final String name;
    public ResourceLocation modelResourceLocation;
    private final List<Supplier<Attachment>> compatibleAttachmentsSuppliers;
    private Collection<Attachment> compatibleAttachments;
    private final List<String> compatibleAttachmentGroups;
    private final Map<Class<? extends Feature>, Feature> features;
    private final List<Supplier<AttachmentItem>> defaultAttachments;
    private final Script script;
    private static final EnumMap<ArmorItem.Type, UUID> ARMOR_MODIFIER_UUID_PER_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), p_266744_ -> {
        p_266744_.put(ArmorItem.Type.BOOTS, UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"));
        p_266744_.put(ArmorItem.Type.LEGGINGS, UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"));
        p_266744_.put(ArmorItem.Type.CHESTPLATE, UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"));
        p_266744_.put(ArmorItem.Type.HELMET, UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"));
    });
    protected final ArmorItem.Type type;
    private final int defense;
    private final float toughness;
    protected final float knockbackResistance;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private final Ingredient repairMaterial;
    private final long craftingDuration;
    private final SoundEvent equipSound;
    private final List<GlowAnimationController.Builder> glowEffectBuilders;
    boolean equipped = false;
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);

    public ArmorItem(Builder builder, String namespace) {
        super((ArmorMaterial)ArmorMaterials.LEATHER, builder.armorType, new Item.Properties().m_41487_(1).m_41503_(builder.durability));
        this.name = builder.name;
        this.modelResourceLocation = this.name.contains(":") ? ResourceLocation.parse((String)this.name) : ResourceLocation.fromNamespaceAndPath((String)namespace, (String)this.name);
        this.glowEffectBuilders = builder.glowEffectBuilders;
        this.defense = builder.armor;
        this.type = builder.armorType;
        this.toughness = builder.armorToughness;
        this.equipSound = builder.equipSound;
        this.knockbackResistance = builder.knockbackResistance;
        this.compatibleAttachmentGroups = builder.compatibleAttachmentGroups;
        this.defaultAttachments = builder.defaultAttachments;
        this.compatibleAttachmentsSuppliers = builder.compatibleAttachments;
        this.script = builder.script;
        this.craftingDuration = builder.craftingDuration;
        this.repairMaterial = Ingredient.m_43921_(builder.repairItems.stream());
        HashMap features = new HashMap();
        for (FeatureBuilder<?, ?> featureBuilder : builder.featureBuilders) {
            Object feature = featureBuilder.build(this);
            features.put(feature.getClass(), feature);
        }
        this.features = Collections.unmodifiableMap(features);
        ImmutableMultimap.Builder attrbuilder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIER_UUID_PER_TYPE.get(builder.armorType);
        attrbuilder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)this.defense, AttributeModifier.Operation.ADDITION));
        attrbuilder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)this.toughness, AttributeModifier.Operation.ADDITION));
        if (this.knockbackResistance > 0.0f) {
            attrbuilder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)this.knockbackResistance, AttributeModifier.Operation.ADDITION));
        }
        this.defaultModifiers = attrbuilder.build();
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void equipArmor() {
    }

    public void unequipArmor() {
    }

    boolean hasSlots(ItemStack pStack) {
        int addedSlots = 0;
        int weight = 0;
        for (ItemStack attachment : Attachments.getAttachments(pStack)) {
            SlotFeature feature;
            AttachmentItem attachmentI = (AttachmentItem)attachment.m_41720_();
            if (!attachmentI.hasFeature(SlotFeature.class) || (feature = ((AttachmentItem)attachment.m_41720_()).getFeature(SlotFeature.class)) == null) continue;
            ++addedSlots;
            weight += feature.weight;
        }
        return addedSlots > 0;
    }

    public boolean m_142305_(ItemStack pStack, ItemStack pOther, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        return this.stack(pStack, pOther, pAction, pPlayer, pAccess);
    }

    public boolean m_142522_(ItemStack pStack) {
        return false;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack pStack) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        this.getContents(pStack).forEach(arg_0 -> nonnulllist.add(arg_0));
        int weight = this.getTotalWeight(pStack);
        if (this.getMaxWeight(pStack) == 0) {
            return Optional.empty();
        }
        return Optional.of(new BundleTooltip(nonnulllist, weight));
    }

    public void m_142023_(ItemEntity pItemEntity) {
        ItemUtils.m_150952_((ItemEntity)pItemEntity, (Stream)this.getContents(pItemEntity.m_32055_()));
    }

    private void playRemoveOneSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playDropContentsSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)pEntity;
            this.invokeFunction("inventoryTick", new Object[]{pStack, pLevel, entity});
            for (ItemStack attachment : Attachments.getAttachments(pStack)) {
                ((AttachmentItem)attachment.m_41720_()).invokeFunction("inventoryTick$A", new Object[]{pStack, pLevel, entity});
            }
        }
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (!this.equipped) {
            this.equipped = true;
            this.equipArmor();
        }
        this.invokeFunction("armorTick", new Object[]{stack, level, player});
        for (ItemStack attachment : Attachments.getAttachments(stack)) {
            ((AttachmentItem)attachment.m_41720_()).invokeFunction("armorTick$A", new Object[]{stack, level, player});
        }
    }

    @Override
    public Collection<Attachment> getCompatibleAttachments() {
        if (this.compatibleAttachments == null) {
            HashSet<AttachmentCategory> attachmentCategories = new HashSet<AttachmentCategory>();
            LinkedHashSet<Attachment> compatibleAttachments = new LinkedHashSet<Attachment>();
            for (Attachment attachment : this.getDefaultAttachments()) {
                if (attachmentCategories.size() >= this.getMaxAttachmentCategories()) break;
                attachmentCategories.add(attachment.getCategory());
                compatibleAttachments.add(attachment);
            }
            for (Supplier supplier : this.compatibleAttachmentsSuppliers) {
                Attachment attachment = (Attachment)supplier.get();
                if (attachmentCategories.size() >= this.getMaxAttachmentCategories()) break;
                attachmentCategories.add(attachment.getCategory());
                compatibleAttachments.add(attachment);
            }
            block2: for (String string : this.compatibleAttachmentGroups) {
                for (Supplier<? extends Item> ga : ItemRegistry.ITEMS.getAttachmentsForGroup(string)) {
                    Item item = ga.get();
                    if (!(item instanceof Attachment)) continue;
                    Attachment attachment = (Attachment)item;
                    if (attachmentCategories.size() >= this.getMaxAttachmentCategories()) continue block2;
                    compatibleAttachments.add(attachment);
                }
            }
            this.compatibleAttachments = compatibleAttachments;
        }
        return this.compatibleAttachments;
    }

    @Override
    public long getCraftingDuration() {
        return this.craftingDuration;
    }

    @Override
    public Collection<Feature> getFeatures() {
        return this.features.values();
    }

    @Override
    @Nullable
    public Script getScript() {
        return this.script;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private ArmorItemRenderer renderer = null;
            public ArmorInHandRenderer inHandRenderer = null;

            @NotNull
            public ArmorItemRenderer getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.inHandRenderer == null) {
                    this.inHandRenderer = new ArmorInHandRenderer(ArmorItem.this.modelResourceLocation, ArmorItem.this.glowEffectBuilders);
                }
                if (this.renderer == null) {
                    this.renderer = new ArmorItemRenderer(((ArmorItem)itemStack.m_41720_()).modelResourceLocation, this.inHandRenderer);
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.inHandRenderer == null) {
                    this.inHandRenderer = new ArmorInHandRenderer(ArmorItem.this.modelResourceLocation, ArmorItem.this.glowEffectBuilders);
                }
                return this.inHandRenderer;
            }
        });
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public ArmorItem.Type m_266204_() {
        return this.type;
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_6832_(ItemStack pToRepair, ItemStack pRepair) {
        return this.repairMaterial.test(pRepair) || super.m_6832_(pToRepair, pRepair);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot pEquipmentSlot, ItemStack stack) {
        LinkedListMultimap multimap = LinkedListMultimap.create(this.defaultModifiers);
        for (AttributeFeature feature : Features.getEnabledFeatures(stack, AttributeFeature.class).stream().map(enb -> (AttributeFeature)enb.feature()).toList()) {
            multimap.get((Object)feature.baseAttribute).add(feature.modifier);
        }
        multimap.get((Object)Attributes.f_22284_).add(new AttributeModifier(ARMOR_MODIFIER_UUID_PER_TYPE.get(this.type), "Defense", (double)this.getAdjustedDefense(stack), AttributeModifier.Operation.ADDITION));
        multimap.get((Object)Attributes.f_22285_).add(new AttributeModifier(ARMOR_MODIFIER_UUID_PER_TYPE.get(this.type), "Toughness", (double)this.getAdjustedToughness(stack), AttributeModifier.Operation.ADDITION));
        return pEquipmentSlot == this.type.m_266308_() ? multimap : super.m_7167_(pEquipmentSlot);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        for (Feature descFeature : Features.getEnabledFeatures(pStack, DescriptionFeature.class).stream().map(Features.EnabledFeature::feature).toList()) {
            pTooltipComponents.add(((DescriptionFeature)descFeature).getMutableDescription());
        }
    }

    public int getDefaultTooltipHideFlags(@NotNull ItemStack stack) {
        return 2;
    }

    public int getAdjustedDefense(ItemStack stack) {
        float defenseMod = DefenseFeature.getDefenseModifier(stack);
        int defenseAdd = DefenseFeature.getDefenseAdditive(stack);
        int defenseFinal = (int)((float)this.defense * defenseMod) + defenseAdd;
        if (this.hasFunction("addArmorDefense")) {
            defenseFinal += ((Integer)this.invokeFunction("addArmorDefense", new Object[]{stack})).intValue();
        }
        if (this.hasFunction("mulArmorDefense")) {
            defenseFinal *= ((Integer)this.invokeFunction("mulArmorDefense", new Object[]{stack})).intValue();
        }
        return defenseFinal;
    }

    public float getAdjustedToughness(ItemStack stack) {
        float toughnessMod = DefenseFeature.getToughnessModifier(stack);
        float toughnessAdd = DefenseFeature.getToughnessAdditive(stack);
        float toughnessFinal = this.toughness * toughnessMod + toughnessAdd;
        if (this.hasFunction("addArmorToughness")) {
            toughnessFinal += (float)((Integer)this.invokeFunction("addArmorToughness", new Object[]{stack})).intValue();
        }
        if (this.hasFunction("mulArmorToughness")) {
            toughnessFinal *= (float)((Integer)this.invokeFunction("mulArmorToughness", new Object[]{stack})).intValue();
        }
        return toughnessFinal;
    }

    public int m_40404_() {
        return this.defense;
    }

    public float m_40405_() {
        return this.toughness;
    }

    public EquipmentSlot m_40402_() {
        return this.type.m_266308_();
    }

    public SoundEvent m_150681_() {
        return this.equipSound;
    }

    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        for (Supplier<AttachmentItem> attachmentSupplier : this.defaultAttachments) {
            Attachments.addAttachment(stack, attachmentSupplier.get().m_7968_(), true);
        }
        return stack;
    }

    public static class Builder
    extends ItemBuilder<Builder> {
        private long craftingDuration = 500L;
        private int armor;
        private float armorToughness;
        private float knockbackResistance;
        private int durability;
        private String name;
        private final SoundEvent equipSound = SoundEvents.f_11675_;
        private ArmorItem.Type armorType;
        private final List<ItemStack> repairItems;
        private final List<Supplier<Attachment>> compatibleAttachments;
        private final List<String> compatibleAttachmentGroups;
        private final List<FeatureBuilder<?, ?>> featureBuilders;
        private final List<Supplier<AttachmentItem>> defaultAttachments;
        private final List<GlowAnimationController.Builder> glowEffectBuilders = new ArrayList<GlowAnimationController.Builder>();
        private Script script;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withArmorToughness(float toughness) {
            this.armorToughness = toughness;
            return this;
        }

        public Builder withArmor(int armor) {
            this.armor = armor;
            return this;
        }

        public Builder withEquipSound(SoundEvent soundEvent) {
            this.armor = this.armor;
            return this;
        }

        public Builder withType(ArmorItem.Type type) {
            this.armorType = type;
            return this;
        }

        public Builder withScript(Script script) {
            this.script = script;
            return this;
        }

        public Builder withKnockbackResistance(float knockbackResistance) {
            this.knockbackResistance = knockbackResistance;
            return this;
        }

        private Builder withCraftingDuration(long craftingDuration) {
            this.craftingDuration = craftingDuration;
            return this;
        }

        private Builder withFeature(FeatureBuilder<?, ?> featureBuilder) {
            this.featureBuilders.add(featureBuilder);
            return this;
        }

        private Builder withDurability(int durability) {
            this.durability = durability;
            return this;
        }

        public Builder withGlow(String glowingPartName) {
            return this.withGlow(glowingPartName, null);
        }

        public Builder withGlow(String glowingPartName, String textureName) {
            return this.withGlow(Collections.singleton(GunItem.FirePhase.ANY), Collections.singleton(glowingPartName), textureName);
        }

        public Builder withGlow(Collection<GunItem.FirePhase> firePhases, String glowingPartName) {
            return this.withGlow(firePhases, Collections.singleton(glowingPartName), null);
        }

        public Builder withGlow(Collection<GunItem.FirePhase> firePhases, Collection<String> glowingPartNames, String texture) {
            GlowAnimationController.Builder builder = new GlowAnimationController.Builder().withFirePhases(firePhases);
            if (texture != null) {
                builder.withTexture(ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)texture));
            }
            builder.withGlowingPartNames(glowingPartNames);
            this.glowEffectBuilders.add(builder);
            return this;
        }

        public Builder withGlow(Collection<GunItem.FirePhase> firePhases, String glowingPartName, String texture, AbstractEffect.SpriteAnimationType spriteAnimationType, int spriteRows, int spriteColumns, int spritesPerSecond, Direction ... directions) {
            GlowAnimationController.Builder builder = new GlowAnimationController.Builder().withFirePhases(firePhases);
            if (texture != null) {
                builder.withTexture(ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)texture));
            }
            builder.withGlowingPartNames(Collections.singleton(glowingPartName));
            builder.withSprites(spriteRows, spriteColumns, spritesPerSecond, spriteAnimationType);
            builder.withDirections(directions);
            this.glowEffectBuilders.add(builder);
            return this;
        }

        public Builder() {
            this.compatibleAttachments = new ArrayList<Supplier<Attachment>>();
            this.compatibleAttachmentGroups = new ArrayList<String>();
            this.featureBuilders = new ArrayList();
            this.defaultAttachments = new ArrayList<Supplier<AttachmentItem>>();
            this.repairItems = new ArrayList<ItemStack>();
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            Supplier ri;
            this.withName(JsonUtil.getJsonString(obj, "name")).withScript(JsonUtil.getJsonScript(obj)).withCraftingDuration(JsonUtil.getJsonInt(obj, "craftingDuration", 500)).withArmor(JsonUtil.getJsonInt(obj, "defense", 0)).withDurability(JsonUtil.getJsonInt(obj, "durability", 128)).withArmorToughness(JsonUtil.getJsonFloat(obj, "toughness", 0.0f)).withType((ArmorItem.Type)JsonUtil.getEnum(obj, "armorType", ArmorItem.Type.class, ArmorItem.Type.HELMET, true));
            for (JsonObject featureObj : JsonUtil.getJsonObjects(obj, "features")) {
                FeatureBuilder<?, ?> featureBuilder = Features.fromJson(featureObj);
                this.withFeature(featureBuilder);
            }
            for (String compatibleAttachmentName : JsonUtil.getStrings(obj, "compatibleAttachments")) {
                ri = ItemRegistry.ITEMS.getDeferredRegisteredObject(compatibleAttachmentName);
                if (ri == null) continue;
                this.compatibleAttachments.add(() -> (Attachment)ri.get());
            }
            for (String compatibleAttachmentName : JsonUtil.getStrings(obj, "defaultAttachments")) {
                ri = ItemRegistry.ITEMS.getDeferredRegisteredObject(compatibleAttachmentName);
                if (ri == null) continue;
                this.defaultAttachments.add(() -> (AttachmentItem)ri.get());
            }
            for (JsonObject glowingPart : JsonUtil.getJsonObjects(obj, "glowingParts")) {
                String partName = JsonUtil.getJsonString(glowingPart, "name");
                List<GunItem.FirePhase> firePhases = Collections.singletonList(GunItem.FirePhase.ANY);
                String textureName = JsonUtil.getJsonString(glowingPart, "texture", null);
                Direction direction = (Direction)JsonUtil.getEnum(glowingPart, "direction", Direction.class, null, true);
                JsonObject spritesObj = glowingPart.getAsJsonObject("sprites");
                if (spritesObj != null) {
                    int rows = JsonUtil.getJsonInt(spritesObj, "rows", 1);
                    int columns = JsonUtil.getJsonInt(spritesObj, "columns", 1);
                    int fps = JsonUtil.getJsonInt(spritesObj, "fps", 60);
                    AbstractEffect.SpriteAnimationType spriteAnimationType = (AbstractEffect.SpriteAnimationType)JsonUtil.getEnum(spritesObj, "type", AbstractEffect.SpriteAnimationType.class, AbstractEffect.SpriteAnimationType.LOOP, true);
                    if (direction != null) {
                        this.withGlow(firePhases, partName, textureName, spriteAnimationType, rows, columns, fps, direction);
                        continue;
                    }
                    this.withGlow(firePhases, partName, textureName, spriteAnimationType, rows, columns, fps, new Direction[0]);
                    continue;
                }
                this.withGlow(firePhases, Collections.singletonList(partName), textureName);
            }
            List<String> compatibleAttachmentGroups = JsonUtil.getStrings(obj, "compatibleAttachmentGroups");
            this.compatibleAttachmentGroups.addAll(compatibleAttachmentGroups);
            return this;
        }

        public ArmorItem build() {
            return new ArmorItem(this, "pointblank");
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

