/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.item;

import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.pbj.attachment.Attachment;
import mod.pbj.attachment.AttachmentCategory;
import mod.pbj.attachment.AttachmentHost;
import mod.pbj.attachment.Attachments;
import mod.pbj.client.render.AttachmentModelRenderer;
import mod.pbj.crafting.Craftable;
import mod.pbj.feature.Feature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.feature.Features;
import mod.pbj.item.ItemBuilder;
import mod.pbj.item.ScriptHolder;
import mod.pbj.registry.ExtensionRegistry;
import mod.pbj.registry.ItemRegistry;
import mod.pbj.script.Script;
import mod.pbj.util.JsonUtil;
import mod.pbj.util.TimeUnit;
import mod.pbj.util.Tradeable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public final class AttachmentItem
extends Item
implements ScriptHolder,
GeoItem,
Attachment,
AttachmentHost,
FeatureProvider,
Craftable,
Tradeable {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private String name;
    private AttachmentCategory category;
    private List<String> compatibleAttachmentGroups;
    private List<Supplier<Attachment>> compatibleAttachmentSuppliers;
    private List<Attachment> compatibleAttachments;
    private Set<String> groups;
    private Map<Class<? extends Feature>, Feature> features;
    private long craftingDuration;
    private float tradePrice;
    private int tradeBundleQuantity;
    private int tradeLevel;
    private List<Component> descriptionLines;
    public List<Supplier<Attachment>> defaultAttachmentSuppliers;
    @Nullable
    private Script script;

    public AttachmentItem() {
        super(new Item.Properties());
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private AttachmentModelRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new AttachmentModelRenderer(AttachmentItem.this.name);
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "scriptAnimator", state -> PlayState.CONTINUE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<Feature> getFeatures() {
        return Collections.unmodifiableCollection(this.features.values());
    }

    @Override
    public List<Component> getDescriptionTooltipLines() {
        return this.descriptionLines;
    }

    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
    }

    @Override
    public AttachmentCategory getCategory() {
        return this.category;
    }

    @Override
    public Set<String> getGroups() {
        return this.groups;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    @Override
    public Collection<Attachment> getCompatibleAttachments() {
        if (this.compatibleAttachments == null) {
            this.compatibleAttachments = new ArrayList<Attachment>();
            for (Supplier<Attachment> cas : this.compatibleAttachmentSuppliers) {
                this.compatibleAttachments.add(cas.get());
            }
            for (String group : this.compatibleAttachmentGroups) {
                for (Supplier<? extends Item> ga : ItemRegistry.ITEMS.getAttachmentsForGroup(group)) {
                    Item item = ga.get();
                    if (!(item instanceof Attachment)) continue;
                    Attachment attachment = (Attachment)item;
                    this.compatibleAttachments.add(attachment);
                }
            }
        }
        return this.compatibleAttachments;
    }

    public Component m_7626_(ItemStack itemStack) {
        return Component.m_237115_((String)this.m_5671_(itemStack));
    }

    @Override
    public <T extends Feature> T getFeature(Class<T> featureClass) {
        return (T)((Feature)featureClass.cast(this.features.get(featureClass)));
    }

    @Override
    public long getCraftingDuration() {
        return this.craftingDuration;
    }

    @Override
    public float getPrice() {
        return this.tradePrice;
    }

    @Override
    public int getTradeLevel() {
        return this.tradeLevel;
    }

    @Override
    public int getBundleQuantity() {
        return this.tradeBundleQuantity;
    }

    public List<Attachment> getDefaultAttachments() {
        return this.defaultAttachmentSuppliers.stream().map(Supplier::get).toList();
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        if (!level.f_46443_) {
            this.ensureItemStack(itemStack);
        }
    }

    public void ensureItemStack(ItemStack itemStack) {
        CompoundTag stateTag = itemStack.m_41783_();
        if (stateTag == null) {
            stateTag = new CompoundTag();
            itemStack.m_41751_(stateTag);
            Item defaultAttachments = itemStack.m_41720_();
            if (defaultAttachments instanceof AttachmentHost) {
                AttachmentHost attachmentHost = (AttachmentHost)defaultAttachments;
                for (Attachment attachment : attachmentHost.getDefaultAttachments()) {
                    Attachments.addAttachment(itemStack, new ItemStack((ItemLike)attachment), true);
                }
            }
        }
    }

    @Override
    @Nullable
    public Script getScript() {
        return this.script;
    }

    public static class Builder
    extends ItemBuilder<Builder> {
        private static final int DEFAULT_CRAFTING_DURATION = 750;
        private static final float DEFAULT_PRICE = Float.NaN;
        private static final int DEFAULT_TRADE_LEVEL = 0;
        private static final int DEFAULT_TRADE_BUNDLE_QUANTITY = 1;
        private String name;
        private AttachmentCategory category;
        private final List<Supplier<Attachment>> compatibleAttachmentSuppliers = new ArrayList<Supplier<Attachment>>();
        private final List<String> compatibleAttachmentGroups = new ArrayList<String>();
        private final Set<String> groups = new HashSet<String>();
        private final List<FeatureBuilder<?, ?>> featureBuilders = new ArrayList();
        private long craftingDuration = 750L;
        private float tradePrice = Float.NaN;
        private int tradeBundleQuantity = 1;
        private int tradeLevel = 0;
        private final List<Component> descriptionLines = new ArrayList<Component>();
        private final List<Supplier<Attachment>> defaultAttachments = new ArrayList<Supplier<Attachment>>();
        @Nullable
        private Script script;

        public Builder(ExtensionRegistry.Extension extension) {
            this.extension = extension;
        }

        public Builder() {
            this.extension = new ExtensionRegistry.Extension("pointblank", Path.of("pointblank", new String[0]), "pointblank");
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withScript(Script script) {
            this.script = script;
            return this;
        }

        public Builder withCategory(String categoryName) {
            this.category = AttachmentCategory.fromString(categoryName);
            return this;
        }

        public Builder withCategory(AttachmentCategory category) {
            this.category = category;
            return this;
        }

        public Builder withDescription(Component description) {
            this.descriptionLines.add(description);
            return this;
        }

        public Builder withDescription(String description) {
            this.descriptionLines.add((Component)Component.m_237115_((String)description).m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
            return this;
        }

        public Builder withFeature(FeatureBuilder<?, ?> featureBuilder) {
            this.featureBuilders.add(featureBuilder);
            return this;
        }

        @SafeVarargs
        public final Builder withCompatibleAttachment(Supplier<? extends Attachment> ... attachmentSuppliers) {
            for (Supplier<? extends Attachment> s : attachmentSuppliers) {
                Objects.requireNonNull(s);
                this.compatibleAttachmentSuppliers.add(s::get);
            }
            return this;
        }

        public Builder withCompatibleAttachmentGroup(String ... groups) {
            this.compatibleAttachmentGroups.addAll(Set.of(groups));
            return this;
        }

        public Builder withGroup(String ... groups) {
            this.groups.addAll(Set.of(groups));
            return this;
        }

        public Builder withCraftingDuration(int duration, TimeUnit timeUnit) {
            this.craftingDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withTradePrice(double price, int tradeLevel) {
            this.tradePrice = (float)price;
            this.tradeLevel = tradeLevel;
            this.tradeBundleQuantity = 1;
            return this;
        }

        public Set<String> getGroups() {
            return Collections.unmodifiableSet(this.groups);
        }

        @SafeVarargs
        public final Builder withDefaultAttachment(Supplier<? extends Attachment> ... attachmentSuppliers) {
            for (Supplier<? extends Attachment> s : attachmentSuppliers) {
                Objects.requireNonNull(s);
                this.defaultAttachments.add(s::get);
            }
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            this.withName(JsonUtil.getJsonString(obj, "name"));
            String description = JsonUtil.getJsonString(obj, "description", null);
            if (description != null) {
                this.withDescription(description);
            }
            this.withCategory(JsonUtil.getJsonString(obj, "category"));
            this.withTradePrice(JsonUtil.getJsonFloat(obj, "tradePrice", Float.NaN), JsonUtil.getJsonInt(obj, "tradeLevel", 0));
            this.withCraftingDuration(JsonUtil.getJsonInt(obj, "craftingDuration", 750), TimeUnit.MILLISECOND);
            this.withScript(JsonUtil.getJsonScript(obj));
            List<String> groups = JsonUtil.getStrings(obj, "groups");
            this.groups.addAll(groups);
            for (JsonObject featureObj : JsonUtil.getJsonObjects(obj, "features")) {
                FeatureBuilder<?, ?> featureBuilder = Features.fromJson(featureObj);
                this.withFeature(featureBuilder);
            }
            for (String compatibleAttachmentName : JsonUtil.getStrings(obj, "compatibleAttachments")) {
                Supplier ri = ItemRegistry.ITEMS.getDeferredRegisteredObject(compatibleAttachmentName);
                if (ri == null) continue;
                this.withCompatibleAttachment(() -> (Attachment)ri.get());
            }
            List<String> compatibleAttachmentGroups = JsonUtil.getStrings(obj, "compatibleAttachmentGroups");
            this.compatibleAttachmentGroups.addAll(compatibleAttachmentGroups);
            for (String defaultAttachmentName : JsonUtil.getStrings(obj, "defaultAttachments")) {
                Supplier ri = ItemRegistry.ITEMS.getDeferredRegisteredObject(defaultAttachmentName);
                if (ri == null) continue;
                this.withDefaultAttachment(() -> (Attachment)ri.get());
            }
            return this;
        }

        @Override
        public AttachmentItem build() {
            Object feature;
            if (this.name == null) {
                throw new IllegalStateException("Attachment name not set");
            }
            if (this.category == null) {
                throw new IllegalStateException("Attachment category not set");
            }
            AttachmentItem attachment = new AttachmentItem();
            attachment.name = this.name;
            attachment.descriptionLines = Collections.unmodifiableList(this.descriptionLines);
            attachment.category = this.category;
            attachment.compatibleAttachmentSuppliers = Collections.unmodifiableList(this.compatibleAttachmentSuppliers);
            attachment.compatibleAttachmentGroups = Collections.unmodifiableList(this.compatibleAttachmentGroups);
            attachment.groups = Collections.unmodifiableSet(this.groups);
            attachment.script = this.script;
            HashMap features = new HashMap();
            for (FeatureBuilder<?, ?> featureBuilder : this.category.getDefaultFeatures()) {
                feature = featureBuilder.build(attachment);
                features.put(feature.getClass(), feature);
            }
            for (FeatureBuilder<?, ?> featureBuilder : this.featureBuilders) {
                feature = featureBuilder.build(attachment);
                features.put(feature.getClass(), feature);
            }
            attachment.features = Collections.unmodifiableMap(features);
            attachment.craftingDuration = this.craftingDuration;
            attachment.tradePrice = this.tradePrice;
            attachment.tradeBundleQuantity = this.tradeBundleQuantity;
            attachment.tradeLevel = this.tradeLevel;
            attachment.defaultAttachmentSuppliers = Collections.unmodifiableList(this.defaultAttachments);
            return attachment;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

