/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.item;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mod.pbj.Config;
import mod.pbj.Nameable;
import mod.pbj.attachment.Attachment;
import mod.pbj.attachment.AttachmentCategory;
import mod.pbj.attachment.AttachmentHost;
import mod.pbj.attachment.Attachments;
import mod.pbj.client.BiDirectionalInterpolator;
import mod.pbj.client.DynamicGeoListener;
import mod.pbj.client.GunClientState;
import mod.pbj.client.GunStatePoseProvider;
import mod.pbj.client.LockableTarget;
import mod.pbj.client.controller.AbstractProceduralAnimationController;
import mod.pbj.client.controller.AdvancedRecoilController;
import mod.pbj.client.controller.BlendingAnimationController;
import mod.pbj.client.controller.GlowAnimationController;
import mod.pbj.client.controller.GunRandomizingAnimationController;
import mod.pbj.client.controller.GunRecoilAnimationController;
import mod.pbj.client.controller.GunStateAnimationController;
import mod.pbj.client.controller.PlayerRecoilController;
import mod.pbj.client.controller.RotationAnimationController;
import mod.pbj.client.controller.TimerController;
import mod.pbj.client.controller.ViewShakeAnimationController;
import mod.pbj.client.controller.ViewShakeAnimationController2;
import mod.pbj.client.effect.AbstractEffect;
import mod.pbj.client.effect.EffectBuilder;
import mod.pbj.client.effect.EffectLauncher;
import mod.pbj.client.effect.MuzzleFlashEffect;
import mod.pbj.client.render.GunItemRenderer;
import mod.pbj.crafting.Craftable;
import mod.pbj.entity.ProjectileBulletEntity;
import mod.pbj.entity.ProjectileLike;
import mod.pbj.feature.AccuracyFeature;
import mod.pbj.feature.ActiveMuzzleFeature;
import mod.pbj.feature.AdsSpeedFeature;
import mod.pbj.feature.AimingFeature;
import mod.pbj.feature.AmmoCapacityFeature;
import mod.pbj.feature.AmmoOverrideFeature;
import mod.pbj.feature.AttributeFeature;
import mod.pbj.feature.BulletModifierFeature;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.DescriptionFeature;
import mod.pbj.feature.Feature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.Features;
import mod.pbj.feature.FireModeFeature;
import mod.pbj.feature.GlowFeature;
import mod.pbj.feature.MuzzleFlashFeature;
import mod.pbj.feature.PipFeature;
import mod.pbj.feature.ReloadFeature;
import mod.pbj.feature.ReticleFeature;
import mod.pbj.feature.SlotFeature;
import mod.pbj.feature.SoundFeature;
import mod.pbj.item.AmmoItem;
import mod.pbj.item.AnimationProvider;
import mod.pbj.item.BulletData;
import mod.pbj.item.ConditionalAnimationProvider;
import mod.pbj.item.FireMode;
import mod.pbj.item.FireModeInstance;
import mod.pbj.item.HurtingItem;
import mod.pbj.item.ScriptHolder;
import mod.pbj.network.FireModeRequestPacket;
import mod.pbj.network.FireModeResponsePacket;
import mod.pbj.network.HitScanFireRequestPacket;
import mod.pbj.network.HitScanFireResponsePacket;
import mod.pbj.network.Network;
import mod.pbj.network.ProjectileFireRequestPacket;
import mod.pbj.network.ReloadRequestPacket;
import mod.pbj.network.ReloadResponsePacket;
import mod.pbj.registry.AmmoRegistry;
import mod.pbj.registry.EffectRegistry;
import mod.pbj.registry.ExtensionRegistry;
import mod.pbj.registry.ItemRegistry;
import mod.pbj.registry.SoundRegistry;
import mod.pbj.script.Script;
import mod.pbj.util.ClientUtil;
import mod.pbj.util.Conditions;
import mod.pbj.util.HitScan;
import mod.pbj.util.JsonUtil;
import mod.pbj.util.MiscUtil;
import mod.pbj.util.SimpleHitResult;
import mod.pbj.util.TimeUnit;
import mod.pbj.util.Tradeable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.data.SoundKeyframeData;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GunItem
extends HurtingItem
implements ScriptHolder,
Craftable,
AttachmentHost,
Nameable,
GeoItem,
LockableTarget.TargetLocker,
Tradeable,
SlotFeature.SlotHolder {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private static final String DEFAULT_ANIMATION_IDLE = "animation.model.idle";
    private static final String DEFAULT_ANIMATION_RELOAD = "animation.model.reload";
    private static final String DEFAULT_ANIMATION_INSPECT = "animation.model.inspect";
    private static final String DEFAULT_ANIMATION_DRAW = "animation.model.draw";
    private static final String DEFAULT_ANIMATION_ENABLE_FIRE_MODE = "animation.model.enablefiremode";
    private static final String DEFAULT_ANIMATION_COMPLETE_FIRE = "animation.model.completefire";
    private static final String DEFAULT_ANIMATION_PREPARE_FIRE = "animation.model.preparefire";
    public static final String DEFAULT_ANIMATION_FIRE = "animation.model.fire";
    public static final String DEFAULT_ANIMATION_OFF_GROUND = "animation.model.off_ground";
    public static final String DEFAULT_ANIMATION_OFF_GROUND_SPRINTING = "animation.model.off_ground_sprinting";
    public static final String DEFAULT_ANIMATION_STANDING = "animation.model.standing";
    public static final String DEFAULT_ANIMATION_WALKING = "animation.model.walking";
    public static final String DEFAULT_ANIMATION_CROUCHING = "animation.model.crouching";
    public static final String DEFAULT_ANIMATION_WALKING_AIMING = "animation.model.walking_aiming";
    public static final String DEFAULT_ANIMATION_WALKING_BACKWARDS = "animation.model.walking_backwards";
    public static final String DEFAULT_ANIMATION_WALKING_LEFT = "animation.model.walking_left";
    public static final String DEFAULT_ANIMATION_WALKING_RIGHT = "animation.model.walking_right";
    public static final String DEFAULT_ANIMATION_RUNNING = "animation.model.running";
    public static final String DEFAULT_ANIMATION_PREPARE_RUNNING = "animation.model.runningstart";
    public static final String DEFAULT_ANIMATION_COMPLETE_RUNNING = "animation.model.runningend";
    public static final int INFINITE_AMMO = Integer.MAX_VALUE;
    public static final String DEFAULT_RETICLE_OVERLAY = "textures/item/reticle.png";
    public static final String DEFAULT_RETICLE_OVERLAY_PARALLAX = "textures/item/reticle4.png";
    public static final RawAnimation RAW_ANIMATION_OFF_GROUND = RawAnimation.begin().thenPlay("animation.model.off_ground");
    public static final RawAnimation RAW_ANIMATION_OFF_GROUND_SPRINTING = RawAnimation.begin().thenPlay("animation.model.off_ground_sprinting");
    public static final RawAnimation RAW_ANIMATION_STANDING = RawAnimation.begin().thenPlay("animation.model.standing");
    public static final RawAnimation RAW_ANIMATION_WALKING = RawAnimation.begin().thenPlay("animation.model.walking");
    public static final RawAnimation RAW_ANIMATION_CROUCHING = RawAnimation.begin().thenPlay("animation.model.crouching");
    public static final RawAnimation RAW_ANIMATION_WALKING_AIMING = RawAnimation.begin().thenPlay("animation.model.walking_aiming");
    public static final RawAnimation RAW_ANIMATION_WALKING_BACKWARDS = RawAnimation.begin().thenPlay("animation.model.walking_backwards");
    public static final RawAnimation RAW_ANIMATION_WALKING_LEFT = RawAnimation.begin().thenPlay("animation.model.walking_left");
    public static final RawAnimation RAW_ANIMATION_WALKING_RIGHT = RawAnimation.begin().thenPlay("animation.model.walking_right");
    public static final RawAnimation RAW_ANIMATION_PREPARE_RUNNING = RawAnimation.begin().thenPlay("animation.model.runningstart");
    public static final RawAnimation RAW_ANIMATION_COMPLETE_RUNNING = RawAnimation.begin().thenPlay("animation.model.runningend");
    public static final RawAnimation RAW_ANIMATION_ACTIVE = RawAnimation.begin().thenLoop("animation.model.active");
    public static final RawAnimation RAW_ANIMATION_RUNNING = RawAnimation.begin().thenPlay("animation.model.running");
    private static final List<ResourceLocation> FALLBACK_COMMON_ANIMATIONS = List.of(ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)"common"));
    private static final List<ResourceLocation> FALLBACK_PISTOL_ANIMATIONS = List.of(ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)"pistol"), ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)"common"));
    private static final Random random = new Random();
    private static final double MAX_SHOOTING_DISTANCE_WITHOUT_AIMING = 100.0;
    private static final ResourceLocation DEFAULT_SCOPE_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)"textures/gui/scope.png");
    private static final int MAX_ATTACHMENT_CATEGORIES = 11;
    private final String name;
    private final String nameSpace;
    private final float tradePrice;
    private final int tradeLevel;
    private final int tradeBundleQuantity;
    private final int maxAmmoCapacity;
    private boolean requiresPhasedReload;
    private final boolean isAimingEnabled;
    private final int rpm;
    private final long prepareIdleCooldownDuration;
    private final long prepareFireCooldownDuration;
    private final long completeFireCooldownDuration;
    private final long enableFireModeCooldownDuration;
    private final long targetLockTimeTicks;
    private final Set<Supplier<AmmoItem>> compatibleBullets;
    private final double viewRecoilAmplitude;
    private final double shakeRecoilAmplitude;
    private final int viewRecoilMaxPitch;
    private final long viewRecoilDuration;
    private final double shakeRecoilSpeed;
    private final double shakeDecay;
    private final long shakeRecoilDuration;
    private final double gunRecoilInitialAmplitude;
    private final double gunRecoilRateOfAmplitudeDecay;
    private final double gunRecoilInitialAngularFrequency;
    private final double gunRecoilRateOfFrequencyIncrease;
    private final double gunRecoilPitchMultiplier;
    private final long gunRecoilDuration;
    private final int shotsPerRecoil;
    private final int shotsPerTrace;
    private final long idleRandomizationDuration;
    private final long recoilRandomizationDuration;
    private final double gunRandomizationAmplitude;
    private final int burstShots;
    private final SoundEvent fireSound;
    private final float fireSoundVolume;
    private final SoundEvent targetLockedSound;
    private final SoundEvent targetStartLockingSound;
    private final long reloadCooldownTime;
    private final float bobbing;
    private final float bobbingOnAim;
    private final float bobbingRollMultiplier;
    private final double jumpMultiplier;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final double aimingCurveX;
    private final double aimingCurveY;
    private final double aimingCurveZ;
    private final double aimingCurvePitch;
    private final double aimingCurveYaw;
    private final double aimingCurveRoll;
    private final double aimingZoom;
    private final double pipScopeZoom;
    private final ResourceLocation scopeOverlay;
    private final ResourceLocation targetLockOverlay;
    private final ResourceLocation modelResourceLocation;
    private List<PhasedReload> phasedReloads;
    private AnimationProvider drawAnimationProvider;
    private AnimationProvider inspectAnimationProvider;
    private AnimationProvider idleAnimationProvider;
    private final String reloadAnimation;
    private int pelletCount;
    private final double pelletSpread;
    private final double inaccuracy;
    private final double inaccuracyAiming;
    private final double inaccuracySprinting;
    public long adsSpeed;
    private final List<Tuple<Long, AbstractProceduralAnimationController>> reloadEffectControllers;
    private final List<GlowAnimationController.Builder> glowEffectBuilders;
    private final List<RotationAnimationController.Builder> rotationEffectBuilders;
    private final EffectLauncher effectLauncher;
    private final BulletData bulletData;
    private final float modelScale;
    private final boolean hitscan;
    private final List<Supplier<Attachment>> compatibleAttachmentSuppliers;
    private final List<String> compatibleAttachmentGroups;
    private Set<Attachment> compatibleAttachments;
    private final List<Supplier<Attachment>> defaultAttachmentSuppliers;
    private final long craftingDuration;
    private final Map<Class<? extends Feature>, Feature> features;
    private final AnimationType animationType;
    private ResourceLocation firstPersonFallbackAnimations;
    private final String thirdPersonFallbackAnimations;
    public boolean useAdvancedRecoil = false;
    public double verticalAmplitude = 1.0;
    public double verticalRecovery = 1.0;
    public double verticalSmoothness = 1.0;
    public double horizontalAmplitude = 1.0;
    public double horizontalRecovery = 1.0;
    public double horizontalSmoothness = 1.0;
    public double horizontalRandomness = 0.0;
    public String recoilPattern = "default";
    @javax.annotation.Nullable
    private Script script = null;
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);

    public GunItem(Builder builder, String namespace) {
        super(new Item.Properties(), builder);
        ReloadFeature reloadFeature;
        PipFeature pipFeature;
        AimingFeature aimingFeature;
        ReticleFeature reticleFeature;
        MuzzleFlashFeature muzzleFlashFeature;
        FireModeFeature fireModeFeature;
        this.name = builder.name;
        this.nameSpace = builder.extension.getName();
        this.modelResourceLocation = this.name.contains(":") ? ResourceLocation.parse((String)this.name) : ResourceLocation.fromNamespaceAndPath((String)namespace, (String)this.name);
        this.useAdvancedRecoil = builder.useAdvancedRecoil;
        this.verticalAmplitude = builder.verticalAmplitude;
        this.verticalRecovery = builder.verticalRecovery;
        this.verticalSmoothness = builder.verticalSmoothness;
        this.horizontalAmplitude = builder.horizontalAmplitude;
        this.horizontalRecovery = builder.horizontalRecovery;
        this.horizontalSmoothness = builder.horizontalSmoothness;
        this.horizontalRandomness = builder.horizontalRandomness;
        this.recoilPattern = builder.recoilPattern;
        this.modelScale = builder.modelScale;
        this.tradePrice = builder.tradePrice;
        this.tradeLevel = builder.tradeLevel;
        this.hitscan = builder.hitscan;
        this.adsSpeed = builder.adsSpeed;
        this.tradeBundleQuantity = builder.tradeBundleQuantity;
        this.script = builder.mainScript;
        this.maxAmmoCapacity = builder.maxAmmoCapacity;
        this.rpm = builder.rpm;
        this.isAimingEnabled = builder.isAimingEnabled;
        this.compatibleBullets = builder.compatibleAmmo != null && !builder.compatibleAmmo.isEmpty() ? builder.compatibleAmmo : Collections.emptySet();
        this.targetLockTimeTicks = builder.targetLockTimeTicks;
        this.bulletData = builder.bulletData;
        this.viewRecoilAmplitude = builder.viewRecoilAmplitude;
        this.shakeRecoilAmplitude = builder.shakeRecoilAmplitude;
        this.viewRecoilMaxPitch = builder.viewRecoilMaxPitch;
        this.viewRecoilDuration = builder.viewRecoilDuration;
        this.shakeRecoilSpeed = builder.shakeRecoilSpeed;
        this.shakeRecoilDuration = builder.shakeRecoilDuration;
        this.shakeDecay = builder.shakeDecay;
        this.gunRecoilInitialAmplitude = builder.gunRecoilInitialAmplitude;
        this.gunRecoilRateOfAmplitudeDecay = builder.gunRecoilRateOfAmplitudeDecay;
        this.gunRecoilInitialAngularFrequency = builder.gunRecoilInitialAngularFrequency;
        this.gunRecoilRateOfFrequencyIncrease = builder.gunRecoilRateOfFrequencyIncrease;
        this.gunRecoilPitchMultiplier = builder.gunRecoilPitchMultiplier;
        this.gunRecoilDuration = builder.gunRecoilDuration;
        this.shotsPerRecoil = builder.shotsPerRecoil;
        this.shotsPerTrace = builder.shotsPerTrace;
        this.gunRandomizationAmplitude = builder.gunRandomizationAmplitude;
        this.idleRandomizationDuration = builder.idleRandomizationDuration;
        this.recoilRandomizationDuration = builder.recoilRandomizationDuration;
        this.jumpMultiplier = builder.jumpMultiplier;
        this.burstShots = builder.burstShots;
        this.fireSound = builder.fireSound != null ? builder.fireSound.get() : null;
        this.fireSoundVolume = builder.fireSoundVolume;
        this.prepareIdleCooldownDuration = builder.prepareIdleCooldownDuration;
        this.prepareFireCooldownDuration = builder.prepareFireCooldownDuration;
        this.completeFireCooldownDuration = builder.completeFireCooldownDuration;
        this.enableFireModeCooldownDuration = builder.enableFireModeCooldownDuration;
        this.craftingDuration = builder.craftingDuration;
        this.aimingCurveX = builder.aimingCurveX;
        this.aimingCurveY = builder.aimingCurveY;
        this.aimingCurveZ = builder.aimingCurveZ;
        this.aimingCurvePitch = builder.aimingCurvePitch;
        this.aimingCurveYaw = builder.aimingCurveYaw;
        this.aimingCurveRoll = builder.aimingCurveRoll;
        this.pipScopeZoom = builder.pipScopeZoom;
        this.aimingZoom = builder.aimingZoom;
        this.scopeOverlay = builder.scopeOverlay != null ? ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)builder.scopeOverlay) : null;
        this.targetLockOverlay = builder.targetLockOverlay != null ? ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)builder.targetLockOverlay) : null;
        this.targetLockedSound = builder.targetLockedSound != null ? builder.targetLockedSound.get() : null;
        this.targetStartLockingSound = builder.targetStartLockingSound != null ? builder.targetStartLockingSound.get() : null;
        this.bobbing = builder.bobbing;
        this.bobbingOnAim = builder.bobbingOnAim;
        this.bobbingRollMultiplier = builder.bobbingRollMultiplier;
        this.reloadEffectControllers = Collections.unmodifiableList(builder.reloadEffectControllers);
        this.phasedReloads = builder.phasedReloads;
        if (!builder.drawAnimationsBuilder.getAnimations().isEmpty()) {
            this.drawAnimationProvider = builder.drawAnimationsBuilder.build();
        }
        if (!builder.inspectAnimationsBuilder.getAnimations().isEmpty()) {
            this.inspectAnimationProvider = builder.inspectAnimationsBuilder.build();
        }
        if (!builder.idleAnimationBuilder.getAnimations().isEmpty()) {
            this.idleAnimationProvider = builder.idleAnimationBuilder.build();
        }
        this.animationType = builder.animationType;
        if (builder.firstPersonFallbackAnimations != null) {
            this.firstPersonFallbackAnimations = ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)builder.firstPersonFallbackAnimations);
        }
        this.thirdPersonFallbackAnimations = builder.thirdPersonFallbackAnimations;
        this.pelletSpread = builder.pelletSpread;
        if (builder.pelletCount > 1) {
            this.maxShootingDistance = Math.min(this.maxShootingDistance, 50.0);
        }
        this.inaccuracyAiming = builder.inaccuracyAiming;
        this.inaccuracy = builder.inaccuracy;
        this.inaccuracySprinting = builder.inaccuracySprinting;
        this.reloadCooldownTime = builder.reloadCooldownTime;
        this.reloadAnimation = builder.reloadAnimation;
        if (this.hasFunction("overrideReloads")) {
            this.phasedReloads = (List)this.invokeFunction("overrideReloads", new Object[]{builder});
            System.out.println("reloads = " + String.valueOf(this.phasedReloads));
            this.requiresPhasedReload = true;
        }
        if (!this.requiresPhasedReload) {
            if (this.phasedReloads.isEmpty() && this.reloadAnimation != null) {
                this.phasedReloads.add(new PhasedReload(ReloadPhase.RELOADING, this.reloadCooldownTime, this.reloadAnimation));
            } else {
                this.requiresPhasedReload = true;
            }
        }
        this.compatibleAttachmentSuppliers = Collections.unmodifiableList(builder.compatibleAttachments);
        this.compatibleAttachmentGroups = Collections.unmodifiableList(builder.compatibleAttachmentGroups);
        this.defaultAttachmentSuppliers = Collections.unmodifiableList(builder.defaultAttachments);
        HashMap features = new HashMap();
        for (FeatureBuilder<?, ?> featureBuilder : builder.featureBuilders) {
            Object feature = featureBuilder.build(this);
            features.put(feature.getClass(), feature);
        }
        ActiveMuzzleFeature activeMuzzleFeature = (ActiveMuzzleFeature)features.get(ActiveMuzzleFeature.class);
        if (activeMuzzleFeature == null) {
            ActiveMuzzleFeature.Builder activeMuzzleFeatureBuilder = new ActiveMuzzleFeature.Builder().withCondition(Conditions.isUsingDefaultMuzzle().and(Conditions.doesNotHaveAttachmentInCategory(AttachmentCategory.MUZZLE)));
            features.put(ActiveMuzzleFeature.class, activeMuzzleFeatureBuilder.build(this));
        }
        if ((fireModeFeature = (FireModeFeature)features.get(FireModeFeature.class)) == null) {
            FireModeFeature.Builder fireModeFeatureBuilder = new FireModeFeature.Builder();
            if (builder.fireModes != null) {
                for (FireMode fireMode : builder.fireModes) {
                    AnimationProvider fireAnimationProvider = builder.fireAnimationsBuilder.build();
                    fireModeFeatureBuilder.withFireMode(new FireModeFeature.FireModeDescriptor.Builder().withName(fireMode.name()).withType(fireMode).withDisplayName((Component)Component.m_237115_((String)String.format("label.%s.fireMode.%s", "pointblank", fireMode.name().toLowerCase()))).withMaxAmmoCapacity(this.maxAmmoCapacity).withRpm(builder.rpm).withBurstShots(builder.burstShots).withDamage(this.getDamage()).withMaxShootingDistance((int)this.maxShootingDistance).withPelletCount(builder.pelletCount).withPelletSpread(builder.pelletSpread).withIsUsingDefaultMuzzle(true).withFireAnimationProvider(fireAnimationProvider).build());
                }
            }
            features.put(FireModeFeature.class, fireModeFeatureBuilder.build(this));
        }
        if ((muzzleFlashFeature = (MuzzleFlashFeature)features.get(MuzzleFlashFeature.class)) == null) {
            MuzzleFlashFeature.Builder muzzleFlashFeatureBulder = new MuzzleFlashFeature.Builder();
            List<Supplier<EffectBuilder<EffectBuilder<?, ?>, ?>>> fbsl = builder.effectBuilders.get(FirePhase.FIRING);
            if (fbsl != null) {
                for (Supplier<EffectBuilder<EffectBuilder<?, ?>, ?>> s : fbsl) {
                    EffectBuilder<? extends EffectBuilder<?, ?>, ?> eb = s.get();
                    if (!(eb instanceof MuzzleFlashEffect.Builder)) continue;
                    muzzleFlashFeatureBulder.withEffect(FirePhase.FIRING, s);
                }
            }
            muzzleFlashFeature = muzzleFlashFeatureBulder.build(this);
            features.put(MuzzleFlashFeature.class, muzzleFlashFeature);
        }
        if ((reticleFeature = (ReticleFeature)features.get(ReticleFeature.class)) == null && builder.reticleOverlay != null && !MiscUtil.isGreaterThanZero(builder.pipScopeZoom)) {
            features.put(ReticleFeature.class, new ReticleFeature.Builder().withTexture(builder.reticleOverlay).build(this));
        }
        if ((aimingFeature = (AimingFeature)features.get(AimingFeature.class)) == null && builder.isAimingEnabled) {
            features.put(AimingFeature.class, new AimingFeature.Builder().withZoom(this.aimingZoom).build(this));
        }
        if ((pipFeature = (PipFeature)features.get(PipFeature.class)) == null && MiscUtil.isGreaterThanZero(builder.pipScopeZoom)) {
            features.put(PipFeature.class, new PipFeature.Builder().withZoom(builder.pipScopeZoom).withOverlayTexture(builder.reticleOverlay).build(this));
        }
        if ((reloadFeature = (ReloadFeature)features.get(ReloadFeature.class)) == null) {
            features.put(ReloadFeature.class, new ReloadFeature.Builder().withMaxAmmoPerReloadIteration(builder.maxAmmoPerReloadIteration).build(this));
        }
        this.glowEffectBuilders = builder.glowEffectBuilders;
        this.rotationEffectBuilders = builder.rotationEffectBuilders;
        this.effectLauncher = new EffectLauncher(builder.effectBuilders);
        if (!this.glowEffectBuilders.isEmpty() && !features.containsKey(GlowFeature.class)) {
            features.put(GlowFeature.class, new GlowFeature());
        }
        this.features = Collections.unmodifiableMap(features);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot pEquipmentSlot, ItemStack stack) {
        LinkedListMultimap multimap = LinkedListMultimap.create();
        for (AttributeFeature feature : Features.getEnabledFeatures(stack, AttributeFeature.class).stream().map(enb -> (AttributeFeature)enb.feature()).toList()) {
            multimap.get((Object)feature.baseAttribute).add(feature.modifier);
        }
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? multimap : super.m_7167_(pEquipmentSlot);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        return !GunItem.getFireModeInstance(pStack).isMelee();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Component m_7626_(ItemStack itemStack) {
        return Component.m_237115_((String)this.m_5671_(itemStack));
    }

    public float getModelScale() {
        return this.modelScale;
    }

    @Override
    public Collection<Feature> getFeatures() {
        return this.features.values();
    }

    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        for (Feature descFeature : Features.getEnabledFeatures(stack, DescriptionFeature.class).stream().map(Features.EnabledFeature::feature).toList()) {
            tooltip.add(((DescriptionFeature)descFeature).getMutableDescription());
        }
        FireModeInstance currentFireMode = GunItem.getFireModeInstance(stack);
        if (currentFireMode != null && currentFireMode.getPelletCount() > 0) {
            tooltip.add((Component)Component.m_237115_((String)"label.pointblank.damage").m_130946_(": ").m_130946_(String.format("%.2f (%.2fx%d)", Float.valueOf(currentFireMode.getDamage() * (float)currentFireMode.getPelletCount()), Float.valueOf(currentFireMode.getDamage()), currentFireMode.getPelletCount())).m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
        } else if (currentFireMode != null) {
            tooltip.add((Component)Component.m_237115_((String)"label.pointblank.damage").m_130946_(": ").m_130946_(String.format("%.2f", Float.valueOf(currentFireMode.getDamage()))).m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"label.pointblank.damage").m_130946_(": ").m_130946_(String.format("%.2f", Float.valueOf(this.getDamage()))).m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
        }
        tooltip.add((Component)Component.m_237115_((String)"label.pointblank.rpm").m_130946_(": ").m_130946_(String.format("%d", this.rpm)).m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
        MutableComponent ammoDescription = Component.m_237115_((String)"label.pointblank.ammo").m_130946_(": ");
        boolean isFirst = true;
        for (Supplier<AmmoItem> ammoItemSupplier : this.compatibleBullets) {
            AmmoItem ammoItem;
            if (!isFirst) {
                ammoDescription.m_130946_(", ");
            }
            if ((ammoItem = ammoItemSupplier.get()) != null) {
                ammoDescription.m_7220_((Component)Component.m_237115_((String)ammoItemSupplier.get().m_5524_()));
            } else {
                ammoDescription.m_7220_((Component)Component.m_237115_((String)"missing_ammo"));
            }
            isFirst = false;
        }
        ammoDescription.m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC);
        tooltip.add((Component)ammoDescription);
        if (this.hasFunction("appendHoverText")) {
            this.invokeFunction("appendHoverText", new Object[]{stack, world, tooltip, flag});
        }
    }

    public MutableComponent getDisplayName() {
        return Component.m_237115_((String)(this.m_5524_() + ".desc")).m_130940_(ChatFormatting.YELLOW);
    }

    public boolean requiresPhasedReload() {
        return this.requiresPhasedReload;
    }

    public List<FireModeInstance> getMainFireModes() {
        FireModeFeature fireModeFeature = this.getFeature(FireModeFeature.class);
        return fireModeFeature.getFireModes();
    }

    public int getRpm() {
        return this.rpm;
    }

    public boolean isAimingEnabled() {
        return this.isAimingEnabled;
    }

    public long getPrepareFireCooldownDuration() {
        return this.prepareFireCooldownDuration;
    }

    public long getCompleteFireCooldownDuration() {
        return this.completeFireCooldownDuration;
    }

    public long getEnableFireModeCooldownDuration() {
        return this.enableFireModeCooldownDuration;
    }

    public long getPrepareIdleCooldownDuration() {
        return this.prepareIdleCooldownDuration;
    }

    public int getPelletCount() {
        return this.pelletCount;
    }

    public double getPelletSpread() {
        return this.pelletSpread;
    }

    public long getDrawCooldownDuration(LivingEntity player, GunClientState state, ItemStack itemStack) {
        if (this.drawAnimationProvider == null) {
            return 0L;
        }
        AnimationProvider.Descriptor descriptor = this.drawAnimationProvider.getDescriptor(player, itemStack, state);
        return descriptor != null ? descriptor.timeUnit().toMillis(descriptor.duration()) : 0L;
    }

    public long getInspectCooldownDuration(LivingEntity player, GunClientState state, ItemStack itemStack) {
        if (this.inspectAnimationProvider == null) {
            return 0L;
        }
        AnimationProvider.Descriptor descriptor = this.inspectAnimationProvider.getDescriptor(player, itemStack, state);
        return descriptor != null ? descriptor.timeUnit().toMillis(descriptor.duration()) : 0L;
    }

    public long getIdleCooldownDuration(LivingEntity player, GunClientState state, ItemStack itemStack) {
        if (this.idleAnimationProvider == null) {
            return 0L;
        }
        AnimationProvider.Descriptor descriptor = this.idleAnimationProvider.getDescriptor(player, itemStack, state);
        return descriptor != null ? descriptor.timeUnit().toMillis(descriptor.duration()) : 0L;
    }

    public long getReloadingCooldownTime(ReloadPhase phase, LivingEntity player, GunClientState state, ItemStack itemStack) {
        long cooldownTime = 0L;
        for (PhasedReload reload : this.phasedReloads) {
            if (phase != reload.phase || !reload.predicate.test(new ConditionContext(player, itemStack, state, null))) continue;
            cooldownTime = reload.timeUnit.toMillis(reload.cooldownTime);
            break;
        }
        return cooldownTime;
    }

    public int getBurstShots(ItemStack itemStack, FireModeInstance fireModeInstance) {
        FireModeFeature mainFireModeFeature = this.getFeature(FireModeFeature.class);
        if (mainFireModeFeature.getFireModes().contains(fireModeInstance)) {
            int burstShots = fireModeInstance.getBurstShots() == -1 ? this.burstShots : fireModeInstance.getBurstShots();
            return burstShots;
        }
        List<FireModeInstance> allFireModes = GunItem.getFireModes(itemStack);
        return allFireModes.contains(fireModeInstance) ? fireModeInstance.getBurstShots() : this.burstShots;
    }

    public void cancelReload(ItemStack stack) {
    }

    public int getMaxAmmoCapacity(ItemStack itemStack, FireModeInstance fireModeInstance) {
        FireModeFeature mainFireModeFeature = this.getFeature(FireModeFeature.class);
        if (mainFireModeFeature.getFireModes().contains(fireModeInstance)) {
            if (fireModeInstance.getMaxAmmoCapacity() == Integer.MAX_VALUE) {
                int ammoCapacity = Integer.MAX_VALUE;
                return AmmoCapacityFeature.modifyAmmoCapacity(itemStack, ammoCapacity);
            }
            int ammoCapacity = fireModeInstance.getAmmo() == AmmoRegistry.DEFAULT_AMMO_POOL.get() ? this.maxAmmoCapacity : fireModeInstance.getMaxAmmoCapacity();
            return AmmoCapacityFeature.modifyAmmoCapacity(itemStack, ammoCapacity);
        }
        List<FireModeInstance> allFireModes = GunItem.getFireModes(itemStack);
        if (allFireModes.contains(fireModeInstance)) {
            int ammoCapacity = fireModeInstance.getAmmo() == AmmoRegistry.DEFAULT_AMMO_POOL.get() ? this.maxAmmoCapacity : fireModeInstance.getMaxAmmoCapacity();
            return AmmoCapacityFeature.modifyAmmoCapacity(itemStack, ammoCapacity);
        }
        return 0;
    }

    public ResourceLocation getScopeOverlay() {
        return this.scopeOverlay == null && MiscUtil.isGreaterThanZero(this.pipScopeZoom) && !Config.pipScopesEnabled ? DEFAULT_SCOPE_OVERLAY : this.scopeOverlay;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GunItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    List<Object> fallbackAnimations;
                    if (GunItem.this.firstPersonFallbackAnimations != null) {
                        fallbackAnimations = new ArrayList<ResourceLocation>();
                        fallbackAnimations.add(GunItem.this.firstPersonFallbackAnimations);
                        fallbackAnimations.addAll(GunItem.this.animationType.getFallbackFirstPersonAnimations());
                    } else {
                        fallbackAnimations = GunItem.this.animationType.getFallbackFirstPersonAnimations();
                    }
                    this.renderer = new GunItemRenderer(GunItem.this.modelResourceLocation, fallbackAnimations, GunItem.this.glowEffectBuilders);
                }
                return this.renderer;
            }

            public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
                return true;
            }
        });
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return true;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity entity, InteractionHand hand) {
        this.invokeFunction("interactLivingEntity", new Object[]{itemStack, player, entity, hand});
        return InteractionResult.SUCCESS;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (this.hasFunction("onLeftClickEntity")) {
            return (Boolean)this.invokeFunction("onLeftClickEntity", new Object[]{stack, player, entity});
        }
        return !GunItem.getFireModeInstance(stack).isMelee();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new BlendingAnimationController<GunItem>(this, "walking", 2, false, state -> PlayState.STOP).withTransition(DEFAULT_ANIMATION_STANDING, DEFAULT_ANIMATION_WALKING, 2, false).withTransition(DEFAULT_ANIMATION_STANDING, DEFAULT_ANIMATION_WALKING_BACKWARDS, 2, false).withTransition(DEFAULT_ANIMATION_STANDING, DEFAULT_ANIMATION_PREPARE_RUNNING, 2, false).withTransition(DEFAULT_ANIMATION_WALKING, DEFAULT_ANIMATION_PREPARE_RUNNING, 2, false).withTransition(DEFAULT_ANIMATION_PREPARE_RUNNING, DEFAULT_ANIMATION_RUNNING, 2, false).withTransition(DEFAULT_ANIMATION_PREPARE_RUNNING, DEFAULT_ANIMATION_COMPLETE_RUNNING, 3, false).withTransition(DEFAULT_ANIMATION_RUNNING, DEFAULT_ANIMATION_COMPLETE_RUNNING, 2, false).withTransition(DEFAULT_ANIMATION_COMPLETE_RUNNING, DEFAULT_ANIMATION_WALKING, 3, false).withTransition(DEFAULT_ANIMATION_COMPLETE_RUNNING, DEFAULT_ANIMATION_STANDING, 3, false).withTransition(DEFAULT_ANIMATION_COMPLETE_RUNNING, DEFAULT_ANIMATION_PREPARE_RUNNING, 2, false).withSpeedProvider((p, c) -> {
            double baseSpeed;
            double speed = p.m_6113_();
            AttributeInstance attribute = p.m_21051_(Attributes.f_22279_);
            double d = baseSpeed = attribute != null ? attribute.m_22115_() : speed;
            if (baseSpeed == 0.0) {
                baseSpeed = speed;
            }
            if (p.m_20142_()) {
                baseSpeed += baseSpeed * 0.3;
            }
            double ratio = speed / baseSpeed;
            if (((LocalPlayer)p).m_108635_() || p.m_6069_() || p.m_20069_()) {
                ratio *= 0.6;
            }
            return Math.sqrt(Mth.m_14008_((double)ratio, (double)0.1, (double)10.0));
        }).triggerableAnim(DEFAULT_ANIMATION_WALKING, RAW_ANIMATION_WALKING).triggerableAnim(DEFAULT_ANIMATION_CROUCHING, RAW_ANIMATION_CROUCHING).triggerableAnim(DEFAULT_ANIMATION_WALKING_AIMING, RAW_ANIMATION_WALKING_AIMING).triggerableAnim(DEFAULT_ANIMATION_WALKING_BACKWARDS, RAW_ANIMATION_WALKING_BACKWARDS).triggerableAnim(DEFAULT_ANIMATION_WALKING_LEFT, RAW_ANIMATION_WALKING_LEFT).triggerableAnim(DEFAULT_ANIMATION_WALKING_RIGHT, RAW_ANIMATION_WALKING_RIGHT).triggerableAnim(DEFAULT_ANIMATION_PREPARE_RUNNING, RAW_ANIMATION_PREPARE_RUNNING).triggerableAnim(DEFAULT_ANIMATION_RUNNING, RAW_ANIMATION_RUNNING).triggerableAnim(DEFAULT_ANIMATION_COMPLETE_RUNNING, RAW_ANIMATION_COMPLETE_RUNNING).triggerableAnim(DEFAULT_ANIMATION_STANDING, RAW_ANIMATION_STANDING).triggerableAnim(DEFAULT_ANIMATION_OFF_GROUND, RAW_ANIMATION_OFF_GROUND).triggerableAnim(DEFAULT_ANIMATION_OFF_GROUND_SPRINTING, RAW_ANIMATION_OFF_GROUND_SPRINTING).setSoundKeyframeHandler(event -> {
            SoundKeyframeData soundKeyframeData;
            String soundName;
            SoundEvent soundEvent;
            Player player = ClientUtil.getClientPlayer();
            if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                player.m_5496_(soundEvent, 1.0f, 1.0f);
            }
        })});
        for (GunStateAnimationController reloadAnimationController : this.createReloadAnimationControllers()) {
            controllers.add(new AnimationController[]{reloadAnimationController});
        }
        GunStateAnimationController fireAnimationController = new GunStateAnimationController(this, "fire_controller", DEFAULT_ANIMATION_FIRE, ctx -> ctx.gunClientState().getFireState() == GunClientState.FireState.FIRE_SINGLE || ctx.gunClientState().getFireState() == GunClientState.FireState.FIRE_AUTO || ctx.gunClientState().getFireState() == GunClientState.FireState.FIRE_BURST || ctx.gunClientState().getFireState() == GunClientState.FireState.FIRE_COOLDOWN_SINGLE || ctx.gunClientState().getFireState() == GunClientState.FireState.FIRE_COOLDOWN_AUTO || ctx.gunClientState().getFireState() == GunClientState.FireState.FIRE_COOLDOWN_BURST || this.completeFireCooldownDuration == 0L && ctx.gunClientState().isIdle()){

            @Override
            public void onStartFiring(LivingEntity player, GunClientState state, ItemStack itemStack) {
                if (ClientUtil.isFirstPerson(player)) {
                    this.scheduleReset(player, state, itemStack, FireModeFeature.getFireAnimation(player, state, itemStack));
                }
            }
        };
        fireAnimationController.setSoundKeyframeHandler(event -> {
            SoundKeyframeData soundKeyframeData;
            String soundName;
            SoundEvent soundEvent;
            Player player = ClientUtils.getClientPlayer();
            if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                player.m_5496_(soundEvent, this.fireSoundVolume, 1.0f);
            }
        });
        controllers.add(new AnimationController[]{fireAnimationController});
        GunStateAnimationController prepareFiringAnimationController = new GunStateAnimationController(this, "prepare_fire_controller", DEFAULT_ANIMATION_PREPARE_FIRE, ctx -> ctx.gunClientState().isPreparingFiring()){

            @Override
            public void onPrepareFiring(LivingEntity player, GunClientState state, ItemStack itemStack) {
                if (ClientUtil.isFirstPerson(player)) {
                    this.scheduleReset(player, state, itemStack, FireModeFeature.getPrepareFireAnimation(player, state, itemStack));
                }
            }
        };
        prepareFiringAnimationController.setSoundKeyframeHandler(event -> {
            SoundKeyframeData soundKeyframeData;
            String soundName;
            SoundEvent soundEvent;
            Player player = ClientUtils.getClientPlayer();
            if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                player.m_5496_(soundEvent, 1.0f, 1.0f);
            }
        });
        controllers.add(new AnimationController[]{prepareFiringAnimationController});
        GunStateAnimationController completeFiringAnimationController = new GunStateAnimationController(this, "complete_fire_controller", DEFAULT_ANIMATION_COMPLETE_FIRE, ctx -> ctx.gunClientState().isCompletingFiring()){

            @Override
            public void onCompleteFiring(LivingEntity player, GunClientState state, ItemStack itemStack) {
                if (ClientUtil.isFirstPerson(player)) {
                    this.scheduleReset(player, state, itemStack, FireModeFeature.getCompleteFireAnimation(player, state, itemStack));
                }
            }
        };
        completeFiringAnimationController.setSoundKeyframeHandler(event -> {
            SoundKeyframeData soundKeyframeData;
            String soundName;
            SoundEvent soundEvent;
            Player player = ClientUtils.getClientPlayer();
            if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                player.m_5496_(soundEvent, 1.0f, 1.0f);
            }
        });
        controllers.add(new AnimationController[]{completeFiringAnimationController});
        GunStateAnimationController drawAnimationController = new GunStateAnimationController(this, "draw_controller", DEFAULT_ANIMATION_DRAW, ctx -> ctx.gunClientState().isDrawing()){

            private String getAnimationName(LivingEntity player, GunClientState state, ItemStack itemStack) {
                if (GunItem.this.drawAnimationProvider == null) {
                    return null;
                }
                AnimationProvider.Descriptor descriptor = GunItem.this.drawAnimationProvider.getDescriptor(player, itemStack, state);
                return descriptor != null ? descriptor.animationName() : null;
            }

            @Override
            public void onDrawing(LivingEntity player, GunClientState state, ItemStack itemStack) {
                if (ClientUtil.isFirstPerson(player)) {
                    this.scheduleReset(player, state, itemStack, this.getAnimationName(player, state, itemStack));
                }
            }
        };
        drawAnimationController.setSoundKeyframeHandler(event -> {
            SoundKeyframeData soundKeyframeData;
            String soundName;
            SoundEvent soundEvent;
            Player player = ClientUtils.getClientPlayer();
            if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                player.m_5496_(soundEvent, 1.0f, 1.0f);
            }
        });
        controllers.add(new AnimationController[]{drawAnimationController});
        GunStateAnimationController inspectAnimationController = new GunStateAnimationController(this, "inspect_controller", DEFAULT_ANIMATION_INSPECT, ctx -> ctx.gunClientState().isInspecting()){

            private String getAnimationName(LivingEntity player, GunClientState state, ItemStack itemStack) {
                if (GunItem.this.inspectAnimationProvider == null) {
                    return null;
                }
                AnimationProvider.Descriptor descriptor = GunItem.this.inspectAnimationProvider.getDescriptor(player, itemStack, state);
                return descriptor != null ? descriptor.animationName() : null;
            }

            @Override
            public void onInspecting(LivingEntity player, GunClientState state, ItemStack itemStack) {
                if (ClientUtil.isFirstPerson(player)) {
                    this.scheduleReset(player, state, itemStack, this.getAnimationName(player, state, itemStack));
                }
            }
        };
        inspectAnimationController.setSoundKeyframeHandler(event -> {
            SoundKeyframeData soundKeyframeData;
            String soundName;
            SoundEvent soundEvent;
            Player player = ClientUtils.getClientPlayer();
            if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                player.m_5496_(soundEvent, 1.0f, 1.0f);
            }
        });
        controllers.add(new AnimationController[]{inspectAnimationController});
        GunStateAnimationController idleAnimationController = new GunStateAnimationController(this, "idle_controller", DEFAULT_ANIMATION_IDLE, ctx -> ctx.gunClientState().getFireState() == GunClientState.FireState.IDLE || ctx.gunClientState().getFireState() == GunClientState.FireState.IDLE_COOLDOWN){

            private String getAnimationName(LivingEntity player, GunClientState state, ItemStack itemStack) {
                if (GunItem.this.idleAnimationProvider == null) {
                    return null;
                }
                AnimationProvider.Descriptor descriptor = GunItem.this.idleAnimationProvider.getDescriptor(player, itemStack, state);
                return descriptor != null ? descriptor.animationName() : null;
            }

            @Override
            public void onIdle(LivingEntity player, GunClientState state, ItemStack itemStack) {
                if (ClientUtil.isFirstPerson(player)) {
                    this.scheduleReset(player, state, itemStack, this.getAnimationName(player, state, itemStack));
                }
            }
        };
        idleAnimationController.setSoundKeyframeHandler(event -> {
            SoundKeyframeData soundKeyframeData;
            String soundName;
            SoundEvent soundEvent;
            Player player = ClientUtils.getClientPlayer();
            if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                player.m_5496_(soundEvent, 1.0f, 1.0f);
            }
        });
        controllers.add(new AnimationController[]{idleAnimationController});
        GunStateAnimationController enableFireModeAimationController = new GunStateAnimationController(this, "enable_fire_mode_controller", DEFAULT_ANIMATION_ENABLE_FIRE_MODE, ctx -> ctx.gunClientState().isChangingFireMode()){

            @Override
            public void onEnablingFireMode(LivingEntity player, GunClientState state, ItemStack itemStack) {
                if (ClientUtil.isFirstPerson(player)) {
                    this.scheduleReset(player, state, itemStack, FireModeFeature.getEnableFireModeAnimation(player, state, itemStack));
                }
            }
        };
        enableFireModeAimationController.setSoundKeyframeHandler(event -> {
            SoundKeyframeData soundKeyframeData;
            String soundName;
            SoundEvent soundEvent;
            Player player = ClientUtils.getClientPlayer();
            if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                player.m_5496_(soundEvent, 1.0f, 1.0f);
            }
        });
        controllers.add(new AnimationController[]{enableFireModeAimationController});
    }

    private static boolean isCompatibleBullet(Item ammoItem, ItemStack gunStack, FireModeInstance fireModeInstance) {
        boolean result = false;
        Item item = gunStack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            if (fireModeInstance.hasFunction("isCompatibleBullet")) {
                return (Boolean)fireModeInstance.invokeFunction("isCompatibleBullet", (AmmoItem)ammoItem, gunStack, fireModeInstance);
            }
            List<Features.EnabledFeature> overrides = Features.getEnabledFeatures(gunStack, AmmoOverrideFeature.class);
            boolean hasOverrideOnly = false;
            for (Features.EnabledFeature ef : overrides) {
                AmmoOverrideFeature feature = (AmmoOverrideFeature)ef.feature();
                if (feature.getOverrideAmmo() == ammoItem) {
                    return true;
                }
                if (!feature.isOverrideOnly()) continue;
                hasOverrideOnly = true;
            }
            if (hasOverrideOnly) {
                return false;
            }
            List<FireModeInstance> firModeInstances = GunItem.getFireModes(gunStack);
            if (!firModeInstances.contains(fireModeInstance)) {
                return false;
            }
            if (fireModeInstance.isUsingDefaultAmmoPool()) {
                for (Supplier<AmmoItem> compatibleBullet : gunItem.compatibleBullets) {
                    if (!Objects.equals(compatibleBullet.get(), ammoItem)) continue;
                    result = true;
                    break;
                }
            } else {
                result = ammoItem == fireModeInstance.getAmmo();
            }
            return result;
        }
        return false;
    }

    public int canReloadGun(ItemStack gunStack, Player player, FireModeInstance fireModeInstance) {
        int currentAmmo;
        GunItem gunItem = (GunItem)gunStack.m_41720_();
        int maxCapacity = gunItem.getMaxAmmoCapacity(gunStack, fireModeInstance);
        int ammoNeeded = maxCapacity - (currentAmmo = GunItem.getAmmo(gunStack, fireModeInstance));
        if (ammoNeeded <= 0) {
            return 0;
        }
        if (player.m_7500_()) {
            return ammoNeeded;
        }
        int availableBullets = 0;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemStack = player.m_150109_().m_8020_(i);
            if (GunItem.isCompatibleBullet(itemStack.m_41720_(), gunStack, fireModeInstance)) {
                availableBullets += itemStack.m_41613_();
            }
            if (availableBullets >= ammoNeeded) break;
        }
        int potentialReloadAmount = Math.min(ammoNeeded, availableBullets);
        return potentialReloadAmount;
    }

    int reloadGun(ItemStack gunStack, Player player, FireModeInstance fireModeInstance) {
        int currentAmmo;
        Item item = gunStack.m_41720_();
        if (!(item instanceof GunItem)) {
            return 0;
        }
        GunItem gunItem = (GunItem)item;
        if (!gunItem.isEnabled()) {
            return 0;
        }
        int maxCapacity = gunItem.getMaxAmmoCapacity(gunStack, fireModeInstance);
        int neededAmmo = maxCapacity - (currentAmmo = GunItem.getAmmo(gunStack, fireModeInstance));
        if (neededAmmo <= 0) {
            return currentAmmo;
        }
        if (player.m_7500_()) {
            int newAmmo = currentAmmo + neededAmmo;
            GunItem.setAmmo(gunStack, fireModeInstance, newAmmo);
            return newAmmo;
        }
        int foundAmmoCount = 0;
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack inventoryItem = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (!GunItem.isCompatibleBullet(inventoryItem.m_41720_(), gunStack, fireModeInstance)) continue;
            int availableBullets = inventoryItem.m_41613_();
            if (availableBullets <= neededAmmo) {
                foundAmmoCount += availableBullets;
                neededAmmo -= availableBullets;
                player.m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
            } else {
                inventoryItem.m_41774_(neededAmmo);
                foundAmmoCount += neededAmmo;
                neededAmmo = 0;
            }
            if (neededAmmo == 0) break;
        }
        int newAmmo = currentAmmo + foundAmmoCount;
        GunItem.setAmmo(gunStack, fireModeInstance, newAmmo);
        return newAmmo;
    }

    public void handleClientReloadRequest(ServerPlayer player, ItemStack itemStack, UUID clientStateId, int slotIndex, FireModeInstance fireModeInstance) {
        boolean isOffhand;
        boolean bl = isOffhand = player.m_21206_() == itemStack;
        if (!isOffhand && itemStack != null) {
            int ammo = this.reloadGun(itemStack, (Player)player, fireModeInstance);
            UUID itemStackId = GunItem.getItemStackId(itemStack);
            Network.networkChannel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ReloadResponsePacket(itemStackId, slotIndex, 0, ammo > 0, ammo, fireModeInstance));
        }
    }

    public static UUID getItemStackId(ItemStack itemStack) {
        CompoundTag idTag = itemStack.m_41783_();
        return idTag != null ? MiscUtil.getTagId(idTag) : null;
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        boolean isOffhand;
        if (entity instanceof Player) {
            Player plr = (Player)entity;
            this.invokeFunction("onInventoryTick", new Object[]{itemStack, level, plr, itemSlot, isSelected});
        }
        boolean bl = isOffhand = entity instanceof Player && ((Player)entity).m_21206_() == itemStack;
        if (!level.f_46443_) {
            this.ensureItemStack(itemStack, level, entity, isOffhand);
        } else {
            GunClientState state = null;
            if (entity instanceof Player) {
                state = GunClientState.getState((Player)entity, itemStack, itemSlot, isOffhand);
            }
            if (state != null && entity instanceof Player) {
                state.inventoryTick((LivingEntity)((Player)entity), itemStack, isSelected);
            }
        }
    }

    public void ensureItemStack(ItemStack itemStack, Level level, Entity entity, boolean isOffhand) {
        GeoItem.getOrAssignId((ItemStack)itemStack, (ServerLevel)((ServerLevel)level));
        GunItem.getOrAssignRandomSeed(itemStack);
        CompoundTag stateTag = itemStack.m_41784_();
        long mid = stateTag.m_128454_("mid");
        long lid = stateTag.m_128454_("lid");
        if (mid == 0L && lid == 0L) {
            UUID newId = UUID.randomUUID();
            stateTag.m_128356_("mid", newId.getMostSignificantBits());
            stateTag.m_128356_("lid", newId.getLeastSignificantBits());
            stateTag.m_128405_("ammo", this.maxAmmoCapacity == Integer.MAX_VALUE ? Integer.MAX_VALUE : 0);
            stateTag.m_128365_("ammox", (Tag)new CompoundTag());
            List<FireModeInstance> mainFireModes = this.getMainFireModes();
            if (mainFireModes != null && !mainFireModes.isEmpty()) {
                stateTag.m_128362_("fmid", this.getMainFireModes().get(0).getId());
            }
            stateTag.m_128379_("aim", false);
            Item defaultAttachments = itemStack.m_41720_();
            if (defaultAttachments instanceof AttachmentHost) {
                AttachmentHost attachmentHost = (AttachmentHost)defaultAttachments;
                for (Attachment attachment : attachmentHost.getDefaultAttachments()) {
                    Attachments.addAttachment(itemStack, new ItemStack((ItemLike)attachment), true);
                }
            }
        } else {
            this.ensureValidFireModeSelected(itemStack);
        }
        Attachments.ensureValidAttachmentsSelected(itemStack);
    }

    public static void initStackForCrafting(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            CompoundTag stateTag = itemStack.m_41784_();
            long mid = stateTag.m_128454_("mid");
            long lid = stateTag.m_128454_("lid");
            if (mid == 0L && lid == 0L) {
                UUID newId = UUID.randomUUID();
                stateTag.m_128356_("mid", newId.getMostSignificantBits());
                stateTag.m_128356_("lid", newId.getLeastSignificantBits());
                stateTag.m_128365_("ammox", (Tag)new CompoundTag());
                List<FireModeInstance> mainFireModes = gunItem.getMainFireModes();
                if (mainFireModes != null && !mainFireModes.isEmpty()) {
                    stateTag.m_128362_("fmid", gunItem.getMainFireModes().get(0).getId());
                }
                stateTag.m_128379_("aim", false);
                Item defaultAttachments = itemStack.m_41720_();
                if (defaultAttachments instanceof AttachmentHost) {
                    AttachmentHost attachmentHost = (AttachmentHost)defaultAttachments;
                    for (Attachment attachment : attachmentHost.getDefaultAttachments()) {
                        Attachments.addAttachment(itemStack, new ItemStack((ItemLike)attachment), true);
                    }
                }
            }
        }
    }

    private void ensureValidFireModeSelected(ItemStack itemStack) {
        CompoundTag idTag = itemStack.m_41783_();
        if (idTag != null) {
            UUID fireModeInstanceId = idTag.m_128403_("fmid") ? idTag.m_128342_("fmid") : null;
            FireModeInstance selectedModeInstance = FireModeInstance.getOrElse(fireModeInstanceId, null);
            List<FireModeInstance> fireModes = GunItem.getFireModes(itemStack);
            if (selectedModeInstance != null && !fireModes.contains(selectedModeInstance)) {
                selectedModeInstance = null;
            }
            if (selectedModeInstance == null && !fireModes.isEmpty()) {
                selectedModeInstance = fireModes.get(0);
                GunItem.setFireModeInstance(itemStack, selectedModeInstance);
            }
            if (selectedModeInstance == null) {
                idTag.m_128473_("fmid");
            }
        }
    }

    private static long getOrAssignRandomSeed(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        long seed = tag.m_128454_("seed");
        if (!tag.m_128425_("seed", 99)) {
            seed = random.nextLong();
            tag.m_128356_("seed", seed);
        }
        return seed;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity shooter, int ticksRemaining) {
    }

    private Predicate<Block> getDestroyBlockByHitScanPredicate() {
        return block -> Config.bulletsBreakGlassEnabled && (block instanceof AbstractGlassBlock || block instanceof StainedGlassPaneBlock || block == Blocks.f_50185_);
    }

    private Predicate<Block> getPassThroughBlocksByHitScanPredicate() {
        return block -> block instanceof BushBlock || block instanceof LeavesBlock;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void requestFireFromServer(GunClientState gunClientState, Player player, ItemStack itemStack, Entity targetEntity) {
        int activeSlot = player.m_150109_().f_35977_;
        LOGGER.debug("{} requesting fire from server", (Object)(System.currentTimeMillis() % 100000L));
        SoundFeature.playFireSound(player, itemStack);
        Pair<Integer, Double> pcs = FireModeFeature.getPelletCountAndSpread((LivingEntity)player, gunClientState, itemStack);
        int shotCount = (Integer)pcs.getFirst() > 0 ? (Integer)pcs.getFirst() : 1;
        long requestSeed = random.nextLong();
        FireModeInstance fireModeInstance = GunItem.getFireModeInstance(itemStack);
        if (fireModeInstance.getType() == FireMode.MELEE) {
            return;
        }
        AmmoItem projectileItem = this.getFirstCompatibleProjectile(itemStack, fireModeInstance);
        if (projectileItem != null) {
            Vec3 direction;
            Vec3 startPos;
            GunStatePoseProvider gunStatePoseProvider = GunStatePoseProvider.getInstance();
            Vec3[] pd = gunStatePoseProvider.getPositionAndDirection(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE);
            if (pd == null) {
                pd = gunStatePoseProvider.getPositionAndDirection(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE_FLASH);
            }
            if (pd != null) {
                startPos = pd[0];
                direction = pd[1];
            } else {
                startPos = player.m_146892_();
                direction = player.m_20252_(0.0f);
                startPos = startPos.m_82549_(direction.m_82541_().m_82542_(2.0, 2.0, 2.0));
            }
            Network.networkChannel.sendToServer((Object)new ProjectileFireRequestPacket(fireModeInstance, GunItem.getItemStackId(itemStack), activeSlot, gunClientState.isAiming(), startPos.f_82479_, startPos.f_82480_, startPos.f_82481_, direction.f_82479_, direction.f_82480_, direction.f_82481_, targetEntity != null ? targetEntity.m_19879_() : -1, requestSeed));
        } else {
            double adjustedInaccuracy = this.adjustInaccuracy(player, itemStack, gunClientState.isAiming());
            long itemSeed = GunItem.getOrAssignRandomSeed(itemStack);
            long xorSeed = itemSeed ^ requestSeed;
            this.acquireHitScan(player, itemStack, gunClientState, shotCount, xorSeed, adjustedInaccuracy);
            Network.networkChannel.sendToServer((Object)new HitScanFireRequestPacket(fireModeInstance, GunItem.getItemStackId(itemStack), activeSlot, gunClientState.isAiming(), requestSeed));
            LOGGER.debug("{} sent fire request to server", (Object)(System.currentTimeMillis() % 100000L));
        }
    }

    private void acquireHitScan(Player player, ItemStack itemStack, @NotNull GunClientState gunClientState, int shotCount, long seed, double adjustedInaccuracy) {
        if (shotCount <= 1) {
            double maxDistance = this.getMaxClientShootingDistance(itemStack, gunClientState);
            for (HitResult hitResult : HitScan.getObjectsInCrosshair((LivingEntity)player, player.m_146892_(), player.m_20252_(0.0f), 1.0f, maxDistance, shotCount, adjustedInaccuracy, seed, this.getDestroyBlockByHitScanPredicate(), this.getPassThroughBlocksByHitScanPredicate(), new ArrayList<BlockPos>())) {
                gunClientState.acquireHitScan((LivingEntity)player, itemStack, hitResult);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private double getMaxClientShootingDistance(ItemStack itemStack, GunClientState gunClientState) {
        Minecraft mc = Minecraft.m_91087_();
        double maxDistance = Math.min(mc.f_91066_.m_193772_() * 16, FireModeFeature.getMaxShootingDistance(itemStack));
        if (!gunClientState.isAiming()) {
            maxDistance = Math.min(maxDistance, 100.0);
        }
        return maxDistance;
    }

    private double adjustInaccuracy(Player player, ItemStack itemStack, boolean isAiming) {
        double adjustedInaccuracy = isAiming ? this.inaccuracyAiming : (player.m_20142_() ? this.inaccuracySprinting : this.inaccuracy);
        Pair<Integer, Double> pcs = FireModeFeature.getPelletCountAndSpread((LivingEntity)player, null, itemStack);
        if ((Integer)pcs.getFirst() > 0) {
            adjustedInaccuracy += ((Double)pcs.getSecond()).doubleValue();
        }
        float accuracyModifier = AccuracyFeature.getAccuracyModifier(itemStack);
        return adjustedInaccuracy / (double)accuracyModifier;
    }

    public static LazyOptional<Integer> getClientSideAmmo(Player player, ItemStack itemStack, int slotIndex) {
        GunClientState state = GunClientState.getState(player, itemStack, slotIndex, false);
        return LazyOptional.of(state != null ? () -> state.getAmmoCount(GunItem.getFireModeInstance(itemStack)) : null);
    }

    public double getInacuracy() {
        return this.inaccuracy;
    }

    public int getShotsPerTrace() {
        return this.shotsPerTrace;
    }

    public static int getAmmo(ItemStack itemStack, FireModeInstance fireModeInstance) {
        CompoundTag idTag;
        if (itemStack.m_41720_() instanceof GunItem && (idTag = itemStack.m_41783_()) != null) {
            if (GunItem.getFireModeInstance(itemStack).getMaxAmmoCapacity() == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (fireModeInstance.isUsingDefaultAmmoPool()) {
                return idTag.m_128451_("ammo");
            }
            CompoundTag auxAmmoTag = idTag.m_128469_("ammox");
            if (auxAmmoTag != null) {
                return auxAmmoTag.m_128451_(fireModeInstance.getAmmo().getName());
            }
        }
        return 0;
    }

    public static void setAmmo(ItemStack itemStack, FireModeInstance fireModeInstance, int ammo) {
        if (itemStack.m_41720_() instanceof GunItem) {
            LOGGER.debug("Setting ammo in stack {} to {}", (Object)System.identityHashCode(itemStack), (Object)ammo);
            CompoundTag idTag = itemStack.m_41783_();
            if (idTag != null) {
                if (fireModeInstance.isUsingDefaultAmmoPool()) {
                    idTag.m_128405_("ammo", ammo);
                } else {
                    CompoundTag auxAmmoTag = idTag.m_128469_("ammox");
                    auxAmmoTag.m_128405_(fireModeInstance.getAmmo().getName(), ammo);
                    idTag.m_128365_("ammox", (Tag)auxAmmoTag);
                }
            }
        }
    }

    public static int decrementAmmo(ItemStack itemStack) {
        if (!(itemStack.m_41720_() instanceof GunItem)) {
            return 0;
        }
        CompoundTag idTag = itemStack.m_41783_();
        if (idTag != null) {
            int ammo = idTag.m_128451_("ammo");
            if (ammo <= 0) {
                return -1;
            }
            idTag.m_128405_("ammo", --ammo);
            return ammo;
        }
        return 0;
    }

    public static FireMode getSelectedFireModeType(ItemStack itemStack) {
        FireModeInstance fireModeInstance = GunItem.getFireModeInstance(itemStack);
        return fireModeInstance != null ? fireModeInstance.getType() : null;
    }

    public static FireModeInstance getFireModeInstance(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            CompoundTag idTag = itemStack.m_41783_();
            if (idTag != null) {
                UUID fireModeInstanceId = idTag.m_128403_("fmid") ? idTag.m_128342_("fmid") : null;
                FireModeInstance fireModeInstance = null;
                if (fireModeInstanceId != null) {
                    fireModeInstance = FireModeInstance.getOrElse(fireModeInstanceId, null);
                }
                if (fireModeInstance == null) {
                    fireModeInstance = gunItem.getMainFireModes().get(0);
                }
                return fireModeInstance;
            }
            return null;
        }
        return null;
    }

    private static void setFireModeInstance(ItemStack itemStack, FireModeInstance fireModeInstance) {
        CompoundTag idTag;
        if (itemStack.m_41720_() instanceof GunItem && (idTag = itemStack.m_41783_()) != null) {
            idTag.m_128362_("fmid", fireModeInstance.getId());
            LOGGER.debug("Set fire mode instance to {}, tag: {}", (Object)fireModeInstance.getDisplayName(), (Object)idTag);
        }
    }

    public void handleClientProjectileFireRequest(ServerPlayer player, FireModeInstance fireModeInstance, UUID stateId, int slotIndex, int correlationId, boolean isAiming, double spawnPositionX, double spawnPositionY, double spawnPositionZ, double spawnDirectionX, double spawnDirectionY, double spawnDirectionZ, int targetEntityId, long requestSeed) {
        ItemStack itemStack = player.m_150109_().m_8020_(slotIndex);
        AmmoItem projectileItem = this.getFirstCompatibleProjectile(itemStack, fireModeInstance);
        if (projectileItem == null) {
            LOGGER.error("Attempted to handle client projectile fire request with an item that does not support projectiles: " + String.valueOf(this));
        } else if (this.isEnabled() && projectileItem.isEnabled()) {
            boolean isOffhand;
            boolean bl = isOffhand = player.m_21206_() == itemStack;
            if (itemStack != null && !isOffhand && itemStack.m_41720_() instanceof GunItem) {
                int ammo = 0;
                ammo = GunItem.getAmmo(itemStack, fireModeInstance);
                if (ammo > 0) {
                    LOGGER.debug("Received client projectile file request");
                    Entity targetEntity = null;
                    if (targetEntityId >= 0) {
                        targetEntity = MiscUtil.getLevel((Entity)player).m_6815_(targetEntityId);
                    }
                    ProjectileLike projectile = null;
                    if (targetEntity != null) {
                        HitResult hitResult = HitScan.ensureEntityInCrosshair((LivingEntity)player, targetEntity, 0.0f, 400.0, 2.0f);
                        if (hitResult != null && hitResult.m_6662_() == HitResult.Type.ENTITY && ((EntityHitResult)hitResult).m_82443_() == targetEntity) {
                            projectile = projectileItem.createProjectile((LivingEntity)player, spawnPositionX, spawnPositionY, spawnPositionZ);
                            projectile.launchAtTargetEntity((LivingEntity)player, hitResult, targetEntity);
                        }
                    } else {
                        projectile = projectileItem.createProjectile((LivingEntity)player, spawnPositionX, spawnPositionY, spawnPositionZ);
                        long xorSeed = GunItem.getOrAssignRandomSeed(itemStack) ^ requestSeed;
                        double adjustedInaccuracy = this.adjustInaccuracy((Player)player, itemStack, isAiming);
                        projectile.launchAtLookTarget((LivingEntity)player, adjustedInaccuracy, xorSeed);
                    }
                    if (projectile != null) {
                        if (this.getMaxAmmoCapacity(itemStack, fireModeInstance) < Integer.MAX_VALUE) {
                            GunItem.setAmmo(itemStack, fireModeInstance, ammo - 1);
                        }
                        SoundFeature.playFireSound((Player)player, itemStack);
                        MiscUtil.getLevel((Entity)player).m_7967_((Entity)projectile);
                    } else {
                        LOGGER.debug("Did not fire projectile");
                    }
                }
            }
        }
    }

    public List<AmmoItem> getCompatibleAmmo() {
        return this.compatibleBullets.stream().map(Supplier::get).toList();
    }

    private AmmoItem getFirstCompatibleProjectile(ItemStack gunStack, FireModeInstance fireModeInstance) {
        Item item = gunStack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            List<FireModeInstance> firModeInstances = GunItem.getFireModes(gunStack);
            if (!firModeInstances.contains(fireModeInstance)) {
                return null;
            }
            AmmoItem projectileItem = null;
            if (fireModeInstance.isUsingDefaultAmmoPool()) {
                for (Supplier<AmmoItem> ammoSupplier : gunItem.compatibleBullets) {
                    AmmoItem ammoItem = ammoSupplier.get();
                    if (ammoItem == null || !ammoItem.isHasProjectile()) continue;
                    projectileItem = ammoItem;
                    break;
                }
            } else {
                AmmoItem ammoItem = fireModeInstance.getAmmo();
                if (ammoItem.isHasProjectile()) {
                    projectileItem = ammoItem;
                }
            }
            return projectileItem;
        }
        return null;
    }

    public void handleClientHitScanFireRequest(ServerPlayer player, FireModeInstance fireModeInstance, UUID stateId, int slotIndex, int correlationId, boolean isAiming, long requestSeed) {
        try {
            boolean isOffhand;
            LOGGER.debug("{} handling client fire request", (Object)(System.currentTimeMillis() % 100000L));
            ItemStack itemStack = player.m_150109_().m_8020_(slotIndex);
            AmmoItem projectileItem = this.getFirstCompatibleProjectile(itemStack, fireModeInstance);
            if (projectileItem != null) {
                LOGGER.error("Attempted to handle client hit scan fire request with an item that fires projectiles: " + String.valueOf(this));
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            boolean bl = isOffhand = player.m_21206_() == itemStack;
            if (itemStack == null || isOffhand || !(itemStack.m_41720_() instanceof GunItem)) {
                return;
            }
            ArrayList<HitResult> hitResults = new ArrayList<HitResult>();
            int ammo = 0;
            ammo = GunItem.getAmmo(itemStack, fireModeInstance);
            if (ammo > 0) {
                if (this.getMaxAmmoCapacity(itemStack, fireModeInstance) < Integer.MAX_VALUE) {
                    GunItem.setAmmo(itemStack, fireModeInstance, ammo - 1);
                }
                SoundFeature.playFireSound((Player)player, itemStack);
                Pair<Integer, Double> pcs = FireModeFeature.getPelletCountAndSpread((LivingEntity)player, null, itemStack);
                int shotCount = (Integer)pcs.getFirst() > 0 ? (Integer)pcs.getFirst() : 1;
                double adjustedInaccuracy = this.adjustInaccuracy((Player)player, itemStack, isAiming);
                long xorSeed = GunItem.getOrAssignRandomSeed(itemStack) ^ requestSeed;
                Vec3 eyePos = player.m_146892_();
                Vec3 lookVec = player.m_20252_(0.0f);
                ServerLevel level = (ServerLevel)MiscUtil.getLevel((Entity)player);
                double maxHitScanDistance = this.getMaxServerShootingDistance(itemStack, isAiming, level);
                ArrayList<BlockPos> blockPosToDestroy = new ArrayList<BlockPos>();
                if (this.hitscan) {
                    hitResults.addAll(HitScan.getObjectsInCrosshair((LivingEntity)player, eyePos, lookVec, 0.0f, maxHitScanDistance, shotCount, adjustedInaccuracy, xorSeed, this.getDestroyBlockByHitScanPredicate(), this.getPassThroughBlocksByHitScanPredicate(), blockPosToDestroy));
                } else {
                    BulletData modifiedBulletData = this.bulletData;
                    List<Features.EnabledFeature> modifiers = Features.getEnabledFeatures(itemStack, BulletModifierFeature.class);
                    for (Features.EnabledFeature feature : modifiers) {
                        BulletModifierFeature mod = (BulletModifierFeature)feature.feature();
                        modifiedBulletData = new BulletData(modifiedBulletData.velocity() + mod.getVelocityModifier(), modifiedBulletData.speedOffset() + mod.getSpeedOffsetModifier(), modifiedBulletData.maxSpeedOffset() + mod.getMaxSpeedOffsetModifier(), modifiedBulletData.inaccuracy() + mod.getInaccuracyModifier(), modifiedBulletData.gravity() + mod.getGravityModifier());
                    }
                    for (int i = 0; i < shotCount; ++i) {
                        float speed = modifiedBulletData.speedOffset() + Mth.m_14036_((float)(fireModeInstance.getDamage() * (float)shotCount / (modifiedBulletData.velocity() + 1.0f)), (float)0.0f, (float)modifiedBulletData.maxSpeedOffset());
                        float damage = fireModeInstance.getDamage();
                        ProjectileBulletEntity bullet = new ProjectileBulletEntity((LivingEntity)player, player.m_9236_(), damage, speed, shotCount, fireModeInstance.getMaxShootingDistance(), fireModeInstance.getHeadshotMultiplier(), itemStack, correlationId);
                        bullet.m_5602_((Entity)player);
                        bullet.setBulletGravity(modifiedBulletData.gravity());
                        bullet.m_37251_((Entity)bullet, player.m_146909_(), player.m_146908_(), 0.0f, speed, (float)adjustedInaccuracy * modifiedBulletData.inaccuracy());
                        player.m_9236_().m_7967_((Entity)bullet);
                    }
                }
                LOGGER.debug("{} obtained hit results", (Object)(System.currentTimeMillis() % 100000L));
                for (HitResult hitResult : hitResults) {
                    this.hitScanTarget((Player)player, itemStack, slotIndex, correlationId, hitResult, maxHitScanDistance, blockPosToDestroy);
                    if (!this.hasFunction("postFire")) continue;
                    this.invokeFunction("postFire", new Object[]{itemStack, player, this, hitResult});
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to handle client hit scan fire request: {}", (Throwable)e);
        }
    }

    private double getMaxServerShootingDistance(ItemStack itemStack, boolean isAiming, ServerLevel level) {
        MinecraftServer server = level.m_7654_();
        double maxHitScanDistance = Math.min(server.m_6846_().m_11312_() * 16, FireModeFeature.getMaxShootingDistance(itemStack));
        if (!isAiming) {
            maxHitScanDistance = Math.min(maxHitScanDistance, 100.0);
        }
        return maxHitScanDistance;
    }

    private void hitScanTarget(Player player, ItemStack itemStack, int slotIndex, int correlationId, HitResult hitResult, double maxHitScanDistance, List<BlockPos> blockPosToDestroy) {
        float entityDamage = 0.0f;
        LOGGER.debug("Executing hit target task for hit result {}", (Object)hitResult);
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            entityDamage = this.hurtEntity((LivingEntity)player, (EntityHitResult)hitResult, null, itemStack);
        } else if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            this.handleBlockHit((LivingEntity)player, (BlockHitResult)hitResult, null);
        }
        for (BlockPos bp : blockPosToDestroy) {
            MiscUtil.getLevel((Entity)player).m_46953_(bp, true, (Entity)player);
        }
        double maxHitScanDistanceSqr = maxHitScanDistance * maxHitScanDistance;
        for (ServerPlayer serverPlayer : ((ServerLevel)MiscUtil.getLevel((Entity)player)).m_8795_(p -> true)) {
            if (serverPlayer != player && !(serverPlayer.m_20280_((Entity)player) < maxHitScanDistanceSqr)) continue;
            LOGGER.debug("{} sends hit scan notification to {}", (Object)player, (Object)serverPlayer);
            Network.networkChannel.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new HitScanFireResponsePacket(player.m_19879_(), GunItem.getItemStackId(itemStack), slotIndex, correlationId, SimpleHitResult.fromHitResult(hitResult), entityDamage));
        }
    }

    public void handleClientFireModeRequest(ServerPlayer player, UUID stateId, int slotIndex, int correlationId, FireModeInstance fireModeInstance) {
        ItemStack itemStack = player.m_150109_().m_8020_(slotIndex);
        if (itemStack != null && itemStack.m_41720_() instanceof GunItem) {
            boolean isSuccess = GunItem.getFireModes(itemStack).contains(fireModeInstance);
            if (isSuccess) {
                GunItem.setFireModeInstance(itemStack, fireModeInstance);
                GunItem.setAmmo(itemStack, fireModeInstance, GunItem.getAmmo(itemStack, fireModeInstance));
            }
            Network.networkChannel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new FireModeResponsePacket(stateId, slotIndex, correlationId, isSuccess, fireModeInstance));
        } else {
            Network.networkChannel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new FireModeResponsePacket(stateId, slotIndex, correlationId, false, fireModeInstance));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processServerHitScanFireResponse(Player player, UUID stateId, ItemStack itemStack, GunClientState gunClientState, SimpleHitResult hitResult, float damage) {
        if (gunClientState != null) {
            Item var9;
            Player mainPlayer = ClientUtils.getClientPlayer();
            if (player == mainPlayer) {
                if (hitResult.m_6662_() != HitResult.Type.MISS) {
                    gunClientState.confirmHitScanTarget((LivingEntity)mainPlayer, itemStack, hitResult, damage);
                }
            } else if (itemStack != null && (var9 = itemStack.m_41720_()) instanceof GunItem) {
                GunItem gunItem = (GunItem)var9;
                gunItem.effectLauncher.onStartFiring((LivingEntity)mainPlayer, gunClientState, itemStack);
                gunItem.effectLauncher.onHitScanTargetAcquired((LivingEntity)mainPlayer, gunClientState, itemStack, hitResult);
                if (hitResult.m_6662_() != HitResult.Type.MISS) {
                    gunItem.effectLauncher.onHitScanTargetConfirmed((LivingEntity)mainPlayer, gunClientState, itemStack, hitResult, damage);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processServerFireModeResponse(UUID stateId, int correlationId, boolean isSuccess, ItemStack itemStack, GunClientState gunClientState, FireModeInstance fireModeInstance) {
        LOGGER.debug("Process fire mode response: {}", (Object)isSuccess);
        if (isSuccess && GunItem.getFireModes(itemStack).contains(fireModeInstance)) {
            GunItem.setFireModeInstance(itemStack, fireModeInstance);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processServerReloadResponse(int correlationId, boolean isSuccess, ItemStack itemStack, GunClientState gunClientState, int ammo, FireModeInstance fireModeInstance) {
        LOGGER.debug("Process server reload response with ammo count {}", (Object)ammo);
        gunClientState.reloadAmmo(ClientUtils.getLevel(), fireModeInstance, ammo);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean tryReload(Player player, ItemStack itemStack) {
        GunClientState gunClientState;
        boolean isMainHand;
        boolean result = false;
        int activeSlot = player.m_150109_().f_35977_;
        boolean bl = isMainHand = player.m_21205_() == itemStack;
        if (isMainHand && (gunClientState = GunClientState.getState(player, itemStack, activeSlot, false)) != null) {
            result = gunClientState.tryReload((LivingEntity)player, itemStack);
        }
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean tryFire(LocalPlayer player, ItemStack itemStack, Entity targetEntity) {
        GunClientState gunClientState;
        boolean isMainHand;
        boolean result = false;
        int activeSlot = player.m_150109_().f_35977_;
        boolean bl = isMainHand = player.m_21205_() == itemStack;
        if (isMainHand && (gunClientState = GunClientState.getState((Player)player, itemStack, activeSlot, false)) != null) {
            gunClientState.setTrigger(true);
            result = gunClientState.tryFire((LivingEntity)player, itemStack, targetEntity);
        }
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean requestReloadFromServer(Player player, ItemStack itemStack) {
        boolean isMainHandItem;
        LOGGER.debug("{} Initiating client side reload", (Object)(System.currentTimeMillis() % 100000L));
        boolean result = false;
        int activeSlot = player.m_150109_().f_35977_;
        boolean bl = isMainHandItem = player.m_21205_() == itemStack;
        if (isMainHandItem) {
            FireModeInstance fireModeInstance = GunItem.getFireModeInstance(itemStack);
            int ammoToReload = this.canReloadGun(itemStack, player, fireModeInstance);
            if (ammoToReload > 0) {
                Network.networkChannel.sendToServer((Object)new ReloadRequestPacket(GunItem.getItemStackId(itemStack), activeSlot, fireModeInstance));
                result = true;
            } else {
                LOGGER.debug("No ammo to reload");
            }
        }
        return result;
    }

    public double getAimingCurveX() {
        return this.aimingCurveX;
    }

    public double getAimingCurveY() {
        return this.aimingCurveY;
    }

    public double getAimingCurveZ() {
        return this.aimingCurveZ;
    }

    public double getAimingCurvePitch() {
        return this.aimingCurvePitch;
    }

    public double getAimingCurveYaw() {
        return this.aimingCurveYaw;
    }

    public double getAimingCurveRoll() {
        return this.aimingCurveRoll;
    }

    public double getAimingZoom() {
        return this.aimingZoom;
    }

    private static FireModeInstance getNextFireModeInstance(ItemStack itemStack, FireModeInstance currentMode) {
        List<FireModeInstance> allFireModes = GunItem.getFireModes(itemStack);
        int currentIndex = allFireModes.indexOf(currentMode);
        int nextIndex = (currentIndex + 1) % allFireModes.size();
        return allFireModes.get(nextIndex);
    }

    public static List<FireModeInstance> getFireModes(ItemStack itemStack) {
        ArrayList<FireModeInstance> allFireModes = new ArrayList<FireModeInstance>();
        for (Features.EnabledFeature efmf : Features.getEnabledFeatures(itemStack, FireModeFeature.class)) {
            FireModeFeature fmf = (FireModeFeature)efmf.feature();
            allFireModes.addAll(fmf.getFireModes());
        }
        return allFireModes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initiateClientSideFireMode(Player player, ItemStack itemStack) {
        FireModeInstance currentFireMode;
        FireModeInstance nextFireMode;
        GunClientState gunClientState;
        boolean isOffhand;
        int activeSlot = player.m_150109_().f_35977_;
        boolean bl = isOffhand = player.m_21206_() == itemStack;
        if (!(isOffhand || (gunClientState = GunClientState.getState(player, itemStack, activeSlot, false)) == null || gunClientState.isReloading() || gunClientState.isFiring() || gunClientState.isInspecting() || (nextFireMode = GunItem.getNextFireModeInstance(itemStack, currentFireMode = GunItem.getFireModeInstance(itemStack))) == currentFireMode)) {
            LOGGER.debug("Requesting fire mode change from {} to {}", (Object)currentFireMode.getDisplayName(), (Object)nextFireMode.getDisplayName());
            GunItem.setAmmo(itemStack, nextFireMode, GunItem.getAmmo(itemStack, nextFireMode));
            Network.networkChannel.sendToServer((Object)new FireModeRequestPacket(GunItem.getItemStackId(itemStack), activeSlot, nextFireMode));
        }
    }

    public void handleClientStopFireRequest(ServerPlayer player, UUID stateId, int slotIndex, int correlationId) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processStopServerFireResponse(UUID stateId, int correlationId, boolean isSuccess, ItemStack itemStack, GunClientState gunClientState) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setTriggerOff(LocalPlayer player, ItemStack itemStack) {
        GunClientState gunClientState;
        boolean isOffhand;
        int activeSlot = player.m_150109_().f_35977_;
        boolean bl = isOffhand = player.m_21206_() == itemStack;
        if (!isOffhand && (gunClientState = GunClientState.getState((Player)player, itemStack, activeSlot, false)) != null) {
            gunClientState.setTrigger(false);
        }
    }

    public GunClientState createState(UUID stateId) {
        String controllerId;
        final GunClientState state = new GunClientState(stateId, this);
        LOGGER.debug("Creating state {}", (Object)stateId);
        if (this.useAdvancedRecoil) {
            state.setAnimationController("advancedRecoil", new AdvancedRecoilController(this.verticalAmplitude, this.verticalRecovery, this.verticalSmoothness, this.horizontalAmplitude, this.horizontalRecovery, this.horizontalSmoothness, this.horizontalRandomness, this.recoilPattern));
            LOGGER.debug("AdvancedRecoilController added for state {}", (Object)stateId);
        } else {
            state.setAnimationController("playerRecoil", new PlayerRecoilController(this.viewRecoilAmplitude, this.viewRecoilMaxPitch, this.viewRecoilDuration));
            LOGGER.debug("PlayerRecoilController added for state {}", (Object)stateId);
        }
        state.setAnimationController("shake", new ViewShakeAnimationController(this.shakeRecoilAmplitude, this.shakeRecoilSpeed, this.shakeDecay, this.shakeRecoilDuration){

            @Override
            public void onStartFiring(LivingEntity player, GunClientState state, ItemStack itemStack) {
                FireModeInstance.ViewShakeDescriptor viewShakeDescriptor = FireModeFeature.getViewShakeDescriptor(itemStack);
                this.reset(viewShakeDescriptor);
            }
        });
        state.setAnimationController("recoil2", new GunRecoilAnimationController(this.gunRecoilInitialAmplitude, this.gunRecoilRateOfAmplitudeDecay, this.gunRecoilInitialAngularFrequency, this.gunRecoilRateOfFrequencyIncrease, this.gunRecoilPitchMultiplier, this.gunRecoilDuration, this.shotsPerRecoil));
        state.setAnimationController("randomizer", new GunRandomizingAnimationController(this.gunRandomizationAmplitude, this.idleRandomizationDuration, this.recoilRandomizationDuration));
        state.setAnimationController("reloadTimer", this.createReloadTimerController());
        for (GlowAnimationController.Builder builder : this.glowEffectBuilders) {
            controllerId = "glowEffect" + builder.getEffectId();
            state.setAnimationController(controllerId, builder.build());
        }
        for (RotationAnimationController.Builder builder : this.rotationEffectBuilders) {
            controllerId = "rotation" + builder.getModelPartName();
            state.setAnimationController(controllerId, builder.build());
        }
        state.addListener(new DynamicGeoListener());
        state.addListener(this.effectLauncher);
        state.setAnimationController("aiming", new BiDirectionalInterpolator(this.adsSpeed){

            @Override
            public void onToggleAiming(boolean isAiming, Player player) {
                this.setFullDuration(AdsSpeedFeature.getTotalAdsSpeed(player.m_21205_(), player, state));
                this.set(isAiming ? BiDirectionalInterpolator.Position.END : BiDirectionalInterpolator.Position.START, false);
            }
        });
        return state;
    }

    private List<GunStateAnimationController> createReloadAnimationControllers() {
        ArrayList<GunStateAnimationController> reloadAnimationControllers = new ArrayList<GunStateAnimationController>();
        if (this.phasedReloads.isEmpty()) {
            GunStateAnimationController reloadAnimationController = new GunStateAnimationController(this, "reload_controller", DEFAULT_ANIMATION_RELOAD, ctx -> ctx.gunClientState().isReloading()){

                @Override
                public void onStartReloading(LivingEntity player, GunClientState state, ItemStack itemStack) {
                    if (ClientUtil.isFirstPerson(player)) {
                        this.scheduleReset(player, state, itemStack);
                    }
                }
            };
            reloadAnimationControllers.add(reloadAnimationController);
        } else {
            long maxReloadDuration = 0L;
            for (PhasedReload phasedReload : this.phasedReloads) {
                long conditionalReloadTimeMillis = phasedReload.timeUnit.toMillis(phasedReload.cooldownTime);
                if (conditionalReloadTimeMillis <= maxReloadDuration) continue;
                maxReloadDuration = conditionalReloadTimeMillis;
            }
            int counter = 0;
            for (final PhasedReload phasedReload : this.phasedReloads) {
                ReloadAnimation reloadAnimation = phasedReload.reloadAnimation;
                final Predicate<ConditionContext> combinedPredicate = ctx -> ctx.gunClientState().isReloading() && phasedReload.predicate.test((ConditionContext)ctx);
                GunStateAnimationController reloadAnimationController = new GunStateAnimationController(this, reloadAnimation.animationName + "_" + counter++, reloadAnimation.animationName, combinedPredicate){

                    @Override
                    public void onStartReloading(LivingEntity player, GunClientState state, ItemStack itemStack) {
                        if (ClientUtil.isFirstPerson(player) && phasedReload.phase == ReloadPhase.RELOADING && combinedPredicate.test(new ConditionContext(player, itemStack, state, null))) {
                            LOGGER.debug("Reset {} on start reloading. Iter: {}", (Object)this.getName(), (Object)state.getReloadIterationIndex());
                            this.scheduleReset(player, state, itemStack);
                        }
                    }

                    @Override
                    public void onCompleteReloading(LivingEntity player, GunClientState state, ItemStack itemStack) {
                        if (ClientUtil.isFirstPerson(player) && phasedReload.phase == ReloadPhase.COMPLETETING && combinedPredicate.test(new ConditionContext(player, itemStack, state, null))) {
                            LOGGER.debug("Reset {} on complete reloading. Iter: {}", (Object)this.getName(), (Object)state.getReloadIterationIndex());
                            this.scheduleReset(player, state, itemStack);
                        }
                    }

                    @Override
                    public void onPrepareReloading(LivingEntity player, GunClientState state, ItemStack itemStack) {
                        if (ClientUtil.isFirstPerson(player) && phasedReload.phase == ReloadPhase.PREPARING && combinedPredicate.test(new ConditionContext(player, itemStack, state, null))) {
                            LOGGER.debug("Reset {} on prepare reloading. Iter: {}", (Object)this.getName(), (Object)state.getReloadIterationIndex());
                            this.scheduleReset(player, state, itemStack);
                        }
                    }
                };
                reloadAnimationController.setSoundKeyframeHandler(event -> {
                    SoundKeyframeData soundKeyframeData;
                    String soundName;
                    SoundEvent soundEvent;
                    Player player = ClientUtils.getClientPlayer();
                    if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                        player.m_5496_(soundEvent, 1.0f, 1.0f);
                    }
                });
                reloadAnimationControllers.add(reloadAnimationController);
            }
        }
        Collections.shuffle(reloadAnimationControllers);
        return reloadAnimationControllers;
    }

    private TimerController createReloadTimerController() {
        TimerController reloadTimerController;
        if (this.phasedReloads.isEmpty()) {
            reloadTimerController = new TimerController(this.reloadCooldownTime){

                @Override
                public void onStartReloading(LivingEntity player, GunClientState state, ItemStack itemStack) {
                    this.reset();
                }
            };
            for (Tuple<Long, AbstractProceduralAnimationController> t : this.reloadEffectControllers) {
                reloadTimerController.schedule(ReloadPhase.RELOADING, (Long)t.m_14418_(), TimeUnit.MILLISECOND, (AbstractProceduralAnimationController)t.m_14419_(), null);
            }
        } else {
            long maxReloadDuration = 0L;
            for (PhasedReload phasedReload : this.phasedReloads) {
                long conditionalReloadTimeMillis = phasedReload.timeUnit.toMillis(phasedReload.cooldownTime);
                if (conditionalReloadTimeMillis <= maxReloadDuration) continue;
                maxReloadDuration = conditionalReloadTimeMillis;
            }
            reloadTimerController = new TimerController(maxReloadDuration){

                @Override
                public void onStartReloading(LivingEntity player, GunClientState state, ItemStack itemStack) {
                    if (ClientUtil.isFirstPerson(player)) {
                        this.reset();
                    }
                }

                @Override
                public void onCompleteReloading(LivingEntity player, GunClientState state, ItemStack itemStack) {
                    if (ClientUtil.isFirstPerson(player)) {
                        this.reset();
                    }
                }

                @Override
                public void onPrepareReloading(LivingEntity player, GunClientState state, ItemStack itemStack) {
                    if (ClientUtil.isFirstPerson(player)) {
                        this.reset();
                    }
                }
            };
            for (PhasedReload phasedReload : this.phasedReloads) {
                ReloadAnimation reloadAnimation = phasedReload.reloadAnimation;
                Predicate<ConditionContext> combinedPredicate = ctx -> ctx.gunClientState().isReloading() && phasedReload.predicate.test((ConditionContext)ctx);
                for (ReloadShakeEffect effect : reloadAnimation.shakeEffects) {
                    ViewShakeAnimationController2 controller = new ViewShakeAnimationController2(effect.initialAmplitude, effect.rateOfAmplitudeDecay, effect.initialAngularFrequency, effect.rateOfFrequencyIncrease, effect.duration);
                    reloadTimerController.schedule(phasedReload.phase, phasedReload.timeUnit.toMillis(effect.startTime), TimeUnit.MILLISECOND, controller, combinedPredicate);
                }
            }
        }
        return reloadTimerController;
    }

    public Map<String, AnimationController<GeoAnimatable>> getGeoAnimationControllers(ItemStack itemStack) {
        long geoId = GeoItem.getId((ItemStack)itemStack);
        AnimatableManager animatableManager = this.cache.getManagerForId(geoId);
        return animatableManager.getAnimationControllers();
    }

    public AnimationController<GeoAnimatable> getGeoAnimationController(String controllerId, ItemStack itemStack) {
        Map<String, AnimationController<GeoAnimatable>> controllers = this.getGeoAnimationControllers(itemStack);
        return controllers.get(controllerId);
    }

    public ResourceLocation getTargetLockOverlay() {
        return this.targetLockOverlay;
    }

    @Override
    public long getTargetLockTimeTicks() {
        return this.targetLockTimeTicks;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onTargetStartLocking(Entity targetEntity) {
        LOGGER.debug("Locking target: {}", (Object)targetEntity);
        if (this.targetStartLockingSound != null) {
            Player player = ClientUtils.getClientPlayer();
            MiscUtil.getLevel((Entity)player).m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.targetStartLockingSound, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onTargetLocked(Entity targetEntity) {
        GunClientState state;
        LOGGER.debug("Target locked: {}", (Object)targetEntity);
        Player player = ClientUtils.getClientPlayer();
        if (this.targetLockedSound != null) {
            MiscUtil.getLevel((Entity)player).m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.targetLockedSound, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if ((state = GunClientState.getMainHeldState()) != null) {
            MutableComponent var10001 = Component.m_237115_((String)"message.pointblank.targetAcquired").m_130946_(": ").m_7220_(targetEntity.m_7755_()).m_130946_(". ");
            MutableComponent var10002 = Component.m_237115_((String)"message.pointblank.distance").m_130946_(": ");
            float var10003 = targetEntity.m_20270_((Entity)player);
            state.publishMessage((Component)var10001.m_7220_((Component)var10002.m_130946_("" + Math.round(var10003))), 1000L, s -> true);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onTargetStartUnlocking(Entity targetEntity) {
        LOGGER.debug("Target unlocked: {}", (Object)targetEntity);
    }

    @Override
    public float getPrice() {
        return this.tradePrice;
    }

    @Override
    public int getBundleQuantity() {
        return this.tradeBundleQuantity;
    }

    @Override
    public int getTradeLevel() {
        return this.tradeLevel;
    }

    public float getBobbing() {
        return this.bobbing;
    }

    public float getBobbingOnAim() {
        return this.bobbingOnAim;
    }

    public float getBobbingRollMultiplier() {
        return this.bobbingRollMultiplier;
    }

    public double getJumpMultiplier() {
        return this.jumpMultiplier;
    }

    public double getPipScopeZoom() {
        return this.pipScopeZoom;
    }

    public void handleAimingChangeRequest(Player player, ItemStack itemStack, UUID stateId, int slotIndex, boolean isAiming) {
        if (itemStack.m_41720_() instanceof GunItem) {
            CompoundTag idTag = itemStack.m_41783_();
            if (idTag != null) {
                idTag.m_128379_("aim", isAiming && this.isAimingEnabled);
            }
            if (player.m_20142_() && isAiming && this.isAimingEnabled) {
                player.m_6858_(false);
            }
        }
    }

    public static boolean isAiming(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            CompoundTag idTag = itemStack.m_41783_();
            if (idTag == null) {
                return false;
            }
            return gunItem.isAimingEnabled && idTag.m_128471_("aim");
        }
        return false;
    }

    @Override
    public int getMaxAttachmentCategories() {
        return 11;
    }

    public List<Attachment> getDefaultAttachments() {
        return this.defaultAttachmentSuppliers.stream().map(Supplier::get).toList();
    }

    @Override
    public Collection<Attachment> getCompatibleAttachments() {
        if (this.compatibleAttachments == null) {
            HashSet<AttachmentCategory> attachmentCategories = new HashSet<AttachmentCategory>();
            LinkedHashSet<Attachment> compatibleAttachments = new LinkedHashSet<Attachment>();
            for (Attachment attachment : this.getDefaultAttachments()) {
                if (attachmentCategories.size() >= this.getMaxAttachmentCategories()) {
                    LOGGER.warn("Cannot add compatible attachment {} with category {} to  item {} because the existing number of compatible categories for this item cannot exceed {}", (Object)attachment.getName(), (Object)attachment.getCategory(), (Object)this.getName(), (Object)this.getMaxAttachmentCategories());
                    break;
                }
                attachmentCategories.add(attachment.getCategory());
                compatibleAttachments.add(attachment);
            }
            for (Supplier supplier : this.compatibleAttachmentSuppliers) {
                Attachment attachment = (Attachment)supplier.get();
                if (attachmentCategories.size() >= this.getMaxAttachmentCategories()) {
                    LOGGER.warn("Cannot add compatible attachment {} with category {} to  item {} because the existing number of compatible categories for this item cannot exceed {}", (Object)attachment.getName(), (Object)attachment.getCategory(), (Object)this.getName(), (Object)this.getMaxAttachmentCategories());
                    break;
                }
                attachmentCategories.add(attachment.getCategory());
                compatibleAttachments.add(attachment);
            }
            block2: for (String string : this.compatibleAttachmentGroups) {
                for (Supplier<? extends Item> ga : ItemRegistry.ITEMS.getAttachmentsForGroup(string)) {
                    Item item = ga.get();
                    if (!(item instanceof Attachment)) continue;
                    Attachment attachment = (Attachment)item;
                    if (attachmentCategories.size() >= this.getMaxAttachmentCategories()) {
                        LOGGER.warn("Cannot add compatible attachment {} with category {} to  item {} because the existing number of compatible categories for this item cannot exceed {}", (Object)attachment.getName(), (Object)attachment.getCategory(), (Object)this.getName(), (Object)this.getMaxAttachmentCategories());
                        continue block2;
                    }
                    compatibleAttachments.add(attachment);
                }
            }
            this.compatibleAttachments = compatibleAttachments;
        }
        return this.compatibleAttachments;
    }

    @Override
    public <T extends Feature> T getFeature(Class<T> featureClass) {
        return (T)((Feature)featureClass.cast(this.features.get(featureClass)));
    }

    @Override
    public long getCraftingDuration() {
        return this.craftingDuration;
    }

    public SoundEvent getFireSound() {
        return this.fireSound;
    }

    public float getFireSoundVolume() {
        return this.fireSoundVolume;
    }

    public static ItemStack getMainHeldGunItemStack(LivingEntity player) {
        ItemStack itemStack = player.m_21205_();
        return itemStack != null && itemStack.m_41720_() instanceof GunItem ? itemStack : null;
    }

    public boolean hasIdleAnimations() {
        return this.idleAnimationProvider != null;
    }

    public AnimationType getAnimationType() {
        return this.animationType;
    }

    public String getThirdPersonFallbackAnimations() {
        return this.thirdPersonFallbackAnimations;
    }

    @Override
    public Script getScript() {
        return this.script;
    }

    @Override
    public boolean hasScript() {
        return this.script != null;
    }

    public boolean m_142305_(ItemStack pStack, ItemStack pOther, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        return this.stack(pStack, pOther, pAction, pPlayer, pAccess);
    }

    public boolean m_142522_(ItemStack pStack) {
        return false;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack pStack) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        this.getContents(pStack).forEach(arg_0 -> nonnulllist.add(arg_0));
        int weight = this.getTotalWeight(pStack);
        if (this.getMaxWeight(pStack) == 0) {
            return Optional.empty();
        }
        return Optional.of(new BundleTooltip(nonnulllist, weight));
    }

    public void m_142023_(ItemEntity pItemEntity) {
        ItemUtils.m_150952_((ItemEntity)pItemEntity, (Stream)this.getContents(pItemEntity.m_32055_()));
    }

    private void playRemoveOneSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playDropContentsSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public static class Builder
    extends HurtingItem.Builder<Builder>
    implements Nameable,
    ScriptHolder {
        private static final float DEFAULT_PRICE = Float.NaN;
        private static final int DEFAULT_TRADE_LEVEL = 0;
        private static final int DEFAULT_TRADE_BUNDLE_QUANTITY = 1;
        private static final int DEFAULT_VIEW_RECOIL_DURATION = 100;
        private static final int DEFAULT_SHAKE_RECOIL_DURATION = 400;
        private static final int DEFAULT_GUN_RECOIL_DURATION = 500;
        private static final int DEFAULT_IDLE_RANDOMIZATION_DURATION = 2500;
        private static final int DEFAULT_RECOIL_RANDOMIZATION_DURATION = 250;
        private static final int DEFAULT_DRAW_COOLDOWN_DURATION = 500;
        private static final int DEFAULT_PREPARE_IDLE_COOLDOWN_DURATION = 0;
        private static final int DEFAULT_INSPECT_COOLDOWN_DURATION = 1000;
        private static final int DEFAULT_CRAFTING_DURATION = 1000;
        private static final float DEFAULT_HIT_SCAN_SPEED = 800.0f;
        private static final float DEFAULT_HIT_SCAN_ACCELERATION = 0.0f;
        private static final double DEFAULT_VIEW_RECOIL_AMPLITUDE = 1.0;
        private static final double DEFAULT_SHAKE_RECOIL_AMPLITUDE = 0.5;
        private static final int DEFAULT_VIEW_RECOIL_MAX_PITCH = 20;
        private static final double DEFAULT_SHAKE_RECOIL_SPEED = 8.0;
        private static final double DEFAULT_SHAKE_DECAY = 0.98;
        private static final double DEFAULT_GUN_RECOIL_INITIAL_AMPLITUDE = 0.3;
        private static final double DEFAULT_GUN_RECOIL_RATE_OF_AMPLITUDE_DECAY = 0.8;
        private static final double DEFAULT_GUN_RECOIL_INITIAL_ANGULAR_FREQUENCY = 1.0;
        private static final double DEFAULT_GUN_RECOIL_RATE_OF_FREQUENCY_INCREASE = 0.05;
        private static final double DEFAULT_GUN_RANDOMIZATION_AMPLITUDE = 0.01;
        private static final double DEFAULT_GUN_RECOIL_PITCH_MULTIPLIER = 1.0;
        private static final double DEFAULT_JUMP_MULTIPLIER = 1.0;
        private static final double DEFAULT_RELOAD_SHAKE_INITIAL_AMPLITUDE = 0.15;
        private static final double DEFAULT_RELOAD_SHAKE_RATE_OF_AMPLITUDE_DECAY = 0.3;
        private static final double DEFAULT_RELOAD_SHAKE_INITIAL_ANGULAR_FREQUENCY = 1.0;
        private static final double DEFAULT_RELOAD_SHAKE_RATE_OF_FREQUENCY_INCREASE = 0.01;
        private static final int DEFAULT_BURST_SHOTS = 3;
        private static final int DEFAULT_RELOAD_COOLDOWN_TIME = 1000;
        public static final double DEFAULT_AIMING_CURVE_X = 0.0;
        public static final double DEFAULT_AIMING_CURVE_Y = -0.07;
        public static final double DEFAULT_AIMING_CURVE_Z = 0.3;
        public static final double DEFAULT_AIMING_CURVE_PITCH = -0.01;
        public static final double DEFAULT_AIMING_CURVE_YAW = -0.01;
        public static final double DEFAULT_AIMING_CURVE_ROLL = -0.01;
        public static final double DEFAULT_AIMING_ZOOM = 0.05;
        public static final double DEFAULT_PELLET_SPREAD = 1.0;
        private static final double DEFAULT_INACCURACY = 0.03;
        private static final double DEFAULT_INACCURACY_AIMING = 0.0;
        private static final double DEFAULT_INACCURACY_SPRINTING = 0.1;
        private static final int DEFAULT_RPM = 600;
        private static final float DEFAULT_FIRE_SOUND_VOLUME = 5.0f;
        public static final int DEFAULT_MAX_AMMO_PER_RELOAD_ITERATION = Integer.MAX_VALUE;
        private static final String DEFAULT_RETICLE_OVERLAY = "textures/item/reticle.png";
        public static final int MAX_PELLET_SHOOTING_RANGE = 50;
        private static final float DEFAULT_BOBBING = 1.0f;
        private static final float DEFAULT_BOBBING_ON_AIM = 0.3f;
        private static final float DEFAULT_BOBBING_ROLL_MULTIPLIER = 1.0f;
        public boolean hitscan = false;
        public BulletData bulletData;
        public long adsSpeed;
        private long targetLockTimeTicks;
        private double viewRecoilAmplitude = 1.0;
        private double shakeRecoilAmplitude = 0.5;
        private int viewRecoilMaxPitch = 20;
        private long viewRecoilDuration = 100L;
        private double shakeRecoilSpeed = 8.0;
        private double shakeDecay = 0.98;
        private long shakeRecoilDuration = 400L;
        private double gunRecoilInitialAmplitude = 0.3;
        private double gunRecoilRateOfAmplitudeDecay = 0.8;
        private double gunRecoilInitialAngularFrequency = 1.0;
        private double gunRecoilRateOfFrequencyIncrease = 0.05;
        private double gunRandomizationAmplitude = 0.01;
        private double gunRecoilPitchMultiplier = 1.0;
        private long gunRecoilDuration = 500L;
        private double jumpMultiplier = 1.0;
        private int shotsPerRecoil = 1;
        private int shotsPerTrace = 1;
        private long idleRandomizationDuration = 2500L;
        private long recoilRandomizationDuration = 250L;
        private int burstShots = 3;
        private long prepareIdleCooldownDuration = 0L;
        private long prepareFireCooldownDuration = 0L;
        private long completeFireCooldownDuration = 0L;
        private long enableFireModeCooldownDuration = 0L;
        private long craftingDuration = 1000L;
        private String name;
        private float tradePrice = Float.NaN;
        private int tradeBundleQuantity = 1;
        private int tradeLevel = 0;
        private int rpm = 600;
        private long reloadCooldownTime;
        private String reloadAnimation;
        private int maxAmmoCapacity;
        private int maxAmmoPerReloadIteration = Integer.MAX_VALUE;
        private FireMode[] fireModes;
        private final Set<Supplier<AmmoItem>> compatibleAmmo = new LinkedHashSet<Supplier<AmmoItem>>();
        private Supplier<SoundEvent> fireSound;
        private float fireSoundVolume = 5.0f;
        private Supplier<SoundEvent> targetLockedSound;
        private Supplier<SoundEvent> targetStartLockingSound;
        private boolean isAimingEnabled = true;
        public boolean useAdvancedRecoil = false;
        public double verticalAmplitude = 0.0;
        public double verticalRecovery = 0.0;
        public double verticalSmoothness = 0.0;
        public double horizontalAmplitude = 0.0;
        public double horizontalRecovery = 0.0;
        public double horizontalSmoothness = 0.0;
        public double horizontalRandomness = 0.0;
        public String recoilPattern = "random";
        private double aimingCurveX = 0.0;
        private double aimingCurveY = -0.07;
        private double aimingCurveZ = 0.3;
        private double aimingCurvePitch = -0.01;
        private double aimingCurveYaw = -0.01;
        private double aimingCurveRoll = -0.01;
        private double aimingZoom = 0.05;
        private double pipScopeZoom = 0.0;
        private final List<Tuple<Long, AbstractProceduralAnimationController>> reloadEffectControllers;
        private String scopeOverlay;
        private String reticleOverlay;
        private String targetLockOverlay;
        private final List<PhasedReload> phasedReloads = new ArrayList<PhasedReload>();
        private final ConditionalAnimationProvider.Builder drawAnimationsBuilder = new ConditionalAnimationProvider.Builder();
        private final ConditionalAnimationProvider.Builder idleAnimationBuilder = new ConditionalAnimationProvider.Builder();
        private final ConditionalAnimationProvider.Builder inspectAnimationsBuilder = new ConditionalAnimationProvider.Builder();
        private final ConditionalAnimationProvider.Builder fireAnimationsBuilder = new ConditionalAnimationProvider.Builder();
        private int pelletCount = 0;
        private double pelletSpread = 1.0;
        private double inaccuracy = 0.03;
        private double inaccuracyAiming = 0.0;
        private double inaccuracySprinting = 0.1;
        private final List<GlowAnimationController.Builder> glowEffectBuilders = new ArrayList<GlowAnimationController.Builder>();
        private final List<RotationAnimationController.Builder> rotationEffectBuilders = new ArrayList<RotationAnimationController.Builder>();
        private final Map<FirePhase, List<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>>> effectBuilders = new HashMap();
        private float bobbing = 1.0f;
        private float bobbingOnAim = 0.3f;
        private float bobbingRollMultiplier = 1.0f;
        private float modelScale = 1.0f;
        private AnimationType animationType = AnimationType.RIFLE;
        private String firstPersonFallbackAnimations;
        private String thirdPersonFallbackAnimations;
        private final List<Supplier<Attachment>> compatibleAttachments = new ArrayList<Supplier<Attachment>>();
        private final List<String> compatibleAttachmentGroups = new ArrayList<String>();
        private final List<FeatureBuilder<?, ?>> featureBuilders = new ArrayList();
        private final List<Supplier<Attachment>> defaultAttachments = new ArrayList<Supplier<Attachment>>();
        @javax.annotation.Nullable
        private Script mainScript;

        public Builder(ExtensionRegistry.Extension extension) {
            this.reloadEffectControllers = new ArrayList<Tuple<Long, AbstractProceduralAnimationController>>();
            this.extension = extension;
        }

        public Builder withAdvancedRecoil(double verticalAmplitude, double verticalRecovery, double verticalSmoothness, double horizontalAmplitude, double horizontalRecovery, double horizontalSmoothness, double horizontalRandomness, String pattern) {
            this.useAdvancedRecoil = true;
            this.verticalAmplitude = verticalAmplitude;
            this.verticalRecovery = verticalRecovery;
            this.verticalSmoothness = verticalSmoothness;
            this.horizontalAmplitude = horizontalAmplitude;
            this.horizontalRecovery = horizontalRecovery;
            this.horizontalSmoothness = horizontalSmoothness;
            this.horizontalRandomness = horizontalRandomness;
            this.recoilPattern = pattern;
            return this;
        }

        public Builder() {
            this(new ExtensionRegistry.Extension("pointblank", Path.of("pointblank", new String[0]), "pointblank"));
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withHitscan(boolean hitscan) {
            this.hitscan = hitscan;
            return this;
        }

        public Builder withAdsSpeed(long adsSpeed) {
            this.adsSpeed = adsSpeed;
            return this;
        }

        public Builder withAnimationType(AnimationType animationType) {
            this.animationType = animationType;
            return this;
        }

        public Builder withFirstPersonFallbackAnimations(String firstPersonFallbackAnimations) {
            this.firstPersonFallbackAnimations = firstPersonFallbackAnimations;
            return this;
        }

        public Builder withThirdPersonFallbackAnimations(String thirdPersonFallbackAnimations) {
            this.thirdPersonFallbackAnimations = thirdPersonFallbackAnimations;
            return this;
        }

        @SafeVarargs
        public final Builder withDefaultAttachment(Supplier<? extends Attachment> ... attachmentSuppliers) {
            for (Supplier<? extends Attachment> s : attachmentSuppliers) {
                Objects.requireNonNull(s);
                this.defaultAttachments.add(s::get);
            }
            return this;
        }

        @SafeVarargs
        public final Builder withCompatibleAttachment(Supplier<? extends Attachment> ... attachmentSuppliers) {
            for (Supplier<? extends Attachment> s : attachmentSuppliers) {
                Objects.requireNonNull(s);
                this.compatibleAttachments.add(s::get);
            }
            return this;
        }

        public Builder withCompatibleAttachmentGroup(String ... groups) {
            this.compatibleAttachmentGroups.addAll(Set.of(groups));
            return this;
        }

        public Builder withFeature(FeatureBuilder<?, ?> featureBuilder) {
            this.featureBuilders.add(featureBuilder);
            return this;
        }

        public Builder withModelScale(double modelScale) {
            this.modelScale = Mth.m_14036_((float)((float)modelScale), (float)0.1f, (float)1.0f);
            return this;
        }

        public Builder withTradePrice(float price, int tradeBundleQuantity, int tradeLevel) {
            this.tradePrice = price;
            this.tradeLevel = tradeLevel;
            this.tradeBundleQuantity = tradeBundleQuantity;
            return this;
        }

        public Builder withTradePrice(float price, int tradeLevel) {
            return this.withTradePrice(price, 1, tradeLevel);
        }

        public Builder withMaxAmmoCapacity(int maxAmmoCapacity) {
            this.maxAmmoCapacity = maxAmmoCapacity;
            return this;
        }

        public Builder withMaxAmmoPerReloadIteration(int maxAmmoPerReloadIteration) {
            this.maxAmmoPerReloadIteration = maxAmmoPerReloadIteration;
            return this;
        }

        public Builder withRpm(int rpm) {
            this.rpm = rpm;
            return this;
        }

        public Builder withReloadAnimation(String reloadAnimation) {
            this.reloadAnimation = reloadAnimation;
            return this;
        }

        public Builder withReloadCooldownDuration(long reloadCooldownTime, TimeUnit timeUnit) {
            this.reloadCooldownTime = timeUnit.toMillis(reloadCooldownTime);
            return this;
        }

        public Builder withFireModes(FireMode ... fireModes) {
            this.fireModes = fireModes;
            return this;
        }

        public Builder withCraftingDuration(int duration, TimeUnit timeUnit) {
            this.craftingDuration = timeUnit.toMillis(duration);
            return this;
        }

        @SafeVarargs
        public final Builder withCompatibleAmmo(Supplier<AmmoItem> ... ammo) {
            Collections.addAll(this.compatibleAmmo, ammo);
            return this;
        }

        public final Builder withCompatibleAmmo(List<Supplier<AmmoItem>> ammo) {
            this.compatibleAmmo.addAll(ammo);
            return this;
        }

        public final Builder withTargetLock(int minTargetLockTime, TimeUnit timeUnit) {
            this.targetLockTimeTicks = timeUnit.toTicks(minTargetLockTime);
            return this;
        }

        public Builder withViewRecoilAmplitude(double amplitude) {
            this.viewRecoilAmplitude = amplitude;
            return this;
        }

        public Builder withShakeRecoilAmplitude(double amplitude) {
            this.shakeRecoilAmplitude = amplitude;
            return this;
        }

        public Builder withViewRecoilMaxPitch(int pitch) {
            this.viewRecoilMaxPitch = pitch;
            return this;
        }

        public Builder withViewRecoilDuration(int duration, TimeUnit timeUnit) {
            this.viewRecoilDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withShakeRecoilSpeed(double speed) {
            this.shakeRecoilSpeed = speed;
            return this;
        }

        public Builder withShakeDecay(double shakeDecay) {
            this.shakeDecay = shakeDecay;
            return this;
        }

        public Builder withShakeRecoilDuration(int duration, TimeUnit timeUnit) {
            this.shakeRecoilDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withGunRecoilInitialAmplitude(double amplitude) {
            this.gunRecoilInitialAmplitude = amplitude;
            return this;
        }

        public Builder withGunRecoilRateOfAmplitudeDecay(double decayRate) {
            this.gunRecoilRateOfAmplitudeDecay = decayRate;
            return this;
        }

        public Builder withGunRecoilInitialAngularFrequency(double frequency) {
            this.gunRecoilInitialAngularFrequency = frequency;
            return this;
        }

        public Builder withGunRecoilRateOfFrequencyIncrease(double rate) {
            this.gunRecoilRateOfFrequencyIncrease = rate;
            return this;
        }

        public Builder withGunRecoilPitchMultiplier(double gunRecoilPitchMultiplier) {
            this.gunRecoilPitchMultiplier = gunRecoilPitchMultiplier;
            return this;
        }

        public Builder withGunRecoilDuration(int duration, TimeUnit timeUnit) {
            this.gunRecoilDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withJumpMultiplier(double jumpMultiplier) {
            this.jumpMultiplier = jumpMultiplier;
            return this;
        }

        public Builder withShotsPerRecoil(int shotsPerRecoil) {
            this.shotsPerRecoil = shotsPerRecoil;
            return this;
        }

        public Builder withShotsPerTrace(int shotsPerTrace) {
            this.shotsPerTrace = shotsPerTrace;
            return this;
        }

        public Builder withIdleRandomizationDuration(int duration, TimeUnit timeUnit) {
            this.idleRandomizationDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withRecoilRandomizationDuration(int duration, TimeUnit timeUnit) {
            this.recoilRandomizationDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withFireSound(Supplier<SoundEvent> fireSound) {
            this.fireSound = fireSound;
            return this;
        }

        public Builder withFireSound(Supplier<SoundEvent> fireSound, float fireSoundVolume) {
            this.fireSound = fireSound;
            this.fireSoundVolume = fireSoundVolume;
            return this;
        }

        public Builder withFireSound(SoundEvent fireSound) {
            this.fireSound = () -> fireSound;
            return this;
        }

        public Builder withFireSound(SoundEvent fireSound, float fireSoundVolume) {
            this.fireSound = () -> fireSound;
            this.fireSoundVolume = fireSoundVolume;
            return this;
        }

        public Builder withReloadSound(Supplier<SoundEvent> reloadSound) {
            return this;
        }

        public Builder withReloadSound(SoundEvent reloadSound) {
            return this;
        }

        public Builder withReloadShakeEffect(long startTime, long duration, TimeUnit timeUnit, double initialAmplitude, double rateOfAmplitudeDecay, double initialAngularFrequency, double rateOfFrequencyIncrease) {
            this.reloadEffectControllers.add((Tuple<Long, AbstractProceduralAnimationController>)new Tuple((Object)timeUnit.toMillis(startTime), (Object)new ViewShakeAnimationController2(initialAmplitude, rateOfAmplitudeDecay, initialAngularFrequency, rateOfFrequencyIncrease, duration)));
            return this;
        }

        public Builder withAimingEnabled(boolean aimingEnabled) {
            this.isAimingEnabled = aimingEnabled;
            return this;
        }

        public Builder withAimingCurveX(double aimingCurveX) {
            this.aimingCurveX = aimingCurveX;
            return this;
        }

        public Builder withAimingCurveY(double aimingCurveY) {
            this.aimingCurveY = aimingCurveY;
            return this;
        }

        public Builder withAimingCurveZ(double aimingCurveZ) {
            this.aimingCurveZ = aimingCurveZ;
            return this;
        }

        public Builder withAimingCurvePitch(double aimingCurvePitch) {
            this.aimingCurvePitch = aimingCurvePitch;
            return this;
        }

        public Builder withAimingCurveYaw(double aimingCurveYaw) {
            this.aimingCurveYaw = aimingCurveYaw;
            return this;
        }

        public Builder withAimingCurveRoll(double aimingCurveRoll) {
            this.aimingCurveRoll = aimingCurveRoll;
            return this;
        }

        public Builder withAimingZoom(double aimingZoom) {
            this.aimingZoom = aimingZoom;
            return this;
        }

        public Builder withPipScopeZoom(double pipScopeZoom) {
            this.pipScopeZoom = pipScopeZoom;
            return this;
        }

        public Builder withScopeOverlay(String scopeOverlay) {
            this.scopeOverlay = scopeOverlay;
            return this;
        }

        public Builder withReticleOverlay(String reticleOverlay) {
            this.reticleOverlay = reticleOverlay;
            return this;
        }

        public Builder withTargetLockOverlay(String targetLockOverlay) {
            this.targetLockOverlay = targetLockOverlay;
            return this;
        }

        public Builder withTargetLockedSound(Supplier<SoundEvent> targetLockedSound) {
            this.targetLockedSound = targetLockedSound;
            return this;
        }

        public Builder withTargetLockedSound(SoundEvent targetLockedSound) {
            this.targetLockedSound = () -> targetLockedSound;
            return this;
        }

        public Builder withTargetStartLockingSound(Supplier<SoundEvent> targetStartLockingSound) {
            this.targetStartLockingSound = targetStartLockingSound;
            return this;
        }

        public Builder withTargetStartLockingSound(SoundEvent targetStartLockingSound) {
            this.targetStartLockingSound = () -> targetStartLockingSound;
            return this;
        }

        public Builder withReticleOverlay() {
            this.reticleOverlay = "textures/item/reticle.png";
            return this;
        }

        public Builder withPrepareFireCooldownDuration(int duration, TimeUnit timeUnit) {
            this.prepareFireCooldownDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withCompleteFireCooldownDuration(int duration, TimeUnit timeUnit) {
            this.completeFireCooldownDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withEnableFireModeCooldownDuration(int duration, TimeUnit timeUnit) {
            this.enableFireModeCooldownDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withPrepareIdleCooldownDuration(int duration, TimeUnit timeUnit) {
            this.prepareIdleCooldownDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withDrawCooldownDuration(int duration, TimeUnit timeUnit) {
            this.withDrawAnimation(GunItem.DEFAULT_ANIMATION_DRAW, ctx -> true, duration, timeUnit);
            return this;
        }

        public Builder withDrawAnimation(String animationName, Predicate<ConditionContext> predicate, int duration, TimeUnit timeUnit) {
            this.drawAnimationsBuilder.withAnimation(animationName, predicate, duration, timeUnit);
            return this;
        }

        public Builder withInspectCooldownDuration(int duration, TimeUnit timeUnit) {
            this.withInspectAnimation(GunItem.DEFAULT_ANIMATION_INSPECT, ctx -> true, duration, timeUnit);
            return this;
        }

        public Builder withInspectAnimation(String animationName, Predicate<ConditionContext> predicate, int duration, TimeUnit timeUnit) {
            this.inspectAnimationsBuilder.withAnimation(animationName, predicate, duration, timeUnit);
            return this;
        }

        public Builder withIdleAnimation(String animationName, Predicate<ConditionContext> predicate, int duration, TimeUnit timeUnit) {
            this.idleAnimationBuilder.withAnimation(animationName, predicate, duration, timeUnit);
            return this;
        }

        public Builder withFireAnimation(String animationName, Predicate<ConditionContext> predicate, int duration, TimeUnit timeUnit) {
            this.fireAnimationsBuilder.withAnimation(animationName, predicate, duration, timeUnit);
            return this;
        }

        public Builder withPhasedReload(PhasedReload phasedReload) {
            this.phasedReloads.add(phasedReload);
            return this;
        }

        public Builder withPhasedReload(ReloadPhase phase, long cooldownTime, String animationName) {
            this.phasedReloads.add(new PhasedReload(phase, cooldownTime, animationName));
            return this;
        }

        public Builder withPhasedReload(ReloadPhase phase, long cooldownTime, ReloadAnimation reloadAnimation) {
            this.phasedReloads.add(new PhasedReload(phase, cooldownTime, reloadAnimation));
            return this;
        }

        public Builder withPhasedReload(ReloadPhase phase, TriPredicate<LivingEntity, GunClientState, ItemStack> predicate, long cooldownTime, ReloadAnimation reloadAnimation) {
            this.phasedReloads.add(new PhasedReload(phase, predicate, cooldownTime, reloadAnimation));
            return this;
        }

        public Builder withPhasedReload(ReloadPhase phase, Predicate<ConditionContext> predicate, long cooldownTime, ReloadAnimation reloadAnimation) {
            this.phasedReloads.add(new PhasedReload(phase, predicate, cooldownTime, TimeUnit.MILLISECOND, reloadAnimation));
            return this;
        }

        public Builder withPelletCount(int pelletCount) {
            this.pelletCount = pelletCount;
            return this;
        }

        public Builder withPelletSpread(double pelletSpread) {
            this.pelletSpread = pelletSpread;
            return this;
        }

        public Builder withGunRandomizationAmplitude(double gunRandomizationAmplitude) {
            this.gunRandomizationAmplitude = gunRandomizationAmplitude;
            return this;
        }

        public Builder withBurstShots(int burstShots) {
            this.burstShots = burstShots;
            return this;
        }

        public Builder withInaccuracy(double inaccuracy) {
            this.inaccuracy = inaccuracy;
            return this;
        }

        public Builder withInaccuracyAiming(double inaccuracyAiming) {
            this.inaccuracyAiming = inaccuracyAiming;
            return this;
        }

        public Builder withInaccuracySprinting(double inaccuracySprinting) {
            this.inaccuracySprinting = inaccuracySprinting;
            return this;
        }

        public Builder withGlow(String glowingPartName) {
            return this.withGlow(glowingPartName, null);
        }

        public Builder withGlow(String glowingPartName, String textureName) {
            return this.withGlow(Collections.singleton(FirePhase.ANY), Collections.singleton(glowingPartName), textureName);
        }

        public Builder withGlow(Collection<FirePhase> firePhases, String glowingPartName) {
            return this.withGlow(firePhases, Collections.singleton(glowingPartName), null);
        }

        public Builder withGlow(Collection<FirePhase> firePhases, Collection<String> glowingPartNames, String texture) {
            GlowAnimationController.Builder builder = new GlowAnimationController.Builder().withFirePhases(firePhases);
            if (texture != null) {
                builder.withTexture(ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)texture));
            }
            builder.withGlowingPartNames(glowingPartNames);
            this.glowEffectBuilders.add(builder);
            return this;
        }

        public Builder withGlow(Collection<FirePhase> firePhases, String glowingPartName, String texture, AbstractEffect.SpriteAnimationType spriteAnimationType, int spriteRows, int spriteColumns, int spritesPerSecond, Direction ... directions) {
            GlowAnimationController.Builder builder = new GlowAnimationController.Builder().withFirePhases(firePhases);
            if (texture != null) {
                builder.withTexture(ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)texture));
            }
            builder.withGlowingPartNames(Collections.singleton(glowingPartName));
            builder.withSprites(spriteRows, spriteColumns, spritesPerSecond, spriteAnimationType);
            builder.withDirections(directions);
            this.glowEffectBuilders.add(builder);
            return this;
        }

        public Builder withRotation(String phase, String modelPart, double rpm, double acceleration, double deceleration) {
            RotationAnimationController.Builder builder = new RotationAnimationController.Builder().withPhase(phase).withModelPart(modelPart).withAccelerationRate(acceleration).withDecelerationRate(deceleration).withRotationsPerMinute(rpm);
            this.rotationEffectBuilders.add(builder);
            return this;
        }

        public Builder withRotation(RotationAnimationController.PhaseMapper phaseMapper, String modelPart, double rpm, double acceleration, double deceleration) {
            RotationAnimationController.Builder builder = new RotationAnimationController.Builder().withPhaseMapper(phaseMapper).withModelPart(modelPart).withAccelerationRate(acceleration).withDecelerationRate(deceleration).withRotationsPerMinute(rpm);
            this.rotationEffectBuilders.add(builder);
            return this;
        }

        public Builder withEffect(FirePhase firePhase, Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>> effectBuilder) {
            List builders = this.effectBuilders.computeIfAbsent(firePhase, k -> new ArrayList());
            builders.add(effectBuilder);
            return this;
        }

        public Builder withBulletData(BulletData bulletData) {
            this.bulletData = bulletData;
            return this;
        }

        public Builder withBobbing(double bobbing) {
            this.bobbing = Mth.m_14036_((float)((float)bobbing), (float)0.0f, (float)2.0f);
            return this;
        }

        public Builder withBobbingOnAim(double bobbingOnAim) {
            this.bobbingOnAim = Mth.m_14036_((float)((float)bobbingOnAim), (float)0.0f, (float)2.0f);
            return this;
        }

        public Builder withBobbingRollMultiplier(double bobbingRollMultiplier) {
            this.bobbingRollMultiplier = Mth.m_14036_((float)((float)bobbingRollMultiplier), (float)0.0f, (float)10.0f);
            return this;
        }

        public Builder withScript(Script script) {
            this.mainScript = script;
            return this;
        }

        @Override
        public GunItem build() {
            return this.build("pointblank");
        }

        public GunItem build(String namespace) {
            return new GunItem(this, namespace);
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            Predicate<ConditionContext> condition;
            JsonElement reloadSoundElem;
            JsonElement reloadAnimationElem;
            JsonElement targetStartLockingSoundElem;
            super.withJsonObject(obj);
            Builder builder = this;
            this.withScript(JsonUtil.getJsonScript(obj));
            this.withAdsSpeed(JsonUtil.getJsonInt(obj, "adsSpeed", 400));
            this.withName(obj.getAsJsonPrimitive("name").getAsString());
            this.withAnimationType((AnimationType)JsonUtil.getEnum(obj, "animationType", AnimationType.class, AnimationType.RIFLE, true));
            this.withFirstPersonFallbackAnimations(JsonUtil.getJsonString(obj, "firstPersonFallbackAnimations", null));
            this.withThirdPersonFallbackAnimations(JsonUtil.getJsonString(obj, "thirdPersonFallbackAnimations", null));
            this.withModelScale(JsonUtil.getJsonFloat(obj, "modelScale", 1.0f));
            this.withTradePrice(JsonUtil.getJsonFloat(obj, "tradePrice", Float.NaN), JsonUtil.getJsonInt(obj, "traceBundleQuantity", 1), JsonUtil.getJsonInt(obj, "tradeLevel", 0));
            JsonPrimitive jsonMaxAmmoCapacity = obj.getAsJsonPrimitive("maxAmmoCapacity");
            if (jsonMaxAmmoCapacity.isString() && "infinite".equalsIgnoreCase(jsonMaxAmmoCapacity.getAsString())) {
                this.withMaxAmmoCapacity(Integer.MAX_VALUE);
            } else {
                this.withMaxAmmoCapacity(obj.getAsJsonPrimitive("maxAmmoCapacity").getAsInt());
            }
            this.withCraftingDuration(JsonUtil.getJsonInt(obj, "craftingDuration", 1000), TimeUnit.MILLISECOND);
            this.withMaxAmmoPerReloadIteration(JsonUtil.getJsonInt(obj, "maxAmmoPerReloadIteration", Integer.MAX_VALUE));
            this.withAimingEnabled(JsonUtil.getJsonBoolean(obj, "aimingEnabled", true));
            this.withHitscan(JsonUtil.getJsonBoolean(obj, "hitscan", false));
            this.withTargetLock(JsonUtil.getJsonInt(obj, "minTargetLockTime", 0), TimeUnit.MILLISECOND);
            this.withRpm(JsonUtil.getJsonInt(obj, "rpm", 600));
            this.withPrepareIdleCooldownDuration(JsonUtil.getJsonInt(obj, "prepareIdleCooldownDuration", 0), TimeUnit.MILLISECOND);
            this.withViewRecoilMaxPitch(JsonUtil.getJsonInt(obj, "viewRecoilMaxPitch", 20));
            this.withViewRecoilDuration(JsonUtil.getJsonInt(obj, "viewRecoilDuration", 100), TimeUnit.MILLISECOND);
            this.withShakeRecoilDuration(JsonUtil.getJsonInt(obj, "shakeRecoilDuration", 400), TimeUnit.MILLISECOND);
            this.withGunRecoilDuration(JsonUtil.getJsonInt(obj, "gunRecoilDuration", 500), TimeUnit.MILLISECOND);
            this.withIdleRandomizationDuration(JsonUtil.getJsonInt(obj, "idleRandomizationDuration", 2500), TimeUnit.MILLISECOND);
            this.withRecoilRandomizationDuration(JsonUtil.getJsonInt(obj, "recoilRandomizationDuration", 250), TimeUnit.MILLISECOND);
            this.withBurstShots(JsonUtil.getJsonInt(obj, "burstShots", 3));
            this.withReloadCooldownDuration(JsonUtil.getJsonInt(obj, "reloadCooldownTime", 1000), TimeUnit.MILLISECOND);
            this.withPelletCount(JsonUtil.getJsonInt(obj, "pelletCount", 0));
            this.withPrepareFireCooldownDuration(JsonUtil.getJsonInt(obj, "prepareFireCooldownDuration", 0), TimeUnit.MILLISECOND);
            this.withCompleteFireCooldownDuration(JsonUtil.getJsonInt(obj, "completeFireCooldownDuration", 0), TimeUnit.MILLISECOND);
            this.withEnableFireModeCooldownDuration(JsonUtil.getJsonInt(obj, "enableFireModeCooldownDuration", 0), TimeUnit.MILLISECOND);
            this.withViewRecoilAmplitude(JsonUtil.getJsonDouble(obj, "viewRecoilAmplitude", 1.0));
            this.withShakeRecoilAmplitude(JsonUtil.getJsonDouble(obj, "shakeRecoilAmplitude", 0.5));
            this.withShakeRecoilSpeed(JsonUtil.getJsonDouble(obj, "shakeRecoilSpeed", 8.0));
            this.withShakeDecay(JsonUtil.getJsonDouble(obj, "shakeDecay", 0.98));
            this.withGunRecoilInitialAmplitude(JsonUtil.getJsonDouble(obj, "gunRecoilInitialAmplitude", 0.3));
            this.withGunRecoilRateOfAmplitudeDecay(JsonUtil.getJsonDouble(obj, "gunRecoilRateOfAmplitudeDecay", 0.8));
            this.withGunRecoilInitialAngularFrequency(JsonUtil.getJsonDouble(obj, "gunRecoilInitialAngularFrequency", 1.0));
            this.withGunRecoilRateOfFrequencyIncrease(JsonUtil.getJsonDouble(obj, "gunRecoilRateOfFrequencyIncrease", 0.05));
            this.withGunRecoilPitchMultiplier(JsonUtil.getJsonDouble(obj, "gunRecoilPitchMultiplier", 1.0));
            this.withGunRandomizationAmplitude(JsonUtil.getJsonDouble(obj, "gunRandomizationAmplitude", 0.01));
            this.withAimingCurveX(JsonUtil.getJsonDouble(obj, "aimingCurveX", 0.0));
            this.withAimingCurveY(JsonUtil.getJsonDouble(obj, "aimingCurveY", -0.07));
            this.withAimingCurveZ(JsonUtil.getJsonDouble(obj, "aimingCurveZ", 0.3));
            this.withAimingCurvePitch(JsonUtil.getJsonDouble(obj, "aimingCurvePitch", -0.01));
            this.withAimingCurveYaw(JsonUtil.getJsonDouble(obj, "aimingCurveYaw", -0.01));
            this.withAimingCurveRoll(JsonUtil.getJsonDouble(obj, "aimingCurveRoll", -0.01));
            this.withAimingZoom(JsonUtil.getJsonDouble(obj, "aimingZoom", 0.05));
            this.withPipScopeZoom(JsonUtil.getJsonDouble(obj, "pipScopeZoom", 0.0));
            this.withShotsPerRecoil(JsonUtil.getJsonInt(obj, "shotsPerRecoil", 1));
            this.withShotsPerTrace(JsonUtil.getJsonInt(obj, "shotsPerTrace", 1));
            this.withPelletSpread(JsonUtil.getJsonDouble(obj, "pelletSpread", 1.0));
            this.withInaccuracy(JsonUtil.getJsonDouble(obj, "inaccuracy", 0.03));
            this.withInaccuracyAiming(JsonUtil.getJsonDouble(obj, "inaccuracyAiming", 0.0));
            this.withInaccuracySprinting(JsonUtil.getJsonDouble(obj, "inaccuracySprinting", 0.1));
            this.withJumpMultiplier(JsonUtil.getJsonDouble(obj, "jumpMultiplier", 1.0));
            this.withScopeOverlay(obj.has("scopeOverlay") ? obj.getAsJsonPrimitive("scopeOverlay").getAsString() : null);
            this.withReticleOverlay(obj.has("reticleOverlay") ? obj.getAsJsonPrimitive("reticleOverlay").getAsString() : null);
            this.withTargetLockOverlay(obj.has("targetLockOverlay") ? obj.getAsJsonPrimitive("targetLockOverlay").getAsString() : null);
            JsonElement targetLockedSoundElem = obj.get("targetLockedSound");
            if (targetLockedSoundElem != null && !targetLockedSoundElem.isJsonNull()) {
                String targetLockedSoundName = targetLockedSoundElem.getAsString();
                this.withTargetLockedSound(() -> SoundRegistry.getSoundEvent(targetLockedSoundName));
            }
            if (obj.has("advancedRecoil")) {
                JsonObject advancedRecoil = obj.getAsJsonObject("advancedRecoil");
                builder.useAdvancedRecoil = true;
                if (advancedRecoil.has("vertical")) {
                    JsonObject vertical = advancedRecoil.getAsJsonObject("vertical");
                    builder.verticalAmplitude = Builder.getDoubleOrDefault(vertical, "amplitude", 0.0);
                    builder.verticalRecovery = Builder.getDoubleOrDefault(vertical, "recovery", 0.0);
                    builder.verticalSmoothness = Builder.getDoubleOrDefault(vertical, "smoothness", 0.0);
                }
                if (advancedRecoil.has("horizontal")) {
                    JsonObject horizontal = advancedRecoil.getAsJsonObject("horizontal");
                    builder.horizontalAmplitude = Builder.getDoubleOrDefault(horizontal, "amplitude", 0.0);
                    builder.horizontalRecovery = Builder.getDoubleOrDefault(horizontal, "recovery", 0.0);
                    builder.horizontalSmoothness = Builder.getDoubleOrDefault(horizontal, "smoothness", 0.0);
                    builder.horizontalRandomness = Builder.getDoubleOrDefault(horizontal, "randomness", 0.0);
                }
                if (advancedRecoil.has("pattern")) {
                    builder.recoilPattern = advancedRecoil.get("pattern").getAsString();
                }
            }
            if ((targetStartLockingSoundElem = obj.get("targetStartLockingSound")) != null && !targetStartLockingSoundElem.isJsonNull()) {
                String targetStargetLockingdSoundName = targetStartLockingSoundElem.getAsString();
                this.withTargetStartLockingSound(() -> SoundRegistry.getSoundEvent(targetStargetLockingdSoundName));
            }
            List<String> fireModeNames = JsonUtil.getStrings(obj, "fireModes");
            this.withFireModes((FireMode[])fireModeNames.stream().map(n -> FireMode.valueOf(n.toUpperCase(Locale.ROOT))).toArray(FireMode[]::new));
            this.withBulletData(BulletData.fromJson(obj));
            for (JsonObject jsonObject : JsonUtil.getJsonObjects(obj, "reloadShakeEffects")) {
                builder.withReloadShakeEffect(jsonObject.getAsJsonPrimitive("start").getAsInt(), jsonObject.getAsJsonPrimitive("duration").getAsInt(), TimeUnit.MILLISECOND, JsonUtil.getJsonDouble(jsonObject, "initialAmplitude", 0.15), JsonUtil.getJsonDouble(jsonObject, "rateOfAmplitudeDecay", 0.3), JsonUtil.getJsonDouble(jsonObject, "initialAngularFrequency", 1.0), JsonUtil.getJsonDouble(jsonObject, "rateOfFrequencyIncrease", 0.01));
            }
            if (this.hasFunction("overridePhasedReloads")) {
                List reloads = (List)this.invokeFunction("overridePhasedReloads", obj);
                Iterator iterator = reloads.iterator();
                while (iterator.hasNext()) {
                    PhasedReload reload = (PhasedReload)iterator.next();
                    builder.withPhasedReload(reload);
                }
            } else {
                for (JsonObject jsonObject : JsonUtil.getJsonObjects(obj, "phasedReloads")) {
                    ArrayList<ReloadShakeEffect> shakeEffects = new ArrayList<ReloadShakeEffect>();
                    for (JsonObject jsReloadShakeEffect : JsonUtil.getJsonObjects(jsonObject, "shakeEffects")) {
                        shakeEffects.add(new ReloadShakeEffect(jsReloadShakeEffect.getAsJsonPrimitive("start").getAsLong(), jsReloadShakeEffect.getAsJsonPrimitive("duration").getAsLong(), TimeUnit.MILLISECOND, JsonUtil.getJsonDouble(jsReloadShakeEffect, "initialAmplitude", 0.15), JsonUtil.getJsonDouble(jsReloadShakeEffect, "rateOfAmplitudeDecay", 0.3), JsonUtil.getJsonDouble(jsReloadShakeEffect, "initialAngularFrequency", 1.0), JsonUtil.getJsonDouble(jsReloadShakeEffect, "rateOfFrequencyIncrease", 0.01)));
                    }
                    Predicate<ConditionContext> condition2 = jsonObject.has("condition") ? Conditions.fromJson(jsonObject.get("condition")) : ctx -> true;
                    builder.withPhasedReload(new PhasedReload(ReloadPhase.valueOf(jsonObject.getAsJsonPrimitive("phase").getAsString()), condition2, jsonObject.getAsJsonPrimitive("duration").getAsInt(), TimeUnit.MILLISECOND, new ReloadAnimation(jsonObject.getAsJsonPrimitive("animation").getAsString(), shakeEffects)));
                }
            }
            String string = (reloadAnimationElem = obj.get("reloadAnimation")) != null ? reloadAnimationElem.getAsString() : null;
            builder.withReloadAnimation(string);
            float fireSoundVolume = JsonUtil.getJsonFloat(obj, "fireSoundVolume", 5.0f);
            JsonElement fireSoundElem = obj.get("fireSound");
            if (fireSoundElem != null && !fireSoundElem.isJsonNull()) {
                String fireSoundName = fireSoundElem.getAsString();
                builder.withFireSound(() -> SoundRegistry.getSoundEvent(fireSoundName), fireSoundVolume);
            }
            if ((reloadSoundElem = obj.get("reloadSound")) != null && !reloadSoundElem.isJsonNull()) {
                String reloadSoundName = reloadSoundElem.getAsString();
                builder.withReloadSound(() -> SoundRegistry.getSoundEvent(reloadSoundName));
            }
            List<String> compatibleAmmoNames = JsonUtil.getStrings(obj, "compatibleAmmo");
            ArrayList<Supplier<AmmoItem>> compatibleAmmo = new ArrayList<Supplier<AmmoItem>>();
            for (String string2 : compatibleAmmoNames) {
                Supplier supplier = ItemRegistry.ITEMS.getDeferredRegisteredObject(string2);
                if (supplier == null) continue;
                compatibleAmmo.add(supplier);
            }
            builder.withCompatibleAmmo(compatibleAmmo);
            for (JsonObject jsonObject : JsonUtil.getJsonObjects(obj, "rotations")) {
                builder.withRotation(JsonUtil.getJsonString(jsonObject, "phase", "fire"), JsonUtil.getJsonString(jsonObject, "modelPart", null), JsonUtil.getJsonDouble(jsonObject, "rpm", 180.0), JsonUtil.getJsonDouble(jsonObject, "acceleration", 1.0), JsonUtil.getJsonDouble(jsonObject, "deceleration", 5.0));
            }
            for (JsonObject jsonObject : JsonUtil.getJsonObjects(obj, "effects")) {
                FirePhase firePhase = (FirePhase)JsonUtil.getEnum(jsonObject, "phase", FirePhase.class, null, true);
                String effectName = JsonUtil.getJsonString(jsonObject, "name");
                Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>> supplier = () -> EffectRegistry.getEffectBuilderSupplier(effectName).get();
                builder.withEffect(firePhase, supplier);
            }
            builder.withBobbing(JsonUtil.getJsonDouble(obj, "bobbing", 1.0));
            builder.withBobbingOnAim(JsonUtil.getJsonFloat(obj, "bobbingOnAim", 0.3f));
            builder.withBobbingRollMultiplier(JsonUtil.getJsonDouble(obj, "bobbingRollMultiplier", 1.0));
            for (JsonObject jsonObject : JsonUtil.getJsonObjects(obj, "glowingParts")) {
                String string3 = JsonUtil.getJsonString(jsonObject, "name");
                List<String> firePhaseNames = JsonUtil.getStrings(obj, "phases");
                List<FirePhase> firePhases = firePhaseNames.stream().map(n -> FirePhase.valueOf(n.toUpperCase(Locale.ROOT))).toList();
                if (firePhases.isEmpty()) {
                    firePhases = Collections.singletonList(FirePhase.ANY);
                }
                String textureName = JsonUtil.getJsonString(jsonObject, "texture", null);
                Direction direction = (Direction)JsonUtil.getEnum(jsonObject, "direction", Direction.class, null, true);
                JsonObject spritesObj = jsonObject.getAsJsonObject("sprites");
                if (spritesObj != null) {
                    int rows = JsonUtil.getJsonInt(spritesObj, "rows", 1);
                    int columns = JsonUtil.getJsonInt(spritesObj, "columns", 1);
                    int fps = JsonUtil.getJsonInt(spritesObj, "fps", 60);
                    AbstractEffect.SpriteAnimationType spriteAnimationType = (AbstractEffect.SpriteAnimationType)JsonUtil.getEnum(spritesObj, "type", AbstractEffect.SpriteAnimationType.class, AbstractEffect.SpriteAnimationType.LOOP, true);
                    if (direction != null) {
                        builder.withGlow(firePhases, string3, textureName, spriteAnimationType, rows, columns, fps, direction);
                        continue;
                    }
                    builder.withGlow(firePhases, string3, textureName, spriteAnimationType, rows, columns, fps, new Direction[0]);
                    continue;
                }
                builder.withGlow(firePhases, Collections.singletonList(string3), textureName);
            }
            for (String string4 : JsonUtil.getStrings(obj, "compatibleAttachments")) {
                Supplier supplier = ItemRegistry.ITEMS.getDeferredRegisteredObject(string4);
                if (supplier == null) continue;
                this.withCompatibleAttachment(() -> (Attachment)ri.get());
            }
            List<String> compatibleAttachmentGroups = JsonUtil.getStrings(obj, "compatibleAttachmentGroups");
            this.compatibleAttachmentGroups.addAll(compatibleAttachmentGroups);
            for (JsonObject jsonObject : JsonUtil.getJsonObjects(obj, "features")) {
                FeatureBuilder<?, ?> featureBuilder = Features.fromJson(jsonObject);
                this.withFeature(featureBuilder);
            }
            for (String string5 : JsonUtil.getStrings(obj, "defaultAttachments")) {
                Supplier ri2 = ItemRegistry.ITEMS.getDeferredRegisteredObject(string5);
                if (ri2 == null) continue;
                this.withDefaultAttachment(() -> (Attachment)ri2.get());
            }
            for (JsonObject jsonObject : JsonUtil.getJsonObjects(obj, "idleAnimations")) {
                Predicate<ConditionContext> condition3 = jsonObject.has("condition") ? Conditions.fromJson(jsonObject.get("condition")) : ctx -> true;
                builder.withIdleAnimation(JsonUtil.getJsonString(jsonObject, "name", GunItem.DEFAULT_ANIMATION_IDLE), condition3, jsonObject.getAsJsonPrimitive("duration").getAsInt(), TimeUnit.MILLISECOND);
            }
            List<JsonObject> list = JsonUtil.getJsonObjects(obj, "inspectAnimations");
            for (JsonObject jsInspect : list) {
                Predicate<ConditionContext> condition4 = jsInspect.has("condition") ? Conditions.fromJson(jsInspect.get("condition")) : ctx -> true;
                builder.withInspectAnimation(JsonUtil.getJsonString(jsInspect, "name", GunItem.DEFAULT_ANIMATION_INSPECT), condition4, jsInspect.getAsJsonPrimitive("duration").getAsInt(), TimeUnit.MILLISECOND);
            }
            if (list.isEmpty()) {
                builder.withInspectCooldownDuration(JsonUtil.getJsonInt(obj, "inspectCooldownDuration", 1000), TimeUnit.MILLISECOND);
            }
            List<JsonObject> list2 = JsonUtil.getJsonObjects(obj, "drawAnimations");
            for (JsonObject jsIdleAnimation : list2) {
                condition = jsIdleAnimation.has("condition") ? Conditions.fromJson(jsIdleAnimation.get("condition")) : ctx -> true;
                builder.withDrawAnimation(JsonUtil.getJsonString(jsIdleAnimation, "name", GunItem.DEFAULT_ANIMATION_DRAW), condition, jsIdleAnimation.getAsJsonPrimitive("duration").getAsInt(), TimeUnit.MILLISECOND);
            }
            if (list2.isEmpty()) {
                builder.withDrawCooldownDuration(JsonUtil.getJsonInt(obj, "drawCooldownDuration", 500), TimeUnit.MILLISECOND);
            }
            for (JsonObject jsFireAnimation : JsonUtil.getJsonObjects(obj, "fireAnimations")) {
                condition = jsFireAnimation.has("condition") ? Conditions.fromJson(jsFireAnimation.get("condition")) : ctx -> true;
                builder.withFireAnimation(JsonUtil.getJsonString(jsFireAnimation, "name", GunItem.DEFAULT_ANIMATION_INSPECT), condition, 0, TimeUnit.MILLISECOND);
            }
            return this;
        }

        private static double getDoubleOrDefault(JsonObject obj, String key, double defaultValue) {
            JsonElement element;
            if (obj.has(key) && (element = obj.get(key)) != null && !element.isJsonNull()) {
                return element.getAsDouble();
            }
            return defaultValue;
        }

        @Override
        @Nullable
        public Script getScript() {
            return this.mainScript;
        }
    }

    public static enum AnimationType {
        RIFLE("__DEFAULT_RIFLE_ANIMATIONS__", FALLBACK_COMMON_ANIMATIONS),
        PISTOL("__DEFAULT_PISTOL_ANIMATIONS__", FALLBACK_PISTOL_ANIMATIONS);

        private final String defaultThirdPersonAnimation;
        private final List<ResourceLocation> fallbackFirstPersonAnimations;

        private AnimationType(String defaultThirdPersonAnimation, List<ResourceLocation> fallbackFirstPersonAnimations) {
            this.defaultThirdPersonAnimation = defaultThirdPersonAnimation;
            this.fallbackFirstPersonAnimations = fallbackFirstPersonAnimations;
        }

        public String getDefaultThirdPersonAnimation() {
            return this.defaultThirdPersonAnimation;
        }

        private List<ResourceLocation> getFallbackFirstPersonAnimations() {
            return this.fallbackFirstPersonAnimations;
        }
    }

    public record PhasedReload(ReloadPhase phase, Predicate<ConditionContext> predicate, long cooldownTime, TimeUnit timeUnit, ReloadAnimation reloadAnimation) {
        public PhasedReload {
            if (cooldownTime == 0L) {
                throw new IllegalArgumentException("cooldownTime cannot be null");
            }
            if (timeUnit == null) {
                throw new IllegalArgumentException("timeUnit cannot be null");
            }
            if (predicate == null) {
                throw new IllegalArgumentException("predicate cannot be null");
            }
        }

        public PhasedReload(ReloadPhase phase, TriPredicate<LivingEntity, GunClientState, ItemStack> predicate, long cooldownTime, ReloadAnimation reloadAnimation) {
            this(phase, ctx -> predicate.test((Object)ctx.player(), (Object)ctx.gunClientState(), (Object)ctx.currentItemStack()), cooldownTime, TimeUnit.MILLISECOND, reloadAnimation);
        }

        public PhasedReload(ReloadPhase phase, long cooldownTime, ReloadAnimation reloadAnimation) {
            this(phase, ctx -> true, cooldownTime, TimeUnit.MILLISECOND, reloadAnimation);
        }

        public PhasedReload(ReloadPhase phase, long cooldownTime, String animationName) {
            this(phase, ctx -> true, cooldownTime, TimeUnit.MILLISECOND, new ReloadAnimation(animationName));
        }

        public PhasedReload(ReloadPhase phase, long cooldownTime, String animationName, Predicate<ConditionContext> predicate) {
            this(phase, predicate, cooldownTime, TimeUnit.MILLISECOND, new ReloadAnimation(animationName));
        }
    }

    public static enum ReloadPhase {
        PREPARING,
        RELOADING,
        COMPLETETING;

    }

    public static enum FirePhase implements Nameable
    {
        PREPARING,
        FIRING,
        COMPLETETING,
        HIT_SCAN_ACQUIRED,
        HIT_TARGET,
        ANY,
        FLYING;


        @Override
        public String getName() {
            return this.name();
        }
    }

    public record ReloadAnimation(String animationName, List<ReloadShakeEffect> shakeEffects) {
        public ReloadAnimation(String animationName) {
            this(animationName, Collections.emptyList());
        }
    }

    public record ReloadShakeEffect(long startTime, long duration, TimeUnit timeUnit, double initialAmplitude, double rateOfAmplitudeDecay, double initialAngularFrequency, double rateOfFrequencyIncrease) {
        private static final double DEFAULT_INITIAL_ANGULAR_FREQUENCY = 1.0;
        private static final double DEFAULT_RATE_OF_FREQUENCY_INCREASE = 0.01;

        public ReloadShakeEffect(long startTime, long duration, double initialAmplitude, double rateOfAmplitudeDecay) {
            this(startTime, duration, TimeUnit.MILLISECOND, initialAmplitude, rateOfAmplitudeDecay, 1.0, 0.01);
        }
    }
}

