/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mod.pbj.Config;
import mod.pbj.Enableable;
import mod.pbj.client.effect.EffectBuilder;
import mod.pbj.config.ConfigManager;
import mod.pbj.config.ConfigOptionBuilder;
import mod.pbj.config.Configurable;
import mod.pbj.entity.EntityExt;
import mod.pbj.event.BlockHitEvent;
import mod.pbj.explosion.CustomExplosion;
import mod.pbj.feature.DamageFeature;
import mod.pbj.feature.FireModeFeature;
import mod.pbj.item.ExplosionDescriptor;
import mod.pbj.item.ItemBuilder;
import mod.pbj.network.CustomClientBoundExplosionPacket;
import mod.pbj.network.Network;
import mod.pbj.network.SpawnParticlePacket;
import mod.pbj.registry.EffectRegistry;
import mod.pbj.registry.SoundRegistry;
import mod.pbj.util.HitScan;
import mod.pbj.util.JsonUtil;
import mod.pbj.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;

public abstract class HurtingItem
extends Item
implements Enableable {
    private static final float DEFAULT_EXPLOSION_SOUND_VOLUME = 4.0f;
    public static final double DEFAULT_MAX_SHOOTING_DISTANCE = 200.0;
    public static final float DEFAULT_DAMAGE = 5.0f;
    public static final float DEFAULT_HEADSHOT_SOUND_VOLUME = 3.0f;
    public static final float DEFAULT_LIGHT_DAMAGE_SOUND_VOLUME = 3.0f;
    public static final float DEFAULT_HEAVY_DAMAGE_SOUND_VOLUME = 3.0f;
    public static final float MAX_LIGHT_DAMAGE = 15.0f;
    public static final long DEFAULT_ENTITY_HIT_SOUND_COOLDOWN = 100L;
    protected ExplosionDescriptor explosionDescriptor;
    protected double maxShootingDistance;
    protected float damage;
    protected boolean isEnabled;
    protected float headshotSoundVolume;
    protected Supplier<SoundEvent> headshotSound;
    protected float lightDamageSoundVolume;
    protected Supplier<SoundEvent> lightDamageSound;
    protected float heavyDamageSoundVolume;
    protected Supplier<SoundEvent> heavyDamageSound;
    protected long entityHitSoundCooldown = 100L;

    public HurtingItem(Item.Properties properties, Builder<?> builder) {
        super(properties);
        if (builder != null) {
            this.explosionDescriptor = builder.explosionDescriptor;
            this.maxShootingDistance = builder.maxShootingDistance;
            this.isEnabled = builder.configOptionEnabled.get();
            this.damage = builder.configOptionDamage.get().floatValue();
            this.headshotSound = builder.headshotSound;
            this.headshotSoundVolume = builder.headshotSoundVolume;
            this.lightDamageSound = builder.lightDamageSound;
            this.lightDamageSoundVolume = builder.lightDamageSoundVolume;
            this.heavyDamageSound = builder.heavyDamageSound;
            this.heavyDamageSoundVolume = builder.heavyDamageSoundVolume;
        }
    }

    public float getDamage() {
        return this.damage;
    }

    public ExplosionDescriptor getExplosion() {
        return this.explosionDescriptor;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    public float hurtEntity(LivingEntity player, EntityHitResult entityHitResult, Entity projectile, ItemStack gunStack) {
        float damage = 0.0f;
        if (this.getExplosion() != null) {
            Vec3 hitLocation = entityHitResult.m_82443_().m_20318_(0.0f);
            if (MiscUtil.isProtected(entityHitResult.m_82443_())) {
                Vec3 pos = entityHitResult.m_82443_().m_20182_();
                MiscUtil.getLevel((Entity)player).m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11785_, SoundSource.AMBIENT, 3.0f, 1.0f);
            } else {
                this.explode(MiscUtil.getLevel((Entity)player), projectile, null, hitLocation.f_82479_, hitLocation.f_82480_, hitLocation.f_82481_);
            }
        } else {
            Entity hitEntity = entityHitResult.m_82443_();
            if (MiscUtil.isProtected(hitEntity)) {
                Vec3 pos = hitEntity.m_20182_();
                MiscUtil.getLevel((Entity)player).m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11785_, SoundSource.AMBIENT, 3.0f, 1.0f);
            } else {
                DamageSource damageSource;
                boolean isHeadshot = false;
                if (hitEntity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)hitEntity;
                    isHeadshot = HitScan.isHeadshot(livingEntity, entityHitResult.m_82450_());
                }
                if (player instanceof Player) {
                    damageSource = player.m_269291_().m_269075_((Player)player);
                } else {
                    DamageSources damageSources = MiscUtil.getLevel((Entity)player).m_269111_();
                    damageSource = damageSources.m_269264_();
                }
                int origInvulnerableTime = hitEntity.f_19802_;
                hitEntity.f_19802_ = 0;
                double distanceToPlayer = entityHitResult.m_82448_((Entity)player);
                double adjustedDamage = FireModeFeature.getDamage(gunStack);
                if (isHeadshot) {
                    adjustedDamage *= Config.headshotDamageModifier;
                }
                adjustedDamage *= Mth.m_14008_((double)(1.0 - Math.pow(Math.sqrt(distanceToPlayer) / this.maxShootingDistance * 0.5, 6.0)), (double)0.0, (double)1.0);
                if (gunStack != null) {
                    adjustedDamage *= (double)DamageFeature.getHitScanDamageModifier(gunStack);
                    adjustedDamage *= Config.hitscanDamageModifier;
                }
                hitEntity.m_6469_(damageSource, (float)adjustedDamage);
                EntityExt entityExt = (EntityExt)hitEntity;
                if (System.currentTimeMillis() - entityExt.getLastHitSoundTimestamp() > this.entityHitSoundCooldown) {
                    entityExt.setLastHitSoundTimestamp(System.currentTimeMillis());
                    if (isHeadshot && !MiscUtil.getLevel((Entity)hitEntity).f_46443_) {
                        MiscUtil.getLevel(hitEntity).m_6263_(null, hitEntity.m_20185_(), hitEntity.m_20186_(), hitEntity.m_20189_(), this.headshotSound.get(), SoundSource.PLAYERS, this.headshotSoundVolume, 1.0f);
                    } else if (adjustedDamage < 15.0) {
                        MiscUtil.getLevel(hitEntity).m_6263_(null, hitEntity.m_20185_(), hitEntity.m_20186_(), hitEntity.m_20189_(), this.lightDamageSound.get(), SoundSource.PLAYERS, this.lightDamageSoundVolume, 1.0f);
                    } else {
                        MiscUtil.getLevel(hitEntity).m_6263_(null, hitEntity.m_20185_(), hitEntity.m_20186_(), hitEntity.m_20189_(), this.heavyDamageSound.get(), SoundSource.PLAYERS, this.heavyDamageSoundVolume, 1.0f);
                    }
                }
                hitEntity.f_19802_ = origInvulnerableTime;
                damage = (float)adjustedDamage;
            }
        }
        if (projectile != null) {
            projectile.m_146870_();
        }
        return damage;
    }

    public void handleBlockHit(LivingEntity player, BlockHitResult blockHitResult, @Nullable Entity projectile) {
        BlockHitEvent event = new BlockHitEvent(player, blockHitResult, projectile);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            HurtingItem.spawnBlockBreakParticles((ServerPlayer)player, blockHitResult.m_82425_(), blockHitResult.m_82450_());
            if (this.getExplosion() != null) {
                Vec3 hitLocation = blockHitResult.m_82450_();
                this.explode(MiscUtil.getLevel((Entity)player), projectile, null, hitLocation.f_82479_, hitLocation.f_82480_, hitLocation.f_82481_);
            }
            if (projectile != null) {
                projectile.m_146870_();
            }
        }
    }

    public void discardProjectile(Entity projectile) {
        this.explodeProjectile(projectile);
    }

    public void explodeProjectile(Entity projectile) {
        this.explode(MiscUtil.getLevel(projectile), projectile, null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_());
    }

    private static void spawnBlockBreakParticles(ServerPlayer player, BlockPos blockPos, Vec3 hitLocation) {
        Level level = MiscUtil.getLevel((Entity)player);
        BlockState blockState = level.m_8055_(blockPos);
        if (blockState != null) {
            Network.networkChannel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SpawnParticlePacket((ParticleType<?>)ParticleTypes.f_123762_, hitLocation.f_82479_, hitLocation.f_82480_, hitLocation.f_82481_, 5));
        }
    }

    private void explode(Level level, @Nullable Entity entity, @Nullable DamageSource damageSource, double posX, double posY, double posZ) {
        boolean fire;
        if (level.f_46443_) {
            throw new IllegalArgumentException("Cannot use this method on the client side");
        }
        ExplosionDamageCalculator calc = null;
        float power = this.explosionDescriptor.power();
        CustomExplosion customExplosion = CustomExplosion.explode(level, this, entity, damageSource, calc, posX, posY, posZ, power, fire = this.explosionDescriptor.fire(), this.explosionDescriptor.interaction(), false);
        if (!customExplosion.m_254884_()) {
            customExplosion.m_46080_();
        }
        for (ServerPlayer player : ((ServerLevel)level).m_8795_(p -> true)) {
            if (!(player.m_20275_(posX, posY, posZ) < 22000.0)) continue;
            Network.networkChannel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new CustomClientBoundExplosionPacket(this, posX, posY, posZ, power, customExplosion.m_46081_(), (Vec3)customExplosion.m_46078_().get(player)));
        }
    }

    public static abstract class Builder<T extends ItemBuilder<T>>
    extends ItemBuilder<T>
    implements Configurable,
    Enableable {
        private ExplosionDescriptor explosionDescriptor;
        private double maxShootingDistance = 2000.0;
        private float damage = 5.0f;
        private Supplier<Boolean> configOptionEnabled;
        private Supplier<Double> configOptionDamage;
        private float headshotSoundVolume = 3.0f;
        private Supplier<SoundEvent> headshotSound = SoundRegistry.HIT_HEADSHOT;
        protected float lightDamageSoundVolume = 3.0f;
        protected Supplier<SoundEvent> lightDamageSound = SoundRegistry.HIT_LIGHT;
        protected float heavyDamageSoundVolume = 3.0f;
        protected Supplier<SoundEvent> heavyDamageSound = SoundRegistry.HIT_HEAVY;

        protected T cast(Builder<T> _this) {
            return (T)_this;
        }

        public T withDamage(float damage) {
            this.damage = damage;
            return this.cast(this);
        }

        public T withHeadshotSound(Supplier<SoundEvent> headshotSound, float headshotSoundVolume) {
            this.headshotSound = headshotSound;
            this.headshotSoundVolume = headshotSoundVolume;
            return this.cast(this);
        }

        public T withLightDamageSound(Supplier<SoundEvent> lightDamageSound, float lightDamageSoundVolume) {
            this.lightDamageSound = lightDamageSound;
            this.lightDamageSoundVolume = lightDamageSoundVolume;
            return this.cast(this);
        }

        public T withHeavyDamageSound(Supplier<SoundEvent> heavyDamageSound, float heavyDamageSoundVolume) {
            this.heavyDamageSound = heavyDamageSound;
            this.heavyDamageSoundVolume = heavyDamageSoundVolume;
            return this.cast(this);
        }

        public T withMaxShootingDistance(double distance) {
            this.maxShootingDistance = distance;
            return this.cast(this);
        }

        public T withExplosion(float power, boolean fire, Level.ExplosionInteraction explosionInteraction, List<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>> effects) {
            return this.withExplosion(power, fire, explosionInteraction, null, 4.0f, effects);
        }

        public T withExplosion(float power, boolean fire, Level.ExplosionInteraction explosionInteraction, @Nullable String soundName, float soundVolume, List<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>> effects) {
            this.explosionDescriptor = new ExplosionDescriptor(power, fire, explosionInteraction, soundName, soundVolume, effects);
            return this.cast(this);
        }

        @Override
        public void configure(ConfigManager.Builder builder) {
            this.configOptionEnabled = ((ConfigOptionBuilder)((ConfigOptionBuilder)((ConfigOptionBuilder)builder.createBooleanOption().withName(this.getName() + ".enabled")).withDescription("Set to `false` to remove the item from the game.")).withDefault(true)).getSupplier();
            this.configOptionDamage = ((ConfigOptionBuilder)((ConfigOptionBuilder)((ConfigOptionBuilder)((ConfigOptionBuilder)builder.createDoubleOption().withName(this.getName() + ".damage")).withDescription("Sets this item damage.")).withRange(0.01, 100.0)).withDefault((Double)Double.valueOf(this.damage))).getSupplier();
        }

        @Override
        public T withJsonObject(JsonObject obj) {
            JsonObject jsExplosion;
            this.withMaxShootingDistance(JsonUtil.getJsonDouble(obj, "maxShootingDistance", 2000.0));
            this.withDamage(JsonUtil.getJsonFloat(obj, "damage", 5.0f));
            float headshotSoundVolume = JsonUtil.getJsonFloat(obj, "headshotSoundVolume", 3.0f);
            JsonElement headshotSoundElem = obj.get("headshotSound");
            if (headshotSoundElem != null && !headshotSoundElem.isJsonNull()) {
                String headshotSoundName = headshotSoundElem.getAsString();
                this.withHeadshotSound(() -> SoundRegistry.getSoundEvent(headshotSoundName), headshotSoundVolume);
            }
            if ((jsExplosion = obj.getAsJsonObject("explosion")) != null) {
                float power = JsonUtil.getJsonFloat(jsExplosion, "power", 1.0f);
                boolean fire = JsonUtil.getJsonBoolean(jsExplosion, "fire", false);
                String soundName = JsonUtil.getJsonString(jsExplosion, "sound", null);
                float soundVolume = JsonUtil.getJsonFloat(jsExplosion, "soundVolume", 4.0f);
                Level.ExplosionInteraction interaction = (Level.ExplosionInteraction)JsonUtil.getEnum(jsExplosion, "interaction", Level.ExplosionInteraction.class, Level.ExplosionInteraction.BLOCK, true);
                ArrayList explosionEffects = new ArrayList();
                for (String effectName : JsonUtil.getStrings(jsExplosion, "effects")) {
                    Supplier<EffectBuilder> supplier = () -> EffectRegistry.getEffectBuilderSupplier(effectName).get();
                    explosionEffects.add(supplier);
                }
                this.withExplosion(power, fire, interaction, soundName, soundVolume, explosionEffects);
            }
            return this.cast(this);
        }

        public float getDamage() {
            return this.damage;
        }

        @Override
        public boolean isEnabled() {
            return this.configOptionEnabled == null || this.configOptionEnabled.get() != false;
        }
    }
}

