/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.item;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mod.pbj.InvalidExtensionComponentException;
import mod.pbj.Nameable;
import mod.pbj.entity.EntityBuilderProvider;
import mod.pbj.item.AmmoItem;
import mod.pbj.item.ArmorItem;
import mod.pbj.item.AttachmentItem;
import mod.pbj.item.GunItem;
import mod.pbj.item.MiscItem;
import mod.pbj.item.ThrowableItem;
import mod.pbj.registry.ExtensionRegistry;
import net.minecraft.world.item.Item;

public abstract class ItemBuilder<T extends ItemBuilder<T>>
implements Nameable {
    public String nameSpace;
    public ExtensionRegistry.Extension extension;

    public static ItemBuilder<?> fromZipEntry(ZipFile zipFile, ZipEntry entry, ExtensionRegistry.Extension extension) throws InvalidExtensionComponentException {
        try {
            ItemBuilder<?> var3;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));){
                var3 = ItemBuilder.fromReader(reader, extension);
            }
            return var3;
        }
        catch (IOException var7) {
            throw new InvalidExtensionComponentException("Zip file: " + String.valueOf(zipFile) + ", zip entry: " + String.valueOf(entry), var7);
        }
    }

    public static ItemBuilder<?> fromPath(Path path, ExtensionRegistry.Extension extension) throws InvalidExtensionComponentException {
        try {
            ItemBuilder<?> var2;
            try (BufferedReader br = Files.newBufferedReader(path);){
                var2 = ItemBuilder.fromReader(br, extension);
            }
            return var2;
        }
        catch (IOException var6) {
            throw new InvalidExtensionComponentException("Component path: " + String.valueOf(path), var6);
        }
    }

    public static ItemBuilder<?> fromReader(Reader reader, ExtensionRegistry.Extension extension) {
        try {
            JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            String itemTypeStr = obj.has("type") ? obj.getAsJsonPrimitive("type").getAsString() : ItemType.GUN.toString();
            ItemType itemType = ItemType.valueOf(itemTypeStr.toUpperCase(Locale.ROOT));
            if (itemType == ItemType.GUN) {
                return new GunItem.Builder(extension).withJsonObject(obj);
            }
            if (itemType == ItemType.AMMO) {
                return new AmmoItem.Builder(extension).withJsonObject(obj);
            }
            if (itemType == ItemType.THROWABLE) {
                return new ThrowableItem.Builder(extension).withJsonObject(obj);
            }
            if (itemType == ItemType.MISC) {
                return new MiscItem.MiscItemBuilder(extension).withJsonObject(obj);
            }
            if (itemType == ItemType.ATTACHMENT) {
                return new AttachmentItem.Builder(extension).withJsonObject(obj);
            }
            if (itemType == ItemType.ARMOR) {
                return new ArmorItem.Builder().withJsonObject(obj);
            }
            throw new IllegalArgumentException("Invalid item type: " + String.valueOf((Object)itemType));
        }
        catch (Exception var4) {
            throw new RuntimeException("Error processing JSON: " + var4.getMessage(), var4);
        }
    }

    public abstract T withJsonObject(JsonObject var1);

    public EntityBuilderProvider getEntityBuilderProvider() {
        return null;
    }

    public abstract Item build();

    public static enum ItemType {
        GUN,
        AMMO,
        MISC,
        ATTACHMENT,
        THROWABLE,
        ARMOR;

    }
}

