/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.item;

import javax.annotation.Nullable;
import mod.pbj.PointBlankJelly;
import mod.pbj.script.Script;

public interface ScriptHolder {
    @Nullable
    public Script getScript();

    default public boolean hasScript() {
        return this.getScript() != null;
    }

    default public boolean hasFunction(String functionName) {
        return this.getScript() != null && this.getScript().hasFunction(functionName);
    }

    default public <T> T invokeFunction(String functionName, Class<T> clazz, Object ... args) {
        if (this.getScript() == null) {
            return null;
        }
        if (!this.hasFunction(functionName)) {
            PointBlankJelly.LOGGER.debug("Function {} not found in script: {}", (Object)functionName, (Object)this.getScript().getClass().getName());
            return null;
        }
        try {
            return this.getScript().invokeMethod(functionName, clazz, args);
        }
        catch (Exception e) {
            PointBlankJelly.LOGGER.debug("Failed to invoke function {} in script: {}", (Object)functionName, (Object)this.getScript().getClass().getName(), (Object)e);
            return null;
        }
    }

    default public Object invokeFunction(String functionName, Object ... args) {
        if (this.getScript() == null) {
            return null;
        }
        if (!this.hasFunction(functionName)) {
            PointBlankJelly.LOGGER.debug("Function {} not found in script: {}", (Object)functionName, (Object)this.getScript().getClass().getName());
            return null;
        }
        try {
            return this.getScript().invokeMethod(functionName, args);
        }
        catch (Exception e) {
            PointBlankJelly.LOGGER.debug("Failed to invoke function {} in script: {}", (Object)functionName, (Object)this.getScript().getClass().getName(), (Object)e);
            return null;
        }
    }
}

