/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.jei;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mod.pbj.crafting.PointBlankIngredient;
import mod.pbj.crafting.PointBlankRecipe;
import mod.pbj.jei.PointBlankJeiPlugin;
import mod.pbj.registry.BlockRegistry;
import mod.pbj.util.MiscUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.joml.Quaternionf;

public class PointBlankRecipeCategory
implements IRecipeCategory<PointBlankRecipe> {
    public static final ResourceLocation BACKGROUND_RESOURCE = new ResourceLocation("pointblank", "textures/gui/jei.png");
    private final IDrawableStatic backgroundDrawable;
    private final IDrawableStatic itemDrawable;
    private final IDrawableStatic inventoryDrawable;
    private final IDrawable icon;
    private final Component title;

    public PointBlankRecipeCategory(IGuiHelper gui) {
        this.backgroundDrawable = gui.createBlankDrawable(180, 124);
        this.itemDrawable = gui.createDrawable(BACKGROUND_RESOURCE, 2, 2, 180, 102);
        this.inventoryDrawable = gui.createDrawable(BACKGROUND_RESOURCE, 2, 108, 180, 19);
        this.icon = gui.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.PRINTER.get()));
        this.title = Component.m_237115_((String)"block.pointblank.printer");
    }

    public RecipeType<PointBlankRecipe> getRecipeType() {
        return PointBlankJeiPlugin.POINTBLANK_RECIPE_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.backgroundDrawable;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PointBlankRecipe recipe, IFocusGroup focuses) {
        ItemStack resultStack = recipe.m_8043_(null);
        List<PointBlankIngredient> pbi = recipe.getPointBlankIngredients();
        for (int i = 0; i < pbi.size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, i * 18 + 1, 106).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, pbi.get(i).getItemStacks());
        }
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(resultStack);
    }

    public void draw(PointBlankRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        this.itemDrawable.draw(guiGraphics, 0, 0);
        this.inventoryDrawable.draw(guiGraphics, 0, this.itemDrawable.getHeight() + 3);
        Font font = mc.f_91062_;
        ItemStack itemStack = recipe.getInitializedStack();
        MutableComponent displayName = itemStack.m_41786_().m_6881_();
        if (itemStack.m_41613_() > 1) {
            displayName.m_7220_((Component)Component.m_237113_((String)(" x " + itemStack.m_41613_())));
        }
        int offsetX = this.itemDrawable.getWidth() >> 1;
        guiGraphics.m_280653_(font, (Component)displayName, offsetX, 4, -256);
        PoseStack poseStack = RenderSystem.getModelViewStack();
        float fullTick = (float)mc.f_91074_.f_19797_ + mc.m_91296_();
        float yOffset = Mth.m_14089_((float)(fullTick * (float)Math.PI * 0.02f)) * 2.0f;
        poseStack.m_85836_();
        poseStack.m_252931_(guiGraphics.m_280168_().m_85850_().m_252922_());
        poseStack.m_252880_(90.0f, 55.0f + yOffset, 1000.0f);
        poseStack.m_252781_(new Quaternionf().rotationXYZ(-0.34906584f, fullTick * ((float)Math.PI / 180) * 2.0f, 0.0f));
        poseStack.m_85841_(60.0f, -60.0f, 60.0f);
        RenderSystem.applyModelViewMatrix();
        BakedModel model = mc.m_91291_().m_174264_(itemStack, MiscUtil.getLevel((Entity)mc.f_91074_), (LivingEntity)mc.f_91074_, mc.f_91074_.m_19879_() + ItemDisplayContext.GROUND.ordinal());
        Lighting.m_84931_();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        mc.m_91291_().m_115143_(itemStack, ItemDisplayContext.GROUND, false, new PoseStack(), (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, model);
        buffer.m_109911_();
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }
}

