/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.mixin;

import mod.pbj.Config;
import mod.pbj.item.GunItem;
import mod.pbj.util.MiscUtil;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class}, remap=false)
public class LivingEntityMixin {
    @Unique
    private final ThreadLocal<DamageSource> hurtDamageSource = new ThreadLocal();

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V")})
    private void beforeHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> callbackInfo) {
        this.hurtDamageSource.set(source);
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V", shift=At.Shift.AFTER)})
    private void afterHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> callbackInfo) {
        this.hurtDamageSource.remove();
    }

    @ModifyArg(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V"), index=0)
    private double onKnockback(double knockback) {
        LivingEntity hurtByEntity;
        GunItem gunItem;
        Entity entity;
        DamageSource source = this.hurtDamageSource.get();
        if (source != null && (entity = source.m_7639_()) instanceof LivingEntity && (gunItem = (GunItem)MiscUtil.getMainHeldGun(hurtByEntity = (LivingEntity)entity).orElse(null)) != null) {
            knockback = Mth.m_14008_((double)(knockback * Config.knockback), (double)0.0, (double)100.0);
        }
        return knockback;
    }
}

