/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.network;

import java.util.function.Supplier;
import mod.pbj.client.ClientEventHandler;
import mod.pbj.client.gui.CraftingScreen;
import mod.pbj.client.gui.NotificationToast;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class CraftingResponsePacket {
    private ItemStack itemStack;
    private CraftingResult result;
    private boolean isAddedToInventory;

    public CraftingResponsePacket(ItemStack itemStack, CraftingResult result, boolean isAddedToInventory) {
        this.itemStack = itemStack;
        this.result = result;
        this.isAddedToInventory = isAddedToInventory;
    }

    public CraftingResponsePacket() {
    }

    public static void encode(CraftingResponsePacket packet, FriendlyByteBuf buf) {
        buf.writeItemStack(packet.itemStack, false);
        buf.m_130068_((Enum)packet.result);
        buf.writeBoolean(packet.isAddedToInventory);
    }

    public static CraftingResponsePacket decode(FriendlyByteBuf buf) {
        return new CraftingResponsePacket(buf.m_130267_(), (CraftingResult)buf.m_130066_(CraftingResult.class), buf.readBoolean());
    }

    public static void handle(CraftingResponsePacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientEventHandler.runSyncTick(() -> {
            MutableComponent message = null;
            switch (packet.result) {
                case COMPLETED: {
                    if (packet.isAddedToInventory) {
                        message = Component.m_237115_((String)"").m_7220_(packet.itemStack.m_41720_().m_7626_(packet.itemStack)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"message.pointblank.added_to_the_inventory")).m_130946_("!");
                        break;
                    }
                    message = Component.m_237115_((String)"").m_7220_(packet.itemStack.m_41720_().m_7626_(packet.itemStack)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"message.pointblank.dropped_on_the_gound")).m_130946_("!");
                    break;
                }
                case FAILED: {
                    Minecraft mc = Minecraft.m_91087_();
                    Screen patt2905$temp = mc.f_91080_;
                    if (patt2905$temp instanceof CraftingScreen) {
                        CraftingScreen craftingScreen = (CraftingScreen)patt2905$temp;
                        craftingScreen.cancelCrafting();
                    }
                    message = Component.m_237115_((String)"message.pointblank.failed_to_craft");
                    break;
                }
                case CANCELLED: {
                    message = Component.m_237115_((String)"").m_7220_(packet.itemStack.m_41720_().m_7626_(packet.itemStack)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"message.pointblank.cancelled_to_craft"));
                }
            }
            if (message != null) {
                CraftingResponsePacket.notifyUser(message);
            }
        }));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void notifyUser(Component message) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new NotificationToast(message, 3000L));
    }

    public static enum CraftingResult {
        COMPLETED,
        FAILED,
        CANCELLED;

    }
}

