/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.network;

import java.util.UUID;
import java.util.function.Supplier;
import mod.pbj.client.ClientEventHandler;
import mod.pbj.client.GunClientState;
import mod.pbj.item.GunItem;
import mod.pbj.network.GunStateResponsePacket;
import mod.pbj.util.InventoryUtils;
import mod.pbj.util.SimpleHitResult;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import software.bernie.geckolib.util.ClientUtils;

public class HitScanFireResponsePacket
extends GunStateResponsePacket {
    private SimpleHitResult hitResult;
    private int ownerEntityId;
    private float damage;

    public HitScanFireResponsePacket() {
    }

    public HitScanFireResponsePacket(int ownerEntityId, UUID stateId, int slotIndex, int correlationId, SimpleHitResult hitResult, float damage) {
        super(stateId, slotIndex, correlationId, true);
        this.ownerEntityId = ownerEntityId;
        this.hitResult = hitResult;
        this.damage = damage;
    }

    @Override
    protected void doEncode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.ownerEntityId);
        SimpleHitResult.writer().accept((Object)buffer, (Object)this.hitResult);
        buffer.writeFloat(this.damage);
    }

    public static HitScanFireResponsePacket decode(FriendlyByteBuf buffer) {
        GunStateResponsePacket header = GunStateResponsePacket.decodeHeader(buffer);
        int ownerEntityId = buffer.readInt();
        SimpleHitResult hitResult = (SimpleHitResult)((Object)SimpleHitResult.reader().apply((Object)buffer));
        float damage = buffer.readFloat();
        return new HitScanFireResponsePacket(ownerEntityId, header.stateId, header.slotIndex, header.correlationId, hitResult, damage);
    }

    public static void handle(HitScanFireResponsePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientEventHandler.runSyncTick(() -> {
            Player player;
            Tuple<ItemStack, GunClientState> targetTuple;
            Level level = ClientUtils.getLevel();
            Entity entity = level.m_6815_(packet.ownerEntityId);
            if (entity instanceof Player && (targetTuple = packet.getItemStackAndState(packet, (Entity)(player = (Player)entity))) != null) {
                packet.handleEnqueued(player, (ItemStack)targetTuple.m_14418_(), (GunClientState)targetTuple.m_14419_());
            }
        }));
        ctx.get().setPacketHandled(true);
    }

    @Override
    protected <T extends GunStateResponsePacket> Tuple<ItemStack, GunClientState> getItemStackAndState(T packet, Entity entity) {
        Player clientPlayer = ClientUtils.getClientPlayer();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return InventoryUtils.getItemStackByStateId(player, packet.stateId, clientPlayer == player ? packet.slotIndex : 0);
        }
        return null;
    }

    protected <T extends GunStateResponsePacket> void handleEnqueued(Player player, ItemStack itemStack, GunClientState gunClientState) {
        Item var5 = itemStack.m_41720_();
        if (var5 instanceof GunItem) {
            GunItem gunItem = (GunItem)var5;
            gunItem.processServerHitScanFireResponse(player, this.stateId, itemStack, gunClientState, this.hitResult, this.damage);
        }
    }
}

