/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.network;

import java.util.UUID;
import java.util.function.Supplier;
import mod.pbj.client.GunClientState;
import mod.pbj.network.GunStateRequestPacket;
import mod.pbj.network.MainHeldSimplifiedStateBroadcastPacket;
import mod.pbj.network.Network;
import mod.pbj.util.MiscUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class MainHeldSimplifiedStateSyncRequest
extends GunStateRequestPacket {
    private static final int MAX_STATE_SYNC_DISTANCE_SQR = 10000;
    private GunClientState.FireState simplifiedState;

    public MainHeldSimplifiedStateSyncRequest() {
    }

    public MainHeldSimplifiedStateSyncRequest(UUID stateId, GunClientState.FireState simplifiedState) {
        super(stateId, 0);
        this.simplifiedState = simplifiedState;
    }

    @Override
    protected void doEncode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.simplifiedState.ordinal());
    }

    public static MainHeldSimplifiedStateSyncRequest decode(FriendlyByteBuf buffer) {
        GunStateRequestPacket header = GunStateRequestPacket.decodeHeader(buffer);
        GunClientState.FireState state = GunClientState.FireState.values()[buffer.readInt()];
        return new MainHeldSimplifiedStateSyncRequest(header.stateId, state);
    }

    @Override
    protected <T extends GunStateRequestPacket> void handleEnqueued(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer sender = ctx.get().getSender();
        for (ServerPlayer player : ((ServerLevel)MiscUtil.getLevel((Entity)sender)).m_8795_(p -> true)) {
            if (player == sender || !(player.m_20238_(player.m_20182_()) < 10000.0)) continue;
            Network.networkChannel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MainHeldSimplifiedStateBroadcastPacket((Player)sender, this.stateId, this.simplifiedState));
        }
    }
}

