/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import mod.pbj.entity.EntityBuilder;
import mod.pbj.entity.ProjectileBulletEntity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class EntityRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"pointblank");
    private static final List<EntityBuilder<?, ?>> entityBuilders = new ArrayList();
    private static final Map<EntityKey, Supplier<EntityBuilder<?, ?>>> entityBuildersByNameType = new HashMap();
    private static final Map<String, RegistryObject<EntityType<?>>> typesByName = new HashMap();
    private static final Map<RegistryObject<EntityType<?>>, Supplier<EntityBuilder<?, ?>>> itemEntityBuilders = new HashMap();

    public static Supplier<EntityBuilder<?, ?>> getEntityBuilder(String name, EntityBuilder.EntityTypeExt type) {
        Supplier<EntityBuilder<?, ?>> supplier = entityBuildersByNameType.get(new EntityKey(name, type));
        if (supplier == null) {
            throw new IllegalArgumentException("Entity '" + name + "' of type '" + String.valueOf((Object)type) + "' not found");
        }
        return supplier;
    }

    public static List<EntityBuilder<?, ?>> getEntityBuilders() {
        return Collections.unmodifiableList(entityBuilders);
    }

    public static RegistryObject<EntityType<?>> getTypeByName(String name) {
        return typesByName.get(name);
    }

    public static Map<RegistryObject<EntityType<?>>, Supplier<EntityBuilder<?, ?>>> getItemEntityBuilders() {
        return Collections.unmodifiableMap(itemEntityBuilders);
    }

    public static RegistryObject<EntityType<?>> registerItemEntity(String name, Supplier<EntityBuilder<?, ?>> entityBuilderSupplier) {
        Supplier<EntityType> sup = () -> ((EntityBuilder)entityBuilderSupplier.get()).getEntityTypeBuilder().m_20712_(name);
        RegistryObject registeredEntityType = ENTITIES.register(name, sup);
        typesByName.put(name, registeredEntityType);
        itemEntityBuilders.put(registeredEntityType, entityBuilderSupplier);
        return registeredEntityType;
    }

    static {
        ENTITIES.register("bullet", () -> ProjectileBulletEntity.TYPE);
    }

    private record EntityKey(String name, EntityBuilder.EntityTypeExt type) {
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntityKey other = (EntityKey)obj;
            return Objects.equals(this.name, other.name) && this.type == other.type;
        }
    }
}

