/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.registry;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.jarhandling.SecureJar;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import mod.pbj.InvalidExtensionComponentException;
import mod.pbj.InvalidExtensionException;
import mod.pbj.PointBlankJelly;
import mod.pbj.client.effect.EffectBuilder;
import mod.pbj.compat.playeranimator.PlayerAnimationBuilder;
import mod.pbj.entity.EntityBuilder;
import mod.pbj.item.ArmorItem;
import mod.pbj.item.AttachmentItem;
import mod.pbj.item.GunItem;
import mod.pbj.item.ItemBuilder;
import mod.pbj.registry.AmmoRegistry;
import mod.pbj.registry.EffectRegistry;
import mod.pbj.registry.ItemRegistry;
import mod.pbj.registry.SoundRegistry;
import mod.pbj.registry.ThirdPersonAnimationRegistry;
import mod.pbj.script.ScriptParser;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.resource.DelegatingPackResources;
import net.minecraftforge.resource.PathPackResources;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtensionRegistry {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private Pack extensionsPack;
    private List<Extension> extensions = new ArrayList<Extension>();
    private final RepositorySource repositorySource = consumer -> {
        if (this.extensionsPack != null) {
            consumer.accept(this.extensionsPack);
        }
    };

    public List<Extension> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public RepositorySource getRepositorySource() {
        return this.repositorySource;
    }

    public void discoverExtensions(PackType packType) {
        Path resourcePacksPath = FMLPaths.GAMEDIR.get().resolve("pointblank");
        this.extensions = ExtensionRegistry.scanExtensions(resourcePacksPath);
        ArrayList<1> extensionPacks = new ArrayList<1>();
        for (final Extension extension : this.extensions) {
            LOGGER.error("Adding extension: {}", (Object)extension);
            extensionPacks.add(new PathPackResources(extension.name, false, extension.path){
                private final SecureJar secureJar;
                {
                    super(packId, isBuiltin, source);
                    this.secureJar = SecureJar.from((Path[])new Path[]{extension.path});
                }

                protected Path resolve(String ... paths) {
                    if (paths.length < 1) {
                        throw new IllegalArgumentException("Missing path");
                    }
                    return this.secureJar.getPath(String.join((CharSequence)"/", paths), new String[0]);
                }

                public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
                    return super.m_214146_(type, location);
                }

                public void m_8031_(PackType type, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
                    super.m_8031_(type, namespace, path, resourceOutput);
                }
            });
        }
        this.extensionsPack = Pack.m_245429_((String)"pointblank_resources", (Component)Component.m_237113_((String)"Pointblank Resources"), (boolean)true, id -> new DelegatingPackResources(id, false, new PackMetadataSection((Component)Component.m_237110_((String)"pointblank.resources.modresources", (Object[])new Object[]{extensionPacks.size()}), SharedConstants.m_183709_().m_264084_(packType)), extensionPacks){

            public boolean isHidden() {
                return true;
            }
        }, (PackType)packType, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10527_);
    }

    public static void registerItemsFromExtensions(ExtensionRegistry registry, IEventBus modEventBus) {
        for (Extension extension : registry.getExtensions()) {
            ArrayList registeredExtItems = new ArrayList();
            ItemRegistry extItems = ItemRegistry.ITEMS;
            for (String string : extension.getSounds()) {
                Supplier<SoundEvent> registeredSound = SoundRegistry.register(string);
                extension.registeredExtSounds.put(string, registeredSound);
            }
            for (ItemBuilder itemBuilder : extension.getItemBuilders()) {
                Supplier registeredExtItem = extItems.register(itemBuilder);
                registeredExtItems.add(registeredExtItem);
            }
            for (EffectBuilder effectBuilder : extension.getEffectBuilders()) {
                EffectRegistry.register(effectBuilder.getName(), () -> effectBuilder);
            }
            for (PlayerAnimationBuilder playerAnimationBuilder : extension.getPlayerAnimationBuilders()) {
                ThirdPersonAnimationRegistry.register(playerAnimationBuilder.getName(), playerAnimationBuilder.getReaderFactory());
            }
            Supplier<ItemStack> tabIconSupplier = () -> {
                Optional<Supplier> firstGunItem;
                Supplier<? extends Item> supplier;
                Item item = null;
                if (extension.creativeTabIconItem != null && (supplier = ItemRegistry.ITEMS.getItemsByName().get(extension.creativeTabIconItem)) != null) {
                    item = supplier.get();
                }
                if (item == null && (item = (firstGunItem = registeredExtItems.stream().filter(ro -> ro.get() instanceof GunItem).findFirst()).isPresent() ? (Item)firstGunItem.get().get() : Items.f_42127_) == null) {
                    item = AmmoRegistry.AMMOCREATIVE.get();
                }
                return new ItemStack((ItemLike)(item != null ? item : Items.f_41852_));
            };
            ItemRegistry.TABS.register(extension.getName(), () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)("itemGroup." + extension.getName() + ".items"))).m_257737_(tabIconSupplier).m_257501_((enabledFeatures, entries) -> {
                CreativeModeTab.Output output = new CreativeModeTab.Output(){

                    public void m_246267_(ItemStack itemStack, CreativeModeTab.TabVisibility tabVisibility) {
                        entries.m_246267_(itemStack, tabVisibility);
                    }

                    public void m_246326_(ItemLike itemLike) {
                        if (itemLike != null) {
                            entries.m_246326_(itemLike);
                        }
                    }
                };
                Stream<Item> sortedExtItems = registeredExtItems.stream().map(Supplier::get).sorted((item, item2) -> {
                    int eq = 0;
                    if (item == item2) {
                        return eq;
                    }
                    if (item instanceof AttachmentItem) {
                        --eq;
                    }
                    if (item2 instanceof AttachmentItem) {
                        ++eq;
                    }
                    return eq;
                }).sorted((item, item2) -> {
                    int eq = 0;
                    ArmorItem armorItem = null;
                    ArmorItem armorItem2 = null;
                    if (item == item2) {
                        return eq;
                    }
                    if (item instanceof ArmorItem) {
                        ArmorItem armor = (ArmorItem)item;
                        --eq;
                        armorItem = armor;
                    }
                    if (item2 instanceof ArmorItem) {
                        ArmorItem armor2 = (ArmorItem)item2;
                        ++eq;
                        armorItem2 = armor2;
                    }
                    if (armorItem != null && armorItem2 != null) {
                        if (armorItem.m_40404_() < armorItem2.m_40404_()) {
                            --eq;
                        }
                        if (armorItem.m_40404_() > armorItem2.m_40404_()) {
                            ++eq;
                        }
                    }
                    return eq;
                }).sorted((item, item2) -> {
                    int eq = 0;
                    GunItem gunItem = null;
                    GunItem gunItem2 = null;
                    if (item == item2) {
                        return eq;
                    }
                    if (item instanceof GunItem) {
                        GunItem gun = (GunItem)item;
                        --eq;
                        gunItem = gun;
                    }
                    if (item2 instanceof GunItem) {
                        GunItem gun2 = (GunItem)item2;
                        ++eq;
                        gunItem2 = gun2;
                    }
                    if (gunItem != null && gunItem2 != null) {
                        if (gunItem.getDamage() < gunItem2.getDamage()) {
                            --eq;
                        }
                        if (gunItem.getDamage() > gunItem2.getDamage()) {
                            ++eq;
                        }
                    }
                    return eq;
                });
                for (Item registeredExtensionItem : sortedExtItems.toList()) {
                    output.m_246326_((ItemLike)registeredExtensionItem);
                }
            }).m_257652_());
        }
    }

    @Nullable
    public static Object getScript(ResourceLocation scriptName) {
        System.out.println("Getting Script of " + scriptName.m_135827_() + " with name " + scriptName.m_135815_());
        return ScriptParser.SCRIPTCACHE.get(scriptName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<Extension> scanExtensions(Path extensionsPath) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(extensionsPath);){
            for (Path entry : stream) {
                Extension extension;
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    try {
                        extension = Extension.fromPath(entry);
                        if (extension == null) continue;
                        extensions.add(extension);
                        continue;
                    }
                    catch (Exception re) {
                        throw new InvalidExtensionException(entry, (Throwable)re);
                    }
                }
                if (!entry.toString().endsWith(".zip")) continue;
                try {
                    extension = Extension.fromZipPath(entry);
                    if (extension == null) continue;
                    extensions.add(extension);
                }
                catch (Exception re) {
                    throw new InvalidExtensionException(entry, (Throwable)re);
                    return extensions;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return extensions;
    }

    private static Set<String> getSoundEventNames(Path pathToJson) {
        HashSet<String> soundEventNames = new HashSet<String>();
        try {
            try (BufferedReader reader = Files.newBufferedReader(pathToJson);){
                JsonElement element = (JsonElement)new Gson().fromJson((Reader)reader, JsonElement.class);
                if (element != null && element.isJsonObject()) {
                    JsonObject jsonObject = element.getAsJsonObject();
                    soundEventNames.addAll(jsonObject.keySet());
                } else {
                    LOGGER.error("Content of the sounds file {} is not an object", (Object)pathToJson);
                }
            }
            return soundEventNames;
        }
        catch (IOException e) {
            LOGGER.error("Failed to load json file {}", (Object)pathToJson, (Object)e);
            throw new RuntimeException("Failed to load file " + String.valueOf(pathToJson) + ". Error: " + String.valueOf(e));
        }
    }

    private static Set<String> getSoundEventNamesFromZip(ZipFile zipFile, ZipEntry entry) {
        try {
            HashSet<String> soundEventNames;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));){
                JsonObject jsonObject = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                soundEventNames = new HashSet<String>(jsonObject.keySet());
            }
            return soundEventNames;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class Extension {
        private final String name;
        private Path path;
        private final String creativeTabIconItem;
        private List<ItemBuilder<?>> itemBuilders;
        private List<EffectBuilder<?, ?>> effectBuilders;
        private List<EntityBuilder<?, ?>> entityBuilders;
        private List<PlayerAnimationBuilder> playerAnimationBuilders;
        private Set<String> sounds;
        private Map<String, Supplier<SoundEvent>> registeredExtSounds;
        public Map<String, Supplier<Object>> clientScripts = new HashMap<String, Supplier<Object>>();

        public Extension(String name, Path path, String creativeTabIconItem) {
            this.name = name;
            this.path = path;
            this.creativeTabIconItem = creativeTabIconItem;
        }

        List<ItemBuilder<?>> getItemBuilders() {
            return Collections.unmodifiableList(this.itemBuilders);
        }

        List<EffectBuilder<?, ?>> getEffectBuilders() {
            return this.effectBuilders;
        }

        List<EntityBuilder<?, ?>> getEntityBuilders() {
            return this.entityBuilders;
        }

        Set<String> getSounds() {
            return Collections.unmodifiableSet(this.sounds);
        }

        List<PlayerAnimationBuilder> getPlayerAnimationBuilders() {
            return this.playerAnimationBuilders;
        }

        public String getName() {
            return this.name;
        }

        public String getCreativeTabIconItem() {
            return this.creativeTabIconItem;
        }

        static Extension fromPath(Path extPath) throws InvalidExtensionComponentException {
            Path extDescriptorPath = extPath.resolve("ext.json");
            if (Files.exists(extDescriptorPath, new LinkOption[0]) && Files.isRegularFile(extDescriptorPath, new LinkOption[0])) {
                try {
                    Extension var27;
                    try (BufferedReader reader = Files.newBufferedReader(extDescriptorPath);){
                        Path soundsPath;
                        Path effectsPath;
                        String scriptName;
                        DirectoryStream<Path> scriptFiles;
                        Extension extension = (Extension)new Gson().fromJson((Reader)reader, Extension.class);
                        extension.clientScripts = new HashMap<String, Supplier<Object>>();
                        extension.path = extPath;
                        extension.itemBuilders = new ArrayList();
                        extension.effectBuilders = new ArrayList();
                        extension.entityBuilders = new ArrayList();
                        extension.registeredExtSounds = new HashMap<String, Supplier<SoundEvent>>();
                        extension.playerAnimationBuilders = new ArrayList<PlayerAnimationBuilder>();
                        Path namespacePath = extPath.resolve("assets").resolve("pointblank");
                        Path itemsPath = namespacePath.resolve("items");
                        Path scriptsPath = namespacePath.resolve("scripts");
                        Path clientScriptsPath = scriptsPath.resolve("client");
                        if (Files.exists(scriptsPath, new LinkOption[0]) && Files.isDirectory(scriptsPath, new LinkOption[0])) {
                            scriptFiles = Files.newDirectoryStream(scriptsPath, "*.js");
                            try {
                                for (Path path : scriptFiles) {
                                    if (!path.getParent().endsWith("scripts")) continue;
                                    scriptName = path.getFileName().toString().replace(".js", "");
                                    ScriptParser.cacheScript(path, ResourceLocation.fromNamespaceAndPath((String)extension.name, (String)scriptName));
                                    PointBlankJelly.LOGGER.debug("Loaded script: {} from extension: {}", (Object)scriptName, (Object)extension.name);
                                }
                            }
                            finally {
                                if (scriptFiles != null) {
                                    scriptFiles.close();
                                }
                            }
                        }
                        if (Files.exists(clientScriptsPath, new LinkOption[0]) && Files.isDirectory(clientScriptsPath, new LinkOption[0])) {
                            scriptFiles = Files.newDirectoryStream(clientScriptsPath, "*.js");
                            try {
                                for (Path path : scriptFiles) {
                                    scriptName = path.getFileName().toString().replace(".js", "");
                                    extension.clientScripts.put(scriptName, () -> ScriptParser.getScript(scriptFile));
                                    PointBlankJelly.LOGGER.debug("Loaded client script: {} from extension: {}", (Object)scriptName, (Object)extension.name);
                                }
                            }
                            finally {
                                if (scriptFiles != null) {
                                    scriptFiles.close();
                                }
                            }
                        }
                        if (Files.exists(itemsPath, new LinkOption[0]) && Files.isDirectory(itemsPath, new LinkOption[0])) {
                            try (DirectoryStream<Path> itemFiles = Files.newDirectoryStream(itemsPath, "*.json");){
                                for (Path path : itemFiles) {
                                    extension.itemBuilders.add(ItemBuilder.fromPath(path, extension));
                                }
                            }
                        }
                        if (Files.exists(effectsPath = namespacePath.resolve("effects"), new LinkOption[0]) && Files.isDirectory(effectsPath, new LinkOption[0])) {
                            try (DirectoryStream<Path> effectFiles = Files.newDirectoryStream(effectsPath, "*.json");){
                                for (Path effectFile : effectFiles) {
                                    extension.effectBuilders.add(EffectBuilder.fromPath(effectFile));
                                }
                            }
                        }
                        extension.sounds = Files.exists(soundsPath = namespacePath.resolve("sounds.json"), new LinkOption[0]) && Files.isRegularFile(soundsPath, new LinkOption[0]) ? ExtensionRegistry.getSoundEventNames(soundsPath) : Collections.emptySet();
                        Path path = namespacePath.resolve("animations").resolve("player");
                        if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
                            try (DirectoryStream<Path> playerAnimationFiles = Files.newDirectoryStream(path, "*.animation.json");){
                                for (Path playerAnimationFile : playerAnimationFiles) {
                                    extension.playerAnimationBuilders.add(PlayerAnimationBuilder.fromPath(playerAnimationFile));
                                }
                            }
                        }
                        var27 = extension;
                    }
                    return var27;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to load extension from path {}. Error: {}", (Object)extPath, (Object)e);
                    return null;
                }
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static Extension fromZipPath(Path zipPath) throws InvalidExtensionComponentException {
            try (ZipFile zipFile = new ZipFile(zipPath.toFile());){
                ZipEntry extDescriptorEntry = zipFile.getEntry("ext.json");
                if (extDescriptorEntry == null) {
                    Extension extension = null;
                    return extension;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(extDescriptorEntry)));){
                    Extension extension = (Extension)new Gson().fromJson((Reader)reader, Extension.class);
                    extension.path = zipPath;
                    extension.clientScripts = new HashMap<String, Supplier<Object>>();
                    extension.itemBuilders = new ArrayList();
                    extension.effectBuilders = new ArrayList();
                    extension.entityBuilders = new ArrayList();
                    extension.registeredExtSounds = new HashMap<String, Supplier<SoundEvent>>();
                    extension.playerAnimationBuilders = new ArrayList<PlayerAnimationBuilder>();
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    Path scriptsPath = zipPath.resolve("assets/pointblank/scripts");
                    while (entries.hasMoreElements()) {
                        BufferedReader scriptreader;
                        ZipEntry entry = entries.nextElement();
                        if (entry.getName().startsWith("assets/pointblank/scripts/") && entry.getName().endsWith(".js")) {
                            scriptreader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));
                            try {
                                ScriptParser.cacheScript(scriptreader, ResourceLocation.fromNamespaceAndPath((String)extension.name, (String)entry.getName().replace("assets/pointblank/scripts/", "")));
                                continue;
                            }
                            finally {
                                scriptreader.close();
                                continue;
                            }
                        }
                        if (entry.getName().startsWith("assets/pointblank/scripts/client/") && entry.getName().endsWith(".js")) {
                            scriptreader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));
                            try {
                                extension.clientScripts.put(entry.getName().replace("assets/pointblank/scripts/client/", ""), () -> ScriptParser.getScript(scriptreader, entry.getName().replace("assets/pointblank/scripts/client/", "")));
                                continue;
                            }
                            finally {
                                scriptreader.close();
                                continue;
                            }
                        }
                        if (entry.getName().startsWith("assets/pointblank/items/") && entry.getName().endsWith(".json")) {
                            extension.itemBuilders.add(ItemBuilder.fromZipEntry(zipFile, entry, extension));
                            continue;
                        }
                        if (entry.getName().startsWith("assets/pointblank/effects/") && entry.getName().endsWith(".json")) {
                            extension.effectBuilders.add(EffectBuilder.fromZipEntry(zipFile, entry));
                            continue;
                        }
                        if (entry.getName().startsWith("assets/pointblank/entities/") && entry.getName().endsWith(".json")) {
                            extension.entityBuilders.add(EntityBuilder.fromZipEntry(zipFile, entry));
                            continue;
                        }
                        if (!entry.getName().startsWith("assets/pointblank/animations/player/") || !entry.getName().endsWith(".animation.json")) continue;
                        extension.playerAnimationBuilders.add(PlayerAnimationBuilder.fromZipEntry(zipFile, entry));
                    }
                    ZipEntry soundsEntry = zipFile.getEntry("assets/pointblank/sounds.json");
                    if (soundsEntry != null) {
                        extension.sounds = ExtensionRegistry.getSoundEventNamesFromZip(zipFile, soundsEntry);
                    }
                    Extension var7 = extension;
                    return var7;
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to load extension from ZIP {}. Error: {}", (Object)zipPath, (Object)e);
                return null;
            }
        }

        public String toString() {
            return "Extension{name='" + this.name + "', path=" + String.valueOf(this.path) + "}";
        }
    }
}

