/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.registry;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mod.pbj.PointBlankJelly;
import mod.pbj.feature.AccuracyFeature;
import mod.pbj.feature.ActiveMuzzleFeature;
import mod.pbj.feature.AdsSpeedFeature;
import mod.pbj.feature.AimingFeature;
import mod.pbj.feature.AmmoCapacityFeature;
import mod.pbj.feature.AttributeFeature;
import mod.pbj.feature.DamageFeature;
import mod.pbj.feature.DefenseFeature;
import mod.pbj.feature.DescriptionFeature;
import mod.pbj.feature.Feature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FireModeFeature;
import mod.pbj.feature.MuzzleFlashFeature;
import mod.pbj.feature.PartVisibilityFeature;
import mod.pbj.feature.PipFeature;
import mod.pbj.feature.RecoilFeature;
import mod.pbj.feature.ReloadFeature;
import mod.pbj.feature.ReticleFeature;
import mod.pbj.feature.SkinFeature;
import mod.pbj.feature.SoundFeature;
import mod.pbj.util.InternalFiles;
import net.minecraft.client.Minecraft;

public class FeatureTypeRegistry {
    private static int featureTypeId;
    private static final Map<Class<? extends Feature>, Integer> typeToId;
    private static final Map<Integer, Class<? extends Feature>> idToType;
    public static final Supplier<FeatureBuilder<?, ?>> AIMING;
    public static final Supplier<FeatureBuilder<?, ?>> PIP;
    public static final Supplier<FeatureBuilder<?, ?>> RETICLE;
    public static final Supplier<FeatureBuilder<?, ?>> MUZZLEFLASH;
    public static final Supplier<FeatureBuilder<?, ?>> PARTVISIBILITY;
    public static final Supplier<FeatureBuilder<?, ?>> RECOIL;
    public static final Supplier<FeatureBuilder<?, ?>> ACCURACY;
    public static final Supplier<FeatureBuilder<?, ?>> ACTIVEMUZZLE;
    public static final Supplier<FeatureBuilder<?, ?>> RELOAD;
    public static final Supplier<FeatureBuilder<?, ?>> AMMOCAPACITY;
    public static final Supplier<FeatureBuilder<?, ?>> DAMAGE;
    public static final Supplier<FeatureBuilder<?, ?>> SKIN;
    public static final Supplier<FeatureBuilder<?, ?>> SOUND;
    public static final Supplier<FeatureBuilder<?, ?>> FIREMODE;
    public static final Supplier<FeatureBuilder<?, ?>> DEFENSE;
    public static final Supplier<FeatureBuilder<?, ?>> ADSSPEED;
    public static final Supplier<FeatureBuilder<?, ?>> ATTRIBUTE;
    public static final Supplier<FeatureBuilder<?, ?>> DESCRIPTION;

    public static Supplier<FeatureBuilder<?, ?>> registerFeatureType(Class<? extends Feature> featureType, Supplier<FeatureBuilder<?, ?>> builderSupplier) {
        if (typeToId.put(featureType, ++featureTypeId) != null) {
            throw new IllegalArgumentException("Duplicate feature type: " + String.valueOf(featureType));
        }
        idToType.put(featureTypeId, featureType);
        return builderSupplier;
    }

    public static Map<Integer, Class<? extends Feature>> getFeatureTypes() {
        return Collections.unmodifiableMap(idToType);
    }

    public static Class<? extends Feature> getFeatureType(int featureTypeId) {
        return idToType.get(featureTypeId);
    }

    public static int getFeatureTypeId(Class<? extends Feature> featureType) {
        Integer id = typeToId.get(featureType);
        if (id == null) {
            throw new IllegalArgumentException("Feature type not registered: " + String.valueOf(featureType));
        }
        return id;
    }

    public static String writeConfig(Path configPath) {
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            Path f = Files.createFile(configPath, new FileAttribute[0]);
            Files.writeString(f, (CharSequence)"false", new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "false";
    }

    public static void init() {
        Path configPath = Minecraft.m_91087_().f_91069_.toPath().resolve("pointblank").resolve("overwrite.config");
        boolean allowBasePackOverwrite = false;
        try {
            allowBasePackOverwrite = Boolean.parseBoolean(Files.exists(configPath, new LinkOption[0]) ? Files.readString(configPath).trim() : FeatureTypeRegistry.writeConfig(configPath));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!allowBasePackOverwrite) {
            try {
                InternalFiles.copyFolder(PointBlankJelly.class.getResource("/base_pack").toURI(), Minecraft.m_91087_().f_91069_.toPath().resolve("pointblank").resolve("base_pack"));
                PointBlankJelly.LOGGER.info("Writing base_pack...");
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        typeToId = new HashMap<Class<? extends Feature>, Integer>();
        idToType = new HashMap<Integer, Class<? extends Feature>>();
        AIMING = FeatureTypeRegistry.registerFeatureType(AimingFeature.class, AimingFeature.Builder::new);
        PIP = FeatureTypeRegistry.registerFeatureType(PipFeature.class, PipFeature.Builder::new);
        RETICLE = FeatureTypeRegistry.registerFeatureType(ReticleFeature.class, ReticleFeature.Builder::new);
        MUZZLEFLASH = FeatureTypeRegistry.registerFeatureType(MuzzleFlashFeature.class, MuzzleFlashFeature.Builder::new);
        PARTVISIBILITY = FeatureTypeRegistry.registerFeatureType(PartVisibilityFeature.class, PartVisibilityFeature.Builder::new);
        RECOIL = FeatureTypeRegistry.registerFeatureType(RecoilFeature.class, RecoilFeature.Builder::new);
        ACCURACY = FeatureTypeRegistry.registerFeatureType(AccuracyFeature.class, AccuracyFeature.Builder::new);
        ACTIVEMUZZLE = FeatureTypeRegistry.registerFeatureType(ActiveMuzzleFeature.class, ActiveMuzzleFeature.Builder::new);
        RELOAD = FeatureTypeRegistry.registerFeatureType(ReloadFeature.class, ReloadFeature.Builder::new);
        AMMOCAPACITY = FeatureTypeRegistry.registerFeatureType(AmmoCapacityFeature.class, AmmoCapacityFeature.Builder::new);
        DAMAGE = FeatureTypeRegistry.registerFeatureType(DamageFeature.class, DamageFeature.Builder::new);
        SKIN = FeatureTypeRegistry.registerFeatureType(SkinFeature.class, SkinFeature.Builder::new);
        SOUND = FeatureTypeRegistry.registerFeatureType(SoundFeature.class, SoundFeature.Builder::new);
        FIREMODE = FeatureTypeRegistry.registerFeatureType(FireModeFeature.class, FireModeFeature.Builder::new);
        DEFENSE = FeatureTypeRegistry.registerFeatureType(DefenseFeature.class, DefenseFeature.Builder::new);
        ADSSPEED = FeatureTypeRegistry.registerFeatureType(AdsSpeedFeature.class, AdsSpeedFeature.Builder::new);
        ATTRIBUTE = FeatureTypeRegistry.registerFeatureType(AttributeFeature.class, AttributeFeature.Builder::new);
        DESCRIPTION = FeatureTypeRegistry.registerFeatureType(DescriptionFeature.class, DescriptionFeature.Builder::new);
    }
}

