/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.script;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Arrays;
import java.util.function.Consumer;
import mod.pbj.PointBlankJelly;
import mod.pbj.network.ClientBoundScriptInvoker;
import mod.pbj.network.Network;
import mod.pbj.network.ServerBoundScriptInvoker;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.network.PacketDistributor;

public final class Scripts {
    public static void runFunctionOnServer(PacketContext context) {
        Network.networkChannel.sendToServer((Object)new ServerBoundScriptInvoker(context));
    }

    public static void runFunctionOnClient(String functionName, ItemStack stack, ServerPlayer player) {
        Network.networkChannel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientBoundScriptInvoker(functionName, stack));
    }

    public static <E extends Event> void registerEvent(Consumer<E> event, Class<E> register, boolean forge) {
        if (forge) {
            MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, true, register, event);
        } else {
            PointBlankJelly.modEventBus.addListener(EventPriority.NORMAL, true, register, event);
        }
    }

    public static <E extends Event> void registerForgeEvent(Consumer<E> event, Class<E> register) {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, true, register, event);
    }

    public static <E extends Event> void registerModEvent(Consumer<E> event, Class<E> register) {
        PointBlankJelly.modEventBus.addListener(EventPriority.NORMAL, true, register, event);
    }

    public record PacketContext(String staticMethod, Object[] MethodArgs) {
        public static final Gson gson = new GsonBuilder().create();

        public JsonObject serialize() {
            JsonObject obj = new JsonObject();
            obj.addProperty("staticMethod", this.staticMethod);
            JsonArray args = new JsonArray();
            for (Object methodArg : this.MethodArgs) {
                JsonObject value;
                if (!Type.hasCodec(methodArg)) continue;
                switch (methodArg.getClass().getSimpleName().toLowerCase()) {
                    case "itemstack": {
                        JsonObject jsonObject = ItemStack.f_41582_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((ItemStack)methodArg)).result().orElse(null);
                        break;
                    }
                    case "integer": {
                        JsonObject jsonObject = Codec.INT.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((Integer)methodArg)).result().orElse(null);
                        break;
                    }
                    case "long": {
                        JsonObject jsonObject = Codec.LONG.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((Long)methodArg)).result().orElse(null);
                        break;
                    }
                    case "float": {
                        JsonObject jsonObject = Codec.FLOAT.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)Float.valueOf(((Float)methodArg).floatValue())).result().orElse(null);
                        break;
                    }
                    case "double": {
                        JsonObject jsonObject = Codec.DOUBLE.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((Double)methodArg)).result().orElse(null);
                        break;
                    }
                    case "boolean": {
                        JsonObject jsonObject = Codec.BOOL.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((Boolean)methodArg)).result().orElse(null);
                        break;
                    }
                    case "compoundtag": {
                        JsonObject jsonObject = CompoundTag.f_128325_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((CompoundTag)methodArg)).result().orElse(null);
                        break;
                    }
                    case "jsonobject": {
                        JsonObject jsonObject = (JsonObject)methodArg;
                        break;
                    }
                    case "jsonelement": {
                        JsonObject jsonObject = (JsonElement)methodArg;
                        break;
                    }
                    case "jsonarray": {
                        JsonObject jsonObject = (JsonArray)methodArg;
                        break;
                    }
                    case "jsonprimitive": {
                        JsonObject jsonObject = (JsonPrimitive)methodArg;
                        break;
                    }
                    case "jsonnull": {
                        JsonObject jsonObject = (JsonNull)methodArg;
                        break;
                    }
                    default: {
                        JsonObject jsonObject = value = null;
                    }
                }
                if (value == null && methodArg.getClass().getSimpleName().equalsIgnoreCase("player") || methodArg.getClass().getSimpleName().equalsIgnoreCase("localplayer")) {
                    JsonObject oj = new JsonObject();
                    oj.addProperty("type", "player");
                    args.add((JsonElement)oj);
                }
                if (value == null) continue;
                JsonObject argObj = new JsonObject();
                argObj.addProperty("type", methodArg.getClass().getSimpleName());
                argObj.add("value", (JsonElement)value);
                args.add((JsonElement)argObj);
            }
            obj.add("arguments", (JsonElement)args);
            PointBlankJelly.LOGGER.debug("Serialized PacketContext w/ JsonObject = {}", (Object)obj);
            return obj;
        }

        public static PacketContext deserialize(JsonObject obj) {
            var packetMedium = new Object(){
                String staticMethod = null;
                Object[] args = null;
            };
            packetMedium.staticMethod = obj.get("staticMethod").getAsString();
            if (obj.has("arguments")) {
                JsonArray argArr = obj.getAsJsonArray("arguments");
                packetMedium.args = new Object[argArr.size()];
                int i = 0;
                for (JsonElement arge : argArr) {
                    JsonObject arg = arge.getAsJsonObject();
                    Type type = Type.valueOf(arg.get("type").getAsString().toUpperCase());
                    Object val = type.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)arg.get("value")).result().orElse(null);
                    packetMedium.args[i] = val;
                    ++i;
                }
            }
            PacketContext ctx = new PacketContext(packetMedium.staticMethod, packetMedium.args);
            PointBlankJelly.LOGGER.debug("Deserialized PacketContext = {}", (Object)ctx.toString());
            return ctx;
        }

        @Override
        public String toString() {
            return "PacketContext{staticMethod='" + this.staticMethod + "', MethodArgs=" + Arrays.toString(this.MethodArgs) + "}";
        }

        private static enum Type {
            ITEMSTACK(ItemStack.f_41582_),
            BOOLEAN((Codec<?>)Codec.BOOL),
            INTEGER((Codec<?>)Codec.INT),
            LONG((Codec<?>)Codec.LONG),
            FLOAT((Codec<?>)Codec.FLOAT),
            DOUBLE((Codec<?>)Codec.DOUBLE),
            COMPOUNDTAG(CompoundTag.f_128325_);

            public final Codec<?> codec;

            private Type(Codec<?> type) {
                this.codec = type;
            }

            public static boolean hasCodec(Object obj) {
                for (Type value : Type.values()) {
                    if (!value.name().equalsIgnoreCase(obj.getClass().getSimpleName())) continue;
                    return true;
                }
                return false;
            }
        }
    }
}

