/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mod.pbj.attachment.Attachment;
import mod.pbj.attachment.AttachmentCategory;
import mod.pbj.attachment.Attachments;
import mod.pbj.feature.ConditionContext;
import mod.pbj.item.FireModeInstance;
import mod.pbj.item.GunItem;
import mod.pbj.util.Expression;
import mod.pbj.util.JsonUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class Conditions {
    public static final Predicate<ConditionContext> RANDOM_PICK = ctx -> ctx.randomSample2() == ctx.randomSample1();

    public static Predicate<ConditionContext> isGunOnGround() {
        return ctx -> ctx.itemDisplayContext() == ItemDisplayContext.GROUND;
    }

    public static Predicate<ConditionContext> aiming() {
        return ctx -> ctx.rootStack().m_41784_().m_128471_("aim");
    }

    public static Predicate<ConditionContext> isGunInHands() {
        return ctx -> ctx.itemDisplayContext() != ItemDisplayContext.GROUND;
    }

    public static Predicate<ConditionContext> selectedFireMode(String fireModeName) {
        return ctx -> {
            if (ctx.rootStack() == null) {
                return false;
            }
            FireModeInstance fireModeInstance = GunItem.getFireModeInstance(ctx.rootStack());
            return fireModeInstance != null && Objects.equals(fireModeInstance.getName().toUpperCase(Locale.ROOT), fireModeName.toUpperCase(Locale.ROOT));
        };
    }

    public static Predicate<ConditionContext> unselectedFireMode(String fireModeName) {
        return Conditions.selectedFireMode(fireModeName).negate();
    }

    public static Predicate<ConditionContext> isUsingDefaultMuzzle() {
        return ctx -> {
            if (ctx.rootStack() == null) {
                return false;
            }
            FireModeInstance fireModeInstance = GunItem.getFireModeInstance(ctx.rootStack());
            return fireModeInstance == null || fireModeInstance.isUsingDefaultMuzzle();
        };
    }

    public static Predicate<ConditionContext> hasAmmoCount(int ammoCount) {
        return ctx -> ammoCount == ctx.gunClientState().getAmmoCount(GunItem.getFireModeInstance(ctx.rootStack()));
    }

    public static Predicate<ConditionContext> onReloadIteration(int index) {
        return ctx -> index == ctx.gunClientState().getReloadIterationIndex();
    }

    public static Predicate<ConditionContext> onEmptyReload() {
        return ctx -> ctx.gunClientState().getReloadIterationIndex() == 0;
    }

    public static Predicate<ConditionContext> onNonEmptyReload() {
        return ctx -> ctx.gunClientState().getReloadIterationIndex() > 0;
    }

    public static Predicate<ConditionContext> beforePreparingReload() {
        return Conditions.onReloadIteration(-1);
    }

    public static Predicate<ConditionContext> afterPreparingReload() {
        return ctx -> ctx.gunClientState().getReloadIterationIndex() >= 0;
    }

    public static Predicate<ConditionContext> hasAttachment(Supplier<? extends Attachment> attachmentSupplier) {
        return ctx -> {
            String var10001;
            NavigableMap<String, ItemStack> attachments = Attachments.getAttachments(ctx.currentItemStack(), false);
            return attachments.get("//" + (var10001 = ((Attachment)attachmentSupplier.get()).getName())) != null;
        };
    }

    public static Predicate<ConditionContext> doesNotHaveAttachment(Supplier<? extends Attachment> attachmentSupplier) {
        return Conditions.hasAttachment(attachmentSupplier).negate();
    }

    public static Predicate<ConditionContext> hasAttachment(String attachmentName) {
        return ctx -> {
            NavigableMap<String, ItemStack> attachments = Attachments.getAttachments(ctx.currentItemStack(), false);
            return attachments.get("//" + attachmentName) != null;
        };
    }

    public static Predicate<ConditionContext> doesNotHaveAttachment(String attachmentName) {
        return Conditions.hasAttachment(attachmentName).negate();
    }

    public static Predicate<ConditionContext> hasAttachmentGroup(String attachmentGroup) {
        return ctx -> Attachments.getAttachmentGroups(ctx.currentItemStack()).containsKey(attachmentGroup);
    }

    public static Predicate<ConditionContext> doesNotHaveAttachmentGroup(String attachmentGroup) {
        return Conditions.hasAttachmentGroup(attachmentGroup).negate();
    }

    public static Predicate<ConditionContext> hasAttachmentAtPathPrefix(String prefix) {
        return ctx -> {
            NavigableMap<String, ItemStack> attachments = Attachments.getAttachments(ctx.currentItemStack(), true);
            String key = attachments.ceilingKey(prefix);
            return key != null && key.startsWith(prefix);
        };
    }

    public static Predicate<ConditionContext> doesNotHaveAttachmentAtPathPrefix(String prefix) {
        return Conditions.hasAttachmentAtPathPrefix(prefix).negate();
    }

    public static Predicate<ConditionContext> hasAttachmentInCategory(AttachmentCategory category) {
        return ctx -> {
            NavigableMap<String, ItemStack> attachments = Attachments.getAttachmentsForCategory(ctx.currentItemStack(), category);
            return !attachments.isEmpty();
        };
    }

    public static Predicate<ConditionContext> doesNotHaveAttachmentInCategory(AttachmentCategory category) {
        return Conditions.hasAttachmentInCategory(category).negate();
    }

    public static Predicate<ConditionContext> hasAttachmentInCategoryAtPathPrefix(AttachmentCategory category, String prefix) {
        return ctx -> {
            NavigableMap<String, ItemStack> attachments = Attachments.getAttachments(ctx.currentItemStack(), true);
            SortedMap<String, ItemStack> tm = attachments.tailMap(prefix);
            boolean result = false;
            for (Map.Entry<String, ItemStack> e : tm.entrySet()) {
                Attachment a;
                Item patt6536$temp;
                if (!e.getKey().startsWith(prefix) || !((patt6536$temp = e.getValue().m_41720_()) instanceof Attachment) || (a = (Attachment)patt6536$temp).getCategory() != category) continue;
                result = true;
            }
            return result;
        };
    }

    public static Predicate<ConditionContext> doesNotHaveAttachmentInCategoryAtPathPrefix(AttachmentCategory category, String prefix) {
        return Conditions.hasAttachmentInCategoryAtPathPrefix(category, prefix).negate();
    }

    public static Predicate<ConditionContext> fromJson(JsonElement element) {
        if (element == null) {
            return ctx -> true;
        }
        if (element.isJsonPrimitive()) {
            String expr = element.getAsString();
            return expr.trim().equalsIgnoreCase("random") ? RANDOM_PICK : Expression.compile(expr);
        }
        JsonObject obj = element.getAsJsonObject();
        if (obj.has("anyOf")) {
            JsonArray conditions = obj.getAsJsonArray("anyOf");
            Predicate<ConditionContext> predicate = ctx -> false;
            for (JsonElement condition : conditions) {
                predicate = predicate.or(Conditions.fromJson((JsonElement)condition.getAsJsonObject()));
            }
            return predicate;
        }
        if (!obj.has("allOf")) {
            if (obj.has("not")) {
                return Conditions.fromJson((JsonElement)obj.getAsJsonObject("not")).negate();
            }
            if (obj.has("hasAttachment")) {
                return Conditions.hasAttachment(JsonUtil.getJsonString(obj, "hasAttachment"));
            }
            if (obj.has("doesNotHaveAttachment")) {
                return Conditions.doesNotHaveAttachment(JsonUtil.getJsonString(obj, "doesNotHaveAttachment"));
            }
            if (obj.has("hasAttachmentAtPathPrefix")) {
                return Conditions.hasAttachmentAtPathPrefix(JsonUtil.getJsonString(obj, "hasAttachmentAtPathPrefix"));
            }
            if (obj.has("doesNotHaveAttachmentAtPathPrefix")) {
                return Conditions.doesNotHaveAttachmentAtPathPrefix(JsonUtil.getJsonString(obj, "doesNotHaveAttachmentAtPathPrefix"));
            }
            if (obj.has("hasAttachmentGroup")) {
                return Conditions.hasAttachmentGroup(JsonUtil.getJsonString(obj, "hasAttachmentGroup"));
            }
            if (obj.has("doesNotHaveAttachmentGroup")) {
                return Conditions.doesNotHaveAttachmentGroup(JsonUtil.getJsonString(obj, "doesNotHaveAttachmentGroup"));
            }
            if (obj.has("hasAttachmentInCategory")) {
                return Conditions.hasAttachmentInCategory(AttachmentCategory.fromString(JsonUtil.getJsonString(obj, "hasAttachmentInCategory")));
            }
            if (obj.has("doesNotHaveAttachmentInCategory")) {
                return Conditions.doesNotHaveAttachmentInCategory(AttachmentCategory.fromString(JsonUtil.getJsonString(obj, "doesNotHaveAttachmentInCategory")));
            }
            if (obj.has("selectedFireMode")) {
                return Conditions.selectedFireMode(JsonUtil.getJsonString(obj, "selectedFireMode"));
            }
            if (obj.has("unselectedFireMode")) {
                return Conditions.unselectedFireMode(JsonUtil.getJsonString(obj, "unselectedFireMode"));
            }
            if (obj.has("isGunInHands")) {
                boolean isGunInHands = JsonUtil.getJsonBoolean(obj, "isGunInHands", true);
                return isGunInHands ? Conditions.isGunInHands() : Conditions.isGunOnGround();
            }
            if (obj.has("isGunOnGround")) {
                boolean isGunOnGround = JsonUtil.getJsonBoolean(obj, "isGunOnGround", false);
                return isGunOnGround ? Conditions.isGunOnGround() : Conditions.isGunInHands();
            }
            if (obj.has("isUsingDefaultMuzzle")) {
                boolean isUsingDefaultMuzzle = JsonUtil.getJsonBoolean(obj, "isUsingDefaultMuzzle", true);
                return isUsingDefaultMuzzle ? Conditions.isUsingDefaultMuzzle() : Conditions.isUsingDefaultMuzzle().negate();
            }
            if (obj.has("aiming")) {
                boolean isAiming = obj.get("aiming").getAsBoolean();
                return isAiming ? Conditions.aiming() : Predicate.not(Conditions.aiming());
            }
            if (obj.has("onEmptyReload")) {
                boolean value = JsonUtil.getJsonBoolean(obj, "onEmptyReload", true);
                return value ? Conditions.onEmptyReload() : Conditions.onNonEmptyReload();
            }
            if (obj.has("ammoCount")) {
                int value = JsonUtil.getJsonInt(obj, "ammoCount");
                return Conditions.hasAmmoCount(value);
            }
            throw new IllegalArgumentException("Unknown condition in JSON: " + String.valueOf(obj));
        }
        JsonArray conditions = obj.getAsJsonArray("allOf");
        Predicate<ConditionContext> predicate = ctx -> true;
        for (JsonElement condition : conditions) {
            predicate = predicate.and(Conditions.fromJson(condition));
        }
        return predicate;
    }
}

