/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.util;

import java.util.LinkedList;
import java.util.WeakHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class HitboxHelper {
    private static final WeakHashMap<Player, LinkedList<Vec3>> PLAYER_POSITION = new WeakHashMap();
    private static final WeakHashMap<Player, LinkedList<AABB>> PLAYER_HITBOXES = new WeakHashMap();
    private static final WeakHashMap<Player, LinkedList<Vec3>> PLAYER_VELOCITY = new WeakHashMap();
    private static final int SAVE_TICK = Mth.m_14107_((double)20.5);

    public static void onPlayerTick(Player player) {
        if (player.m_5833_()) {
            PLAYER_POSITION.remove(player);
            PLAYER_HITBOXES.remove(player);
            PLAYER_VELOCITY.remove(player);
        } else {
            LinkedList positions = PLAYER_POSITION.computeIfAbsent(player, p -> new LinkedList());
            LinkedList boxes = PLAYER_HITBOXES.computeIfAbsent(player, p -> new LinkedList());
            LinkedList velocities = PLAYER_VELOCITY.computeIfAbsent(player, p -> new LinkedList());
            positions.addFirst(player.m_20182_());
            boxes.addFirst(player.m_20191_());
            velocities.addFirst(HitboxHelper.getPlayerVelocity(player));
            if (positions.size() > 2) {
                positions.removeLast();
            }
            if (boxes.size() > SAVE_TICK) {
                boxes.removeLast();
                velocities.removeLast();
            }
        }
    }

    public static void onPlayerLoggedOut(Player player) {
        PLAYER_POSITION.remove(player);
        PLAYER_HITBOXES.remove(player);
        PLAYER_VELOCITY.remove(player);
    }

    public static Vec3 getPlayerVelocity(Player entity) {
        LinkedList positions = PLAYER_POSITION.computeIfAbsent(entity, player -> new LinkedList());
        if (positions.size() > 1) {
            Vec3 currPos = (Vec3)positions.getFirst();
            Vec3 prevPos = (Vec3)positions.getLast();
            return new Vec3(currPos.f_82479_ - prevPos.f_82479_, currPos.f_82480_ - prevPos.f_82480_, currPos.f_82481_ - prevPos.f_82481_);
        }
        return new Vec3(0.0, 0.0, 0.0);
    }

    public static AABB getBoundingBox(Player entity, int ping) {
        if (PLAYER_HITBOXES.containsKey(entity)) {
            LinkedList<AABB> boxes = PLAYER_HITBOXES.get(entity);
            int index = Mth.m_14045_((int)ping, (int)0, (int)(boxes.size() - 1));
            return boxes.get(index);
        }
        return entity.m_20191_();
    }

    public static Vec3 getVelocity(Player entity, int ping) {
        if (PLAYER_VELOCITY.containsKey(entity)) {
            LinkedList<Vec3> velocities = PLAYER_VELOCITY.get(entity);
            int index = Mth.m_14045_((int)ping, (int)0, (int)(velocities.size() - 1));
            return velocities.get(index);
        }
        return HitboxHelper.getPlayerVelocity(entity);
    }

    public static AABB getFixedBoundingBox(Entity entity, Entity owner) {
        AABB boundingBox = entity.m_20191_();
        Vec3 velocity = new Vec3(entity.m_20185_() - entity.f_19790_, entity.m_20186_() - entity.f_19791_, entity.m_20189_() - entity.f_19792_);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (owner instanceof ServerPlayer) {
                ServerPlayer serverPlayerOwner = (ServerPlayer)owner;
                int ping = Mth.m_14107_((double)((double)serverPlayerOwner.f_8943_ / 1000.0 * 20.0 + 0.5));
                boundingBox = HitboxHelper.getBoundingBox((Player)player, ping);
                velocity = HitboxHelper.getVelocity((Player)player, ping);
            }
        }
        double expandHeight = entity instanceof Player && !entity.m_6047_() ? 0.0625 : 0.0;
        boundingBox = boundingBox.m_82363_(0.0, expandHeight, 0.0);
        boundingBox = boundingBox.m_82363_(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        double playerHitboxOffset = 3.0;
        if (entity instanceof ServerPlayer) {
            if (entity.m_20202_() != null) {
                boundingBox = boundingBox.m_82383_(velocity.m_82542_(playerHitboxOffset / 2.0, playerHitboxOffset / 2.0, playerHitboxOffset / 2.0));
            }
            boundingBox = boundingBox.m_82383_(velocity.m_82542_(playerHitboxOffset, playerHitboxOffset, playerHitboxOffset));
        }
        if (entity.m_20202_() != null) {
            boundingBox = boundingBox.m_82383_(velocity.m_82542_(-2.5, -2.5, -2.5));
        }
        boundingBox = boundingBox.m_82383_(velocity.m_82542_(-5.0, -5.0, -5.0));
        return boundingBox;
    }
}

