/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mod.pbj.PointBlankJelly;
import org.apache.commons.io.FileUtils;

public final class InternalFiles {
    private InternalFiles() {
    }

    public static void copyModFile(String srcPath, Path root, String path) {
        URL url = PointBlankJelly.class.getResource(srcPath);
        try {
            if (url != null) {
                FileUtils.copyURLToFile((URL)url, (File)root.resolve(path).toFile());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyModDirectory(Class<?> resourceClass, String srcPath, Path root, String path) {
        URL url = resourceClass.getResource(srcPath);
        try {
            if (url != null) {
                InternalFiles.copyFolder(url.toURI(), root.resolve(path));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyModDirectory(String srcPath, Path root, String path) {
        InternalFiles.copyModDirectory(PointBlankJelly.class, srcPath, root, path);
    }

    @Nullable
    public static InputStream readModFile(String filePath) {
        URL url = PointBlankJelly.class.getResource(filePath);
        try {
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void copyFolder(URI sourceURI, Path targetPath) throws IOException {
        if (Files.isDirectory(targetPath, new LinkOption[0])) {
            InternalFiles.deleteFiles(targetPath);
        }
        try (Stream<Path> stream = Files.walk(Paths.get(sourceURI), Integer.MAX_VALUE, new FileVisitOption[0]);){
            stream.forEach(source -> {
                Path target = targetPath.resolve(sourceURI.relativize(source.toUri()).toString());
                try {
                    if (Files.isDirectory(source, new LinkOption[0])) {
                        Files.createDirectories(target, new FileAttribute[0]);
                    } else {
                        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public static void deleteFiles(Path targetPath) throws IOException {
        Files.walkFileTree(targetPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

