/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.util;

import java.util.Optional;
import java.util.UUID;
import mod.pbj.item.GunItem;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.joml.Quaternionf;

public class MiscUtil {
    private static final double EPSILON = 1.0E-8;
    public static final FriendlyByteBuf.Writer<Vec3> VEC3_WRITER = (buf, vec3) -> {
        buf.writeDouble(vec3.f_82479_);
        buf.writeDouble(vec3.f_82480_);
        buf.writeDouble(vec3.f_82481_);
    };
    public static final FriendlyByteBuf.Reader<Vec3> VEC3_READER = buf -> new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());

    public static boolean isNearlyZero(double value) {
        return Math.abs(value) < 1.0E-8;
    }

    public static boolean isGreaterThanZero(double value) {
        return value > 1.0E-8;
    }

    public static Level getLevel(Entity entity) {
        return entity.m_9236_();
    }

    public static boolean isClientSide(Entity entity) {
        return entity.m_9236_().f_46443_;
    }

    public LivingEntity asLivingEntity(Entity entity) {
        PartEntity entityPart;
        Entity var5;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        if (entity instanceof PartEntity && (var5 = (entityPart = (PartEntity)entity).getParent()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)var5;
            return livingEntity;
        }
        return null;
    }

    public static boolean isProtected(Entity entity) {
        return entity instanceof Cat || entity instanceof Ocelot;
    }

    public static Optional<GunItem> getMainHeldGun(LivingEntity entity) {
        ItemStack itemStack = entity.m_21205_();
        return itemStack != null && itemStack.m_41720_() instanceof GunItem ? Optional.of((GunItem)itemStack.m_41720_()) : Optional.empty();
    }

    public static Quaternionf getRotation(Direction face) {
        Quaternionf quaternionf = null;
        switch (face) {
            case DOWN: {
                quaternionf = new Quaternionf().rotationXYZ(1.5707964f, 0.0f, 0.0f);
                break;
            }
            case UP: {
                break;
            }
            case NORTH: 
            case SOUTH: {
                quaternionf = new Quaternionf().rotationXYZ(0.0f, 0.0f, 1.5707964f);
                break;
            }
            case WEST: 
            case EAST: {
                quaternionf = new Quaternionf().rotationXYZ(0.0f, 1.5707964f, 0.0f);
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return quaternionf;
    }

    public static double timeToTravel(double initialSpeed, double acceleration, double distance) {
        if (acceleration == 0.0) {
            return distance / initialSpeed;
        }
        double a = 0.5 * acceleration;
        double c = -distance;
        double discriminant = initialSpeed * initialSpeed - 4.0 * a * c;
        return discriminant < 0.0 ? -1.0 : (-initialSpeed + Math.sqrt(discriminant)) / (2.0 * a);
    }

    public static double adjustDivisor(double dividend, double divisor) {
        if (divisor == 0.0) {
            throw new IllegalArgumentException("Divisor cannot be zero.");
        }
        double quotient = dividend / divisor;
        long roundedQuotient = Math.round(quotient);
        return dividend / (double)roundedQuotient;
    }

    public static UUID getTagId(CompoundTag tag) {
        return tag != null ? new UUID(tag.m_128454_("mid"), tag.m_128454_("lid")) : null;
    }

    public static UUID getItemStackId(ItemStack itemStack) {
        CompoundTag idTag = itemStack.m_41783_();
        return MiscUtil.getTagId(idTag);
    }
}

