/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.util;

import com.eliotlash.mclib.math.IValue;
import com.eliotlash.mclib.math.functions.Function;

public final class MolangFunctions {

    public static class InOutQuart
    extends Function {
        public InOutQuart(IValue[] values, String name) throws Exception {
            super(values, name);
        }

        public int getRequiredArguments() {
            return 1;
        }

        public double get() {
            double x = this.getArg(0);
            return x < 0.5 ? 8.0 * x * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 4.0) / 2.0;
        }
    }

    public static class OutBackEasing
    extends Function {
        public OutBackEasing(IValue[] values, String name) throws Exception {
            super(values, name);
        }

        public int getRequiredArguments() {
            return 1;
        }

        public double get() {
            double x = this.getArg(0);
            double c1 = 1.70158;
            double c3 = c1 + 1.0;
            return 1.0 + c3 * Math.pow(x - 1.0, 3.0) + c1 * Math.pow(x - 1.0, 2.0);
        }
    }

    public static class BounceEasing
    extends Function {
        public BounceEasing(IValue[] values, String name) throws Exception {
            super(values, name);
        }

        public int getRequiredArguments() {
            return 1;
        }

        public double get() {
            double x = Math.pow(this.getArg(0), 3.0);
            double c4 = 2.0943951023931953;
            return x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : Math.pow(2.0, -10.0 * x) * Math.sin((x * 10.0 - 0.75) * 2.0943951023931953) + 1.0);
        }
    }
}

