/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.util;

import java.util.Random;
import mod.pbj.client.effect.EffectBuilder;
import mod.pbj.util.SimpleHitResult;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import software.bernie.geckolib.util.ClientUtils;

public class ParticleValueProviders {

    public static interface ParticleWidthProvider {
        public float getWidth(EffectBuilder.Context var1);
    }

    public static interface ParticleCountProvider {
        public int getCount(EffectBuilder.Context var1);
    }

    public static class BoundingBoxBasedParticleWidthProvider
    implements ParticleWidthProvider {
        private final double maxBoundBoxSize;
        private final double maxWidth;

        public BoundingBoxBasedParticleWidthProvider(double maxBoundBoxSize, double maxWidth) {
            this.maxBoundBoxSize = maxBoundBoxSize;
            this.maxWidth = maxWidth;
        }

        @Override
        public float getWidth(EffectBuilder.Context effectContext) {
            float result = (float)this.maxWidth;
            HitResult hitResult = effectContext.getHitResult();
            if (hitResult instanceof SimpleHitResult) {
                AABB bb;
                SimpleHitResult simpleHitResult = (SimpleHitResult)hitResult;
                int entityId = simpleHitResult.getEntityId();
                Entity entity = ClientUtils.getLevel().m_6815_(entityId);
                if (entity != null && (bb = entity.m_20191_()) != null) {
                    result = (float)Mth.m_14008_((double)(this.maxWidth * bb.m_82309_() / this.maxBoundBoxSize), (double)0.0, (double)this.maxWidth);
                }
            }
            return result;
        }
    }

    public static class DamageBasedParticleCountProvider
    implements ParticleCountProvider {
        private final int maxCount;
        private final float maxDamage;

        public DamageBasedParticleCountProvider(int maxCount, float maxDamage) {
            this.maxCount = maxCount;
            this.maxDamage = maxDamage;
        }

        @Override
        public int getCount(EffectBuilder.Context effectContext) {
            float damage = effectContext.getDamage();
            return Math.round(Mth.m_14036_((float)((float)this.maxCount * damage / this.maxDamage), (float)0.0f, (float)this.maxCount));
        }
    }

    public static class RandomParticleCountProvider
    implements ParticleCountProvider {
        private final Random random = new Random();
        private final int origin;
        private final int bound;

        public RandomParticleCountProvider(int origin, int bound) {
            this.origin = origin;
            this.bound = bound;
        }

        @Override
        public int getCount(EffectBuilder.Context effectContext) {
            return this.random.nextInt(this.origin, this.bound);
        }
    }

    public static class ConstantParticleCountProvider
    implements ParticleCountProvider {
        private final int count;

        public ConstantParticleCountProvider(int count) {
            this.count = count;
        }

        @Override
        public int getCount(EffectBuilder.Context effectContext) {
            return this.count;
        }
    }
}

