/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.textures;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.textures.PixelContext;
import net.mehvahdjukaar.moonlight.api.resources.textures.Sampler2D;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureOps;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.client.resources.metadata.animation.AnimationFrame;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Rotation;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextureImage
implements AutoCloseable,
Sampler2D {
    @Nullable
    private final McMetaFile metadata;
    private final NativeImage image;
    private final FrameSize frameSize;
    private final int frameCount;
    private final int frameScale;

    public static TextureImage open(ResourceManager manager, ResourceLocation relativePath) throws IOException {
        try {
            if (relativePath.getPath().endsWith(".png")) {
                relativePath = relativePath.withPath(relativePath.getPath().substring(0, relativePath.getPath().length() - 4));
            }
            ResourceLocation textureLoc = ResType.TEXTURES.getPath(relativePath);
            NativeImage i = SpriteUtils.readImage(manager, textureLoc);
            ResourceLocation metadataLoc = ResType.MCMETA.getPath(relativePath);
            McMetaFile metadata = null;
            Optional res = manager.getResource(metadataLoc);
            if (res.isPresent()) {
                try {
                    metadata = McMetaFile.read((Resource)res.get());
                }
                catch (Exception e) {
                    throw new IOException("Failed to open texture at location " + String.valueOf(relativePath) + ": failed to read mcmeta file", e);
                }
            }
            return TextureImage.of(i, metadata);
        }
        catch (Exception e) {
            throw new IOException("Failed to open texture at location " + String.valueOf(relativePath) + ": no such file");
        }
    }

    public static TextureImage createNew(int width, int height) {
        return TextureImage.createNew(width, height, (McMetaFile)null);
    }

    public static TextureImage createNew(int width, int height, @Nullable McMetaFile metadata) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height must be positive integers");
        }
        TextureImage v = new TextureImage(new NativeImage(width, height, false), metadata);
        v.clear();
        return v;
    }

    public static TextureImage of(NativeImage image) {
        return TextureImage.of(image, (McMetaFile)null);
    }

    public static TextureImage of(NativeImage image, @Nullable McMetaFile metadata) {
        return new TextureImage(image, metadata);
    }

    private TextureImage(NativeImage image, @Nullable McMetaFile metadata) {
        this.image = image;
        this.metadata = metadata;
        int imgWidth = this.imageWidth();
        int imgHeight = this.imageHeight();
        this.frameSize = metadata == null || metadata.hasEmptyAnimation() ? new FrameSize(imgWidth, imgHeight) : metadata.animation().calculateFrameSize(imgWidth, imgHeight);
        this.frameScale = imgWidth / this.frameSize.width();
        int frameScaleHeight = imgHeight / this.frameSize.height();
        this.frameCount = this.frameScale * frameScaleHeight;
    }

    public int imageWidth() {
        return this.image.getWidth();
    }

    public int imageHeight() {
        return this.image.getHeight();
    }

    public int frameCount() {
        return this.frameCount;
    }

    public int frameWidth() {
        return this.frameSize.width();
    }

    public int frameHeight() {
        return this.frameSize.height();
    }

    public McMetaFile getMcMeta() {
        return this.metadata;
    }

    @ApiStatus.Internal
    public NativeImage getImage() {
        return this.image;
    }

    public int getFrameStartX(int frameIndex) {
        return frameIndex % this.frameScale * this.frameWidth();
    }

    public int getFrameStartY(int frameIndex) {
        return frameIndex / this.frameScale * this.frameHeight();
    }

    public int getFramePixel(int frameIndex, int x, int y) {
        return this.image.getPixelRGBA(this.getFrameStartX(frameIndex) + x, this.getFrameStartY(frameIndex) + y);
    }

    public int getPixel(int x, int y) {
        return this.image.getPixelRGBA(x, y);
    }

    @Override
    public int sample(float x, float y) {
        int iy = Mth.clamp((int)Math.round(x), (int)0, (int)(this.imageHeight() - 1));
        int ix = Mth.clamp((int)Math.round(y), (int)0, (int)(this.imageWidth() - 1));
        return this.getPixel(iy, ix);
    }

    public Sampler2D frameSampler(int frameIndex) {
        return (x, y) -> {
            int ix = Mth.clamp((int)Math.round(x), (int)0, (int)(this.frameWidth() - 1));
            int iy = Mth.clamp((int)Math.round(y), (int)0, (int)(this.frameHeight() - 1));
            return this.getFramePixel(frameIndex, ix, iy);
        };
    }

    public void setFramePixel(int frameIndex, int x, int y, int color) {
        this.image.setPixelRGBA(this.getFrameStartX(frameIndex) + x, this.getFrameStartY(frameIndex) + y, color);
    }

    public void setPixel(int x, int y, int color) {
        this.image.setPixelRGBA(x, y, color);
    }

    public void blendPixel(int x, int y, int color) {
        this.image.blendPixel(x, y, color);
    }

    public void blendFramePixel(int frameIndex, int x, int y, int color) {
        this.image.blendPixel(this.getFrameStartX(frameIndex) + x, this.getFrameStartY(frameIndex) + y, color);
    }

    public void forEachPixel(Consumer<PixelContext> consumer) {
        PixelContext pixel = new PixelContext(this);
        for (int frameIdx = 0; frameIdx < this.frameCount; ++frameIdx) {
            int xOff = this.getFrameStartX(frameIdx);
            int yOff = this.getFrameStartY(frameIdx);
            for (int x = 0; x < this.frameWidth(); ++x) {
                for (int y = 0; y < this.frameHeight(); ++y) {
                    pixel.frameIndex = frameIdx;
                    pixel.localX = x;
                    pixel.localY = y;
                    pixel.globalX = x + xOff;
                    pixel.globalY = y + yOff;
                    consumer.accept(pixel);
                }
            }
        }
    }

    public TextureImage makeCopy() {
        return this.makeCopyWithMetadata(this.metadata);
    }

    public TextureImage makeCopyWithMetadata(McMetaFile mcMetaFile) {
        NativeImage im = new NativeImage(this.imageWidth(), this.imageHeight(), false);
        im.copyFrom(this.image);
        return new TextureImage(im, mcMetaFile);
    }

    @Override
    public void close() {
        this.image.close();
    }

    public void doAndClose(ThrowingRunnable action) {
        try (TextureImage textureImage = this;){
            action.run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        this.image.fillRect(0, 0, this.image.getWidth(), this.image.getHeight(), 0);
    }

    @Deprecated(forRemoval=true)
    public RGBColor getAverageColor() {
        return SpriteUtils.averageColor(this.image);
    }

    public ImmutableList<NativeImage> splitFrames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.metadata == null) {
            builder.add((Object)this.image);
            return builder.build();
        }
        int imgWidth = this.imageWidth();
        int imgHeight = this.imageHeight();
        FrameSize fs = this.metadata.animation().calculateFrameSize(imgWidth, imgHeight);
        int frameScaleWidth = imgWidth / fs.width();
        int frameScaleHeight = imgHeight / fs.height();
        int maxFrames = frameScaleWidth * frameScaleHeight;
        ArrayList indexList = Lists.newArrayList();
        this.metadata.animation().forEachFrame((index, time) -> indexList.add(index));
        if (indexList.isEmpty()) {
            for (int l = 0; l < maxFrames; ++l) {
                indexList.add(l);
            }
        }
        if (indexList.size() <= 1) {
            builder.add((Object)this.image);
        } else {
            Iterator iterator = indexList.iterator();
            while (iterator.hasNext()) {
                int index2 = (Integer)iterator.next();
                int xOffset = index2 % frameScaleWidth * this.frameWidth();
                int yOffset = index2 / frameScaleWidth * this.frameHeight();
                if (index2 < 0 || xOffset + this.frameWidth() >= imgWidth || yOffset + this.frameHeight() >= imgHeight) continue;
                NativeImage f = new NativeImage(this.frameWidth(), this.frameHeight(), false);
                for (int x = 0; x < this.frameWidth(); ++x) {
                    for (int y = 0; y < this.frameHeight(); ++y) {
                        f.setPixelRGBA(x, y, this.image.getPixelRGBA(x + xOffset, y + yOffset));
                    }
                }
                builder.add((Object)f);
            }
        }
        return builder.build();
    }

    @Deprecated
    public void toGrayscale() {
        TextureOps.grayscale(this);
    }

    @Deprecated(forRemoval=true)
    public TextureImage createAnimationTemplate(int length, McMetaFile useDataFrom) {
        return TextureOps.createSingleFrameAnimation(this, length, useDataFrom);
    }

    @Deprecated(forRemoval=true)
    public void applyOverlay(TextureImage ... overlays) throws IllegalStateException {
        TextureOps.applyOverlay(this, overlays);
        Arrays.stream(overlays).forEach(TextureImage::close);
    }

    @Deprecated(forRemoval=true)
    public void applyOverlayOnExisting(TextureImage ... overlays) throws IllegalStateException {
        TextureOps.applyOverlayOnExisting(this, overlays);
        Arrays.stream(overlays).forEach(TextureImage::close);
    }

    @Deprecated(forRemoval=true)
    public void removeAlpha(int backgroundColor) {
        TextureOps.makeOpaque(this, backgroundColor);
    }

    @Deprecated(forRemoval=true)
    public TextureImage createRotated(Rotation rotation) {
        return TextureOps.createRotated(this, rotation);
    }

    @Deprecated(forRemoval=true)
    public TextureImage createResized(float widthScale, float heightScale) {
        return TextureOps.createScaled(this, widthScale, heightScale);
    }

    @Deprecated(forRemoval=true)
    public void crop(TextureImage mask) {
        this.crop(mask, true);
    }

    @Deprecated(forRemoval=true)
    public void crop(TextureImage mask, boolean discardInner) {
        if (discardInner) {
            TextureOps.applyMask(this, mask);
        } else {
            TextureOps.applyMaskInverted(this, mask);
        }
        mask.close();
    }

    @Deprecated(forRemoval=true)
    public TextureImage createAnimationTemplate(int length, @NotNull AnimationMetadataSection useDataFrom) {
        return this.createAnimationTemplate(length, McMetaFile.of(useDataFrom));
    }

    @Deprecated(forRemoval=true)
    public TextureImage createAnimationTemplate(int length, List<AnimationFrame> frameData, int frameTime, boolean interpolate) {
        return this.createAnimationTemplate(length, new AnimationMetadataSection(frameData, this.frameWidth(), this.frameHeight(), frameTime, interpolate));
    }

    @Deprecated(forRemoval=true)
    public void forEachFrame(FramePixelConsumer e) {
        this.forEachFramePixel(e);
    }

    @Deprecated(forRemoval=true)
    public void forEachFramePixel(FramePixelConsumer framePixelConsumer) {
        for (int ind = 0; ind < this.frameCount; ++ind) {
            int xOff = this.getFrameStartX(ind);
            int yOff = this.getFrameStartY(ind);
            for (int x = 0; x < this.frameWidth(); ++x) {
                for (int y = 0; y < this.frameHeight(); ++y) {
                    framePixelConsumer.accept(ind, x + xOff, y + yOff);
                }
            }
        }
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public AnimationMetadataSection getMetadata() {
        return this.metadata == null ? null : this.metadata.animation();
    }

    @Deprecated(forRemoval=true)
    public static TextureImage createNew(int width, int height, @Nullable AnimationMetadataSection animation) {
        return TextureImage.createNew(width, height, animation == null ? null : McMetaFile.of(animation));
    }

    @Deprecated(forRemoval=true)
    public static TextureImage of(NativeImage image, @Nullable AnimationMetadataSection animation) {
        return TextureImage.of(image, animation == null ? null : McMetaFile.of(animation));
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws Exception;
    }

    @Deprecated(forRemoval=true)
    @FunctionalInterface
    public static interface FramePixelConsumer
    extends TriConsumer<Integer, Integer, Integer> {
        public void accept(Integer var1, Integer var2, Integer var3);
    }
}

