/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.mehvahdjukaar.snowyspirit.common.entity.ContainerHolderEntity;
import net.mehvahdjukaar.snowyspirit.common.entity.SledEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;

public class ContainerHolderEntityRenderer<T extends ContainerHolderEntity>
extends EntityRenderer<T> {
    private final BlockRenderDispatcher blockRenderer;

    public ContainerHolderEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.4f;
        this.blockRenderer = Minecraft.getInstance().getBlockRenderer();
    }

    public void render(T entity, float yRot, float partialTicks, PoseStack poseStack, MultiBufferSource pBuffer, int pPackedLight) {
        BlockState blockstate;
        SledEntity se;
        float sledHurt;
        Entity vehicle = entity.getVehicle();
        if (vehicle == null || vehicle.isControlledByLocalInstance() && Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            return;
        }
        poseStack.pushPose();
        float xRot = vehicle.getViewXRot(partialTicks);
        yRot = vehicle.getViewYRot(partialTicks);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yRot));
        poseStack.mulPose(Axis.XN.rotationDegrees(xRot));
        float hurtTime = (float)((ContainerHolderEntity)((Object)entity)).getHurtTime() - partialTicks;
        float damage = ((ContainerHolderEntity)((Object)entity)).getDamage() - partialTicks;
        int dir = 1;
        if (vehicle instanceof SledEntity && (sledHurt = (float)(se = (SledEntity)vehicle).getHurtTime() - partialTicks) > hurtTime) {
            hurtTime = sledHurt;
            damage = se.getDamage() - partialTicks;
            dir = se.getHurtDir();
        }
        if (hurtTime > 0.0f) {
            if (damage < 0.0f) {
                damage = 0.0f;
            }
            float zRot = Mth.sin((float)hurtTime) * hurtTime * damage / 10.0f * (float)dir;
            poseStack.mulPose(Axis.ZP.rotationDegrees(zRot));
        }
        if ((blockstate = ((ContainerHolderEntity)((Object)entity)).getDisplayState()).getRenderShape() != RenderShape.INVISIBLE) {
            poseStack.pushPose();
            float scale = 0.75f;
            poseStack.scale(scale, scale, scale);
            poseStack.translate(-0.5, 0.0, -0.5);
            this.blockRenderer.renderSingleBlock(blockstate, poseStack, pBuffer, pPackedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(T pEntity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

