/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.client;

import com.google.common.collect.ImmutableList;
import net.mehvahdjukaar.snowyspirit.common.entity.GingyEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class GingyModel
extends HumanoidModel<GingyEntity> {
    private final ModelPart bodyEaten;
    private final float scale;

    public GingyModel(ModelPart modelPart, float scale) {
        super(modelPart);
        this.bodyEaten = modelPart.getChild("body_eaten");
        this.scale = scale;
    }

    public void prepareMobModel(GingyEntity entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((LivingEntity)entity, limbSwing, limbSwingAmount, partialTick);
        int b = entity.getBodyIntegrity().ordinal();
        this.leftArm.visible = b < 1;
        this.rightArm.visible = b < 2;
        this.head.visible = b < 3;
        this.body.visible = b < 4;
        this.bodyEaten.visible = !this.body.visible;
    }

    public void setupAnim(GingyEntity entity, float walkAnimation, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float zRot;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        boolean flyingTicks = entity.getFallFlyingTicks() > 4;
        float f = 1.0f;
        if (flyingTicks) {
            f = (float)entity.getDeltaMovement().lengthSqr();
            f /= 0.2f;
            f *= f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        float period = 7.853982f * this.scale;
        float angle = walkAnimation * ((float)Math.PI * 2 / period);
        float armSwingPower = 2.0f;
        float cos = Mth.cos((float)angle);
        float walkCycle = cos * limbSwingAmount;
        float walkCycleClamped = cos * Mth.clamp((float)limbSwingAmount, (float)0.0f, (float)0.4f);
        this.head.zRot = walkCycleClamped * 0.3f;
        this.rightArm.yRot = walkCycleClamped * armSwingPower / f;
        this.leftArm.yRot = walkCycleClamped * armSwingPower / f;
        float multiplier = 1.6f * Mth.clamp((float)(1.0f - limbSwingAmount * 4.0f), (float)0.0f, (float)1.0f);
        this.rightArm.zRot = zRot = multiplier * (Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f);
        this.leftArm.zRot = -zRot;
        this.rightArm.xRot = 0.005f;
        this.leftArm.xRot = 0.005f;
        this.rightLeg.xRot = walkCycle * 1.4f / f;
        this.leftLeg.xRot = -walkCycle * 1.4f / f;
        this.rightLeg.yRot = 0.005f;
        this.leftLeg.yRot = -0.005f;
        float legZRot = 0.2f;
        this.rightLeg.zRot = 0.005f + legZRot;
        this.leftLeg.zRot = -(0.005f + legZRot);
        if (this.riding || entity.isOrderedToSit()) {
            this.rightLeg.xRot = -1.5207964f;
            this.rightLeg.yRot = 0.31415927f;
            this.rightLeg.zRot = 0.07853982f;
            this.leftLeg.xRot = -1.5207964f;
            this.leftLeg.yRot = -0.31415927f;
            this.leftLeg.zRot = -0.07853982f;
        }
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.bodyEaten);
    }

    public static LayerDefinition createBodyLayer() {
        CubeDeformation cubeDeformation = CubeDeformation.NONE;
        float hOffset = 11.0f;
        MeshDefinition meshDefinition = HumanoidModel.createMesh((CubeDeformation)cubeDeformation, (float)hOffset);
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition head = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -5.0f, -1.5f, 6.0f, 5.0f, 3.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)(0.0f + hOffset), (float)0.0f));
        head.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(11, 10).addBox(-4.0f, -4.0f, -2.5f, 8.0f, 0.0f, 5.0f), PartPose.ZERO);
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 8).addBox(-3.0f, 0.0f, -1.0f, 6.0f, 7.0f, 2.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)(0.0f + hOffset), (float)0.0f));
        body.addOrReplaceChild("skirt", CubeListBuilder.create().texOffs(12, 28).addBox(-4.0f, 7.0f, -2.0f, 8.0f, 0.0f, 4.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("body_eaten", CubeListBuilder.create().texOffs(0, 27).addBox(-3.0f, 0.0f, -1.0f, 6.0f, 3.0f, 2.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)(4.0f + hOffset), (float)0.0f));
        partDefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 17).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f, 0.0f, -0.001f)), PartPose.offset((float)-1.5f, (float)(7.0f + hOffset), (float)0.0f));
        partDefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(10, 17).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f, 0.0f, -0.001f)), PartPose.offset((float)1.5f, (float)(7.0f + hOffset), (float)0.0f));
        partDefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(20, 0).addBox(-4.0f, -1.5f, -1.0f, 4.0f, 3.0f, 2.0f, cubeDeformation), PartPose.offset((float)-3.0f, (float)(1.5f + hOffset), (float)0.0f));
        partDefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(20, 5).addBox(0.0f, -1.5f, -1.0f, 4.0f, 3.0f, 2.0f, cubeDeformation), PartPose.offset((float)3.0f, (float)(1.5f + hOffset), (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)32, (int)32);
    }
}

