/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.client;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.snowyspirit.common.block.GlowLightsBlock;
import net.mehvahdjukaar.snowyspirit.common.block.GlowLightsBlockTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class GlowLightsBakedModel
implements CustomBakedModel {
    private final BlockModelShaper blockModelShaper;
    private final BakedModel overlay;

    public GlowLightsBakedModel(BakedModel overlay, ModelState state) {
        this.overlay = overlay;
        this.blockModelShaper = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper();
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (state != null) {
            try {
                BlockState mimic = (BlockState)extraData.get(GlowLightsBlockTile.MIMIC_KEY);
                if (mimic != null && !mimic.isAir()) {
                    BakedModel model = this.blockModelShaper.getBlockModel(mimic);
                    List qu = model.getQuads(state, side, rand);
                    quads.addAll(qu);
                }
            }
            catch (Exception mimic) {
                // empty catch block
            }
            List overlay = this.overlay.getQuads(state, side, rand);
            if (GlowLightsBlock.hasSide(state, side)) {
                quads.addAll(overlay);
            }
        }
        return quads;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData data) {
        BlockState mimic = (BlockState)data.get(GlowLightsBlockTile.MIMIC_KEY);
        if (mimic != null && !mimic.isAir()) {
            BakedModel model = this.blockModelShaper.getBlockModel(mimic);
            try {
                return model.getParticleIcon();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.blockModelShaper.getBlockModel(Blocks.OAK_LEAVES.defaultBlockState()).getParticleIcon();
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }
}

