/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.client;

import net.mehvahdjukaar.snowyspirit.common.entity.SledEntity;
import net.mehvahdjukaar.snowyspirit.configs.ClientConfigs;
import net.mehvahdjukaar.snowyspirit.reg.ModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;

public class SledSoundInstance
extends AbstractTickableSoundInstance {
    public static final int DELAY = 20;
    public static final float CUTOFF_SPEED = 0.05f;
    public static final int SPEED_DIVIDER = 25;
    private final SledEntity sled;
    private int time;
    private int fastTime;
    private final boolean isSnow;
    private int ticksOnSnow = 0;

    public SledSoundInstance(SledEntity sledEntity, boolean isSnow) {
        super(isSnow ? ModSounds.SLED_SOUND_SNOW.get() : ModSounds.SLED_SOUND.get(), SoundSource.PLAYERS, sledEntity.level().getRandom());
        this.sled = sledEntity;
        this.looping = true;
        this.delay = 0;
        this.volume = 0.0f;
        this.isSnow = isSnow;
    }

    public boolean canPlaySound() {
        return !this.sled.isSilent();
    }

    public boolean canStartSilent() {
        return true;
    }

    public void tick() {
        ++this.time;
        if (!this.sled.isRemoved()) {
            this.x = (float)this.sled.getX();
            this.y = (float)this.sled.getY();
            this.z = (float)this.sled.getZ();
            float f = (float)this.sled.getDeltaMovement().lengthSqr();
            if (f > 0.05f) {
                ++this.fastTime;
            } else {
                this.fastTime = 0;
                this.volume = 0.0f;
                return;
            }
            this.volume = (double)f >= 1.0E-7 ? Mth.clamp((float)(f / 25.0f), (float)0.0f, (float)1.1f) : 0.0f;
            if (this.time < 20) {
                this.volume *= (float)(this.fastTime - 20) / 20.0f;
            }
            if (this.isSnow) {
                if (!this.sled.getCurrentStatus().onSnow()) {
                    this.volume = 0.0f;
                    this.ticksOnSnow = 0;
                } else {
                    ++this.ticksOnSnow;
                    if (this.ticksOnSnow < 5) {
                        this.volume *= (float)(this.ticksOnSnow - 5) / 5.0f;
                    }
                    this.volume = Math.min(0.8f, this.volume);
                }
            }
            float f1 = 0.8f;
            this.pitch = this.volume > 0.8f ? 1.0f + (this.volume - 0.8f) : 1.0f;
            this.volume = (float)((double)this.volume * ClientConfigs.SLED_SOUND_AMPLIFIER.get());
        } else {
            this.stop();
        }
    }

    public static void playAt(SledEntity sledEntity) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new SledSoundInstance(sledEntity, false));
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new SledSoundInstance(sledEntity, true));
    }
}

