/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.entity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.entity.IControllableVehicle;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.client.SledSoundInstance;
import net.mehvahdjukaar.snowyspirit.common.entity.ContainerHolderEntity;
import net.mehvahdjukaar.snowyspirit.common.entity.GroundStatus;
import net.mehvahdjukaar.snowyspirit.common.network.ServerBoundUpdateSledState;
import net.mehvahdjukaar.snowyspirit.configs.CommonConfigs;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.mehvahdjukaar.snowyspirit.reg.ModTags;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SledEntity
extends Entity
implements IControllableVehicle {
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.defineId(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_ID_HURT_DIR = SynchedEntityData.defineId(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.defineId(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<WoodType> DATA_WOOD_TYPE = SynchedEntityData.defineId(SledEntity.class, ModRegistry.WOOD_TYPE_SERIALIZER.get());
    private static final EntityDataAccessor<Integer> DATA_SEAT_TYPE = SynchedEntityData.defineId(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Byte> DATA_WOLF_INDEX = SynchedEntityData.defineId(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Float> DATA_ADDITIONAL_Y = SynchedEntityData.defineId(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_SYNCED_DX = SynchedEntityData.defineId(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_SYNCED_DY = SynchedEntityData.defineId(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_SYNCED_DZ = SynchedEntityData.defineId(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private boolean inputLeft;
    private boolean inputRight;
    private boolean inputUp;
    private boolean inputDown;
    private float landFriction;
    private GroundStatus groundStatus;
    @Nullable
    private Animal sledPuller = null;
    @Nullable
    private ContainerHolderEntity chest = null;
    public float cachedAdditionalY = 0.0f;
    public double prevAdditionalY = 0.0;
    public Vec3 projectedPos = Vec3.ZERO;
    public Vec3 prevProjectedPos = Vec3.ZERO;
    public Vec3 prevDeltaMovement = Vec3.ZERO;
    public boolean boost = false;
    public double misalignedFrictionFactor = 1.0;
    public Vec3 pullerPos = Vec3.ZERO;
    public Vec3 prevPullerPos = Vec3.ZERO;
    public AABB pullerAABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private final EntityDimensions pullerDimensions = new EntityDimensions(0.8f, 2.1f, 1.05f, EntityAttachments.createDefault((float)0.8f, (float)2.1f), false);
    private final WalkAnimationState internalPullerAnimation = new WalkAnimationState();

    public SledEntity(EntityType<? extends SledEntity> entityType, Level level) {
        super(entityType, level);
        this.blocksBuilding = true;
        if (this.level().isClientSide) {
            SledSoundInstance.playAt(this);
        }
    }

    public float maxUpStep() {
        return 1.0f;
    }

    public SledEntity(Level level, double x, double y, double z) {
        this(ModRegistry.SLED.get(), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putString("Type", this.getWoodType().toString());
        if (this.getSeatType() != null) {
            tag.putInt("Seat", this.getSeatType().getId());
        }
        if (this.sledPuller != null) {
            tag.putByte("PullerIndex", (byte)this.getPullerIndex());
        }
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("Type", 8)) {
            this.setWoodType(WoodTypeRegistry.fromNBT((String)tag.getString("Type")));
        }
        if (tag.contains("Seat", 99)) {
            this.setSeatType(DyeColor.byId((int)tag.getInt("Seat")));
        }
        if (tag.contains("PullerIndex")) {
            this.setPullerIndex(tag.getByte("PullerIndex"));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_WOOD_TYPE, (Object)WoodTypeRegistry.OAK_TYPE);
        builder.define(DATA_SEAT_TYPE, (Object)0);
        builder.define(DATA_ID_HURT, (Object)0);
        builder.define(DATA_ID_HURT_DIR, (Object)1);
        builder.define(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
        builder.define(DATA_WOLF_INDEX, (Object)-1);
        builder.define(DATA_ADDITIONAL_Y, (Object)Float.valueOf(0.0f));
        builder.define(DATA_SYNCED_DX, (Object)Float.valueOf(0.0f));
        builder.define(DATA_SYNCED_DY, (Object)Float.valueOf(0.0f));
        builder.define(DATA_SYNCED_DZ, (Object)Float.valueOf(0.0f));
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPushable() {
        return true;
    }

    public boolean canCollideWith(Entity entity) {
        return Boat.canVehicleCollide((Entity)this, (Entity)entity);
    }

    public Vec3 getRelativePortalPosition(Direction.Axis axis, BlockUtil.FoundRectangle rectangle) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition((Vec3)super.getRelativePortalPosition(axis, rectangle));
    }

    /*
     * Unable to fully structure code
     */
    public boolean hurt(DamageSource source, float amount) {
        block7: {
            if (this.isInvulnerableTo(source)) {
                return false;
            }
            level = this.level();
            if (level.isClientSide || this.isRemoved()) break block7;
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.setDamage(this.getDamage() + amount * 10.0f);
            this.markHurt();
            this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, source.getEntity());
            var6_4 = source.getEntity();
            if (!(var6_4 instanceof Player)) ** GOTO lbl-1000
            player = (Player)var6_4;
            if (player.getAbilities().instabuild) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = isCreative = false;
            }
            if (isCreative || this.getDamage() > 40.0f) {
                if (!isCreative && level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    this.spawnAtLocation((ItemLike)this.getSledItem());
                    seat = this.getSeatType();
                    if (seat != null && (carpet = BlocksColorAPI.getColoredItem((String)"carpet", (DyeColor)seat)) != null) {
                        this.spawnAtLocation((ItemLike)carpet);
                    }
                    if (this.hasPuller()) {
                        this.spawnAtLocation((ItemLike)Items.LEAD);
                    }
                }
                this.discard();
            }
        }
        return true;
    }

    public void animateHurt(float hitYaw) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public void push(Entity pEntity) {
        if (pEntity instanceof Boat) {
            if (pEntity.getBoundingBox().minY < this.getBoundingBox().maxY) {
                super.push(pEntity);
            }
        } else if (pEntity.getBoundingBox().minY <= this.getBoundingBox().minY) {
            super.push(pEntity);
        }
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yRot;
        this.lerpXRot = xRot;
        this.lerpSteps = 5;
    }

    public Direction getMotionDirection() {
        return this.getDirection().getClockWise();
    }

    public float getAdditionalY() {
        return ((Float)this.entityData.get(DATA_ADDITIONAL_Y)).floatValue();
    }

    @Nullable
    public void setDataAdditionalY(float additionalY) {
        this.entityData.set(DATA_ADDITIONAL_Y, (Object)Float.valueOf(additionalY));
    }

    public Vec3 getSyncedMovement() {
        return new Vec3((double)((Float)this.entityData.get(DATA_SYNCED_DX)).floatValue(), (double)((Float)this.entityData.get(DATA_SYNCED_DY)).floatValue(), (double)((Float)this.entityData.get(DATA_SYNCED_DZ)).floatValue());
    }

    public void setSyncedMovement(Vec3 deltaMovement) {
        this.setSyncedMovement((float)deltaMovement.x, (float)deltaMovement.y, (float)deltaMovement.z);
    }

    public void setSyncedMovement(float dx, float dy, float dz) {
        this.entityData.set(DATA_SYNCED_DX, (Object)Float.valueOf(dx));
        this.entityData.set(DATA_SYNCED_DY, (Object)Float.valueOf(dy));
        this.entityData.set(DATA_SYNCED_DZ, (Object)Float.valueOf(dz));
    }

    private AABB resetPullerAABB() {
        return this.pullerDimensions.makeBoundingBox(this.position());
    }

    public void move(MoverType pType, Vec3 wantedPosIncrement) {
        boolean isMoving = wantedPosIncrement != Vec3.ZERO;
        this.prevProjectedPos = this.projectedPos;
        this.projectedPos = Vec3.ZERO;
        if (!this.onGround() && isMoving) {
            float belowCheck = -1.25f;
            Vec3 blockBelow = this.calculateSlopePosition(new Vec3(0.0, (double)belowCheck, 0.0), this.getBoundingBox(), this::makeBoundingBox, -1.0f);
            if (blockBelow.y > (double)belowCheck + 0.01) {
                this.setOnGround(true);
            }
        }
        if (this.onGround()) {
            this.projectedPos = !isMoving ? Vec3.ZERO : this.calculateSlopePosition(this.getDeltaMovement().scale(6.0), this.getBoundingBox(), this::makeBoundingBox, -1.0f);
            double y = Mth.clamp((double)this.projectedPos.y, (double)-1.0, (double)1.0);
            if (y == 0.0) {
                this.setXRot(this.getXRot() + -this.getXRot() * 0.3f);
            } else if (y > 0.0) {
                this.setXRot((float)Math.max((double)(this.getXRot() - 6.0f), -30.0 * y));
            } else {
                this.setXRot((float)Math.min((double)(this.getXRot() + 3.0f), -30.0 * y));
            }
        }
        float localAdditionalY = this.getAdditionalY();
        this.prevAdditionalY = localAdditionalY;
        if (this.projectedPos.y > 0.0) {
            double slopeIncrement = (this.projectedPos.y + 0.01) / 2.5;
            localAdditionalY = (float)Math.min(this.projectedPos.y, (double)localAdditionalY + slopeIncrement);
        } else {
            localAdditionalY = 0.0f;
        }
        float snowLayerHeight = 0.0625f;
        if (this.groundStatus == GroundStatus.ON_SNOW_LAYER && (double)localAdditionalY < 0.0625) {
            localAdditionalY += 0.0625f;
        }
        this.setDataAdditionalY(localAdditionalY);
        this.cachedAdditionalY = localAdditionalY;
        Vec3 oldPos = this.position();
        super.move(pType, wantedPosIncrement);
        if (this.cachedAdditionalY > 0.0f && oldPos.y < this.getY()) {
            float newHeight = this.groundStatus == GroundStatus.ON_SNOW_LAYER ? 0.0625f : 0.0f;
            this.setDataAdditionalY(newHeight);
            this.cachedAdditionalY = newHeight;
            this.setBoundingBox(this.makeBoundingBox());
        }
        this.prevPullerPos = this.pullerPos;
        if (this.hasPuller()) {
            this.pullerAABB = this.pullerDimensions.makeBoundingBox(this.position().add(0.0, 0.0, 0.0));
            Vec3 wantedPullerPos = this.calculateSlopePosition(wantedPosIncrement.add(this.getLookAngle().scale(2.0)), this.pullerAABB, this::resetPullerAABB, -1.25f);
            double pxInc = Mth.clamp((double)(wantedPullerPos.x - this.prevPullerPos.x), (double)-0.75, (double)0.75);
            double pyInc = wantedPullerPos.y < 0.0 && wantedPullerPos.y < this.prevPullerPos.y ? Mth.clamp((double)(wantedPullerPos.y - this.prevPullerPos.y), (double)-0.15, (double)1.0) : wantedPullerPos.y - this.prevPullerPos.y;
            double pzInc = Mth.clamp((double)(wantedPullerPos.z - this.prevPullerPos.z), (double)-0.75, (double)0.75);
            this.pullerPos = this.prevPullerPos.add(pxInc, pyInc, pzInc);
            this.pullerAABB = this.pullerDimensions.makeBoundingBox(this.position().add(this.pullerPos));
        }
    }

    public void tick() {
        boolean controlledByLocalInstance;
        Level level = this.level();
        if (!level.isClientSide && this.boost && this.getSyncedMovement().lengthSqr() > 0.09) {
            for (Entity p : this.getPassengers()) {
                if (!(p instanceof ServerPlayer)) continue;
                ServerPlayer sp = (ServerPlayer)p;
                Utils.awardAdvancement((ServerPlayer)sp, (ResourceLocation)SnowySpirit.res("adventure/ride_sled_fast"));
            }
        }
        if (this.chest != null && this.chest.isRemoved()) {
            this.chest = null;
        }
        this.updatePuller();
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        Pair<GroundStatus, Float> newStatus = GroundStatus.computeFriction(this);
        this.groundStatus = (GroundStatus)((Object)newStatus.getFirst());
        this.landFriction = ((Float)newStatus.getSecond()).floatValue();
        this.prevDeltaMovement = this.getDeltaMovement();
        super.tick();
        this.tickLerp();
        Vec3 movement = this.getDeltaMovement();
        this.boost = false;
        if (this.projectedPos.y != 0.0 && this.onGround()) {
            double k = Mth.clamp((double)this.projectedPos.y, (double)-1.0, (double)1.0);
            if (k > 0.0) {
                if (!this.hasPuller()) {
                    this.setDeltaMovement(movement.scale(1.0 + -0.06 * k));
                }
            } else {
                this.boost = true;
                this.setDeltaMovement(movement.add(movement.normalize().scale(k * (double)-0.01f)).add(0.0, -0.2, 0.0));
            }
        }
        if (controlledByLocalInstance = this.isControlledByLocalInstance()) {
            this.applyFriction();
            if (level.isClientSide) {
                this.controlSled();
            }
        } else {
            this.setDeltaMovement(Vec3.ZERO);
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.checkInsideBlocks();
        List list = level.getEntities((Entity)this, this.getBoundingBox().inflate((double)0.15f, (double)0.01f, (double)0.15f), EntitySelector.pushableBy((Entity)this));
        if (!list.isEmpty()) {
            boolean notLocalPlayerControlled = !level.isClientSide && !(this.getControllingPassenger() instanceof Player);
            for (Entity entity : list) {
                if (entity.hasPassenger((Entity)this)) continue;
                if (notLocalPlayerControlled && !entity.isPassenger() && entity.getBbWidth() < this.getBbWidth() && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player) && (this.hasPuller() && this.canAddPassenger(entity) || this.getPassengers().size() < 2)) {
                    entity.startRiding((Entity)this);
                    continue;
                }
                this.push(entity);
            }
        }
        if (level.isClientSide) {
            if (controlledByLocalInstance) {
                movement = this.getDeltaMovement();
                double horizontalSpeed = movement.x * movement.x + movement.z * movement.z;
                if (horizontalSpeed > 0.001) {
                    this.setSyncedMovement(movement);
                    NetworkHelper.sendToServer((CustomPacketPayload)new ServerBoundUpdateSledState(movement));
                    this.spawnTrailParticles(movement, horizontalSpeed);
                }
            } else {
                movement = this.getSyncedMovement();
                double horizontalSpeed = movement.x * movement.x + movement.z * movement.z;
                if (horizontalSpeed > 0.001) {
                    this.spawnTrailParticles(movement, horizontalSpeed);
                }
            }
        } else if (!controlledByLocalInstance && this.getSyncedMovement() != Vec3.ZERO) {
            this.setSyncedMovement(Vec3.ZERO);
        }
    }

    protected void checkInsideBlocks() {
        AABB aabb = this.getBoundingBox();
        BlockPos blockpos = BlockPos.containing((double)(aabb.minX + 0.001), (double)(aabb.minY + 0.001), (double)(aabb.minZ + 0.001));
        BlockPos blockpos1 = BlockPos.containing((double)(aabb.maxX - 0.001), (double)(aabb.maxY - 0.001), (double)(aabb.maxZ - 0.001));
        Level level = this.level();
        if (level.hasChunksAt(blockpos, blockpos1)) {
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            for (int i = blockpos.getX(); i <= blockpos1.getX(); ++i) {
                for (int j = blockpos.getY(); j <= blockpos1.getY(); ++j) {
                    for (int k = blockpos.getZ(); k <= blockpos1.getZ(); ++k) {
                        blockPos.set(i, j, k);
                        BlockState blockstate = level.getBlockState((BlockPos)blockPos);
                        if (blockstate.getBlock() instanceof PowderSnowBlock) continue;
                        try {
                            blockstate.entityInside(level, (BlockPos)blockPos, (Entity)this);
                            this.onInsideBlock(blockstate);
                            continue;
                        }
                        catch (Exception throwable) {
                            CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Colliding entity with block");
                            CrashReportCategory crashreportcategory = crashreport.addCategory("Block being collided with");
                            CrashReportCategory.populateBlockDetails((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)level, (BlockPos)blockPos, (BlockState)blockstate);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
            }
        }
    }

    private void spawnTrailParticles(Vec3 movement, double horizontalSpeed) {
        if (this.groundStatus.onSnow() && this.onGround()) {
            float xRot = this.getXRot();
            float yRot = this.getYRot();
            Vec3 left = null;
            Vec3 right = null;
            Level level = this.level();
            if ((double)(this.random.nextFloat() * 0.16f) < horizontalSpeed) {
                float up = (float)Math.min(horizontalSpeed * 0.6, 0.3);
                Vec3 a = this.calculateViewVector(xRot, yRot + 24.0f);
                Vec3 b = this.calculateViewVector(xRot, yRot - 24.0f);
                left = a.scale(-1.0).add(this.position());
                right = b.scale(-1.0).add(this.position());
                this.spawnSnowFlakeParticle(level, left, (double)Mth.randomBetween((RandomSource)this.random, (float)-1.0f, (float)1.0f) * 0.083, 0.015 + (double)(this.random.nextFloat() * 0.1f) + (double)up, (double)Mth.randomBetween((RandomSource)this.random, (float)-1.0f, (float)1.0f) * 0.083);
                this.spawnSnowFlakeParticle(level, right, (double)Mth.randomBetween((RandomSource)this.random, (float)-1.0f, (float)1.0f) * 0.083, 0.015 + (double)(this.random.nextFloat() * 0.1f) + (double)up, (double)Mth.randomBetween((RandomSource)this.random, (float)-1.0f, (float)1.0f) * 0.083);
            }
            if ((double)Math.abs(xRot) < 0.01) {
                Vec3 v = new Vec3(0.0, 0.0, 1.0);
                v = v.yRot((float)((double)(-yRot / 180.0f) * Math.PI));
                double cross = v.cross((Vec3)new Vec3((double)movement.x, (double)0.0, (double)movement.z).normalize()).y;
                for (int j = 0; j < 2; ++j) {
                    Vec3 p;
                    if (!((double)this.random.nextFloat() < cross * cross - 0.1)) continue;
                    Vec3 forward = this.calculateViewVector(xRot, yRot);
                    float up = (float)Math.min(horizontalSpeed * 0.6, 0.3);
                    if (cross > 0.0) {
                        if (left != null) continue;
                        Vec3 a = this.calculateViewVector(xRot, yRot + 24.0f);
                        left = a.scale(-1.0).add(this.position());
                        p = left.add(forward.scale((double)(this.random.nextFloat() * 1.85f)));
                        this.spawnSnowFlakeParticle(level, p, movement.x * 0.75 + forward.x * 0.25, movement.y + 0.017 + (double)up, movement.z * 0.75 + forward.z * 0.25);
                        continue;
                    }
                    if (right != null) continue;
                    Vec3 b = this.calculateViewVector(xRot, yRot - 24.0f);
                    right = b.scale(-1.0).add(this.position());
                    p = right.add(forward.scale((double)(this.random.nextFloat() * 1.85f)));
                    this.spawnSnowFlakeParticle(level, p, movement.x * 0.75 + forward.x * 0.25, movement.y + 0.017 + (double)up, movement.z * 0.75 + forward.z * 0.25);
                }
            }
        }
    }

    public void spawnSnowFlakeParticle(Level level, Vec3 pos, double dx, double dy, double dz) {
        RandomSource random = level.random;
        level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, pos.x + (double)Mth.randomBetween((RandomSource)random, (float)-0.125f, (float)0.125f), pos.y + 0.2, pos.z + (double)Mth.randomBetween((RandomSource)random, (float)-0.125f, (float)0.125f), dx, dy, dz);
    }

    public boolean canSpawnSprintParticle() {
        return !this.groundStatus.onSnow() && super.canSpawnSprintParticle();
    }

    @NotNull
    protected AABB makeBoundingBox() {
        float additionalY = this.getAdditionalY();
        if (additionalY > 0.0f) {
            return super.makeBoundingBox().expandTowards(0.0, (double)additionalY, 0.0);
        }
        return super.makeBoundingBox();
    }

    public Vec3 collide(Vec3 pVec) {
        double lengthSqr;
        Vec3 vec3;
        Level level;
        ArrayList<VoxelShape> list;
        AABB aabb = this.getBoundingBox();
        Vec3 vec31 = this.maybeClimbUp(pVec, aabb, list = new ArrayList<VoxelShape>((level = this.level()).getEntityCollisions((Entity)this, aabb.expandTowards(pVec))), vec3 = (lengthSqr = pVec.lengthSqr()) == 0.0 ? pVec : SledEntity.collideBoundingBox((Entity)this, (Vec3)pVec, (AABB)aabb, (Level)level, list));
        if (vec31 != null) {
            return vec31;
        }
        return vec3;
    }

    @Nullable
    private Vec3 maybeClimbUp(Vec3 originalMot, AABB aabb, List<VoxelShape> voxelShapes, Vec3 horizonalMot) {
        boolean restrictedX = originalMot.x != horizonalMot.x;
        boolean restrictedY = originalMot.y != horizonalMot.y;
        boolean restrictedZ = originalMot.z != horizonalMot.z;
        boolean onGround = this.onGround() || restrictedY && originalMot.y < 0.0;
        float maxUpStep = this.maxUpStep();
        if (maxUpStep > 0.0f && onGround && (restrictedX || restrictedZ)) {
            Vec3 vec33;
            Level level = this.level();
            Vec3 vec31 = SledEntity.collideBoundingBox((Entity)this, (Vec3)new Vec3(originalMot.x, (double)maxUpStep, originalMot.z), (AABB)aabb, (Level)level, voxelShapes);
            Vec3 vec32 = SledEntity.collideBoundingBox((Entity)this, (Vec3)new Vec3(0.0, (double)maxUpStep, 0.0), (AABB)aabb.expandTowards(originalMot.x, 0.0, originalMot.z), (Level)level, voxelShapes);
            if (vec32.y < (double)maxUpStep && (vec33 = SledEntity.collideBoundingBox((Entity)this, (Vec3)new Vec3(originalMot.x, 0.0, originalMot.z), (AABB)aabb.move(vec32), (Level)level, voxelShapes).add(vec32)).horizontalDistanceSqr() > vec31.horizontalDistanceSqr()) {
                vec31 = vec33;
            }
            if (vec31.horizontalDistanceSqr() > horizonalMot.horizontalDistanceSqr()) {
                return vec31.add(SledEntity.collideBoundingBox((Entity)this, (Vec3)new Vec3(0.0, -vec31.y + originalMot.y, 0.0), (AABB)aabb.move(vec31), (Level)level, voxelShapes));
            }
        }
        return null;
    }

    private Vec3 calculateSlopePosition(Vec3 pVec, AABB aabb, Supplier<AABB> aabbResetter, float maxDownStep) {
        Vec3 vec3;
        Level level = this.level();
        List list = level.getEntityCollisions((Entity)this, aabb.expandTowards(pVec));
        Vec3 vec31 = this.maybeClimbUp(pVec, aabb, list, vec3 = pVec.lengthSqr() == 0.0 ? pVec : SledEntity.collideBoundingBox((Entity)this, (Vec3)pVec, (AABB)aabb, (Level)level, (List)list));
        if (vec31 != null) {
            return vec31;
        }
        Vec3 cached = this.position();
        Vec3 newPos = cached.add(vec3);
        this.setPosRaw(newPos.x, newPos.y, newPos.z);
        AABB aa = aabbResetter.get();
        this.setBoundingBox(aa);
        Vec3 down = SledEntity.collideBoundingBox((Entity)this, (Vec3)new Vec3(0.0, (double)maxDownStep, 0.0), (AABB)aa, (Level)level, (List)list);
        this.setPos(cached);
        return vec3.add(down);
    }

    private void tickLerp() {
        if (this.isControlledByLocalInstance()) {
            this.lerpSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.getX() + (this.lerpX - this.getX()) / (double)this.lerpSteps;
            double d1 = this.getY() + (this.lerpY - this.getY()) / (double)this.lerpSteps;
            double d2 = this.getZ() + (this.lerpZ - this.getZ()) / (double)this.lerpSteps;
            double d3 = Mth.wrapDegrees((double)(this.lerpYRot - (double)this.getYRot()));
            this.setYRot(this.getYRot() + (float)d3 / (float)this.lerpSteps);
            this.setXRot(this.getXRot() + (float)(this.lerpXRot - (double)this.getXRot()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.setPos(d0, d1, d2);
            this.setRot(this.getYRot(), this.getXRot());
        }
    }

    public GroundStatus getCurrentStatus() {
        return this.groundStatus;
    }

    private void applyFriction() {
        double gravity = this.isNoGravity() ? 0.0 : (double)-0.04f;
        float invFriction = 0.05f;
        switch (this.groundStatus) {
            case IN_AIR: {
                invFriction = 0.9f;
                break;
            }
            case IN_WATER: {
                invFriction = 0.45f;
                break;
            }
            case ON_SNOW: 
            case ON_SNOW_LAYER: 
            case ON_LAND: {
                invFriction = this.landFriction;
                if (!(this.getControllingPassenger() instanceof Player)) break;
                this.landFriction /= 2.0f;
            }
        }
        Vec3 movement = this.getDeltaMovement();
        if (this.groundStatus.touchingGround()) {
            double inc = 0.825;
            if (this.inputUp || this.inputDown || movement.lengthSqr() > 0.001) {
                Vec3 v = new Vec3(0.0, 0.0, 1.0);
                v = v.yRot((float)((double)(-this.getYRot() / 180.0f) * Math.PI));
                double dot = v.dot(new Vec3(movement.x, 0.0, movement.z).normalize());
                inc = Mth.clamp((double)((dot + 3.0) / 4.0 + 0.005), (double)inc, (double)1.0);
            }
            this.misalignedFrictionFactor = inc * 4.0 - 3.0;
            invFriction = (float)((double)invFriction * inc);
        }
        this.setDeltaMovement(movement.x * (double)invFriction, movement.y + gravity, movement.z * (double)invFriction);
        this.deltaRotation = (float)((double)this.deltaRotation * Math.min((double)invFriction, this.inputUp ? CommonConfigs.ROTATION_FRICTION_ON_W.get() : CommonConfigs.ROTATION_FRICTION.get()));
    }

    private void controlSled() {
        if (this.isVehicle()) {
            double dot;
            Vec3 v;
            float powah = 0.0f;
            Vec3 movement = this.getDeltaMovement();
            boolean canSteer = (!this.inputRight || !this.inputLeft) && this.inputUp;
            boolean hasWolf = this.hasPuller();
            double steerFactor = hasWolf ? CommonConfigs.STEER_FACTOR_WOLF.get() : CommonConfigs.STEER_FACTOR.get();
            if (this.inputLeft) {
                this.deltaRotation -= 1.0f;
                if (this.groundStatus.touchingGround() && canSteer) {
                    v = new Vec3(0.0, 0.0, 1.0);
                    dot = (v = v.yRot((float)((double)(-this.getYRot() / 180.0f) * Math.PI))).dot(movement.normalize());
                    if (dot > 0.0) {
                        this.setDeltaMovement(movement.yRot((float)(dot * steerFactor)));
                    }
                }
            }
            if (this.inputRight) {
                this.deltaRotation += 1.0f;
                if (this.groundStatus.touchingGround() && canSteer) {
                    v = new Vec3(0.0, 0.0, 1.0);
                    dot = (v = v.yRot((float)((double)(-this.getYRot() / 180.0f) * Math.PI))).dot(movement.normalize());
                    if (dot > 0.8) {
                        this.setDeltaMovement(movement.yRot((float)(-dot * steerFactor)));
                    }
                }
            }
            if (this.inputRight != this.inputLeft && !this.inputUp && !this.inputDown) {
                powah = (float)((double)powah + CommonConfigs.SIDE_ACCELERATION.get());
            }
            this.setYRot(this.getYRot() + this.deltaRotation);
            if (this.inputUp) {
                if (this.groundStatus.onSnow()) {
                    double acceleration = hasWolf ? CommonConfigs.FORWARD_ACCELERATION_WOLF.get() : CommonConfigs.FORWARD_ACCELERATION.get();
                    powah = (float)((double)powah + acceleration);
                } else {
                    powah = (float)((double)powah + CommonConfigs.FORWARD_ACCELERATION_WHEN_NOT_ON_SNOW.get());
                }
            }
            if (this.inputDown) {
                powah = (float)((double)powah - CommonConfigs.BACKWARDS_ACCELERATION.get());
            }
            this.setDeltaMovement(this.getDeltaMovement().add((double)(Mth.sin((float)(-this.getYRot() * ((float)Math.PI / 180))) * powah), 0.0, (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * powah)));
        }
    }

    protected void clampRotation(Entity entity) {
        entity.setYBodyRot(this.getYRot());
        float f = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
        float f1 = Mth.clamp((float)f, (float)-105.0f, (float)105.0f);
        entity.yRotO += f1 - f;
        entity.setYRot(entity.getYRot() + f1 - f);
        entity.setYHeadRot(entity.getYRot());
    }

    protected void checkFallDamage(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
        Level level = this.level();
        if (level.isClientSide && (double)this.fallDistance > 0.5 && this.onGround() && this.groundStatus.onSnow()) {
            float p = Mth.clamp((float)(this.fallDistance * 4.0f), (float)5.0f, (float)20.0f);
            Vec3 front = this.position().add(this.getLookAngle().scale((double)0.8f));
            Vec3 mov = this.getDeltaMovement().scale(1.1);
            float ySpeed = (float)(mov.lengthSqr() * 0.06 + (double)(this.fallDistance * 0.005f));
            int i = 0;
            while ((float)i < p) {
                level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, front.x + (double)Mth.randomBetween((RandomSource)this.random, (float)-0.6f, (float)0.6f), front.y + 0.2 + (double)Mth.randomBetween((RandomSource)this.random, (float)-0.1f, (float)0.2f), front.z + (double)Mth.randomBetween((RandomSource)this.random, (float)-0.6f, (float)0.6f), mov.x + (double)(Mth.randomBetween((RandomSource)this.random, (float)-1.0f, (float)1.0f) * 0.083333336f), 0.1 + (double)(this.random.nextFloat() * ySpeed), mov.z + (double)(Mth.randomBetween((RandomSource)this.random, (float)-1.0f, (float)1.0f) * 0.083333336f));
                ++i;
            }
        }
        if (pOnGround) {
            if (this.fallDistance > 0.0f) {
                // empty if block
            }
            this.resetFallDistance();
        } else if (pY < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - pY);
        }
    }

    public void setDamage(float v) {
        this.entityData.set(DATA_ID_DAMAGE, (Object)Float.valueOf(v));
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DATA_ID_DAMAGE)).floatValue();
    }

    public void setHurtTime(int i) {
        this.entityData.set(DATA_ID_HURT, (Object)i);
    }

    public int getHurtTime() {
        return (Integer)this.entityData.get(DATA_ID_HURT);
    }

    public void setPullerIndex(int i) {
        this.entityData.set(DATA_WOLF_INDEX, (Object)((byte)i));
    }

    public int getPullerIndex() {
        return ((Byte)this.entityData.get(DATA_WOLF_INDEX)).byteValue();
    }

    public void setHurtDir(int i) {
        this.entityData.set(DATA_ID_HURT_DIR, (Object)i);
    }

    public int getHurtDir() {
        return (Integer)this.entityData.get(DATA_ID_HURT_DIR);
    }

    public void setWoodType(WoodType type) {
        this.entityData.set(DATA_WOOD_TYPE, (Object)type);
    }

    public WoodType getWoodType() {
        return (WoodType)this.entityData.get(DATA_WOOD_TYPE);
    }

    @Nullable
    public DyeColor getSeatType() {
        int d = (Integer)this.entityData.get(DATA_SEAT_TYPE);
        if (d == 0) {
            return null;
        }
        return DyeColor.byId((int)(d - 1));
    }

    public void setSeatType(@Nullable DyeColor seatColor) {
        this.entityData.set(DATA_SEAT_TYPE, (Object)(seatColor == null ? 0 : seatColor.getId() + 1));
    }

    @Nullable
    public ContainerHolderEntity tryAddingChest(ItemStack stack) {
        if (ContainerHolderEntity.isValidContainer(stack) && this.canAddChest() && !this.level().isClientSide) {
            Level level = this.level();
            stack = stack.split(1);
            ContainerHolderEntity container = new ContainerHolderEntity(level, this, stack);
            if (!level.isClientSide) {
                level.addFreshEntity((Entity)container);
            }
            Block b = ((BlockItem)stack.getItem()).getBlock();
            this.playSound(b.defaultBlockState().getSoundType().getPlaceSound());
            return container;
        }
        return null;
    }

    public InteractionResult interact(Player player, InteractionHand pHand) {
        if (!player.isSecondaryUseActive()) {
            ItemStack stack = player.getItemInHand(pHand);
            Level level = player.level();
            if (stack.is(ItemTags.WOOL_CARPETS) && this.getSeatType() == null) {
                DyeColor col = BlocksColorAPI.getColor((Item)stack.getItem());
                if (col != null) {
                    this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), 0.5f, 1.0f);
                    this.setSeatType(col);
                    stack.shrink(1);
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            } else if (this.tryAddingChest(stack) != null) {
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (!this.hasPuller()) {
                double radius = 7.0;
                double x = player.getX();
                double y = player.getY();
                double z = player.getZ();
                Mob found = null;
                for (Mob mob : level.getEntitiesOfClass(Mob.class, new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius))) {
                    if (mob.getLeashHolder() != player) continue;
                    found = mob;
                    break;
                }
                if (found != null) {
                    Fox fox;
                    TamableAnimal ta;
                    boolean owned;
                    boolean bl = owned = found instanceof TamableAnimal && (ta = (TamableAnimal)found).getOwner() == player || found instanceof Fox && (fox = (Fox)found).trusts(player.getUUID());
                    if (owned && this.tryConnectingPuller((Entity)found)) {
                        this.playSound(SoundEvents.LEASH_KNOT_PLACE, 1.0f, 1.0f);
                        if (this.chest != null && player instanceof ServerPlayer) {
                            ServerPlayer sp = (ServerPlayer)player;
                            Utils.awardAdvancement((ServerPlayer)sp, (ResourceLocation)SnowySpirit.res("adventure/sled_with_wolf"));
                        }
                        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                    }
                    return InteractionResult.FAIL;
                }
            }
            if (!level.isClientSide) {
                return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected boolean canAddPassenger(Entity entity) {
        if (this.isEyeInFluid(FluidTags.WATER)) {
            return false;
        }
        int maxAllowed = this.getMaxPassengersSize();
        if (this.getPassengers().size() >= maxAllowed) {
            return false;
        }
        return !this.hasChest() || !(entity instanceof ContainerHolderEntity);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity le;
        Entity v = this.getFirstPassenger();
        return v instanceof LivingEntity ? (le = (LivingEntity)v) : null;
    }

    public void onInputUpdate(boolean left, boolean right, boolean up, boolean down, boolean sprint, boolean jumping) {
        this.inputLeft = left;
        this.inputRight = right;
        this.inputUp = up;
        this.inputDown = down;
    }

    protected void addPassenger(Entity passenger) {
        super.addPassenger(passenger);
        if (this.isControlledByLocalInstance() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.absMoveTo(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYRot, (float)this.lerpXRot);
        }
        this.updatePullerIndex();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        int ind;
        super.onSyncedDataUpdated(key);
        if (this.level().isClientSide && DATA_WOLF_INDEX.equals(key) && (ind = this.getPullerIndex()) != -1 && this.getPassengers().size() > ind) {
            Entity wolf = (Entity)this.getPassengers().get(ind);
            this.tryConnectingPuller(wolf);
        }
    }

    protected Vec3 getPassengerAttachmentPoint(Entity passenger, EntityDimensions dimensions, float partialTick) {
        if (this.isMyPuller(passenger)) {
            return this.pullerPos;
        }
        float zPos = 0.0f;
        float yPos = 0.45f + this.getAdditionalY() + (this.getSeatType() != null ? 0.0615f : 0.0f);
        if (this.isChestEntity(passenger)) {
            zPos = -0.4f;
            float cos = Mth.sin((float)((float)((double)this.getXRot() * Math.PI / 180.0)));
            yPos -= cos * zPos;
        } else {
            boolean isMoreThanOneOnBoard;
            boolean bl = isMoreThanOneOnBoard = this.getPassengers().size() > this.getMaxPassengersSize() - 1;
            if (isMoreThanOneOnBoard) {
                Entity p;
                int i = 0;
                Iterator iterator = this.getPassengers().iterator();
                while (iterator.hasNext() && (p = (Entity)iterator.next()) != passenger) {
                    if (this.isMyPuller(p) || this.isChestEntity(p)) continue;
                    ++i;
                }
                float cos = Mth.sin((float)((float)((double)this.getXRot() * Math.PI / 180.0)));
                zPos = i == 0 ? 0.1f : -0.8f;
                yPos -= cos * zPos;
            }
            if (passenger instanceof Animal && isMoreThanOneOnBoard) {
                zPos += 0.2f;
            }
        }
        return new Vec3(0.0, (double)yPos, (double)zPos).yRot(-this.getYRot() * ((float)Math.PI / 180));
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction setPos) {
        super.positionRider(passenger, setPos);
        if (!passenger.getType().is(EntityTypeTags.CAN_TURN_IN_BOATS)) {
            if (this.chest == null && passenger instanceof ContainerHolderEntity) {
                ContainerHolderEntity container;
                this.chest = container = (ContainerHolderEntity)passenger;
            }
            if (this.isMyPuller(passenger)) {
                Animal animal = (Animal)passenger;
                passenger.setYRot(passenger.getYRot() + this.deltaRotation);
                this.clampRotation(passenger);
                passenger.setYBodyRot(animal.yBodyRot + this.deltaRotation * 10.0f);
                passenger.setYHeadRot(animal.yBodyRot);
                this.updatePullerAnimations();
            } else {
                boolean isMoreThanOneOnBoard = false;
                if (this.isChestEntity(passenger)) {
                    passenger.xRotO = this.xRotO;
                    passenger.setXRot(this.getXRot());
                    passenger.yRotO = this.yRotO;
                    passenger.setYRot(this.getYRot());
                } else {
                    isMoreThanOneOnBoard = this.getPassengers().size() > this.getMaxPassengersSize() - 1;
                    passenger.setYRot(passenger.getYRot() + this.deltaRotation);
                    passenger.setYHeadRot(passenger.getYHeadRot() + this.deltaRotation);
                    this.clampRotation(passenger);
                }
                if (passenger instanceof Animal) {
                    Animal animal = (Animal)passenger;
                    if (isMoreThanOneOnBoard) {
                        int yRot = passenger.getId() % 2 == 0 ? 90 : 270;
                        passenger.setYBodyRot(animal.yBodyRot + (float)yRot);
                        passenger.setYHeadRot(passenger.getYHeadRot() + (float)yRot);
                    }
                }
            }
        }
    }

    public void dismountTo(double pX, double pY, double pZ) {
        this.setDataAdditionalY(0.0f);
        this.projectedPos = Vec3.ZERO;
        super.dismountTo(pX, pY, pZ);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity entity) {
        Vec3 vec3 = SledEntity.getCollisionHorizontalEscapeVector((double)(this.getBbWidth() * Mth.SQRT_OF_TWO), (double)entity.getBbWidth(), (float)entity.getYRot());
        double d0 = this.getX() + vec3.x;
        double d1 = this.getZ() + vec3.z;
        BlockPos blockpos = BlockPos.containing((double)d0, (double)this.getBoundingBox().maxY, (double)d1);
        BlockPos below = blockpos.below();
        Level level = this.level();
        if (!level.isWaterAt(below)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = level.getBlockFloorHeight(blockpos);
            if (DismountHelper.isBlockFloorValid((double)d2)) {
                list.add(new Vec3(d0, (double)blockpos.getY() + d2, d1));
            }
            if (DismountHelper.isBlockFloorValid((double)(d3 = level.getBlockFloorHeight(below)))) {
                list.add(new Vec3(d0, (double)below.getY() + d3, d1));
            }
            for (Pose pose : entity.getDismountPoses()) {
                for (Vec3 vec31 : list) {
                    if (!DismountHelper.canDismountTo((CollisionGetter)level, (Vec3)vec31, (LivingEntity)entity, (Pose)pose)) continue;
                    entity.setPose(pose);
                    return vec31;
                }
            }
        }
        return super.getDismountLocationForPassenger(entity);
    }

    public void ejectPassengers() {
        if (this.sledPuller != null) {
            this.disconnectPuller();
        }
        this.chest = null;
        super.ejectPassengers();
    }

    protected void removePassenger(Entity pPassenger) {
        if (this.sledPuller == pPassenger) {
            this.disconnectPuller();
        }
        if (this.chest == pPassenger) {
            this.chest = null;
        }
        super.removePassenger(pPassenger);
        this.updatePullerIndex();
    }

    public void onPassengerTurned(Entity entity) {
        this.clampRotation(entity);
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)this.getSledItem());
    }

    public Item getSledItem() {
        return (Item)ModRegistry.SLED_ITEMS.get(this.getWoodType());
    }

    public boolean isComfy() {
        return true;
    }

    public boolean isChestEntity(Entity entity) {
        return entity == this.chest;
    }

    public boolean hasChest() {
        return this.chest != null;
    }

    public boolean hasPuller() {
        return this.sledPuller != null;
    }

    public boolean isMyPuller(Entity entity) {
        return entity == this.sledPuller;
    }

    @Nullable
    public Animal getSledPuller() {
        return this.sledPuller;
    }

    public boolean tryConnectingPuller(Entity entity) {
        if (entity instanceof Animal) {
            Animal wolf = (Animal)entity;
            if (entity.level().isClientSide) {
                this.sledPuller = wolf;
                return true;
            }
            if (entity.getType().is(ModTags.WOLVES) && (double)entity.getBbWidth() < CommonConfigs.MAX_SLED_PULLER_SIZE.get()) {
                wolf.dropLeash(true, false);
                if (wolf.startRiding((Entity)this) && this.hasPassenger((Entity)wolf)) {
                    this.setPullerIndex((byte)this.getPassengers().indexOf(wolf));
                    this.sledPuller = wolf;
                    return true;
                }
                wolf.spawnAtLocation((ItemLike)Items.LEAD);
                return false;
            }
        }
        return false;
    }

    public void updatePuller() {
        Entity wolf;
        int ind = this.getPullerIndex();
        if (this.sledPuller != null) {
            Entity wolf2;
            if (this.sledPuller.isRemoved()) {
                this.sledPuller = null;
                this.setPullerIndex(-1);
                return;
            }
            if (ind == -1) {
                this.sledPuller = null;
                return;
            }
            this.sledPuller.setInvulnerable(true);
            if (this.getPassengers().size() > ind && (wolf2 = (Entity)this.getPassengers().get(ind)) != this.sledPuller) {
                this.sledPuller = null;
                this.setPullerIndex(-1);
            }
        } else if (ind >= 0 && this.getPassengers().size() > ind && (wolf = (Entity)this.getPassengers().get(ind)) instanceof Animal) {
            Animal a;
            this.sledPuller = a = (Animal)wolf;
        }
    }

    public void disconnectPuller() {
        if (this.sledPuller != null && !this.level().isClientSide) {
            this.setPullerIndex(-1);
            Animal animal = this.sledPuller;
            if (animal instanceof TamableAnimal) {
                TamableAnimal tamableAnimal = (TamableAnimal)animal;
                tamableAnimal.setInSittingPose(false);
            } else {
                animal = this.sledPuller;
                if (animal instanceof Fox) {
                    Fox fox = (Fox)animal;
                    fox.setSitting(false);
                }
            }
            this.sledPuller.setInvulnerable(false);
            this.sledPuller = null;
        }
    }

    protected void updatePullerIndex() {
        for (Entity p : this.getPassengers()) {
            if (p != this.sledPuller) continue;
            this.setPullerIndex(this.getPassengers().indexOf(p));
        }
    }

    protected void updatePullerAnimations() {
        if (this.sledPuller != null) {
            double travelZ;
            double travelY;
            double travelX = this.sledPuller.getX() - this.sledPuller.xo;
            float speed = (float)Mth.length((double)travelX, (double)(travelY = 0.0), (double)(travelZ = this.sledPuller.getZ() - this.sledPuller.zo)) * 4.0f;
            if (speed > 1.0f) {
                speed = 1.0f;
            }
            this.internalPullerAnimation.update(speed, 0.4f);
            this.sledPuller.walkAnimation.setSpeed(this.internalPullerAnimation.speed());
            this.sledPuller.walkAnimation.position = this.internalPullerAnimation.position;
            this.sledPuller.walkAnimation.speedOld = this.internalPullerAnimation.speedOld;
            Vec3 m = this.isControlledByLocalInstance() ? this.getDeltaMovement() : this.getSyncedMovement();
            boolean sit = m.lengthSqr() < 1.0E-5;
            Animal animal = this.sledPuller;
            if (animal instanceof TamableAnimal) {
                TamableAnimal tamableAnimal = (TamableAnimal)animal;
                if (tamableAnimal.isInSittingPose() != sit) {
                    tamableAnimal.setInSittingPose(sit);
                }
            } else {
                Fox fox;
                animal = this.sledPuller;
                if (animal instanceof Fox && (fox = (Fox)animal).isSitting() != sit) {
                    fox.setSitting(sit);
                }
            }
        }
    }

    private boolean canAddChest() {
        return this.getPassengers().size() < this.getMaxPassengersSize() && !this.hasChest();
    }

    private int getMaxPassengersSize() {
        return this.hasPuller() ? 3 : 2;
    }

    public void makeStuckInBlock(BlockState pState, Vec3 pMotionMultiplier) {
        if (pState.is(ModTags.SLED_SNOW) || pState.getBlock() instanceof SnowLayerBlock) {
            return;
        }
        super.makeStuckInBlock(pState, pMotionMultiplier);
    }
}

