/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.network;

import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.common.entity.SledEntity;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class ServerBoundUpdateSledState
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ServerBoundUpdateSledState> CODEC = Message.makeType((ResourceLocation)SnowySpirit.res("s2c_update_sled_movement"), ServerBoundUpdateSledState::new);
    public final float clientDx;
    public final float clientDy;
    public final float clientDz;

    public ServerBoundUpdateSledState(RegistryFriendlyByteBuf buffer) {
        this.clientDx = buffer.readFloat();
        this.clientDy = buffer.readFloat();
        this.clientDz = buffer.readFloat();
    }

    public ServerBoundUpdateSledState(Vec3 movement) {
        this.clientDx = (float)movement.x;
        this.clientDy = (float)movement.y;
        this.clientDz = (float)movement.z;
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeFloat(this.clientDx);
        buffer.writeFloat(this.clientDy);
        buffer.writeFloat(this.clientDz);
    }

    public void handle(Message.Context context) {
        Entity entity = context.getPlayer().getVehicle();
        if (entity instanceof SledEntity) {
            SledEntity sled = (SledEntity)entity;
            sled.setSyncedMovement(this.clientDx, this.clientDy, this.clientDx);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

