/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.wreath;

import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.snowyspirit.common.network.ClientBoundSyncWreathMessage;
import net.mehvahdjukaar.snowyspirit.common.wreath.WreathSavedData;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class WreathHelper {
    public static boolean placeWreathOnDoor(BlockPos pos, Level level) {
        BlockState door;
        WreathSavedData c = WreathSavedData.get(level);
        if (c != null && (door = level.getBlockState(pos)).getBlock() instanceof DoorBlock) {
            BlockPos p;
            boolean lower = door.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER;
            BlockPos blockPos = p = lower ? pos.above() : pos;
            if (!c.hasWreath(p)) {
                if (level instanceof ServerLevel) {
                    BlockState state = ModRegistry.WREATH.get().defaultBlockState();
                    c.refreshWreathVisual(p, level);
                    SoundType soundtype = state.getSoundType();
                    level.playSound(null, p, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                    NetworkHelper.sendToAllClientPlayers((CustomPacketPayload)new ClientBoundSyncWreathMessage(p, true));
                }
                return true;
            }
        }
        return false;
    }
}

