/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.wreath;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WreathSavedData
extends SavedData {
    private static final String FILE_ID = "wreaths";
    public static final SavedData.Factory<WreathSavedData> FACTORY = new SavedData.Factory(WreathSavedData::new, (compoundTag, registries) -> {
        WreathSavedData data = new WreathSavedData();
        data.load((CompoundTag)compoundTag, (HolderLookup.Provider)registries);
        return data;
    }, null);
    private static final WreathSavedData clientData = new WreathSavedData();
    private final Map<BlockPos, Data> wreathBlocks = new HashMap<BlockPos, Data>();

    public static WreathSavedData get(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return (WreathSavedData)serverLevel.getDataStorage().computeIfAbsent(FACTORY, FILE_ID);
        }
        return clientData;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        int i = 0;
        for (BlockPos pos : this.wreathBlocks.keySet()) {
            NbtUtils.writeBlockPos((BlockPos)pos);
            tag.put("" + i, NbtUtils.writeBlockPos((BlockPos)pos));
            ++i;
        }
        tag.putInt("Count", i);
        return tag;
    }

    public void load(CompoundTag total, HolderLookup.Provider reg) {
        for (int i = 0; i < total.getInt("Count"); ++i) {
            BlockPos pos = (BlockPos)NbtUtils.readBlockPos((CompoundTag)total, (String)("" + i)).orElseThrow();
            this.addWreath(pos);
        }
    }

    public Data addWreath(BlockPos pos) {
        return this.wreathBlocks.computeIfAbsent(pos, Data::new);
    }

    public void removeWreath(BlockPos p, Level level, boolean animationAndDrop) {
        this.wreathBlocks.remove(p);
        if (animationAndDrop) {
            ItemEntity itementity = new ItemEntity(level, (double)p.getX() + 0.5, (double)p.getY() + 0.5, (double)p.getZ() + 0.5, ModRegistry.WREATH.get().asItem().getDefaultInstance());
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
            level.levelEvent(2001, p, Block.getId((BlockState)ModRegistry.WREATH.get().defaultBlockState()));
        }
    }

    public Map<BlockPos, Data> getWreathBlocks() {
        return this.wreathBlocks;
    }

    public boolean hasWreath(BlockPos pos) {
        return this.wreathBlocks.containsKey(pos);
    }

    public void refreshWreathVisual(BlockPos pos, Level level) {
        if (level.isLoaded(pos)) {
            BlockState state = level.getBlockState(pos);
            if (state.getBlock() instanceof DoorBlock) {
                Direction dir = (Direction)state.getValue((Property)DoorBlock.FACING);
                boolean open = (Boolean)state.getValue((Property)DoorBlock.OPEN);
                boolean hinge = state.getValue((Property)DoorBlock.HINGE) == DoorHingeSide.RIGHT;
                Data data = this.addWreath(pos);
                data.face = dir;
                data.hinge = hinge;
                data.open = open;
                if (data.needsInitialization) {
                    this.calculateDoorDimensions(level, pos, state, data);
                    data.needsInitialization = false;
                }
            } else {
                this.removeWreath(pos, level, false);
            }
        }
    }

    private void calculateDoorDimensions(Level level, BlockPos pos, BlockState state, Data data) {
        double back;
        double front;
        state = (BlockState)((BlockState)((BlockState)state.setValue((Property)DoorBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.FALSE)).setValue((Property)DoorBlock.HINGE, (Comparable)DoorHingeSide.RIGHT);
        VoxelShape shape = state.getShape((BlockGetter)level, pos);
        AABB bounds = shape.bounds();
        if (bounds.maxX - bounds.minX >= 1.0) {
            front = bounds.minZ - 1.0;
            back = -bounds.maxZ;
            data.closedDimensions = Pair.of((Object)Float.valueOf((float)front), (Object)Float.valueOf((float)back));
        }
        state = (BlockState)((BlockState)state.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.TRUE)).setValue((Property)DoorBlock.FACING, (Comparable)Direction.EAST);
        shape = state.getShape((BlockGetter)level, pos);
        bounds = shape.bounds();
        if (bounds.maxX - bounds.minX >= 1.0) {
            front = bounds.minZ - 1.0;
            back = -bounds.maxZ;
            data.openDimensions = Pair.of((Object)Float.valueOf((float)front), (Object)Float.valueOf((float)back));
        }
    }

    public void refreshClientBlocksVisuals(Level level) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>(this.wreathBlocks.keySet());
        positions.forEach(p -> this.refreshWreathVisual((BlockPos)p, level));
    }

    public void updateAllBlocks(ServerLevel level) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>(this.wreathBlocks.keySet());
        positions.forEach(p -> {
            BlockState state;
            if (level.isLoaded(p) && !((state = level.getBlockState(p)).getBlock() instanceof DoorBlock)) {
                this.removeWreath((BlockPos)p, (Level)level, true);
            }
        });
    }

    public static class Data {
        private Direction face = Direction.NORTH;
        private boolean open = true;
        private boolean hinge = true;
        private boolean needsInitialization = true;
        private Pair<Float, Float> openDimensions = null;
        private Pair<Float, Float> closedDimensions = null;

        public Data(BlockPos pos) {
        }

        public Direction getDirection() {
            if (this.open) {
                return this.hinge ? this.face.getCounterClockWise() : this.face.getClockWise();
            }
            return this.face;
        }

        public boolean isOpen() {
            return this.open;
        }

        public boolean isHinge() {
            return this.hinge;
        }

        public Pair<Float, Float> getDimensions() {
            return this.open ? this.openDimensions : this.closedDimensions;
        }
    }
}

