/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.reg;

import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.snowyspirit.common.ai.WinterVillagerAI;
import net.mehvahdjukaar.snowyspirit.common.entity.SledEntity;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ModSetup {
    public static void setup() {
        WinterVillagerAI.setup();
        ModSetup.registerBurnTimes();
        ModRegistry.SLED_ITEMS.forEach((key, value) -> DispenserBlock.registerBehavior((ItemLike)value, (DispenseItemBehavior)new SledDispenserBehavior((WoodType)key)));
    }

    private static void registerBurnTimes() {
        for (Supplier<Block> b : ModRegistry.GLOW_LIGHTS_BLOCKS.values()) {
            RegHelper.registerBlockFlammability((Block)b.get(), (int)30, (int)60);
        }
        RegHelper.registerBlockFlammability((Block)ModRegistry.GINGER_WILD.get(), (int)60, (int)100);
    }

    public static class SledDispenserBehavior
    extends DefaultDispenseItemBehavior {
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();
        private final WoodType type;

        public SledDispenserBehavior(WoodType pType) {
            this.type = pType;
        }

        public ItemStack execute(BlockSource pSource, ItemStack pStack) {
            Direction direction = (Direction)pSource.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel level = pSource.level();
            Vec3 center = pSource.center();
            double d0 = center.x() + (double)((float)direction.getStepX() * 1.2f);
            double d1 = center.y() + (double)((float)direction.getStepY() * 1.2f);
            double d2 = center.z() + (double)((float)direction.getStepZ() * 1.2f);
            BlockPos blockpos = pSource.pos().relative(direction);
            if (!level.getBlockState(blockpos).isAir() || !level.getFluidState(blockpos).isEmpty()) {
                return this.defaultDispenseItemBehavior.dispense(pSource, pStack);
            }
            SledEntity sled = new SledEntity((Level)level, d0, d1, d2);
            sled.setWoodType(this.type);
            sled.setYRot(direction.toYRot());
            level.addFreshEntity((Entity)sled);
            pStack.shrink(1);
            return pStack;
        }

        protected void playSound(BlockSource pSource) {
            pSource.level().levelEvent(1000, pSource.pos(), 0);
        }
    }
}

