/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_173;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_6862;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_8490;
import net.minecraft.class_8786;

public class ResourceSink {
    private final String modId;
    private final String packId;
    final Map<class_2960, byte[]> resources = new HashMap<class_2960, byte[]>();
    final Set<class_2960> notClearable = new HashSet<class_2960>();
    final Map<class_6862<?>, SimpleTagBuilder> tags = new HashMap();

    public ResourceSink(String modId, String packId) {
        this.modId = modId;
        this.packId = packId;
    }

    protected void addBytes(class_2960 id, byte[] bytes) {
        this.resources.put(id, (byte[])Preconditions.checkNotNull((Object)bytes));
    }

    public void addResource(StaticResource resource) {
        this.addBytes(resource.location, resource.data);
    }

    private void addJson(class_2960 path, JsonElement json) {
        try {
            this.addBytes(path, RPUtils.serializeJson(json).getBytes());
        }
        catch (IOException e) {
            Moonlight.LOGGER.error("Failed to write JSON {} to resource pack.", (Object)path, (Object)e);
        }
    }

    public void addJson(class_2960 location, JsonElement json, ResType resType) {
        this.addJson(resType.getPath(location), json);
    }

    public void addBytes(class_2960 location, byte[] bytes, ResType resType) {
        this.addBytes(resType.getPath(location), bytes);
    }

    @Deprecated(forRemoval=true)
    public void addAndCloseTexture(class_2960 path, TextureImage image) {
        this.addAndCloseTexture(path, image, true);
    }

    @Deprecated(forRemoval=true)
    public void addAndCloseTexture(class_2960 path, TextureImage image, boolean isOnAtlas) {
        try (TextureImage textureImage = image;){
            this.addTexture(path, image, isOnAtlas);
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to add image {} to resource pack {}.", (Object)path, (Object)this, (Object)e);
        }
    }

    public void addAndCloseTexture(class_2960 path, Supplier<TextureImage> image) {
        try (TextureImage img = image.get();){
            this.addTexture(path, img);
        }
    }

    public void addTexture(class_2960 path, TextureImage image) {
        this.addTexture(path, image, true);
    }

    public void addTexture(class_2960 path, TextureImage image, boolean isOnAtlas) {
        try {
            this.addBytes(path, image.getImage().method_24036(), ResType.TEXTURES);
            if (!isOnAtlas) {
                this.markNotClearable(ResType.TEXTURES.getPath(path));
            }
            if (image.getMcMeta() != null) {
                this.addJson(path, (JsonElement)image.getMcMeta().toJson(), ResType.MCMETA);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void markNotClearable(class_2960 path) {
        this.notClearable.add(path);
    }

    public void addBlockModel(class_2960 modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.BLOCK_MODELS);
    }

    public void addItemModel(class_2960 modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.ITEM_MODELS);
    }

    public void addBlockState(class_2960 modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.BLOCKSTATES);
    }

    public void addLang(class_2960 langName, JsonElement language) {
        this.addJson(langName, language, ResType.LANG);
    }

    public void addLang(class_2960 langName, LangBuilder builder) {
        this.addJson(langName, builder.build(), ResType.LANG);
    }

    public void addTag(SimpleTagBuilder builder, class_5321<? extends class_2378<?>> reg) {
        this.tags.put(class_6862.method_40092(reg, (class_2960)builder.getId()), builder);
    }

    public void addSimpleBlockLootTable(class_2248 block) {
        this.addLootTable(block, ResourceSink.createSingleItemTable((class_1935)block).method_334(class_173.field_1172));
    }

    public void addLootTable(class_2248 block, class_52.class_53 table) {
        this.addLootTable(block.method_26162().method_29177(), table.method_338());
    }

    public void addLootTable(class_2960 id, class_52 table) {
        this.addJson(id, (JsonElement)class_8490.field_44498.comp_2520.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)table).getOrThrow(), ResType.LOOT_TABLES);
    }

    protected static class_52.class_53 createSingleItemTable(class_1935 itemLike) {
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)itemLike)).method_354());
    }

    public void addRecipe(class_8786<?> holder) {
        this.addRecipe(holder.comp_1933(), holder.comp_1932());
    }

    public void addRecipe(class_1860<?> recipe, class_2960 id) {
        this.addRecipeNoAdvancement(recipe, id);
    }

    public void addRecipeNoAdvancement(class_1860<?> recipe, class_2960 id) {
        this.addJson(id, RPUtils.writeRecipe(recipe), ResType.RECIPES);
    }

    public void addResourceIfNotPresent(class_3300 manager, StaticResource resource) {
        if (!this.alreadyHasAssetAtLocation(manager, resource.location)) {
            this.addResource(resource);
        }
    }

    public boolean alreadyHasTextureAtLocation(class_3300 manager, class_2960 res) {
        return this.alreadyHasAssetAtLocation(manager, res, ResType.TEXTURES);
    }

    public void addTextureIfNotPresent(class_3300 manager, String relativePath, Supplier<TextureImage> textureSupplier) {
        this.addTextureIfNotPresent(manager, relativePath, textureSupplier, true);
    }

    public void addTextureIfNotPresent(class_3300 manager, String relativePath, Supplier<TextureImage> textureSupplier, boolean isOnAtlas) {
        class_2960 res;
        class_2960 class_29602 = res = relativePath.contains(":") ? class_2960.method_60654((String)relativePath) : class_2960.method_60655((String)this.modId, (String)relativePath);
        if (!this.alreadyHasTextureAtLocation(manager, res)) {
            try (TextureImage textureImage = textureSupplier.get();){
                this.addTexture(res, textureImage, isOnAtlas);
            }
            catch (Exception e) {
                Moonlight.LOGGER.error("Failed to generate texture {}: {}", (Object)res, (Object)e);
            }
        }
    }

    public boolean alreadyHasAssetAtLocation(class_3300 manager, class_2960 res, ResType type) {
        return this.alreadyHasAssetAtLocation(manager, type.getPath(res));
    }

    public boolean alreadyHasAssetAtLocation(class_3300 manager, class_2960 res) {
        Optional resource = manager.method_14486(res);
        return resource.filter(value -> !value.method_14480().equals(this.packId)).isPresent();
    }

    public void addSimilarJsonResource(class_3300 manager, StaticResource resource, String keyword, String replaceWith) throws NoSuchElementException {
        this.addSimilarJsonResource(manager, resource, s -> s.replace(keyword, replaceWith));
    }

    public void addSimilarJsonResource(class_3300 manager, StaticResource resource, Function<String, String> textTransform) throws NoSuchElementException {
        this.addSimilarJsonResource(manager, resource, textTransform, textTransform);
    }

    public void addSimilarJsonResource(class_3300 manager, StaticResource resource, Function<String, String> textTransform, Function<String, String> pathTransform) throws NoSuchElementException {
        class_2960 fullPath = resource.location;
        StringBuilder builder = new StringBuilder();
        String[] partial = fullPath.method_12832().split("/");
        for (int i = 0; i < partial.length; ++i) {
            if (i != 0) {
                builder.append("/");
            }
            if (i == partial.length - 1) {
                builder.append(pathTransform.apply(partial[i]));
                continue;
            }
            builder.append(partial[i]);
        }
        class_2960 newRes = class_2960.method_60655((String)this.modId, (String)builder.toString());
        if (!this.alreadyHasAssetAtLocation(manager, newRes)) {
            String fullText = resource.asString();
            fullText = textTransform.apply(fullText);
            this.addBytes(newRes, fullText.getBytes());
        }
    }

    public void copyResource(class_3300 manager, class_2960 from, class_2960 to, boolean lenient) {
        Optional resource = manager.method_14486(from);
        if (resource.isPresent()) {
            StaticResource s = StaticResource.of((class_3298)resource.get(), from);
            this.addBytes(to, s.data);
        } else if (lenient) {
            Moonlight.LOGGER.info("Resource {} not found for copying to {}", (Object)from, (Object)to);
        } else {
            throw new NoSuchElementException("Resource " + String.valueOf(from) + " not found for copying to " + String.valueOf(to));
        }
    }

    public void appendModelOverride(class_3300 manager, class_2960 modelRes, Consumer<RPUtils.OverrideAppender> modelConsumer) {
        JsonElement json = RPUtils.makeModelOverride(manager, modelRes, modelConsumer);
        this.addItemModel(modelRes, json);
    }
}

