/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.INamedSupplier;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockType {
    private final BiMap<String, Object> children = HashBiMap.create();
    public final class_2960 id;

    protected BlockType(class_2960 resourceLocation) {
        this.id = resourceLocation;
    }

    public class_2960 getId() {
        return this.id;
    }

    public String getTypeName() {
        return this.id.method_12832();
    }

    public String getNamespace() {
        return this.id.method_12836();
    }

    public String getAppendableId() {
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public String getAppendableIdWith(String suffix) {
        return this.getAppendableIdWith("", suffix);
    }

    public String getAppendableIdWith(String prefix, String suffix) {
        Object prefixed = prefix.isEmpty() ? "" : prefix + "_";
        return this.getNamespace() + "/" + (String)prefixed + this.getTypeName() + "_" + suffix;
    }

    public String createPathWith(String shortenedId, String suffix) {
        return this.createFullIdWith("", "", shortenedId, "", suffix);
    }

    public String createPathWith(String shortenedId, String prefix, String suffix) {
        return this.createFullIdWith("", "", shortenedId, prefix, suffix);
    }

    public String createFullIdWith(String modIdOrEmpty, String folderOrEmpty, String shortenedIdOrEmpty, String prefixOrEmpty, String suffix) {
        Object modIded = modIdOrEmpty.isEmpty() ? "" : modIdOrEmpty + ":";
        Object foldered = folderOrEmpty.isEmpty() ? "" : folderOrEmpty + "/";
        String namespaced = modIdOrEmpty.equals(this.getNamespace()) ? "" : this.getNamespace() + "/";
        Object shortenedId = shortenedIdOrEmpty.isEmpty() ? "" : shortenedIdOrEmpty + "/";
        Object prefixed = "";
        if (prefixOrEmpty.contains("/")) {
            prefixed = prefixOrEmpty;
        } else if (!prefixOrEmpty.isEmpty()) {
            prefixed = prefixOrEmpty + "_";
        }
        Object suffixed = "";
        if (suffix.matches("\\.(png|json)")) {
            suffixed = suffix;
        } else if (!suffix.isEmpty()) {
            suffixed = "_" + suffix;
        }
        return (String)modIded + (String)foldered + (String)shortenedId + namespaced + (String)prefixed + this.getTypeName() + (String)suffixed;
    }

    public String toString() {
        return this.id.toString();
    }

    public abstract String getTranslationKey();

    public String getVariantId(String baseName) {
        String namespace;
        String string = namespace = this.isVanilla() ? "" : this.getNamespace() + "/";
        if (baseName.contains("%s")) {
            return namespace + String.format(baseName, this.getTypeName());
        }
        return namespace + baseName + "_" + this.getTypeName();
    }

    public String getVariantId(String baseName, boolean prefix) {
        return this.getVariantId(prefix ? baseName + "_%s" : "%s_" + baseName);
    }

    public String getVariantId(String postfix, String prefix) {
        return this.getVariantId(prefix + "_%s_" + postfix);
    }

    public String getReadableName() {
        return LangBuilder.getReadableName(this.getTypeName());
    }

    public boolean isVanilla() {
        return this.getNamespace().equals("minecraft");
    }

    public <T extends BlockType> BlockTypeRegistry<T> getRegistry() {
        return BlockSetInternal.getRegistry(this.getClass());
    }

    @Nullable
    protected <V> V findRelatedEntry(String after, class_2378<V> reg) {
        return this.findRelatedEntry(after, "", reg);
    }

    @Nullable
    protected <V> V findRelatedEntry(String before, String after, class_2378<V> reg) {
        if (!((String)after).isEmpty()) {
            after = "_" + (String)after;
        }
        class_2960[] targets = new class_2960[]{this.id.method_45136(this.id.method_12832() + "_" + before + (String)after), this.id.method_45136(before + "_" + this.id.method_12832() + (String)after)};
        return Utils.findFirstInRegistry(reg, targets);
    }

    public Set<Map.Entry<String, Object>> getChildren() {
        return this.children.entrySet();
    }

    @Nullable
    public class_1792 getItemOfThis(String key) {
        class_1792 class_17922;
        Object v = this.getChild(key);
        if (v instanceof class_1935) {
            class_1935 i = (class_1935)v;
            class_17922 = i.method_8389();
        } else {
            class_17922 = null;
        }
        return class_17922;
    }

    @Nullable
    public class_2248 getBlockOfThis(String key) {
        class_2248 b;
        Object v = this.getChild(key);
        if (v instanceof class_1747) {
            class_1747 bi = (class_1747)v;
            return bi.method_7711();
        }
        return v instanceof class_2248 ? (b = (class_2248)v) : null;
    }

    @Nullable
    public Object getChild(String key) {
        return this.children.get((Object)key);
    }

    public boolean hasChild(String key) {
        return this.children.containsKey((Object)key);
    }

    public boolean hasChildren(String ... keys) {
        for (String key : keys) {
            if (this.hasChild(key)) continue;
            return false;
        }
        return true;
    }

    public void addChild(String genericName, @Nullable Object obj) {
        if (obj == class_1802.field_8162 || obj == class_2246.field_10124) {
            throw new IllegalStateException("Tried to add air block/item to Block Type. Key " + genericName + ". This is a Moonlight bug, please report me");
        }
        if (obj != null) {
            try {
                this.children.put((Object)genericName, obj);
                BlockTypeRegistry<?> registry = BlockSetInternal.getRegistry(this.getClass());
                if (registry != null) {
                    registry.mapObjectToType(obj, this);
                }
            }
            catch (Exception e) {
                Moonlight.LOGGER.error("Failed to add block type child: value already present. Key {}, Object {}, BlockType {}", (Object)genericName, obj, (Object)this);
            }
        }
    }

    protected abstract void initializeChildrenBlocks();

    protected abstract void initializeChildrenItems();

    public abstract class_1935 mainChild();

    @Nullable
    public String getChildKey(Object child) {
        BiMap inverse = this.children.inverse();
        String firs = (String)inverse.get(child);
        if (firs != null) {
            return firs;
        }
        if (child instanceof class_1747) {
            class_1747 bi = (class_1747)child;
            return (String)inverse.get((Object)bi.method_7711());
        }
        return null;
    }

    @Nullable
    public static Object changeType(Object current, BlockType originalMat, BlockType destinationMat) {
        if (destinationMat == originalMat) {
            return current;
        }
        String key = originalMat.getChildKey(current);
        if (key != null) {
            return destinationMat.getChild(key);
        }
        return null;
    }

    @Nullable
    public static class_1792 changeItemType(class_1792 current, BlockType originalMat, BlockType destinationMat) {
        class_2248 il;
        class_1792 i;
        class_1747 bi;
        Object blockChanged;
        Object changed = BlockType.changeType(current, originalMat, destinationMat);
        if (changed == null && current instanceof class_1747 && (blockChanged = BlockType.changeType((bi = (class_1747)current).method_7711(), originalMat, destinationMat)) instanceof class_2248 && (i = (il = (class_2248)blockChanged).method_8389()) != class_1802.field_8162) {
            changed = i;
        }
        if (changed instanceof class_1935) {
            class_1935 il2 = (class_1935)changed;
            if (il2.method_8389() == current) {
                Moonlight.LOGGER.error("Somehow changed an item type into itself. How? Target mat {}, destination map {}, item {}", (Object)destinationMat, (Object)originalMat, (Object)il2);
            }
            return il2.method_8389();
        }
        return null;
    }

    @Nullable
    public static class_2248 changeBlockType(@NotNull class_2248 current, BlockType originalMat, BlockType destinationMat) {
        class_1747 bi;
        class_1792 i;
        Object itemChanged;
        Object changed = BlockType.changeType(current, originalMat, destinationMat);
        if (changed == null && current.method_8389() != class_1802.field_8162 && (itemChanged = BlockType.changeType(current.method_8389(), originalMat, destinationMat)) instanceof class_1747 && (i = (bi = (class_1747)itemChanged).method_8389()) != class_1802.field_8162) {
            changed = i;
        }
        if (changed instanceof class_2248) {
            class_2248 b = (class_2248)changed;
            return b;
        }
        return null;
    }

    public class_2498 getSound() {
        class_1935 class_19352 = this.mainChild();
        if (class_19352 instanceof class_2248) {
            class_2248 b = (class_2248)class_19352;
            return b.method_9564().method_26231();
        }
        return class_2498.field_11544;
    }

    public static abstract class SetFinderBuilder<T extends BlockType>
    implements SetFinder<T> {
        protected final class_2960 id;
        protected final Map<String, Supplier<class_1935>> childNames = new HashMap<String, Supplier<class_1935>>();
        private final BlockTypeRegistry<T> reg;

        public SetFinderBuilder(class_2960 id, BlockTypeRegistry<T> reg) {
            this.id = id;
            this.reg = reg;
        }

        public SetFinderBuilder<T> child(String childType, Supplier<class_1935> child) {
            this.childNames.put(childType, child);
            return this;
        }

        public SetFinderBuilder<T> childItem(String childType, class_2960 childName) {
            return this.child(childType, () -> (class_1935)class_7923.field_41178.method_17966(childName).orElseThrow());
        }

        public SetFinderBuilder<T> childItemAffix(String childType, String prefix, String suffix) {
            return this.childItem(childType, prefix + this.id.method_12832() + suffix);
        }

        public SetFinderBuilder<T> childItemSuffix(String childType, String suffix) {
            return this.childItem(childType, this.id.method_12832() + suffix);
        }

        public SetFinderBuilder<T> childItem(String childType, String childName) {
            return this.childItem(childType, Utils.idWithOptionalNamespace(childName, this.id.method_12836()));
        }

        public SetFinderBuilder<T> childBlock(String childType, class_2960 childName) {
            return this.child(childType, () -> (class_1935)class_7923.field_41175.method_17966(childName).orElseThrow());
        }

        public SetFinderBuilder<T> childBlockAffix(String childType, String prefix, String suffix) {
            return this.childBlock(childType, prefix + this.id.method_12832() + suffix);
        }

        public SetFinderBuilder<T> childBlockSuffix(String childType, String suffix) {
            return this.childBlock(childType, this.id.method_12832() + suffix);
        }

        public SetFinderBuilder<T> childBlock(String childType, String childName) {
            return this.childBlock(childType, Utils.idWithOptionalNamespace(childName, this.id.method_12836()));
        }

        public INamedSupplier<T> build() {
            return this.reg.makeFutureHolder(this.id);
        }
    }

    @FunctionalInterface
    public static interface SetFinder<T extends BlockType>
    extends Supplier<Optional<T>> {
        @Override
        public Optional<T> get();
    }
}

