/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.ai;

import java.util.EnumSet;
import net.mehvahdjukaar.snowyspirit.common.entity.GingyEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_14;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import net.minecraft.class_7;

public class GingyFollowOwnerGoal
extends class_1352 {
    public static final int TELEPORT_WHEN_DISTANCE_IS = 12;
    private static final int MIN_HORIZONTAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 2;
    private static final int MAX_HORIZONTAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 3;
    private static final int MAX_VERTICAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 1;
    private final GingyEntity tamable;
    private class_1309 owner;
    private final class_4538 level;
    private final double speedModifier;
    private final class_1408 navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;

    public GingyFollowOwnerGoal(GingyEntity tamableAnimal, double speedMod, float startDistance, float g, boolean bl) {
        this.tamable = tamableAnimal;
        this.level = tamableAnimal.method_37908();
        this.speedModifier = speedMod;
        this.navigation = tamableAnimal.method_5942();
        this.startDistance = startDistance;
        this.stopDistance = g;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        if (!(tamableAnimal.method_5942() instanceof class_1409) && !(tamableAnimal.method_5942() instanceof class_1407)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean method_6264() {
        class_1309 livingEntity = this.tamable.method_35057();
        if (livingEntity == null) {
            return false;
        }
        if (livingEntity.method_7325()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.tamable.method_5858((class_1297)livingEntity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingEntity;
        return true;
    }

    public boolean method_6266() {
        if (this.navigation.method_6357()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        return this.tamable.method_5858((class_1297)this.owner) > (double)(this.stopDistance * this.stopDistance);
    }

    private boolean unableToMove() {
        return this.tamable.isOrderedToSit() || this.tamable.method_5765() || this.tamable.method_60953();
    }

    public void method_6269() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tamable.method_5944(class_7.field_18);
        this.tamable.method_5941(class_7.field_18, 0.0f);
    }

    public void method_6270() {
        this.owner = null;
        this.navigation.method_6340();
        this.tamable.method_5941(class_7.field_18, this.oldWaterCost);
    }

    public void method_6268() {
        this.tamable.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.tamable.method_5978());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.method_38847(10);
            boolean canTeleport = false;
            if (this.tamable.method_5858((class_1297)this.owner) >= 144.0 && canTeleport) {
                this.teleportToOwner();
            } else {
                this.navigation.method_6335((class_1297)this.owner, this.speedModifier);
            }
        }
    }

    private void teleportToOwner() {
        class_2338 blockPos = this.owner.method_24515();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean bl = this.maybeTeleportTo(blockPos.method_10263() + j, blockPos.method_10264() + k, blockPos.method_10260() + l);
            if (!bl) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.method_23317()) < 2.0 && Math.abs((double)z - this.owner.method_23321()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new class_2338(x, y, z))) {
            return false;
        }
        this.tamable.method_5808((double)x + 0.5, y, (double)z + 0.5, this.tamable.method_36454(), this.tamable.method_36455());
        this.navigation.method_6340();
        return true;
    }

    private boolean canTeleportTo(class_2338 pos) {
        class_7 blockPathTypes = class_14.method_57625((class_1308)this.tamable, (class_2338)pos.method_25503());
        if (blockPathTypes != class_7.field_12) {
            return false;
        }
        class_2680 blockState = this.level.method_8320(pos.method_10074());
        if (blockState.method_26204() instanceof class_2397) {
            return false;
        }
        class_2338 blockPos = pos.method_10059((class_2382)this.tamable.method_24515());
        return this.level.method_8587((class_1297)this.tamable, this.tamable.method_5829().method_996(blockPos));
    }

    private int randomIntInclusive(int min, int max) {
        return this.tamable.method_59922().method_43048(max - min + 1) + min;
    }
}

