/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.entity;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.snowyspirit.configs.CommonConfigs;
import net.mehvahdjukaar.snowyspirit.reg.ModTags;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_247;
import net.minecraft.class_2488;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4538;

public enum GroundStatus {
    ON_SNOW,
    ON_SNOW_LAYER,
    ON_LAND,
    IN_WATER,
    IN_AIR;


    public boolean touchingGround() {
        return this != IN_AIR && this != IN_WATER;
    }

    public boolean onSnow() {
        return this == ON_SNOW || this == ON_SNOW_LAYER;
    }

    private Pair<GroundStatus, Float> withFriction(float friction) {
        return Pair.of((Object)((Object)this), (Object)Float.valueOf(friction));
    }

    public static Pair<GroundStatus, Float> computeFriction(class_1297 sled) {
        if (sled.method_5799()) {
            return IN_WATER.withFriction(1.0f);
        }
        class_1937 level = sled.method_37908();
        class_238 aabb = sled.method_5829();
        class_238 aabb1 = new class_238(aabb.field_1323, aabb.field_1322 - 0.001, aabb.field_1321, aabb.field_1320, aabb.field_1322, aabb.field_1324);
        int i = class_3532.method_15357((double)aabb1.field_1323) - 1;
        int j = class_3532.method_15384((double)aabb1.field_1320) + 1;
        int k = class_3532.method_15357((double)aabb1.field_1322) - 1;
        int l = class_3532.method_15384((double)aabb1.field_1325) + 1;
        int i1 = class_3532.method_15357((double)aabb1.field_1321) - 1;
        int j1 = class_3532.method_15384((double)aabb1.field_1324) + 1;
        class_265 voxelshape = class_259.method_1078((class_238)aabb1);
        float cumulativeFriction = 0.0f;
        int blockCount = 0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        boolean onSnow = false;
        boolean onSnowLayer = false;
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    mutable.method_10103(l1, k2, i2);
                    double snowFriction = CommonConfigs.SNOW_FRICTION.get();
                    class_2680 above = level.method_8320(mutable.method_10084());
                    if (above.method_26204() instanceof class_2488 || above.method_28498((class_2769)class_2488.field_11518) && above.method_26164(ModTags.SLED_SNOW)) {
                        onSnowLayer = true;
                        cumulativeFriction = (float)((double)cumulativeFriction + snowFriction);
                        ++blockCount;
                        continue;
                    }
                    class_2680 blockstate = level.method_8320((class_2338)mutable);
                    if (blockstate.method_26164(ModTags.SLED_SNOW)) {
                        onSnow = true;
                        cumulativeFriction = (float)((double)cumulativeFriction + snowFriction);
                        ++blockCount;
                        continue;
                    }
                    if (blockstate.method_26164(ModTags.SLED_SAND)) {
                        cumulativeFriction = (float)((double)cumulativeFriction + CommonConfigs.SAND_FRICTION.get());
                        ++blockCount;
                        continue;
                    }
                    if (!class_259.method_1074((class_265)blockstate.method_26220((class_1922)level, (class_2338)mutable).method_1096((double)l1, (double)k2, (double)i2), (class_265)voxelshape, (class_247)class_247.field_16896)) continue;
                    float fr = ForgeHelper.getFriction((class_2680)blockstate, (class_4538)level, (class_2338)mutable, (class_1297)sled);
                    if ((double)fr > 0.9) {
                        fr = (float)((double)fr * CommonConfigs.ICE_FRICTION_MULTIPLIER.get());
                    }
                    cumulativeFriction += fr;
                    ++blockCount;
                }
            }
        }
        if (cumulativeFriction <= 0.0f) {
            return IN_AIR.withFriction(0.0f);
        }
        float friction = cumulativeFriction / (float)blockCount;
        if (sled.method_24828()) {
            double slopeFriction = class_3532.method_15363((float)sled.method_36455(), (float)-45.0f, (float)45.0f) / 45.0f;
            friction = (float)((double)friction + CommonConfigs.SLOPE_FRICTION_INCREASE.get() * slopeFriction);
        }
        float landFriction = Math.min(0.9995f, friction);
        if (onSnowLayer) {
            return ON_SNOW_LAYER.withFriction(landFriction);
        }
        if (onSnow) {
            return ON_SNOW.withFriction(landFriction);
        }
        return ON_LAND.withFriction(landFriction);
    }
}

